#include <QtCore/QtGlobal>
#include <QtGui/qbrush.h>
#include <QtCore/QVariant>
#include <QtGui/qcolor.h>
#include <QtCore/QVector>
#include <QtCore/qpair.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambiGui/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QGradient(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QGradient")
    QGradient *_ptr = reinterpret_cast<QGradient *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// destruct QGradient
void __qt_destruct_QGradient(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QGradient")
    reinterpret_cast<QGradient*>(ptr)->~QGradient();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QGradient::coordinateMode()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QGradient_coordinateMode_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QGradient *__qt_this = QtJambiAPI::objectFromNativeId<QGradient>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGradient::coordinateMode()const", __qt_this)
        QGradient::CoordinateMode __qt_return_value = __qt_this->coordinateMode();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QGradient::interpolationMode()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QGradient_interpolationMode_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QGradient *__qt_this = QtJambiAPI::objectFromNativeId<QGradient>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGradient::interpolationMode()const", __qt_this)
        QGradient::InterpolationMode __qt_return_value = __qt_this->interpolationMode();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QGradient::operator!=(QGradient)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QGradient_operator_1not_1equal_1native_1cref_1QGradient_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QGradient *__qt_this = QtJambiAPI::objectFromNativeId<QGradient>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGradient::operator!=(QGradient)const", __qt_this)
        const QGradient& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QGradient>(other0);
        __java_return_value = (*__qt_this) != __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QGradient::setColorAt(qreal,QColor)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QGradient_setColorAt_1native_1qreal_1cref_1QColor__JDJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble pos0,
 QtJambiNativeID color1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QGradient *__qt_this = QtJambiAPI::objectFromNativeId<QGradient>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGradient::setColorAt(qreal,QColor)", __qt_this)
        const QColor& __qt_color1 = QtJambiAPI::valueReferenceFromNativeId<QColor>(color1);
        __qt_this->setColorAt(static_cast<qreal>(pos0), __qt_color1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QGradient::setCoordinateMode(QGradient::CoordinateMode)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QGradient_setCoordinateMode_1native_1QGradient_1CoordinateMode__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint mode0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QGradient *__qt_this = QtJambiAPI::objectFromNativeId<QGradient>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGradient::setCoordinateMode(QGradient::CoordinateMode)", __qt_this)
        QGradient::CoordinateMode __qt_mode0 = qtjambi_cast<QGradient::CoordinateMode>(__jni_env, mode0);
        __qt_this->setCoordinateMode(QGradient::CoordinateMode(__qt_mode0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QGradient::setInterpolationMode(QGradient::InterpolationMode)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QGradient_setInterpolationMode_1native_1QGradient_1InterpolationMode__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint mode0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QGradient *__qt_this = QtJambiAPI::objectFromNativeId<QGradient>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGradient::setInterpolationMode(QGradient::InterpolationMode)", __qt_this)
        QGradient::InterpolationMode __qt_mode0 = qtjambi_cast<QGradient::InterpolationMode>(__jni_env, mode0);
        __qt_this->setInterpolationMode(QGradient::InterpolationMode(__qt_mode0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QGradient::setSpread(QGradient::Spread)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QGradient_setSpread_1native_1QGradient_1Spread__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint spread0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QGradient *__qt_this = QtJambiAPI::objectFromNativeId<QGradient>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGradient::setSpread(QGradient::Spread)", __qt_this)
        QGradient::Spread __qt_spread0 = qtjambi_cast<QGradient::Spread>(__jni_env, spread0);
        __qt_this->setSpread(QGradient::Spread(__qt_spread0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QGradient::setStops(QGradientStops)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QGradient_setStops_1native_1cref_1QVector__JLjava_util_Collection_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject stops0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QGradient *__qt_this = QtJambiAPI::objectFromNativeId<QGradient>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGradient::setStops(QGradientStops)", __qt_this)
        const QVector<QPair<qreal, QColor> >&  __qt_stops0 = qtjambi_cast<const QVector<QPair<qreal, QColor> >& >(__jni_env, __qtjambi_scope, stops0);
        __qt_this->setStops(__qt_stops0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QGradient::spread()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QGradient_spread_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QGradient *__qt_this = QtJambiAPI::objectFromNativeId<QGradient>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGradient::spread()const", __qt_this)
        QGradient::Spread __qt_return_value = __qt_this->spread();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QGradient::stops()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QGradient_stops_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QGradient *__qt_this = QtJambiAPI::objectFromNativeId<QGradient>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGradient::stops()const", __qt_this)
        QVector<QPair<qreal, QColor> > __qt_return_value = __qt_this->stops();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeCustomStructors)
void* custom_constructor_QGradient(void* placement, const void * __in_var)
{
    Q_UNUSED(placement)
    const QGradient* copy = static_cast<const QGradient*>(__in_var);
    Q_UNUSED(copy)
    Q_UNUSED(copy)
    qWarning("Copying empty QGradient object");
    return new(placement) QGradient();
}
// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QGradient_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QGradient *__qt_this = QtJambiAPI::objectFromNativeId<QGradient>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(hashValue);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}
// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QGradient_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QGradient *__qt_this = QtJambiAPI::objectFromNativeId<QGradient>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QGradient(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QGradient>("QGradient", "io/qt/gui/QGradient");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QGradient, {
    });
// END: function table

    registerMetaObject(typeId, QGradient::staticMetaObject, false);
// END: signal table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QGradient);
    registerMetaType<QGradient>("QGradient", &custom_constructor_QGradient);
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QGradient::CoordinateMode>("QGradient::CoordinateMode", "io/qt/gui/QGradient$CoordinateMode");
    registerEnumTypeInfo<QGradient::InterpolationMode>("QGradient::InterpolationMode", "io/qt/gui/QGradient$InterpolationMode");
    registerEnumTypeInfo<QGradient::Preset>("QGradient::Preset", "io/qt/gui/QGradient$Preset");
    registerEnumTypeInfo<QGradient::Spread>("QGradient::Spread", "io/qt/gui/QGradient$Spread");
// END: enums and flags
}
