#include <QtCore/QtGlobal>
#include <QtCore/qjsonarray.h>
#include <QtCore/QVariant>
#include <QtCore/qjsonvalue.h>
#include <QtCore/QStringList>
#include <QtCore/QList>
#include <QtCore/qdatastream.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QJsonArray(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QJsonArray")
    QJsonArray *_ptr = reinterpret_cast<QJsonArray *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QJsonArray()
void __qt_construct_QJsonArray_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QJsonArray()")
    Q_UNUSED(__java_arguments)
    QJsonArray *__qt_this = new(__qtjambi_ptr) QJsonArray();
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// new QJsonArray(QJsonArray)
void __qt_construct_QJsonArray_1(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QJsonArray(QJsonArray)")
    jobject other0 = __java_arguments[0].l;
    const QJsonArray& __qt_other0 = qtjambi_cast<const QJsonArray& >(__jni_env, other0);
    QJsonArray *__qt_this = new(__qtjambi_ptr) QJsonArray(__qt_other0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QJsonArray(std::initializer_list<QJsonValue>)
void __qt_construct_QJsonArray_2(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QJsonArray(std::initializer_list<QJsonValue>)")
    QtJambiScope __qtjambi_scope;
    jobjectArray args0 = static_cast<jobjectArray>(__java_arguments[0].l);
    std::initializer_list<QJsonValue> __qt_args0 = qtjambi_cast<std::initializer_list<QJsonValue>>(__jni_env, __qtjambi_scope, args0);
    QJsonArray *__qt_this = new(__qtjambi_ptr) QJsonArray(__qt_args0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// destruct QJsonArray
void __qt_destruct_QJsonArray(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QJsonArray")
    reinterpret_cast<QJsonArray*>(ptr)->~QJsonArray();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QJsonArray::QJsonArray()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonArray_initialize_1native__Lio_qt_core_QJsonArray_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QJsonArray::QJsonArray()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QJsonArray_0, sizeof(QJsonArray), typeid(QJsonArray), false, &deleter_QJsonArray, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QJsonArray::QJsonArray(QJsonArray)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonArray_initialize_1native__Lio_qt_core_QJsonArray_2Lio_qt_core_QJsonArray_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QJsonArray::QJsonArray(QJsonArray)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QJsonArray_1, sizeof(QJsonArray), typeid(QJsonArray), false, &deleter_QJsonArray, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QJsonArray::QJsonArray(std::initializer_list<QJsonValue>)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonArray_initialize_1native__Lio_qt_core_QJsonArray_2_3Lio_qt_core_QJsonValue_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobjectArray args0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QJsonArray::QJsonArray(std::initializer_list<QJsonValue>)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = args0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QJsonArray_2, sizeof(QJsonArray), typeid(QJsonArray), false, &deleter_QJsonArray, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QJsonArray::append(QJsonValue)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonArray_append_1native_1cref_1QJsonValue__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID value0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QJsonArray *__qt_this = QtJambiAPI::objectFromNativeId<QJsonArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonArray::append(QJsonValue)", __qt_this)
        const QJsonValue& __qt_value0 = QtJambiAPI::objectReferenceFromNativeId<QJsonValue>(__jni_env, value0);
        __qt_this->append(__qt_value0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QJsonArray::at(int)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonArray_at_1native_1int_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint i0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonArray *__qt_this = QtJambiAPI::objectFromNativeId<QJsonArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonArray::at(int)const", __qt_this)
        QJsonValue __qt_return_value = __qt_this->at(static_cast<int>(i0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonArray::constBegin()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonArray_constBegin_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonArray *__qt_this = QtJambiAPI::objectFromNativeId<QJsonArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonArray::constBegin()const", __qt_this)
        QJsonArray::const_iterator __qt_return_value = __qt_this->constBegin();
        __java_return_value = qtjambi_cast_sequential_iterator(__jni_env, __qtjambi_scope, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonArray::constEnd()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonArray_constEnd_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonArray *__qt_this = QtJambiAPI::objectFromNativeId<QJsonArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonArray::constEnd()const", __qt_this)
        QJsonArray::const_iterator __qt_return_value = __qt_this->constEnd();
        __java_return_value = qtjambi_cast_sequential_iterator(__jni_env, __qtjambi_scope, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonArray::contains(QJsonValue)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonArray_contains_1native_1cref_1QJsonValue_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID element0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonArray *__qt_this = QtJambiAPI::objectFromNativeId<QJsonArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonArray::contains(QJsonValue)const", __qt_this)
        const QJsonValue& __qt_element0 = QtJambiAPI::objectReferenceFromNativeId<QJsonValue>(__jni_env, element0);
        __java_return_value = __qt_this->contains(__qt_element0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonArray::count()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonArray_count_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonArray *__qt_this = QtJambiAPI::objectFromNativeId<QJsonArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonArray::count()const", __qt_this)
        __java_return_value = __qt_this->count();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonArray::erase(QJsonArray::iterator)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonArray_erase_1native_1QJsonArray_1iterator__JLio_qt_core_QSequentialConstIterator_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject it0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QJsonArray *__qt_this = QtJambiAPI::objectFromNativeId<QJsonArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonArray::erase(QJsonArray::iterator)", __qt_this)
        QJsonArray::iterator __qt_it0 = reinterpret_deref_cast<QJsonArray::iterator >(__jni_env, QtJambiAPI::convertJavaObjectToNative(__jni_env, it0));
        QJsonArray::iterator __qt_return_value = __qt_this->erase(__qt_it0);
        __java_return_value = qtjambi_cast_sequential_iterator(__jni_env, __qtjambi_scope, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonArray::first()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonArray_first_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonArray *__qt_this = QtJambiAPI::objectFromNativeId<QJsonArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonArray::first()const", __qt_this)
        QJsonValue __qt_return_value = __qt_this->first();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonArray::insert(int,QJsonValue)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonArray_insert_1native_1int_1cref_1QJsonValue__JIJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint i0,
 QtJambiNativeID value1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QJsonArray *__qt_this = QtJambiAPI::objectFromNativeId<QJsonArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonArray::insert(int,QJsonValue)", __qt_this)
        const QJsonValue& __qt_value1 = QtJambiAPI::objectReferenceFromNativeId<QJsonValue>(__jni_env, value1);
        __qt_this->insert(static_cast<int>(i0), __qt_value1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QJsonArray::isEmpty()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonArray_isEmpty_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonArray *__qt_this = QtJambiAPI::objectFromNativeId<QJsonArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonArray::isEmpty()const", __qt_this)
        __java_return_value = __qt_this->isEmpty();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonArray::last()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonArray_last_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonArray *__qt_this = QtJambiAPI::objectFromNativeId<QJsonArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonArray::last()const", __qt_this)
        QJsonValue __qt_return_value = __qt_this->last();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonArray::operator+(QJsonValue)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonArray_plus_1native_1cref_1QJsonValue_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID v0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonArray *__qt_this = QtJambiAPI::objectFromNativeId<QJsonArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonArray::operator+(QJsonValue)const", __qt_this)
        const QJsonValue& __qt_v0 = QtJambiAPI::objectReferenceFromNativeId<QJsonValue>(__jni_env, v0);
        QJsonArray __qt_return_value = (*__qt_this) + __qt_v0;
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonArray::operator<<(QDataStream&,QJsonArray)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonArray_writeTo_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QJsonArray *__qt_this = QtJambiAPI::objectFromNativeId<QJsonArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonArray::operator<<(QDataStream&,QJsonArray)", __qt_this)
        QDataStream& __qt_arg__1 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, arg__1);
        __qt_arg__1 << (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QJsonArray::operator=(QJsonArray)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonArray_assign_1native_1cref_1QJsonArray__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QJsonArray *__qt_this = QtJambiAPI::objectFromNativeId<QJsonArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonArray::operator=(QJsonArray)", __qt_this)
        const QJsonArray& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QJsonArray>(other0);
        (*__qt_this) = __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QJsonArray::operator==(QJsonArray)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonArray_operator_1equal_1native_1cref_1QJsonArray_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonArray *__qt_this = QtJambiAPI::objectFromNativeId<QJsonArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonArray::operator==(QJsonArray)const", __qt_this)
        const QJsonArray& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QJsonArray>(other0);
        __java_return_value = (*__qt_this) == __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonArray::operator>>(QDataStream&,QJsonArray&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonArray_readFrom_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QJsonArray *__qt_this = QtJambiAPI::objectFromNativeId<QJsonArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonArray::operator>>(QDataStream&,QJsonArray&)", __qt_this)
        QDataStream& __qt_arg__1 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, arg__1);
        __qt_arg__1 >> (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QJsonArray::operator[](int)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonArray_get_1native_1int_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint i0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonArray *__qt_this = QtJambiAPI::objectFromNativeId<QJsonArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonArray::operator[](int)const", __qt_this)
        const QJsonValue __qt_return_value = (*__qt_this)[static_cast<int>(i0)];
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonArray::operator[](int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonArray_set_1native_1int_1const_1QJsonValue__JIJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint i0,
 QtJambiNativeID value1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QJsonArray *__qt_this = QtJambiAPI::objectFromNativeId<QJsonArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonArray::operator[](int)", __qt_this)
        const QJsonValue __qt_value1 = QtJambiAPI::objectReferenceFromNativeId<QJsonValue>(__jni_env, value1);
        (*__qt_this)[static_cast<int>(i0)] = __qt_value1;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QJsonArray::prepend(QJsonValue)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonArray_prepend_1native_1cref_1QJsonValue__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID value0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QJsonArray *__qt_this = QtJambiAPI::objectFromNativeId<QJsonArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonArray::prepend(QJsonValue)", __qt_this)
        const QJsonValue& __qt_value0 = QtJambiAPI::objectReferenceFromNativeId<QJsonValue>(__jni_env, value0);
        __qt_this->prepend(__qt_value0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QJsonArray::removeAt(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonArray_removeAt_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint i0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QJsonArray *__qt_this = QtJambiAPI::objectFromNativeId<QJsonArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonArray::removeAt(int)", __qt_this)
        __qt_this->removeAt(static_cast<int>(i0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QJsonArray::removeFirst()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonArray_removeFirst_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QJsonArray *__qt_this = QtJambiAPI::objectFromNativeId<QJsonArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonArray::removeFirst()", __qt_this)
        __qt_this->removeFirst();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QJsonArray::removeLast()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonArray_removeLast_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QJsonArray *__qt_this = QtJambiAPI::objectFromNativeId<QJsonArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonArray::removeLast()", __qt_this)
        __qt_this->removeLast();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QJsonArray::replace(int,QJsonValue)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonArray_replace_1native_1int_1cref_1QJsonValue__JIJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint i0,
 QtJambiNativeID value1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QJsonArray *__qt_this = QtJambiAPI::objectFromNativeId<QJsonArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonArray::replace(int,QJsonValue)", __qt_this)
        const QJsonValue& __qt_value1 = QtJambiAPI::objectReferenceFromNativeId<QJsonValue>(__jni_env, value1);
        __qt_this->replace(static_cast<int>(i0), __qt_value1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QJsonArray::size()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonArray_size_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonArray *__qt_this = QtJambiAPI::objectFromNativeId<QJsonArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonArray::size()const", __qt_this)
        __java_return_value = __qt_this->size();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonArray::swap(QJsonArray&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonArray_swap_1native_1ref_1QJsonArray__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QJsonArray *__qt_this = QtJambiAPI::objectFromNativeId<QJsonArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonArray::swap(QJsonArray&)", __qt_this)
        QJsonArray& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QJsonArray>(__jni_env, other0);
        __qt_this->swap(__qt_other0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QJsonArray::takeAt(int)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonArray_takeAt_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint i0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QJsonArray *__qt_this = QtJambiAPI::objectFromNativeId<QJsonArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonArray::takeAt(int)", __qt_this)
        QJsonValue __qt_return_value = __qt_this->takeAt(static_cast<int>(i0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonArray::toVariantList()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonArray_toList_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonArray *__qt_this = QtJambiAPI::objectFromNativeId<QJsonArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonArray::toVariantList()const", __qt_this)
        QList<QVariant> __qt_return_value = __qt_this->toVariantList();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonArray::fromStringList(QStringList)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonArray_fromStringList__Ljava_util_Collection_2)
(JNIEnv *__jni_env,
 jclass,
 jobject list0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QJsonArray::fromStringList(QStringList)")
    QtJambiScope __qtjambi_scope;
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QStringList&  __qt_list0 = qtjambi_cast<const QStringList& >(__jni_env, __qtjambi_scope, list0);
        QJsonArray __qt_return_value = QJsonArray::fromStringList(__qt_list0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonArray::fromVariantList(QVariantList)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonArray_fromVariantList__Ljava_util_Collection_2)
(JNIEnv *__jni_env,
 jclass,
 jobject list0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QJsonArray::fromVariantList(QVariantList)")
    QtJambiScope __qtjambi_scope;
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QList<QVariant>&  __qt_list0 = qtjambi_cast<const QList<QVariant>& >(__jni_env, __qtjambi_scope, list0);
        QJsonArray __qt_return_value = QJsonArray::fromVariantList(__qt_list0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonArray_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QJsonArray *__qt_this = QtJambiAPI::objectFromNativeId<QJsonArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(hashValue);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

#include <QtCore/QDebug>
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonArray_toString_1native)(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jstring __java_return_value = nullptr;
    QTJAMBI_TRY {
        QJsonArray *__qt_this = QtJambiAPI::objectFromNativeId<QJsonArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QString res;
        QDebug(&res).noquote() << *__qt_this;
        if(!res.isEmpty() && res.back().isSpace())
            res = res.trimmed();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, res);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonArray_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QJsonArray *__qt_this = QtJambiAPI::objectFromNativeId<QJsonArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QJsonArray(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QJsonArray>("QJsonArray", "io/qt/core/QJsonArray");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QJsonArray, {
        ConstructorInfo(&__qt_construct_QJsonArray_0, nullptr)
       ,ConstructorInfo(&__qt_construct_QJsonArray_1, "Lio/qt/core/QJsonArray;")
       ,ConstructorInfo(&__qt_construct_QJsonArray_2, "[Lio/qt/core/QJsonValue;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QJsonArray);
    registerMetaType<QJsonArray>("QJsonArray");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags
}
