#ifndef QFILEDEVICE_SHELL_H
#define QFILEDEVICE_SHELL_H

#include <QtCore/QtGlobal>
#include <QtCore/qcompilerdetection.h>

QT_WARNING_DISABLE_DEPRECATED

#include <QtCore/qfiledevice.h>
#include <QtJambi/QtJambiAPI>
#include <QtCore/QList>
#include <QtCore/QVariant>
#include <QtCore/qbytearray.h>
#include <QtCore/qcoreevent.h>
#include <QtCore/qdatetime.h>
#include <QtCore/qmetaobject.h>
#include <QtCore/qnamespace.h>
#include <QtCore/qobject.h>
#include <QtCore/qregexp.h>
#include <qtcore-config.h>
#if QT_CONFIG(regularexpression)
#include <QtCore/qregularexpression.h>
#endif //QT_CONFIG(regularexpression)
#include <QtCore/qthread.h>
#include <QtCore/qtimer.h>
#include <QtJambi/JavaAPI>
#include <QtJambi/RegistryAPI>


class QFileDevice_shell : public QFileDevice, public QtJambiShellInterface
{
public:
    QFileDevice_shell();
    QFileDevice_shell(QObject* parent0);
    ~QFileDevice_shell() override;

    bool atEnd() const override;
    qint64 bytesAvailable() const override;
    qint64 bytesToWrite() const override;
    bool canReadLine() const override;
    void childEvent(QChildEvent* event0) override;
    void close() override;
    void connectNotify(const QMetaMethod& signal0) override;
    void customEvent(QEvent* event0) override;
    void disconnectNotify(const QMetaMethod& signal0) override;
    bool event(QEvent* event0) override;
    bool eventFilter(QObject* watched0, QEvent* event1) override;
    QString fileName() const override;
    bool isSequential() const override;
    bool open(QIODevice::OpenMode mode0) override;
    QFileDevice::Permissions permissions() const override;
    qint64 pos() const override;
    qint64 readData(char* data0, qint64 maxlen1) override;
    qint64 readLineData(char* data0, qint64 maxlen1) override;
    bool reset() override;
    bool resize(qint64 sz0) override;
    bool seek(qint64 offset0) override;
    bool setPermissions(QFileDevice::Permissions permissionSpec0) override;
    qint64 size() const override;
    void timerEvent(QTimerEvent* event0) override;
    bool waitForBytesWritten(int msecs0) override;
    bool waitForReadyRead(int msecs0) override;
    qint64 writeData(const char* data0, qint64 len1) override;
    static void operator delete(void * ptr) noexcept;
    const QMetaObject *metaObject() const override final;
    void *qt_metacast(const char *) override final;
    int qt_metacall(QMetaObject::Call, int, void **) override final;
private:
    QtJambiShell* __shell() const override final;
    jmethodID __shell_javaMethod(int pos) const;
};

struct QFileDevice_access : public QFileDevice
{
    jboolean __qt_atEnd(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    void __qt_close(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    jstring __qt_fileName(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jboolean __qt_isSequential(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jint __qt_permissions(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jlong __qt_pos(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jint __qt_readData_char_ptr_qint64(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jbyteArray data0);
    jint __qt_readLineData_char_ptr_qint64(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jbyteArray data0);
    jboolean __qt_resize_qint64(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jlong sz0);
    jboolean __qt_seek_qint64(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jlong offset0);
    jboolean __qt_setPermissions_QFileDevice_Permissions(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint permissionSpec0);
    jlong __qt_size(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jint __qt_writeData_const_char_ptr_qint64(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jbyteArray data0);
};

#endif // QFILEDEVICE_SHELL_H
