#include <QtCore/QtGlobal>
#include <QtCore/qcryptographichash.h>
#include <QtCore/QVariant>
#include <QtCore/qbytearray.h>
#include <QtCore/qiodevice.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QCryptographicHash(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QCryptographicHash")
    QCryptographicHash *_ptr = reinterpret_cast<QCryptographicHash *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QCryptographicHash(QCryptographicHash::Algorithm)
void __qt_construct_QCryptographicHash_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QCryptographicHash(QCryptographicHash::Algorithm)")
    jobject method0 = __java_arguments[0].l;
    QCryptographicHash::Algorithm __qt_method0 = qtjambi_cast<QCryptographicHash::Algorithm>(__jni_env, method0);
    QCryptographicHash *__qt_this = new(__qtjambi_ptr) QCryptographicHash(QCryptographicHash::Algorithm(__qt_method0));
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// destruct QCryptographicHash
void __qt_destruct_QCryptographicHash(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QCryptographicHash")
    reinterpret_cast<QCryptographicHash*>(ptr)->~QCryptographicHash();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QCryptographicHash::QCryptographicHash(QCryptographicHash::Algorithm)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCryptographicHash_initialize_1native__Lio_qt_core_QCryptographicHash_2Lio_qt_core_QCryptographicHash_00024Algorithm_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject method0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QCryptographicHash::QCryptographicHash(QCryptographicHash::Algorithm)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = method0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QCryptographicHash_0, sizeof(QCryptographicHash), typeid(QCryptographicHash), false, &deleter_QCryptographicHash, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCryptographicHash::addData(QIODevice*)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCryptographicHash_addData_1native_1QIODevice_1ptr__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID device0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QCryptographicHash *__qt_this = QtJambiAPI::objectFromNativeId<QCryptographicHash>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCryptographicHash::addData(QIODevice*)", __qt_this)
        QIODevice* __qt_device0 = QtJambiAPI::objectFromNativeId<QIODevice>(device0);
        __java_return_value = __qt_this->addData(__qt_device0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCryptographicHash::addData(QByteArray)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCryptographicHash_addData_1native_1cref_1QByteArray__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID data0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QCryptographicHash *__qt_this = QtJambiAPI::objectFromNativeId<QCryptographicHash>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCryptographicHash::addData(QByteArray)", __qt_this)
        const QByteArray& __qt_data0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(data0);
        __qt_this->addData(__qt_data0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCryptographicHash::addData(const char*,int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCryptographicHash_addData_1native_1const_1char_1ptr_1int__J_3B)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jbyteArray data0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QCryptographicHash *__qt_this = QtJambiAPI::objectFromNativeId<QCryptographicHash>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCryptographicHash::addData(const char*,int)", __qt_this)
        jsize length1 = 0;
        const char* __qt_data0 = qtjambi_array_cast<const char*>(__jni_env, __qtjambi_scope, data0, length1);
        __qt_this->addData(__qt_data0, static_cast<int>(length1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCryptographicHash::reset()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCryptographicHash_reset_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QCryptographicHash *__qt_this = QtJambiAPI::objectFromNativeId<QCryptographicHash>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCryptographicHash::reset()", __qt_this)
        __qt_this->reset();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCryptographicHash::result()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCryptographicHash_result_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QCryptographicHash *__qt_this = QtJambiAPI::objectFromNativeId<QCryptographicHash>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCryptographicHash::result()const", __qt_this)
        QByteArray __qt_return_value = __qt_this->result();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCryptographicHash::hash(QByteArray,QCryptographicHash::Algorithm)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCryptographicHash_hash_1native_1cref_1QByteArray_1QCryptographicHash_1Algorithm__JI)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID data0,
 jint method1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QCryptographicHash::hash(QByteArray,QCryptographicHash::Algorithm)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray& __qt_data0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(data0);
        QCryptographicHash::Algorithm __qt_method1 = qtjambi_cast<QCryptographicHash::Algorithm>(__jni_env, method1);
        QByteArray __qt_return_value = QCryptographicHash::hash(__qt_data0, QCryptographicHash::Algorithm(__qt_method1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCryptographicHash::hashLength(QCryptographicHash::Algorithm)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCryptographicHash_hashLength_1native_1QCryptographicHash_1Algorithm__I)
(JNIEnv *__jni_env,
 jclass,
 jint method0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QCryptographicHash::hashLength(QCryptographicHash::Algorithm)")
    jint __java_return_value{0};
    QTJAMBI_TRY {
        QCryptographicHash::Algorithm __qt_method0 = qtjambi_cast<QCryptographicHash::Algorithm>(__jni_env, method0);
        __java_return_value = QCryptographicHash::hashLength(QCryptographicHash::Algorithm(__qt_method0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

void initialize_meta_info_QCryptographicHash(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerObjectTypeInfo<QCryptographicHash>("QCryptographicHash", "io/qt/core/QCryptographicHash");
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QCryptographicHash, {
        ConstructorInfo(&__qt_construct_QCryptographicHash_0, "Lio/qt/core/QCryptographicHash$Algorithm;")
    });
// END: function table

    registerMetaObject(typeId, QCryptographicHash::staticMetaObject, false);
// END: signal table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QCryptographicHash);
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QCryptographicHash::Algorithm>("QCryptographicHash::Algorithm", "io/qt/core/QCryptographicHash$Algorithm");
// END: enums and flags
}
