package io.qt.dbus;

import io.qt.*;


/**
 * <p>Refers to one pending asynchronous call</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qdbuspendingcall.html">QDBusPendingCall</a></code></p>
 */
public interface QDBusPendingCall extends QtObjectInterface
{
    /**
     * @hidden
     * <p>Implementor class for interface {@link io.qt.dbus.QDBusPendingCall}</p>
     */
    public static class Impl extends QtObject
        implements io.qt.dbus.QDBusPendingCall,
                java.lang.Cloneable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qdbuspendingcall.html#QDBusPendingCall">QDBusPendingCall::<wbr/>QDBusPendingCall(QDBusPendingCall)</a></code></p>
         */
        public Impl(io.qt.dbus.@StrictNonNull QDBusPendingCall other){
            super((QPrivateConstructor)null);
            java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
            initialize_native(this, other);
        }
        
        private native static void initialize_native(QDBusPendingCall instance, io.qt.dbus.QDBusPendingCall other);
        
        /**
         * <p>See <code>QDBusPendingCall::<wbr/>error()const</code></p>
         */
        @QtUninvokable
        public final io.qt.dbus.@NonNull QDBusError error(){
            return error_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static io.qt.dbus.QDBusError error_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <code>QDBusPendingCall::<wbr/>isError()const</code></p>
         */
        @QtUninvokable
        public final boolean isError(){
            return isError_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static boolean isError_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <code>QDBusPendingCall::<wbr/>isFinished()const</code></p>
         */
        @QtUninvokable
        public final boolean isFinished(){
            return isFinished_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static boolean isFinished_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <code>QDBusPendingCall::<wbr/>isValid()const</code></p>
         */
        @QtUninvokable
        public final boolean isValid(){
            return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static boolean isValid_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qdbuspendingcall.html#operator-eq-1">QDBusPendingCall::<wbr/>operator=(QDBusPendingCall)</a></code></p>
         */
        @QtUninvokable
        public final void assign(io.qt.dbus.@NonNull QDBusPendingCall other){
            assign_native_cref_QDBusPendingCall(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
        }
        
        private native static void assign_native_cref_QDBusPendingCall(long __this__nativeId, long other);
        
        /**
         * <p>See <code>QDBusPendingCall::<wbr/>reply()const</code></p>
         */
        @QtUninvokable
        public final io.qt.dbus.@NonNull QDBusMessage reply(){
            return reply_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static io.qt.dbus.QDBusMessage reply_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qdbuspendingcall.html#swap">QDBusPendingCall::<wbr/>swap(QDBusPendingCall&amp;)</a></code></p>
         */
        @QtUninvokable
        public final void swap(io.qt.dbus.@StrictNonNull QDBusPendingCall other){
            java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
            swap_native_ref_QDBusPendingCall(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
        }
        
        private native static void swap_native_ref_QDBusPendingCall(long __this__nativeId, long other);
        
        /**
         * <p>See <code>QDBusPendingCall::<wbr/>waitForFinished()</code></p>
         */
        @QtUninvokable
        public final void waitForFinished(){
            waitForFinished_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static void waitForFinished_native(long __this__nativeId);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qdbuspendingcall.html#fromCompletedCall">QDBusPendingCall::<wbr/>fromCompletedCall(QDBusMessage)</a></code></p>
         */
        private static io.qt.dbus.@NonNull QDBusPendingCall fromCompletedCall(io.qt.dbus.@NonNull QDBusMessage message){
            return fromCompletedCall_native_cref_QDBusMessage(QtJambi_LibraryUtilities.internal.checkedNativeId(message));
        }
        
        private native static io.qt.dbus.QDBusPendingCall fromCompletedCall_native_cref_QDBusMessage(long message);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qdbuspendingcall.html#fromError">QDBusPendingCall::<wbr/>fromError(QDBusError)</a></code></p>
         */
        private static io.qt.dbus.@NonNull QDBusPendingCall fromError(io.qt.dbus.@NonNull QDBusError error){
            return fromError_native_cref_QDBusError(QtJambi_LibraryUtilities.internal.checkedNativeId(error));
        }
        
        private native static io.qt.dbus.QDBusPendingCall fromError_native_cref_QDBusError(long error);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         * @hidden
         */
        @NativeAccess
        protected Impl(QPrivateConstructor p) { super(p); } 
        
        
        /**
         * <p>Creates and returns a copy of this object.</p>
        <p>See <code><a href="https://doc.qt.io/qt/qdbuspendingcall.html#QDBusPendingCall">QDBusPendingCall::<wbr/></a></code></p>
         */
        @QtUninvokable
        @Override
        public Impl clone() {
            return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private static native Impl clone_native(long __this_nativeId);
    }

    
    /**
     * <p>See <code>QDBusPendingCall::<wbr/>error()const</code></p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public default io.qt.dbus.@NonNull QDBusError error(){
        return Impl.error_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    /**
     * <p>See <code>QDBusPendingCall::<wbr/>isError()const</code></p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public default boolean isError(){
        return Impl.isError_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    /**
     * <p>See <code>QDBusPendingCall::<wbr/>isFinished()const</code></p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public default boolean isFinished(){
        return Impl.isFinished_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    /**
     * <p>See <code>QDBusPendingCall::<wbr/>isValid()const</code></p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public default boolean isValid(){
        return Impl.isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbuspendingcall.html#operator-eq-1">QDBusPendingCall::<wbr/>operator=(QDBusPendingCall)</a></code></p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public default void assign(io.qt.dbus.@NonNull QDBusPendingCall other){
        Impl.assign_native_cref_QDBusPendingCall(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    /**
     * <p>See <code>QDBusPendingCall::<wbr/>reply()const</code></p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public default io.qt.dbus.@NonNull QDBusMessage reply(){
        return Impl.reply_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbuspendingcall.html#swap">QDBusPendingCall::<wbr/>swap(QDBusPendingCall&amp;)</a></code></p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public default void swap(io.qt.dbus.@StrictNonNull QDBusPendingCall other){
        Impl.swap_native_ref_QDBusPendingCall(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    /**
     * <p>See <code>QDBusPendingCall::<wbr/>waitForFinished()</code></p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public default void waitForFinished(){
        Impl.waitForFinished_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbuspendingcall.html#fromCompletedCall">QDBusPendingCall::<wbr/>fromCompletedCall(QDBusMessage)</a></code></p>
     */
    public static io.qt.dbus.@NonNull QDBusPendingCall fromCompletedCall(io.qt.dbus.@NonNull QDBusMessage message){
        return Impl.fromCompletedCall(message);
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbuspendingcall.html#fromError">QDBusPendingCall::<wbr/>fromError(QDBusError)</a></code></p>
     */
    public static io.qt.dbus.@NonNull QDBusPendingCall fromError(io.qt.dbus.@NonNull QDBusError error){
        return Impl.fromError(error);
    }
    
}
