package io.qt.dbus;

import io.qt.*;


/**
 * <p>Proxy for interfaces on remote objects</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qdbusinterface.html">QDBusInterface</a></code></p>
 */
public class QDBusInterface extends io.qt.dbus.QDBusAbstractInterface
{
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusinterface.html#QDBusInterface-1">QDBusInterface::<wbr/>QDBusInterface(QString,<wbr/>QString,<wbr/>QString,<wbr/>QDBusConnection,<wbr/>QObject*)</a></code></p>
     */
    public QDBusInterface(java.lang.@NonNull String service, java.lang.@NonNull String path, java.lang.@NonNull String arg__interface, io.qt.dbus.@NonNull QDBusConnection connection, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, service, path, arg__interface, connection, parent);
    }
    
    private native static void initialize_native(QDBusInterface instance, java.lang.String service, java.lang.String path, java.lang.String arg__interface, io.qt.dbus.QDBusConnection connection, io.qt.core.QObject parent);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QDBusInterface(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Overloaded constructor for {@link #QDBusInterface(java.lang.String, java.lang.String, java.lang.String, io.qt.dbus.QDBusConnection, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QDBusInterface(java.lang.@NonNull String service, java.lang.@NonNull String path, java.lang.@NonNull String arg__interface, io.qt.dbus.@NonNull QDBusConnection connection) {
        this(service, path, arg__interface, connection, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QDBusInterface(java.lang.String, java.lang.String, java.lang.String, io.qt.dbus.QDBusConnection, io.qt.core.QObject)}</p>
     * <p>with: </p><ul>
     * <li><code>connection = io.qt.dbus.QDBusConnection.sessionBus()</code></li>
     * <li><code>parent = null</code></li>
     * </ul>
     */
    public QDBusInterface(java.lang.@NonNull String service, java.lang.@NonNull String path, java.lang.@NonNull String arg__interface) {
        this(service, path, arg__interface, io.qt.dbus.QDBusConnection.sessionBus(), (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QDBusInterface(java.lang.String, java.lang.String, java.lang.String, io.qt.dbus.QDBusConnection, io.qt.core.QObject)}</p>
     * <p>with: </p><ul>
     * <li><code>arg__interface = (String)null</code></li>
     * <li><code>connection = io.qt.dbus.QDBusConnection.sessionBus()</code></li>
     * <li><code>parent = null</code></li>
     * </ul>
     */
    public QDBusInterface(java.lang.@NonNull String service, java.lang.@NonNull String path) {
        this(service, path, (String)null, io.qt.dbus.QDBusConnection.sessionBus(), (io.qt.core.QObject)null);
    }
}
