/*
 * Decompiled with CFR 0.152.
 */
package io.qt.dbus;

import io.qt.NonNull;
import io.qt.QtDeclaredFinal;
import io.qt.QtObject;
import io.qt.QtObjectInterface;
import io.qt.QtUninvokable;
import io.qt.StrictNonNull;
import io.qt.dbus.QDBusConnection;
import io.qt.dbus.QDBusMessage;
import io.qt.dbus.QtJambi_LibraryUtilities;
import java.util.Objects;

public interface QDBusContext
extends QtObjectInterface {
    @QtDeclaredFinal
    @QtUninvokable
    default public boolean calledFromDBus() {
        return Impl.calledFromDBus_native_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObjectInterface)this));
    }

    @QtDeclaredFinal
    @QtUninvokable
    default public @NonNull QDBusConnection connection() {
        Impl.checkCalledFromDBus(this);
        return Impl.connection_native_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObjectInterface)this));
    }

    @QtDeclaredFinal
    @QtUninvokable
    default public boolean isDelayedReply() {
        Impl.checkCalledFromDBus(this);
        return Impl.isDelayedReply_native_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObjectInterface)this));
    }

    @QtDeclaredFinal
    @QtUninvokable
    default public @NonNull QDBusMessage message() {
        Impl.checkCalledFromDBus(this);
        return Impl.message_native_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObjectInterface)this));
    }

    @QtDeclaredFinal
    @QtUninvokable
    default public void sendErrorReply( @NonNull QDBusError.ErrorType type, @NonNull String msg) {
        Impl.checkCalledFromDBus(this);
        Impl.sendErrorReply_native_QDBusError_ErrorType_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObjectInterface)this), type.value(), msg);
    }

    @QtDeclaredFinal
    @QtUninvokable
    default public void sendErrorReply(@NonNull String name, @NonNull String msg) {
        Impl.checkCalledFromDBus(this);
        Impl.sendErrorReply_native_cref_QString_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObjectInterface)this), name, msg);
    }

    @QtDeclaredFinal
    @QtUninvokable
    default public void setDelayedReply(boolean enable) {
        Impl.checkCalledFromDBus(this);
        Impl.setDelayedReply_native_bool_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObjectInterface)this), enable);
    }

    @QtDeclaredFinal
    @QtUninvokable
    default public void sendErrorReply( @NonNull QDBusError.ErrorType type) {
        this.sendErrorReply(type, (String)null);
    }

    @QtDeclaredFinal
    @QtUninvokable
    default public void sendErrorReply(@NonNull String name) {
        this.sendErrorReply(name, (String)null);
    }

    public static class Impl
    extends QtObject
    implements QDBusContext,
    Cloneable {
        public Impl() {
            super((QtObject.QPrivateConstructor)null);
            Impl.initialize_native(this);
        }

        private static native void initialize_native(QDBusContext var0);

        public Impl(@StrictNonNull QDBusContext other) {
            super((QtObject.QPrivateConstructor)null);
            Objects.requireNonNull(other, "Argument 'other': null not expected.");
            Impl.initialize_native(this, other);
        }

        private static native void initialize_native(QDBusContext var0, QDBusContext var1);

        @Override
        @QtUninvokable
        public final boolean calledFromDBus() {
            return Impl.calledFromDBus_native_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
        }

        private static native boolean calledFromDBus_native_constfct(long var0);

        @Override
        @QtUninvokable
        public final @NonNull QDBusConnection connection() {
            Impl.checkCalledFromDBus(this);
            return Impl.connection_native_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
        }

        private static native QDBusConnection connection_native_constfct(long var0);

        @Override
        @QtUninvokable
        public final boolean isDelayedReply() {
            Impl.checkCalledFromDBus(this);
            return Impl.isDelayedReply_native_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
        }

        private static native boolean isDelayedReply_native_constfct(long var0);

        @Override
        @QtUninvokable
        public final @NonNull QDBusMessage message() {
            Impl.checkCalledFromDBus(this);
            return Impl.message_native_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
        }

        private static native QDBusMessage message_native_constfct(long var0);

        @Override
        @QtUninvokable
        public final void sendErrorReply( @NonNull QDBusError.ErrorType type, @NonNull String msg) {
            Impl.checkCalledFromDBus(this);
            Impl.sendErrorReply_native_QDBusError_ErrorType_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this), type.value(), msg);
        }

        private static native void sendErrorReply_native_QDBusError_ErrorType_cref_QString_constfct(long var0, int var2, String var3);

        @Override
        @QtUninvokable
        public final void sendErrorReply(@NonNull String name, @NonNull String msg) {
            Impl.checkCalledFromDBus(this);
            Impl.sendErrorReply_native_cref_QString_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this), name, msg);
        }

        private static native void sendErrorReply_native_cref_QString_cref_QString_constfct(long var0, String var2, String var3);

        @Override
        @QtUninvokable
        public final void setDelayedReply(boolean enable) {
            Impl.checkCalledFromDBus(this);
            Impl.setDelayedReply_native_bool_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this), enable);
        }

        private static native void setDelayedReply_native_bool_constfct(long var0, boolean var2);

        protected Impl(QtObject.QPrivateConstructor p) {
            super(p);
        }

        private static void checkCalledFromDBus(QDBusContext instance) {
            if (!instance.calledFromDBus()) {
                throw new IllegalStateException("QDBusContext has not ben called from DBus.");
            }
        }

        @QtUninvokable
        public Impl clone() {
            return Impl.clone_native(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
        }

        private static native Impl clone_native(long var0);

        @Override
        @QtUninvokable
        public final void sendErrorReply( @NonNull QDBusError.ErrorType type) {
            this.sendErrorReply(type, (String)null);
        }

        @Override
        @QtUninvokable
        public final void sendErrorReply(@NonNull String name) {
            this.sendErrorReply(name, (String)null);
        }

        static {
            QtJambi_LibraryUtilities.initialize();
        }
    }
}

