/*
 * Decompiled with CFR 0.152.
 */
package io.qt.dbus;

import io.qt.NonNull;
import io.qt.Nullable;
import io.qt.QFlags;
import io.qt.QNoSuchEnumValueException;
import io.qt.QtAbstractFlagEnumerator;
import io.qt.QtEnumerator;
import io.qt.QtFlagEnumerator;
import io.qt.QtObject;
import io.qt.QtRejectedEntries;
import io.qt.QtUninvokable;
import io.qt.StrictNonNull;
import io.qt.core.QByteArray;
import io.qt.core.QMetaMethod;
import io.qt.core.QMetaObject;
import io.qt.core.QObject;
import io.qt.dbus.QDBus;
import io.qt.dbus.QDBusConnectionInterface;
import io.qt.dbus.QDBusError;
import io.qt.dbus.QDBusMessage;
import io.qt.dbus.QDBusPendingCall;
import io.qt.dbus.QtJambi_LibraryUtilities;
import java.util.Collection;
import java.util.Objects;

public class QDBusConnection
extends QtObject
implements Cloneable {
    public static final @NonNull QMetaObject staticMetaObject;

    public QDBusConnection(@NonNull QDBusConnection other) {
        super((QtObject.QPrivateConstructor)null);
        QDBusConnection.initialize_native(this, other);
    }

    private static native void initialize_native(QDBusConnection var0, QDBusConnection var1);

    public QDBusConnection(@NonNull String name) {
        super((QtObject.QPrivateConstructor)null);
        QDBusConnection.initialize_native(this, name);
    }

    private static native void initialize_native(QDBusConnection var0, String var1);

    @QtUninvokable
    public final @NonNull QDBusPendingCall asyncCall(@NonNull QDBusMessage message, int timeout) {
        return this.asyncCall_native_cref_QDBusMessage_int_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this), QtJambi_LibraryUtilities.internal.checkedNativeId((QtObject)message), timeout);
    }

    @QtUninvokable
    private native QDBusPendingCall asyncCall_native_cref_QDBusMessage_int_constfct(long var1, long var3, int var5);

    @QtUninvokable
    public final @NonNull String baseService() {
        return this.baseService_native_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
    }

    @QtUninvokable
    private native String baseService_native_constfct(long var1);

    @QtUninvokable
    public final @NonNull QDBusMessage call(@NonNull QDBusMessage message, @NonNull QDBus.CallMode mode, int timeout) {
        return this.call_native_cref_QDBusMessage_QDBus_CallMode_int_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this), QtJambi_LibraryUtilities.internal.checkedNativeId((QtObject)message), mode.value(), timeout);
    }

    @QtUninvokable
    private native QDBusMessage call_native_cref_QDBusMessage_QDBus_CallMode_int_constfct(long var1, long var3, int var5, int var6);

    @QtUninvokable
    public final boolean callWithCallback(@NonNull QDBusMessage message, @Nullable QObject receiver, @Nullable String returnMethod, @Nullable String errorMethod, int timeout) {
        QMetaMethod method;
        if (returnMethod != null && !returnMethod.startsWith("1") && !returnMethod.startsWith("2") && (method = receiver.metaObject().method(returnMethod, new Class[0])) != null && method.isValid()) {
            returnMethod = method.methodType() == QMetaMethod.MethodType.Signal ? "2" + method.cppMethodSignature() : "1" + method.cppMethodSignature();
        }
        if (errorMethod != null && !errorMethod.startsWith("1") && !errorMethod.startsWith("2") && (method = receiver.metaObject().method(errorMethod, new Class[0])) != null && method.isValid()) {
            errorMethod = method.methodType() == QMetaMethod.MethodType.Signal ? "2" + method.cppMethodSignature() : "1" + method.cppMethodSignature();
        }
        return this.callWithCallback_native_cref_QDBusMessage_QObject_ptr_const_char_ptr_const_char_ptr_int_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this), QtJambi_LibraryUtilities.internal.checkedNativeId((QtObject)message), QtJambi_LibraryUtilities.internal.checkedNativeId((QtObject)receiver), returnMethod, errorMethod, timeout);
    }

    @QtUninvokable
    private native boolean callWithCallback_native_cref_QDBusMessage_QObject_ptr_const_char_ptr_const_char_ptr_int_constfct(long var1, long var3, long var5, String var7, String var8, int var9);

    @QtUninvokable
    public final boolean callWithCallback(@NonNull QDBusMessage message, @Nullable QObject receiver, @Nullable String slot, int timeout) {
        QMetaMethod method;
        if (slot != null && !slot.startsWith("1") && !slot.startsWith("2") && (method = receiver.metaObject().method(slot, new Class[0])) != null && method.isValid()) {
            slot = method.methodType() == QMetaMethod.MethodType.Signal ? "2" + method.cppMethodSignature() : "1" + method.cppMethodSignature();
        }
        return this.callWithCallback_native_cref_QDBusMessage_QObject_ptr_const_char_ptr_int_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this), QtJambi_LibraryUtilities.internal.checkedNativeId((QtObject)message), QtJambi_LibraryUtilities.internal.checkedNativeId((QtObject)receiver), slot, timeout);
    }

    @QtUninvokable
    private native boolean callWithCallback_native_cref_QDBusMessage_QObject_ptr_const_char_ptr_int_constfct(long var1, long var3, long var5, String var7, int var8);

    @QtUninvokable
    public final boolean connect(@NonNull String service, @NonNull String path, @NonNull String arg__interface, @NonNull String name, @Nullable QObject receiver, @Nullable String slot) {
        QMetaMethod method;
        if (slot != null && !slot.startsWith("1") && !slot.startsWith("2") && (method = receiver.metaObject().method(slot, new Class[0])) != null && method.isValid()) {
            slot = method.methodType() == QMetaMethod.MethodType.Signal ? "2" + method.cppMethodSignature() : "1" + method.cppMethodSignature();
        }
        return this.connect_native_cref_QString_cref_QString_cref_QString_cref_QString_QObject_ptr_const_char_ptr(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this), service, path, arg__interface, name, QtJambi_LibraryUtilities.internal.checkedNativeId((QtObject)receiver), slot);
    }

    @QtUninvokable
    private native boolean connect_native_cref_QString_cref_QString_cref_QString_cref_QString_QObject_ptr_const_char_ptr(long var1, String var3, String var4, String var5, String var6, long var7, String var9);

    @QtUninvokable
    public final boolean connect(@NonNull String service, @NonNull String path, @NonNull String arg__interface, @NonNull String name, @NonNull String signature, @Nullable QObject receiver, @Nullable String slot) {
        QMetaMethod method;
        if (slot != null && !slot.startsWith("1") && !slot.startsWith("2") && (method = receiver.metaObject().method(slot, new Class[0])) != null && method.isValid()) {
            slot = method.methodType() == QMetaMethod.MethodType.Signal ? "2" + method.cppMethodSignature() : "1" + method.cppMethodSignature();
        }
        return this.connect_native_cref_QString_cref_QString_cref_QString_cref_QString_cref_QString_QObject_ptr_const_char_ptr(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this), service, path, arg__interface, name, signature, QtJambi_LibraryUtilities.internal.checkedNativeId((QtObject)receiver), slot);
    }

    @QtUninvokable
    private native boolean connect_native_cref_QString_cref_QString_cref_QString_cref_QString_cref_QString_QObject_ptr_const_char_ptr(long var1, String var3, String var4, String var5, String var6, String var7, long var8, String var10);

    @QtUninvokable
    public final boolean connect(@NonNull String service, @NonNull String path, @NonNull String arg__interface, @NonNull String name, @NonNull Collection<@NonNull String> argumentMatch, @NonNull String signature, @Nullable QObject receiver, @Nullable String slot) {
        QMetaMethod method;
        if (slot != null && !slot.startsWith("1") && !slot.startsWith("2") && (method = receiver.metaObject().method(slot, new Class[0])) != null && method.isValid()) {
            slot = method.methodType() == QMetaMethod.MethodType.Signal ? "2" + method.cppMethodSignature() : "1" + method.cppMethodSignature();
        }
        return this.connect_native_cref_QString_cref_QString_cref_QString_cref_QString_cref_QStringList_cref_QString_QObject_ptr_const_char_ptr(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this), service, path, arg__interface, name, argumentMatch, signature, QtJambi_LibraryUtilities.internal.checkedNativeId((QtObject)receiver), slot);
    }

    @QtUninvokable
    private native boolean connect_native_cref_QString_cref_QString_cref_QString_cref_QString_cref_QStringList_cref_QString_QObject_ptr_const_char_ptr(long var1, String var3, String var4, String var5, String var6, Collection<String> var7, String var8, long var9, String var11);

    @QtUninvokable
    public final @NonNull ConnectionCapabilities connectionCapabilities() {
        return new ConnectionCapabilities(this.connectionCapabilities_native_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this)));
    }

    @QtUninvokable
    private native int connectionCapabilities_native_constfct(long var1);

    @QtUninvokable
    public final boolean disconnect(@NonNull String service, @NonNull String path, @NonNull String arg__interface, @NonNull String name, @Nullable QObject receiver, @Nullable String slot) {
        QMetaMethod method;
        if (slot != null && !slot.startsWith("1") && !slot.startsWith("2") && (method = receiver.metaObject().method(slot, new Class[0])) != null && method.isValid()) {
            slot = method.methodType() == QMetaMethod.MethodType.Signal ? "2" + method.cppMethodSignature() : "1" + method.cppMethodSignature();
        }
        return this.disconnect_native_cref_QString_cref_QString_cref_QString_cref_QString_QObject_ptr_const_char_ptr(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this), service, path, arg__interface, name, QtJambi_LibraryUtilities.internal.checkedNativeId((QtObject)receiver), slot);
    }

    @QtUninvokable
    private native boolean disconnect_native_cref_QString_cref_QString_cref_QString_cref_QString_QObject_ptr_const_char_ptr(long var1, String var3, String var4, String var5, String var6, long var7, String var9);

    @QtUninvokable
    public final boolean disconnect(@NonNull String service, @NonNull String path, @NonNull String arg__interface, @NonNull String name, @NonNull String signature, @Nullable QObject receiver, @Nullable String slot) {
        QMetaMethod method;
        if (slot != null && !slot.startsWith("1") && !slot.startsWith("2") && (method = receiver.metaObject().method(slot, new Class[0])) != null && method.isValid()) {
            slot = method.methodType() == QMetaMethod.MethodType.Signal ? "2" + method.cppMethodSignature() : "1" + method.cppMethodSignature();
        }
        return this.disconnect_native_cref_QString_cref_QString_cref_QString_cref_QString_cref_QString_QObject_ptr_const_char_ptr(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this), service, path, arg__interface, name, signature, QtJambi_LibraryUtilities.internal.checkedNativeId((QtObject)receiver), slot);
    }

    @QtUninvokable
    private native boolean disconnect_native_cref_QString_cref_QString_cref_QString_cref_QString_cref_QString_QObject_ptr_const_char_ptr(long var1, String var3, String var4, String var5, String var6, String var7, long var8, String var10);

    @QtUninvokable
    public final boolean disconnect(@NonNull String service, @NonNull String path, @NonNull String arg__interface, @NonNull String name, @NonNull Collection<@NonNull String> argumentMatch, @NonNull String signature, @Nullable QObject receiver, @Nullable String slot) {
        QMetaMethod method;
        if (slot != null && !slot.startsWith("1") && !slot.startsWith("2") && (method = receiver.metaObject().method(slot, new Class[0])) != null && method.isValid()) {
            slot = method.methodType() == QMetaMethod.MethodType.Signal ? "2" + method.cppMethodSignature() : "1" + method.cppMethodSignature();
        }
        return this.disconnect_native_cref_QString_cref_QString_cref_QString_cref_QString_cref_QStringList_cref_QString_QObject_ptr_const_char_ptr(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this), service, path, arg__interface, name, argumentMatch, signature, QtJambi_LibraryUtilities.internal.checkedNativeId((QtObject)receiver), slot);
    }

    @QtUninvokable
    private native boolean disconnect_native_cref_QString_cref_QString_cref_QString_cref_QString_cref_QStringList_cref_QString_QObject_ptr_const_char_ptr(long var1, String var3, String var4, String var5, String var6, Collection<String> var7, String var8, long var9, String var11);

    @QtUninvokable
    public final @Nullable QDBusConnectionInterface connectionInterface() {
        return this.connectionInterface_native_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
    }

    @QtUninvokable
    private native QDBusConnectionInterface connectionInterface_native_constfct(long var1);

    @QtUninvokable
    public final boolean isConnected() {
        return this.isConnected_native_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
    }

    @QtUninvokable
    private native boolean isConnected_native_constfct(long var1);

    @QtUninvokable
    public final @NonNull QDBusError lastError() {
        return this.lastError_native_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
    }

    @QtUninvokable
    private native QDBusError lastError_native_constfct(long var1);

    @QtUninvokable
    public final @NonNull String name() {
        return this.name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
    }

    @QtUninvokable
    private native String name_native_constfct(long var1);

    @QtUninvokable
    public final @Nullable QObject objectRegisteredAt(@NonNull String path) {
        return this.objectRegisteredAt_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this), path);
    }

    @QtUninvokable
    private native QObject objectRegisteredAt_native_cref_QString_constfct(long var1, String var3);

    @QtUninvokable
    public final void assign(@NonNull QDBusConnection other) {
        this.assign_native_cref_QDBusConnection(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this), QtJambi_LibraryUtilities.internal.checkedNativeId((QtObject)other));
    }

    @QtUninvokable
    private native void assign_native_cref_QDBusConnection(long var1, long var3);

    @QtUninvokable
    public final boolean registerObject(@NonNull String path, @Nullable QObject object, @NonNull RegisterOptions options) {
        return this.registerObject_native_cref_QString_QObject_ptr_QDBusConnection_RegisterOptions(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this), path, QtJambi_LibraryUtilities.internal.checkedNativeId((QtObject)object), options.value());
    }

    @QtUninvokable
    private native boolean registerObject_native_cref_QString_QObject_ptr_QDBusConnection_RegisterOptions(long var1, String var3, long var4, int var6);

    @QtUninvokable
    public final boolean registerObject(@NonNull String path, @NonNull String arg__interface, @Nullable QObject object, @NonNull RegisterOptions options) {
        return this.registerObject_native_cref_QString_cref_QString_QObject_ptr_QDBusConnection_RegisterOptions(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this), path, arg__interface, QtJambi_LibraryUtilities.internal.checkedNativeId((QtObject)object), options.value());
    }

    @QtUninvokable
    private native boolean registerObject_native_cref_QString_cref_QString_QObject_ptr_QDBusConnection_RegisterOptions(long var1, String var3, String var4, long var5, int var7);

    @QtUninvokable
    public final boolean registerService(@NonNull String serviceName) {
        return this.registerService_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this), serviceName);
    }

    @QtUninvokable
    private native boolean registerService_native_cref_QString(long var1, String var3);

    @QtUninvokable
    public final boolean send(@NonNull QDBusMessage message) {
        return this.send_native_cref_QDBusMessage_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this), QtJambi_LibraryUtilities.internal.checkedNativeId((QtObject)message));
    }

    @QtUninvokable
    private native boolean send_native_cref_QDBusMessage_constfct(long var1, long var3);

    @QtUninvokable
    public final void swap(@StrictNonNull QDBusConnection other) {
        Objects.requireNonNull(other, "Argument 'other': null not expected.");
        this.swap_native_ref_QDBusConnection(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this), QtJambi_LibraryUtilities.internal.checkedNativeId((QtObject)other));
    }

    @QtUninvokable
    private native void swap_native_ref_QDBusConnection(long var1, long var3);

    @QtUninvokable
    public final void unregisterObject(@NonNull String path, @NonNull UnregisterMode mode) {
        this.unregisterObject_native_cref_QString_QDBusConnection_UnregisterMode(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this), path, mode.value());
    }

    @QtUninvokable
    private native void unregisterObject_native_cref_QString_QDBusConnection_UnregisterMode(long var1, String var3, int var4);

    @QtUninvokable
    public final boolean unregisterService(@NonNull String serviceName) {
        return this.unregisterService_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this), serviceName);
    }

    @QtUninvokable
    private native boolean unregisterService_native_cref_QString(long var1, String var3);

    public static @NonNull QDBusConnection connectToBus(@NonNull BusType type, @NonNull String name) {
        return QDBusConnection.connectToBus_native_QDBusConnection_BusType_cref_QString(type.value(), name);
    }

    private static native QDBusConnection connectToBus_native_QDBusConnection_BusType_cref_QString(int var0, String var1);

    public static native @NonNull QDBusConnection connectToBus(@NonNull String var0, @NonNull String var1);

    public static native @NonNull QDBusConnection connectToPeer(@NonNull String var0, @NonNull String var1);

    public static native void disconnectFromBus(@NonNull String var0);

    public static native void disconnectFromPeer(@NonNull String var0);

    public static native @NonNull QByteArray localMachineId();

    public static native @NonNull QDBusConnection sessionBus();

    public static native @NonNull QDBusConnection systemBus();

    protected QDBusConnection(QtObject.QPrivateConstructor p) {
        super(p);
    }

    @QtUninvokable
    public QDBusConnection clone() {
        return QDBusConnection.clone_native(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
    }

    private static native QDBusConnection clone_native(long var0);

    @QtUninvokable
    public final @NonNull QDBusPendingCall asyncCall(@NonNull QDBusMessage message) {
        return this.asyncCall(message, -1);
    }

    @QtUninvokable
    public final @NonNull QDBusMessage call(@NonNull QDBusMessage message, @NonNull QDBus.CallMode mode) {
        return this.call(message, mode, -1);
    }

    @QtUninvokable
    public final @NonNull QDBusMessage call(@NonNull QDBusMessage message) {
        return this.call(message, QDBus.CallMode.Block, -1);
    }

    @QtUninvokable
    public final boolean callWithCallback(@NonNull QDBusMessage message, @Nullable QObject receiver, @Nullable String returnMethod, @Nullable String errorMethod) {
        return this.callWithCallback(message, receiver, returnMethod, errorMethod, -1);
    }

    @QtUninvokable
    public final boolean callWithCallback(@NonNull QDBusMessage message, @Nullable QObject receiver, @Nullable String slot) {
        return this.callWithCallback(message, receiver, slot, -1);
    }

    @QtUninvokable
    public final boolean registerObject(@NonNull String path, @Nullable QObject object) {
        return this.registerObject(path, object, new RegisterOptions(1));
    }

    @QtUninvokable
    public final boolean registerObject(@NonNull String path, @Nullable QObject object, RegisterOption ... options) {
        return this.registerObject(path, object, new RegisterOptions(options));
    }

    @QtUninvokable
    public final boolean registerObject(@NonNull String path, @NonNull String arg__interface, @Nullable QObject object) {
        return this.registerObject(path, arg__interface, object, new RegisterOptions(1));
    }

    @QtUninvokable
    public final boolean registerObject(@NonNull String path, @NonNull String arg__interface, @Nullable QObject object, RegisterOption ... options) {
        return this.registerObject(path, arg__interface, object, new RegisterOptions(options));
    }

    @QtUninvokable
    public final void unregisterObject(@NonNull String path) {
        this.unregisterObject(path, UnregisterMode.UnregisterNode);
    }

    static {
        QtJambi_LibraryUtilities.initialize();
        staticMetaObject = QMetaObject.forType(QDBusConnection.class);
    }

    public static final class ConnectionCapabilities
    extends QFlags<ConnectionCapability>
    implements Comparable<ConnectionCapabilities> {
        private static final long serialVersionUID = 126162492624525301L;

        public ConnectionCapabilities(ConnectionCapability ... args) {
            super((QtAbstractFlagEnumerator[])args);
        }

        public ConnectionCapabilities(int value) {
            super(value);
        }

        public final @NonNull ConnectionCapabilities combined(@StrictNonNull ConnectionCapability e) {
            return new ConnectionCapabilities(this.value() | e.value());
        }

        public final @NonNull ConnectionCapabilities setFlag(@Nullable ConnectionCapability e) {
            return this.setFlag(e, true);
        }

        public final @NonNull ConnectionCapabilities setFlag(@Nullable ConnectionCapability e, boolean on) {
            if (on) {
                this.setValue(this.value() | e.value());
            } else {
                this.setValue(this.value() & ~e.value());
            }
            return this;
        }

        public final @NonNull ConnectionCapability @NonNull [] flags() {
            return (ConnectionCapability[])super.flags((QtAbstractFlagEnumerator[])ConnectionCapability.values());
        }

        public final @NonNull ConnectionCapabilities clone() {
            return new ConnectionCapabilities(this.value());
        }

        @Override
        public final int compareTo(@StrictNonNull ConnectionCapabilities other) {
            return Integer.compare(this.value(), other.value());
        }

        static {
            QtJambi_LibraryUtilities.initialize();
        }
    }

    public static final class RegisterOptions
    extends QFlags<RegisterOption>
    implements Comparable<RegisterOptions> {
        private static final long serialVersionUID = -3485871768691274005L;

        public RegisterOptions(RegisterOption ... args) {
            super((QtAbstractFlagEnumerator[])args);
        }

        public RegisterOptions(int value) {
            super(value);
        }

        public final @NonNull RegisterOptions combined(@StrictNonNull RegisterOption e) {
            return new RegisterOptions(this.value() | e.value());
        }

        public final @NonNull RegisterOptions setFlag(@Nullable RegisterOption e) {
            return this.setFlag(e, true);
        }

        public final @NonNull RegisterOptions setFlag(@Nullable RegisterOption e, boolean on) {
            if (on) {
                this.setValue(this.value() | e.value());
            } else {
                this.setValue(this.value() & ~e.value());
            }
            return this;
        }

        public final @NonNull RegisterOption @NonNull [] flags() {
            return (RegisterOption[])super.flags((QtAbstractFlagEnumerator[])RegisterOption.values());
        }

        public final @NonNull RegisterOptions clone() {
            return new RegisterOptions(this.value());
        }

        @Override
        public final int compareTo(@StrictNonNull RegisterOptions other) {
            return Integer.compare(this.value(), other.value());
        }

        static {
            QtJambi_LibraryUtilities.initialize();
        }
    }

    public static enum UnregisterMode implements QtEnumerator
    {
        UnregisterNode(0),
        UnregisterTree(1);

        private final int value;

        private UnregisterMode(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public static @NonNull UnregisterMode resolve(int value) {
            switch (value) {
                case 0: {
                    return UnregisterNode;
                }
                case 1: {
                    return UnregisterTree;
                }
            }
            throw new QNoSuchEnumValueException(value);
        }

        static {
            QtJambi_LibraryUtilities.initialize();
        }
    }

    public static enum BusType implements QtEnumerator
    {
        SessionBus(0),
        SystemBus(1),
        ActivationBus(2);

        private final int value;

        private BusType(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public static @NonNull BusType resolve(int value) {
            switch (value) {
                case 0: {
                    return SessionBus;
                }
                case 1: {
                    return SystemBus;
                }
                case 2: {
                    return ActivationBus;
                }
            }
            throw new QNoSuchEnumValueException(value);
        }

        static {
            QtJambi_LibraryUtilities.initialize();
        }
    }

    @QtRejectedEntries(value={"ExportAllSignal"})
    public static enum RegisterOption implements QtFlagEnumerator
    {
        ExportAdaptors(1),
        ExportScriptableSlots(16),
        ExportScriptableSignals(32),
        ExportScriptableProperties(64),
        ExportScriptableInvokables(128),
        ExportScriptableContents(240),
        ExportNonScriptableSlots(256),
        ExportNonScriptableSignals(512),
        ExportNonScriptableProperties(1024),
        ExportNonScriptableInvokables(2048),
        ExportNonScriptableContents(3840),
        ExportAllSlots(272),
        ExportAllSignals(544),
        ExportAllProperties(1088),
        ExportAllInvokables(2176),
        ExportAllContents(4080),
        ExportAllSignal(544),
        ExportChildObjects(4096);

        private final int value;

        private RegisterOption(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public @NonNull RegisterOptions asFlags() {
            return new RegisterOptions(this.value);
        }

        public @NonNull RegisterOptions combined(@NonNull RegisterOption e) {
            return this.asFlags().setFlag(e, true);
        }

        public @NonNull RegisterOptions cleared(@NonNull RegisterOption e) {
            return this.asFlags().setFlag(e, false);
        }

        public static @NonNull RegisterOptions flags(RegisterOption ... values) {
            return new RegisterOptions(values);
        }

        public static @NonNull RegisterOption resolve(int value) {
            switch (value) {
                case 1: {
                    return ExportAdaptors;
                }
                case 16: {
                    return ExportScriptableSlots;
                }
                case 32: {
                    return ExportScriptableSignals;
                }
                case 64: {
                    return ExportScriptableProperties;
                }
                case 128: {
                    return ExportScriptableInvokables;
                }
                case 240: {
                    return ExportScriptableContents;
                }
                case 256: {
                    return ExportNonScriptableSlots;
                }
                case 512: {
                    return ExportNonScriptableSignals;
                }
                case 1024: {
                    return ExportNonScriptableProperties;
                }
                case 2048: {
                    return ExportNonScriptableInvokables;
                }
                case 3840: {
                    return ExportNonScriptableContents;
                }
                case 272: {
                    return ExportAllSlots;
                }
                case 544: {
                    return ExportAllSignals;
                }
                case 1088: {
                    return ExportAllProperties;
                }
                case 2176: {
                    return ExportAllInvokables;
                }
                case 4080: {
                    return ExportAllContents;
                }
                case 4096: {
                    return ExportChildObjects;
                }
            }
            throw new QNoSuchEnumValueException(value);
        }

        static {
            QtJambi_LibraryUtilities.initialize();
        }
    }

    public static final class VirtualObjectRegisterOptions
    extends QFlags<VirtualObjectRegisterOption>
    implements Comparable<VirtualObjectRegisterOptions> {
        private static final long serialVersionUID = 1954271149534219651L;

        public VirtualObjectRegisterOptions(VirtualObjectRegisterOption ... args) {
            super((QtAbstractFlagEnumerator[])args);
        }

        public VirtualObjectRegisterOptions(int value) {
            super(value);
        }

        public final @NonNull VirtualObjectRegisterOptions combined(@StrictNonNull VirtualObjectRegisterOption e) {
            return new VirtualObjectRegisterOptions(this.value() | e.value());
        }

        public final @NonNull VirtualObjectRegisterOptions setFlag(@Nullable VirtualObjectRegisterOption e) {
            return this.setFlag(e, true);
        }

        public final @NonNull VirtualObjectRegisterOptions setFlag(@Nullable VirtualObjectRegisterOption e, boolean on) {
            if (on) {
                this.setValue(this.value() | e.value());
            } else {
                this.setValue(this.value() & ~e.value());
            }
            return this;
        }

        public final @NonNull VirtualObjectRegisterOption @NonNull [] flags() {
            return (VirtualObjectRegisterOption[])super.flags((QtAbstractFlagEnumerator[])VirtualObjectRegisterOption.values());
        }

        public final @NonNull VirtualObjectRegisterOptions clone() {
            return new VirtualObjectRegisterOptions(this.value());
        }

        @Override
        public final int compareTo(@StrictNonNull VirtualObjectRegisterOptions other) {
            return Integer.compare(this.value(), other.value());
        }

        static {
            QtJambi_LibraryUtilities.initialize();
        }
    }

    public static enum VirtualObjectRegisterOption implements QtFlagEnumerator
    {
        SingleNode(0),
        SubPath(1);

        private final int value;

        private VirtualObjectRegisterOption(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public @NonNull VirtualObjectRegisterOptions asFlags() {
            return new VirtualObjectRegisterOptions(this.value);
        }

        public @NonNull VirtualObjectRegisterOptions combined(@NonNull VirtualObjectRegisterOption e) {
            return this.asFlags().setFlag(e, true);
        }

        public @NonNull VirtualObjectRegisterOptions cleared(@NonNull VirtualObjectRegisterOption e) {
            return this.asFlags().setFlag(e, false);
        }

        public static @NonNull VirtualObjectRegisterOptions flags(VirtualObjectRegisterOption ... values) {
            return new VirtualObjectRegisterOptions(values);
        }

        public static @NonNull VirtualObjectRegisterOption resolve(int value) {
            switch (value) {
                case 0: {
                    return SingleNode;
                }
                case 1: {
                    return SubPath;
                }
            }
            throw new QNoSuchEnumValueException(value);
        }

        static {
            QtJambi_LibraryUtilities.initialize();
        }
    }

    public static enum ConnectionCapability implements QtFlagEnumerator
    {
        UnixFileDescriptorPassing(1);

        private final int value;

        private ConnectionCapability(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public @NonNull ConnectionCapabilities asFlags() {
            return new ConnectionCapabilities(this.value);
        }

        public @NonNull ConnectionCapabilities combined(@NonNull ConnectionCapability e) {
            return this.asFlags().setFlag(e, true);
        }

        public @NonNull ConnectionCapabilities cleared(@NonNull ConnectionCapability e) {
            return this.asFlags().setFlag(e, false);
        }

        public static @NonNull ConnectionCapabilities flags(ConnectionCapability ... values) {
            return new ConnectionCapabilities(values);
        }

        public static @NonNull ConnectionCapability resolve(int value) {
            switch (value) {
                case 1: {
                    return UnixFileDescriptorPassing;
                }
            }
            throw new QNoSuchEnumValueException(value);
        }

        static {
            QtJambi_LibraryUtilities.initialize();
        }
    }
}

