package io.qt.dbus;

import io.qt.*;


/**
 * <p>Holds one Unix file descriptor</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qdbusunixfiledescriptor.html">QDBusUnixFileDescriptor</a></code></p>
 */
public class QDBusUnixFileDescriptor extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusunixfiledescriptor.html#QDBusUnixFileDescriptor">QDBusUnixFileDescriptor::<wbr/>QDBusUnixFileDescriptor()</a></code></p>
     */
    public QDBusUnixFileDescriptor(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QDBusUnixFileDescriptor instance);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusunixfiledescriptor.html#QDBusUnixFileDescriptor-2">QDBusUnixFileDescriptor::<wbr/>QDBusUnixFileDescriptor(QDBusUnixFileDescriptor)</a></code></p>
     */
    public QDBusUnixFileDescriptor(io.qt.dbus.@NonNull QDBusUnixFileDescriptor other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QDBusUnixFileDescriptor instance, io.qt.dbus.QDBusUnixFileDescriptor other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusunixfiledescriptor.html#QDBusUnixFileDescriptor-1">QDBusUnixFileDescriptor::<wbr/>QDBusUnixFileDescriptor(int)</a></code></p>
     */
    public QDBusUnixFileDescriptor(int fileDescriptor){
        super((QPrivateConstructor)null);
        initialize_native(this, fileDescriptor);
    }
    
    private native static void initialize_native(QDBusUnixFileDescriptor instance, int fileDescriptor);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusunixfiledescriptor.html#fileDescriptor">QDBusUnixFileDescriptor::<wbr/>fileDescriptor()const</a></code></p>
     */
    @QtUninvokable
    public final int fileDescriptor(){
        return fileDescriptor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int fileDescriptor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QDBusUnixFileDescriptor::<wbr/>giveFileDescriptor(int)</code></p>
     */
    @QtUninvokable
    public final void giveFileDescriptor(int fileDescriptor){
        giveFileDescriptor_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), fileDescriptor);
    }
    
    @QtUninvokable
    private native void giveFileDescriptor_native_int(long __this__nativeId, int fileDescriptor);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusunixfiledescriptor.html#isValid">QDBusUnixFileDescriptor::<wbr/>isValid()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusunixfiledescriptor.html#operator-eq-1">QDBusUnixFileDescriptor::<wbr/>operator=(QDBusUnixFileDescriptor)</a></code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.dbus.@NonNull QDBusUnixFileDescriptor other){
        assign_native_cref_QDBusUnixFileDescriptor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QDBusUnixFileDescriptor(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusunixfiledescriptor.html#setFileDescriptor">QDBusUnixFileDescriptor::<wbr/>setFileDescriptor(int)</a></code></p>
     */
    @QtUninvokable
    public final void setFileDescriptor(int fileDescriptor){
        setFileDescriptor_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), fileDescriptor);
    }
    
    @QtUninvokable
    private native void setFileDescriptor_native_int(long __this__nativeId, int fileDescriptor);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusunixfiledescriptor.html#swap">QDBusUnixFileDescriptor::<wbr/>swap(QDBusUnixFileDescriptor&amp;)</a></code></p>
     */
    @QtUninvokable
    public final void swap(io.qt.dbus.@StrictNonNull QDBusUnixFileDescriptor other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QDBusUnixFileDescriptor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void swap_native_ref_QDBusUnixFileDescriptor(long __this__nativeId, long other);
    
    /**
     * <p>See <code>QDBusUnixFileDescriptor::<wbr/>takeFileDescriptor()</code></p>
     */
    @QtUninvokable
    public final int takeFileDescriptor(){
        return takeFileDescriptor_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int takeFileDescriptor_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusunixfiledescriptor.html#isSupported">QDBusUnixFileDescriptor::<wbr/>isSupported()</a></code></p>
     */
    public native static boolean isSupported();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QDBusUnixFileDescriptor(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Creates and returns a copy of this object.</p>
    <p>See <code><a href="https://doc.qt.io/qt/qdbusunixfiledescriptor.html#QDBusUnixFileDescriptor-2">QDBusUnixFileDescriptor::<wbr/>QDBusUnixFileDescriptor(QDBusUnixFileDescriptor)</a></code></p>
     */
    @QtUninvokable
    @Override
    public QDBusUnixFileDescriptor clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QDBusUnixFileDescriptor clone_native(long __this_nativeId);
}
