package io.qt.dbus;

import io.qt.*;


/**
 * <p>Represents a connection to the D-Bus bus daemon</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qdbusconnection.html">QDBusConnection</a></code></p>
 */
public class QDBusConnection extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QDBusConnection.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qdbusconnection.html#BusType-enum">QDBusConnection::BusType</a></code></p>
     */
    public enum BusType implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbusconnection.html#BusType-enum">QDBusConnection::<wbr/>SessionBus</a></code></p>
         */
        SessionBus(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbusconnection.html#BusType-enum">QDBusConnection::<wbr/>SystemBus</a></code></p>
         */
        SystemBus(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbusconnection.html#BusType-enum">QDBusConnection::<wbr/>ActivationBus</a></code></p>
         */
        ActivationBus(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private BusType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull BusType resolve(int value) {
            switch (value) {
            case 0: return SessionBus;
            case 1: return SystemBus;
            case 2: return ActivationBus;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qdbusconnection.html#ConnectionCapability-enum">QDBusConnection::ConnectionCapability</a></code></p>
     * 
     * @see ConnectionCapabilities
     */
    public enum ConnectionCapability implements QtFlagEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbusconnection.html#ConnectionCapability-enum">QDBusConnection::<wbr/>UnixFileDescriptorPassing</a></code></p>
         */
        UnixFileDescriptorPassing(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ConnectionCapability(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public @NonNull ConnectionCapabilities asFlags() {
            return new ConnectionCapabilities(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull ConnectionCapabilities combined(@NonNull ConnectionCapability e) {
            return asFlags().setFlag(e, true);
        }

        /**
         * Excludes other enum entry from a flag of this entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull ConnectionCapabilities cleared(@NonNull ConnectionCapability e) {
            return asFlags().setFlag(e, false);
        }

        /**
         * Creates a new {@link ConnectionCapabilities} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull ConnectionCapabilities flags(@Nullable ConnectionCapability @NonNull... values) {
            return new ConnectionCapabilities(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ConnectionCapability resolve(int value) {
            switch (value) {
            case 1: return UnixFileDescriptorPassing;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * {@link QFlags} type for enum {@link ConnectionCapability}
     */
    public static final class ConnectionCapabilities extends QFlags<ConnectionCapability> implements Comparable<ConnectionCapabilities> {
        private static final long serialVersionUID = 0x1c0381e5cdcd7f5L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new ConnectionCapabilities where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public ConnectionCapabilities(@Nullable ConnectionCapability @NonNull... args){
            super(args);
        }

        /**
         * Creates a new ConnectionCapabilities with given <code>value</code>.
         * @param value
         */
        public ConnectionCapabilities(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new ConnectionCapabilities
         */
        @Override
        public final @NonNull ConnectionCapabilities combined(@StrictNonNull ConnectionCapability e){
            return new ConnectionCapabilities(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final @NonNull ConnectionCapabilities setFlag(@Nullable ConnectionCapability e){
            return setFlag(e, true);
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final @NonNull ConnectionCapabilities setFlag(@Nullable ConnectionCapability e, boolean on){
            if (on) {
            	setValue(value() | e.value());
            }else {
            	setValue(value() & ~e.value());
            }
            return this;
        }

        /**
         * Returns an array of flag objects represented by this ConnectionCapabilities.
         * @return array of enum entries
         */
        @Override
        public final @NonNull ConnectionCapability @NonNull[] flags(){
            return super.flags(ConnectionCapability.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull ConnectionCapabilities clone(){
            return new ConnectionCapabilities(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull ConnectionCapabilities other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qdbusconnection.html#RegisterOption-enum">QDBusConnection::RegisterOption</a></code></p>
     * 
     * @see RegisterOptions
     */
    @QtRejectedEntries({"ExportAllSignal"})
    public enum RegisterOption implements QtFlagEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbusconnection.html#RegisterOption-enum">QDBusConnection::<wbr/>ExportAdaptors</a></code></p>
         */
        ExportAdaptors(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbusconnection.html#RegisterOption-enum">QDBusConnection::<wbr/>ExportScriptableSlots</a></code></p>
         */
        ExportScriptableSlots(16),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbusconnection.html#RegisterOption-enum">QDBusConnection::<wbr/>ExportScriptableSignals</a></code></p>
         */
        ExportScriptableSignals(32),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbusconnection.html#RegisterOption-enum">QDBusConnection::<wbr/>ExportScriptableProperties</a></code></p>
         */
        ExportScriptableProperties(64),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbusconnection.html#RegisterOption-enum">QDBusConnection::<wbr/>ExportScriptableInvokables</a></code></p>
         */
        ExportScriptableInvokables(128),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbusconnection.html#RegisterOption-enum">QDBusConnection::<wbr/>ExportScriptableContents</a></code></p>
         */
        ExportScriptableContents(240),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbusconnection.html#RegisterOption-enum">QDBusConnection::<wbr/>ExportNonScriptableSlots</a></code></p>
         */
        ExportNonScriptableSlots(256),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbusconnection.html#RegisterOption-enum">QDBusConnection::<wbr/>ExportNonScriptableSignals</a></code></p>
         */
        ExportNonScriptableSignals(512),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbusconnection.html#RegisterOption-enum">QDBusConnection::<wbr/>ExportNonScriptableProperties</a></code></p>
         */
        ExportNonScriptableProperties(1024),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbusconnection.html#RegisterOption-enum">QDBusConnection::<wbr/>ExportNonScriptableInvokables</a></code></p>
         */
        ExportNonScriptableInvokables(2048),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbusconnection.html#RegisterOption-enum">QDBusConnection::<wbr/>ExportNonScriptableContents</a></code></p>
         */
        ExportNonScriptableContents(3840),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbusconnection.html#RegisterOption-enum">QDBusConnection::<wbr/>ExportAllSlots</a></code></p>
         */
        ExportAllSlots(272),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbusconnection.html#RegisterOption-enum">QDBusConnection::<wbr/>ExportAllSignals</a></code></p>
         */
        ExportAllSignals(544),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbusconnection.html#RegisterOption-enum">QDBusConnection::<wbr/>ExportAllProperties</a></code></p>
         */
        ExportAllProperties(1088),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbusconnection.html#RegisterOption-enum">QDBusConnection::<wbr/>ExportAllInvokables</a></code></p>
         */
        ExportAllInvokables(2176),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbusconnection.html#RegisterOption-enum">QDBusConnection::<wbr/>ExportAllContents</a></code></p>
         */
        ExportAllContents(4080),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbusconnection.html#RegisterOption-enum">QDBusConnection::<wbr/>ExportAllSignal</a></code></p>
         */
        ExportAllSignal(544),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbusconnection.html#RegisterOption-enum">QDBusConnection::<wbr/>ExportChildObjects</a></code></p>
         */
        ExportChildObjects(4096);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private RegisterOption(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public @NonNull RegisterOptions asFlags() {
            return new RegisterOptions(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull RegisterOptions combined(@NonNull RegisterOption e) {
            return asFlags().setFlag(e, true);
        }

        /**
         * Excludes other enum entry from a flag of this entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull RegisterOptions cleared(@NonNull RegisterOption e) {
            return asFlags().setFlag(e, false);
        }

        /**
         * Creates a new {@link RegisterOptions} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull RegisterOptions flags(@Nullable RegisterOption @NonNull... values) {
            return new RegisterOptions(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull RegisterOption resolve(int value) {
            switch (value) {
            case 1: return ExportAdaptors;
            case 16: return ExportScriptableSlots;
            case 32: return ExportScriptableSignals;
            case 64: return ExportScriptableProperties;
            case 128: return ExportScriptableInvokables;
            case 240: return ExportScriptableContents;
            case 256: return ExportNonScriptableSlots;
            case 512: return ExportNonScriptableSignals;
            case 1024: return ExportNonScriptableProperties;
            case 2048: return ExportNonScriptableInvokables;
            case 3840: return ExportNonScriptableContents;
            case 272: return ExportAllSlots;
            case 544: return ExportAllSignals;
            case 1088: return ExportAllProperties;
            case 2176: return ExportAllInvokables;
            case 4080: return ExportAllContents;
            case 4096: return ExportChildObjects;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * {@link QFlags} type for enum {@link RegisterOption}
     */
    public static final class RegisterOptions extends QFlags<RegisterOption> implements Comparable<RegisterOptions> {
        private static final long serialVersionUID = 0xcf9fb21866980eebL;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new RegisterOptions where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public RegisterOptions(@Nullable RegisterOption @NonNull... args){
            super(args);
        }

        /**
         * Creates a new RegisterOptions with given <code>value</code>.
         * @param value
         */
        public RegisterOptions(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new RegisterOptions
         */
        @Override
        public final @NonNull RegisterOptions combined(@StrictNonNull RegisterOption e){
            return new RegisterOptions(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final @NonNull RegisterOptions setFlag(@Nullable RegisterOption e){
            return setFlag(e, true);
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final @NonNull RegisterOptions setFlag(@Nullable RegisterOption e, boolean on){
            if (on) {
            	setValue(value() | e.value());
            }else {
            	setValue(value() & ~e.value());
            }
            return this;
        }

        /**
         * Returns an array of flag objects represented by this RegisterOptions.
         * @return array of enum entries
         */
        @Override
        public final @NonNull RegisterOption @NonNull[] flags(){
            return super.flags(RegisterOption.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull RegisterOptions clone(){
            return new RegisterOptions(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull RegisterOptions other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qdbusconnection.html#UnregisterMode-enum">QDBusConnection::UnregisterMode</a></code></p>
     */
    public enum UnregisterMode implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbusconnection.html#UnregisterMode-enum">QDBusConnection::<wbr/>UnregisterNode</a></code></p>
         */
        UnregisterNode(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbusconnection.html#UnregisterMode-enum">QDBusConnection::<wbr/>UnregisterTree</a></code></p>
         */
        UnregisterTree(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private UnregisterMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull UnregisterMode resolve(int value) {
            switch (value) {
            case 0: return UnregisterNode;
            case 1: return UnregisterTree;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code>QDBusConnection::VirtualObjectRegisterOption</code></p>
     * 
     * @see VirtualObjectRegisterOptions
     */
    public enum VirtualObjectRegisterOption implements QtFlagEnumerator {
        /**
         * <p>Representing <code>QDBusConnection::<wbr/>SingleNode</code></p>
         */
        SingleNode(0),
        /**
         * <p>Representing <code>QDBusConnection::<wbr/>SubPath</code></p>
         */
        SubPath(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private VirtualObjectRegisterOption(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public @NonNull VirtualObjectRegisterOptions asFlags() {
            return new VirtualObjectRegisterOptions(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull VirtualObjectRegisterOptions combined(@NonNull VirtualObjectRegisterOption e) {
            return asFlags().setFlag(e, true);
        }

        /**
         * Excludes other enum entry from a flag of this entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull VirtualObjectRegisterOptions cleared(@NonNull VirtualObjectRegisterOption e) {
            return asFlags().setFlag(e, false);
        }

        /**
         * Creates a new {@link VirtualObjectRegisterOptions} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull VirtualObjectRegisterOptions flags(@Nullable VirtualObjectRegisterOption @NonNull... values) {
            return new VirtualObjectRegisterOptions(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull VirtualObjectRegisterOption resolve(int value) {
            switch (value) {
            case 0: return SingleNode;
            case 1: return SubPath;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * {@link QFlags} type for enum {@link VirtualObjectRegisterOption}
     */
    public static final class VirtualObjectRegisterOptions extends QFlags<VirtualObjectRegisterOption> implements Comparable<VirtualObjectRegisterOptions> {
        private static final long serialVersionUID = 0x1b1ef7419ec80d83L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new VirtualObjectRegisterOptions where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public VirtualObjectRegisterOptions(@Nullable VirtualObjectRegisterOption @NonNull... args){
            super(args);
        }

        /**
         * Creates a new VirtualObjectRegisterOptions with given <code>value</code>.
         * @param value
         */
        public VirtualObjectRegisterOptions(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new VirtualObjectRegisterOptions
         */
        @Override
        public final @NonNull VirtualObjectRegisterOptions combined(@StrictNonNull VirtualObjectRegisterOption e){
            return new VirtualObjectRegisterOptions(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final @NonNull VirtualObjectRegisterOptions setFlag(@Nullable VirtualObjectRegisterOption e){
            return setFlag(e, true);
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final @NonNull VirtualObjectRegisterOptions setFlag(@Nullable VirtualObjectRegisterOption e, boolean on){
            if (on) {
            	setValue(value() | e.value());
            }else {
            	setValue(value() & ~e.value());
            }
            return this;
        }

        /**
         * Returns an array of flag objects represented by this VirtualObjectRegisterOptions.
         * @return array of enum entries
         */
        @Override
        public final @NonNull VirtualObjectRegisterOption @NonNull[] flags(){
            return super.flags(VirtualObjectRegisterOption.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull VirtualObjectRegisterOptions clone(){
            return new VirtualObjectRegisterOptions(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull VirtualObjectRegisterOptions other){
            return Integer.compare(value(), other.value());
        }
    }
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusconnection.html#QDBusConnection-1">QDBusConnection::<wbr/>QDBusConnection(QDBusConnection)</a></code></p>
     */
    public QDBusConnection(io.qt.dbus.@NonNull QDBusConnection other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QDBusConnection instance, io.qt.dbus.QDBusConnection other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusconnection.html#QDBusConnection">QDBusConnection::<wbr/>QDBusConnection(QString)</a></code></p>
     */
    public QDBusConnection(java.lang.@NonNull String name){
        super((QPrivateConstructor)null);
        initialize_native(this, name);
    }
    
    private native static void initialize_native(QDBusConnection instance, java.lang.String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusconnection.html#asyncCall">QDBusConnection::<wbr/>asyncCall(QDBusMessage,<wbr/>int)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.dbus.@NonNull QDBusPendingCall asyncCall(io.qt.dbus.@NonNull QDBusMessage message, int timeout){
        return asyncCall_native_cref_QDBusMessage_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(message), timeout);
    }
    
    @QtUninvokable
    private native io.qt.dbus.QDBusPendingCall asyncCall_native_cref_QDBusMessage_int_constfct(long __this__nativeId, long message, int timeout);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusconnection.html#baseService">QDBusConnection::<wbr/>baseService()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String baseService(){
        return baseService_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String baseService_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusconnection.html#call">QDBusConnection::<wbr/>call(QDBusMessage,<wbr/>QDBus::CallMode,<wbr/>int)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.dbus.@NonNull QDBusMessage call(io.qt.dbus.@NonNull QDBusMessage message, io.qt.dbus.QDBus.@NonNull CallMode mode, int timeout){
        return call_native_cref_QDBusMessage_QDBus_CallMode_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(message), mode.value(), timeout);
    }
    
    @QtUninvokable
    private native io.qt.dbus.QDBusMessage call_native_cref_QDBusMessage_QDBus_CallMode_int_constfct(long __this__nativeId, long message, int mode, int timeout);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusconnection.html#callWithCallback">QDBusConnection::<wbr/>callWithCallback(QDBusMessage,<wbr/>QObject*,<wbr/>const char*,<wbr/>const char*,<wbr/>int)const</a></code></p>
     */
    @QtUninvokable
    public final boolean callWithCallback(io.qt.dbus.@NonNull QDBusMessage message, io.qt.core.@Nullable QObject receiver, java.lang.@Nullable String returnMethod, java.lang.@Nullable String errorMethod, int timeout){
        if(returnMethod!=null && !returnMethod.startsWith("1") && !returnMethod.startsWith("2")) {
            io.qt.core.QMetaMethod method = receiver.metaObject().method(returnMethod);
            if(method!=null && method.isValid()) {
                if(method.methodType()==io.qt.core.QMetaMethod.MethodType.Signal)
                    returnMethod = "2" + method.cppMethodSignature();
                else
                    returnMethod = "1" + method.cppMethodSignature();
            }
        }
        if(errorMethod!=null && !errorMethod.startsWith("1") && !errorMethod.startsWith("2")) {
            io.qt.core.QMetaMethod method = receiver.metaObject().method(errorMethod);
            if(method!=null && method.isValid()) {
                if(method.methodType()==io.qt.core.QMetaMethod.MethodType.Signal)
                    errorMethod = "2" + method.cppMethodSignature();
                else
                    errorMethod = "1" + method.cppMethodSignature();
            }
        }
        return callWithCallback_native_cref_QDBusMessage_QObject_ptr_const_char_ptr_const_char_ptr_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(message), QtJambi_LibraryUtilities.internal.checkedNativeId(receiver), returnMethod, errorMethod, timeout);
    }
    
    @QtUninvokable
    private native boolean callWithCallback_native_cref_QDBusMessage_QObject_ptr_const_char_ptr_const_char_ptr_int_constfct(long __this__nativeId, long message, long receiver, java.lang.String returnMethod, java.lang.String errorMethod, int timeout);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusconnection.html#callWithCallback">QDBusConnection::<wbr/>callWithCallback(QDBusMessage,<wbr/>QObject*,<wbr/>const char*,<wbr/>int)const</a></code></p>
     */
    @QtUninvokable
    public final boolean callWithCallback(io.qt.dbus.@NonNull QDBusMessage message, io.qt.core.@Nullable QObject receiver, java.lang.@Nullable String slot, int timeout){
        if(slot!=null && !slot.startsWith("1") && !slot.startsWith("2")) {
            io.qt.core.QMetaMethod method = receiver.metaObject().method(slot);
            if(method!=null && method.isValid()) {
                if(method.methodType()==io.qt.core.QMetaMethod.MethodType.Signal)
                    slot = "2" + method.cppMethodSignature();
                else
                    slot = "1" + method.cppMethodSignature();
            }
        }
        return callWithCallback_native_cref_QDBusMessage_QObject_ptr_const_char_ptr_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(message), QtJambi_LibraryUtilities.internal.checkedNativeId(receiver), slot, timeout);
    }
    
    @QtUninvokable
    private native boolean callWithCallback_native_cref_QDBusMessage_QObject_ptr_const_char_ptr_int_constfct(long __this__nativeId, long message, long receiver, java.lang.String slot, int timeout);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusconnection.html#connect">QDBusConnection::<wbr/>connect(QString,<wbr/>QString,<wbr/>QString,<wbr/>QString,<wbr/>QObject*,<wbr/>const char*)</a></code></p>
     */
    @QtUninvokable
    public final boolean connect(java.lang.@NonNull String service, java.lang.@NonNull String path, java.lang.@NonNull String arg__interface, java.lang.@NonNull String name, io.qt.core.@Nullable QObject receiver, java.lang.@Nullable String slot){
        if(slot!=null && !slot.startsWith("1") && !slot.startsWith("2")) {
            io.qt.core.QMetaMethod method = receiver.metaObject().method(slot);
            if(method!=null && method.isValid()) {
                if(method.methodType()==io.qt.core.QMetaMethod.MethodType.Signal)
                    slot = "2" + method.cppMethodSignature();
                else
                    slot = "1" + method.cppMethodSignature();
            }
        }
        return connect_native_cref_QString_cref_QString_cref_QString_cref_QString_QObject_ptr_const_char_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), service, path, arg__interface, name, QtJambi_LibraryUtilities.internal.checkedNativeId(receiver), slot);
    }
    
    @QtUninvokable
    private native boolean connect_native_cref_QString_cref_QString_cref_QString_cref_QString_QObject_ptr_const_char_ptr(long __this__nativeId, java.lang.String service, java.lang.String path, java.lang.String arg__interface, java.lang.String name, long receiver, java.lang.String slot);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusconnection.html#connect-1">QDBusConnection::<wbr/>connect(QString,<wbr/>QString,<wbr/>QString,<wbr/>QString,<wbr/>QString,<wbr/>QObject*,<wbr/>const char*)</a></code></p>
     */
    @QtUninvokable
    public final boolean connect(java.lang.@NonNull String service, java.lang.@NonNull String path, java.lang.@NonNull String arg__interface, java.lang.@NonNull String name, java.lang.@NonNull String signature, io.qt.core.@Nullable QObject receiver, java.lang.@Nullable String slot){
        if(slot!=null && !slot.startsWith("1") && !slot.startsWith("2")) {
            io.qt.core.QMetaMethod method = receiver.metaObject().method(slot);
            if(method!=null && method.isValid()) {
                if(method.methodType()==io.qt.core.QMetaMethod.MethodType.Signal)
                    slot = "2" + method.cppMethodSignature();
                else
                    slot = "1" + method.cppMethodSignature();
            }
        }
        return connect_native_cref_QString_cref_QString_cref_QString_cref_QString_cref_QString_QObject_ptr_const_char_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), service, path, arg__interface, name, signature, QtJambi_LibraryUtilities.internal.checkedNativeId(receiver), slot);
    }
    
    @QtUninvokable
    private native boolean connect_native_cref_QString_cref_QString_cref_QString_cref_QString_cref_QString_QObject_ptr_const_char_ptr(long __this__nativeId, java.lang.String service, java.lang.String path, java.lang.String arg__interface, java.lang.String name, java.lang.String signature, long receiver, java.lang.String slot);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusconnection.html#connect-2">QDBusConnection::<wbr/>connect(QString,<wbr/>QString,<wbr/>QString,<wbr/>QString,<wbr/>QStringList,<wbr/>QString,<wbr/>QObject*,<wbr/>const char*)</a></code></p>
     */
    @QtUninvokable
    public final boolean connect(java.lang.@NonNull String service, java.lang.@NonNull String path, java.lang.@NonNull String arg__interface, java.lang.@NonNull String name, java.util.@NonNull Collection<java.lang.@NonNull String> argumentMatch, java.lang.@NonNull String signature, io.qt.core.@Nullable QObject receiver, java.lang.@Nullable String slot){
        if(slot!=null && !slot.startsWith("1") && !slot.startsWith("2")) {
            io.qt.core.QMetaMethod method = receiver.metaObject().method(slot);
            if(method!=null && method.isValid()) {
                if(method.methodType()==io.qt.core.QMetaMethod.MethodType.Signal)
                    slot = "2" + method.cppMethodSignature();
                else
                    slot = "1" + method.cppMethodSignature();
            }
        }
        return connect_native_cref_QString_cref_QString_cref_QString_cref_QString_cref_QStringList_cref_QString_QObject_ptr_const_char_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), service, path, arg__interface, name, argumentMatch, signature, QtJambi_LibraryUtilities.internal.checkedNativeId(receiver), slot);
    }
    
    @QtUninvokable
    private native boolean connect_native_cref_QString_cref_QString_cref_QString_cref_QString_cref_QStringList_cref_QString_QObject_ptr_const_char_ptr(long __this__nativeId, java.lang.String service, java.lang.String path, java.lang.String arg__interface, java.lang.String name, java.util.Collection<java.lang.String> argumentMatch, java.lang.String signature, long receiver, java.lang.String slot);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusconnection.html#connectionCapabilities">QDBusConnection::<wbr/>connectionCapabilities()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.dbus.QDBusConnection.@NonNull ConnectionCapabilities connectionCapabilities(){
        return new io.qt.dbus.QDBusConnection.ConnectionCapabilities(connectionCapabilities_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int connectionCapabilities_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusconnection.html#disconnect">QDBusConnection::<wbr/>disconnect(QString,<wbr/>QString,<wbr/>QString,<wbr/>QString,<wbr/>QObject*,<wbr/>const char*)</a></code></p>
     */
    @QtUninvokable
    public final boolean disconnect(java.lang.@NonNull String service, java.lang.@NonNull String path, java.lang.@NonNull String arg__interface, java.lang.@NonNull String name, io.qt.core.@Nullable QObject receiver, java.lang.@Nullable String slot){
        if(slot!=null && !slot.startsWith("1") && !slot.startsWith("2")) {
            io.qt.core.QMetaMethod method = receiver.metaObject().method(slot);
            if(method!=null && method.isValid()) {
                if(method.methodType()==io.qt.core.QMetaMethod.MethodType.Signal)
                    slot = "2" + method.cppMethodSignature();
                else
                    slot = "1" + method.cppMethodSignature();
            }
        }
        return disconnect_native_cref_QString_cref_QString_cref_QString_cref_QString_QObject_ptr_const_char_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), service, path, arg__interface, name, QtJambi_LibraryUtilities.internal.checkedNativeId(receiver), slot);
    }
    
    @QtUninvokable
    private native boolean disconnect_native_cref_QString_cref_QString_cref_QString_cref_QString_QObject_ptr_const_char_ptr(long __this__nativeId, java.lang.String service, java.lang.String path, java.lang.String arg__interface, java.lang.String name, long receiver, java.lang.String slot);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusconnection.html#disconnect-1">QDBusConnection::<wbr/>disconnect(QString,<wbr/>QString,<wbr/>QString,<wbr/>QString,<wbr/>QString,<wbr/>QObject*,<wbr/>const char*)</a></code></p>
     */
    @QtUninvokable
    public final boolean disconnect(java.lang.@NonNull String service, java.lang.@NonNull String path, java.lang.@NonNull String arg__interface, java.lang.@NonNull String name, java.lang.@NonNull String signature, io.qt.core.@Nullable QObject receiver, java.lang.@Nullable String slot){
        if(slot!=null && !slot.startsWith("1") && !slot.startsWith("2")) {
            io.qt.core.QMetaMethod method = receiver.metaObject().method(slot);
            if(method!=null && method.isValid()) {
                if(method.methodType()==io.qt.core.QMetaMethod.MethodType.Signal)
                    slot = "2" + method.cppMethodSignature();
                else
                    slot = "1" + method.cppMethodSignature();
            }
        }
        return disconnect_native_cref_QString_cref_QString_cref_QString_cref_QString_cref_QString_QObject_ptr_const_char_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), service, path, arg__interface, name, signature, QtJambi_LibraryUtilities.internal.checkedNativeId(receiver), slot);
    }
    
    @QtUninvokable
    private native boolean disconnect_native_cref_QString_cref_QString_cref_QString_cref_QString_cref_QString_QObject_ptr_const_char_ptr(long __this__nativeId, java.lang.String service, java.lang.String path, java.lang.String arg__interface, java.lang.String name, java.lang.String signature, long receiver, java.lang.String slot);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusconnection.html#disconnect-2">QDBusConnection::<wbr/>disconnect(QString,<wbr/>QString,<wbr/>QString,<wbr/>QString,<wbr/>QStringList,<wbr/>QString,<wbr/>QObject*,<wbr/>const char*)</a></code></p>
     */
    @QtUninvokable
    public final boolean disconnect(java.lang.@NonNull String service, java.lang.@NonNull String path, java.lang.@NonNull String arg__interface, java.lang.@NonNull String name, java.util.@NonNull Collection<java.lang.@NonNull String> argumentMatch, java.lang.@NonNull String signature, io.qt.core.@Nullable QObject receiver, java.lang.@Nullable String slot){
        if(slot!=null && !slot.startsWith("1") && !slot.startsWith("2")) {
            io.qt.core.QMetaMethod method = receiver.metaObject().method(slot);
            if(method!=null && method.isValid()) {
                if(method.methodType()==io.qt.core.QMetaMethod.MethodType.Signal)
                    slot = "2" + method.cppMethodSignature();
                else
                    slot = "1" + method.cppMethodSignature();
            }
        }
        return disconnect_native_cref_QString_cref_QString_cref_QString_cref_QString_cref_QStringList_cref_QString_QObject_ptr_const_char_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), service, path, arg__interface, name, argumentMatch, signature, QtJambi_LibraryUtilities.internal.checkedNativeId(receiver), slot);
    }
    
    @QtUninvokable
    private native boolean disconnect_native_cref_QString_cref_QString_cref_QString_cref_QString_cref_QStringList_cref_QString_QObject_ptr_const_char_ptr(long __this__nativeId, java.lang.String service, java.lang.String path, java.lang.String arg__interface, java.lang.String name, java.util.Collection<java.lang.String> argumentMatch, java.lang.String signature, long receiver, java.lang.String slot);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusconnection.html#interface">QDBusConnection::<wbr/>interface()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.dbus.@Nullable QDBusConnectionInterface connectionInterface(){
        return connectionInterface_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.dbus.QDBusConnectionInterface connectionInterface_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusconnection.html#isConnected">QDBusConnection::<wbr/>isConnected()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isConnected(){
        return isConnected_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isConnected_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusconnection.html#lastError">QDBusConnection::<wbr/>lastError()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.dbus.@NonNull QDBusError lastError(){
        return lastError_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.dbus.QDBusError lastError_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusconnection.html#name">QDBusConnection::<wbr/>name()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String name(){
        return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String name_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusconnection.html#objectRegisteredAt">QDBusConnection::<wbr/>objectRegisteredAt(QString)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@Nullable QObject objectRegisteredAt(java.lang.@NonNull String path){
        return objectRegisteredAt_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), path);
    }
    
    @QtUninvokable
    private native io.qt.core.QObject objectRegisteredAt_native_cref_QString_constfct(long __this__nativeId, java.lang.String path);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusconnection.html#operator-eq-1">QDBusConnection::<wbr/>operator=(QDBusConnection)</a></code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.dbus.@NonNull QDBusConnection other){
        assign_native_cref_QDBusConnection(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QDBusConnection(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusconnection.html#registerObject">QDBusConnection::<wbr/>registerObject(QString,<wbr/>QObject*,<wbr/>QDBusConnection::RegisterOptions)</a></code></p>
     */
    @QtUninvokable
    public final boolean registerObject(java.lang.@NonNull String path, io.qt.core.@Nullable QObject object, io.qt.dbus.QDBusConnection.@NonNull RegisterOptions options){
        return registerObject_native_cref_QString_QObject_ptr_QDBusConnection_RegisterOptions(QtJambi_LibraryUtilities.internal.nativeId(this), path, QtJambi_LibraryUtilities.internal.checkedNativeId(object), options.value());
    }
    
    @QtUninvokable
    private native boolean registerObject_native_cref_QString_QObject_ptr_QDBusConnection_RegisterOptions(long __this__nativeId, java.lang.String path, long object, int options);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusconnection.html#registerObject-1">QDBusConnection::<wbr/>registerObject(QString,<wbr/>QString,<wbr/>QObject*,<wbr/>QDBusConnection::RegisterOptions)</a></code></p>
     */
    @QtUninvokable
    public final boolean registerObject(java.lang.@NonNull String path, java.lang.@NonNull String arg__interface, io.qt.core.@Nullable QObject object, io.qt.dbus.QDBusConnection.@NonNull RegisterOptions options){
        return registerObject_native_cref_QString_cref_QString_QObject_ptr_QDBusConnection_RegisterOptions(QtJambi_LibraryUtilities.internal.nativeId(this), path, arg__interface, QtJambi_LibraryUtilities.internal.checkedNativeId(object), options.value());
    }
    
    @QtUninvokable
    private native boolean registerObject_native_cref_QString_cref_QString_QObject_ptr_QDBusConnection_RegisterOptions(long __this__nativeId, java.lang.String path, java.lang.String arg__interface, long object, int options);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusconnection.html#registerService">QDBusConnection::<wbr/>registerService(QString)</a></code></p>
     */
    @QtUninvokable
    public final boolean registerService(java.lang.@NonNull String serviceName){
        return registerService_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), serviceName);
    }
    
    @QtUninvokable
    private native boolean registerService_native_cref_QString(long __this__nativeId, java.lang.String serviceName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusconnection.html#send">QDBusConnection::<wbr/>send(QDBusMessage)const</a></code></p>
     */
    @QtUninvokable
    public final boolean send(io.qt.dbus.@NonNull QDBusMessage message){
        return send_native_cref_QDBusMessage_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(message));
    }
    
    @QtUninvokable
    private native boolean send_native_cref_QDBusMessage_constfct(long __this__nativeId, long message);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusconnection.html#swap">QDBusConnection::<wbr/>swap(QDBusConnection&amp;)</a></code></p>
     */
    @QtUninvokable
    public final void swap(io.qt.dbus.@StrictNonNull QDBusConnection other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QDBusConnection(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void swap_native_ref_QDBusConnection(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusconnection.html#unregisterObject">QDBusConnection::<wbr/>unregisterObject(QString,<wbr/>QDBusConnection::UnregisterMode)</a></code></p>
     */
    @QtUninvokable
    public final void unregisterObject(java.lang.@NonNull String path, io.qt.dbus.QDBusConnection.@NonNull UnregisterMode mode){
        unregisterObject_native_cref_QString_QDBusConnection_UnregisterMode(QtJambi_LibraryUtilities.internal.nativeId(this), path, mode.value());
    }
    
    @QtUninvokable
    private native void unregisterObject_native_cref_QString_QDBusConnection_UnregisterMode(long __this__nativeId, java.lang.String path, int mode);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusconnection.html#unregisterService">QDBusConnection::<wbr/>unregisterService(QString)</a></code></p>
     */
    @QtUninvokable
    public final boolean unregisterService(java.lang.@NonNull String serviceName){
        return unregisterService_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), serviceName);
    }
    
    @QtUninvokable
    private native boolean unregisterService_native_cref_QString(long __this__nativeId, java.lang.String serviceName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusconnection.html#connectToBus">QDBusConnection::<wbr/>connectToBus(QDBusConnection::BusType,<wbr/>QString)</a></code></p>
     */
    public static io.qt.dbus.@NonNull QDBusConnection connectToBus(io.qt.dbus.QDBusConnection.@NonNull BusType type, java.lang.@NonNull String name){
        return connectToBus_native_QDBusConnection_BusType_cref_QString(type.value(), name);
    }
    
    private native static io.qt.dbus.QDBusConnection connectToBus_native_QDBusConnection_BusType_cref_QString(int type, java.lang.String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusconnection.html#connectToBus-1">QDBusConnection::<wbr/>connectToBus(QString,<wbr/>QString)</a></code></p>
     */
    public native static io.qt.dbus.@NonNull QDBusConnection connectToBus(java.lang.@NonNull String address, java.lang.@NonNull String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusconnection.html#connectToPeer">QDBusConnection::<wbr/>connectToPeer(QString,<wbr/>QString)</a></code></p>
     */
    public native static io.qt.dbus.@NonNull QDBusConnection connectToPeer(java.lang.@NonNull String address, java.lang.@NonNull String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusconnection.html#disconnectFromBus">QDBusConnection::<wbr/>disconnectFromBus(QString)</a></code></p>
     */
    public native static void disconnectFromBus(java.lang.@NonNull String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusconnection.html#disconnectFromPeer">QDBusConnection::<wbr/>disconnectFromPeer(QString)</a></code></p>
     */
    public native static void disconnectFromPeer(java.lang.@NonNull String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusconnection.html#localMachineId">QDBusConnection::<wbr/>localMachineId()</a></code></p>
     */
    public native static io.qt.core.@NonNull QByteArray localMachineId();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusconnection.html#sessionBus">QDBusConnection::<wbr/>sessionBus()</a></code></p>
     */
    public native static io.qt.dbus.@NonNull QDBusConnection sessionBus();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusconnection.html#systemBus">QDBusConnection::<wbr/>systemBus()</a></code></p>
     */
    public native static io.qt.dbus.@NonNull QDBusConnection systemBus();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QDBusConnection(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Creates and returns a copy of this object.</p>
    <p>See <code><a href="https://doc.qt.io/qt/qdbusconnection.html#QDBusConnection-1">QDBusConnection::<wbr/>QDBusConnection(QDBusConnection)</a></code></p>
     */
    @QtUninvokable
    @Override
    public QDBusConnection clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QDBusConnection clone_native(long __this_nativeId);
    
    /**
     * <p>Overloaded function for {@link #asyncCall(io.qt.dbus.QDBusMessage, int)}
     *  with <code>timeout = -1</code>.</p>
     */
    @QtUninvokable
    public final io.qt.dbus.@NonNull QDBusPendingCall asyncCall(io.qt.dbus.@NonNull QDBusMessage message) {
        return asyncCall(message, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #call(io.qt.dbus.QDBusMessage, io.qt.dbus.QDBus.CallMode, int)}
     *  with <code>timeout = -1</code>.</p>
     */
    @QtUninvokable
    public final io.qt.dbus.@NonNull QDBusMessage call(io.qt.dbus.@NonNull QDBusMessage message, io.qt.dbus.QDBus.@NonNull CallMode mode) {
        return call(message, mode, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #call(io.qt.dbus.QDBusMessage, io.qt.dbus.QDBus.CallMode, int)}</p>
     * <p>with: </p><ul>
     * <li><code>mode = io.qt.dbus.QDBus.CallMode.Block</code></li>
     * <li><code>timeout = -1</code></li>
     * </ul>
     */
    @QtUninvokable
    public final io.qt.dbus.@NonNull QDBusMessage call(io.qt.dbus.@NonNull QDBusMessage message) {
        return call(message, io.qt.dbus.QDBus.CallMode.Block, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #callWithCallback(io.qt.dbus.QDBusMessage, io.qt.core.QObject, java.lang.String, java.lang.String, int)}
     *  with <code>timeout = -1</code>.</p>
     */
    @QtUninvokable
    public final boolean callWithCallback(io.qt.dbus.@NonNull QDBusMessage message, io.qt.core.@Nullable QObject receiver, java.lang.@Nullable String returnMethod, java.lang.@Nullable String errorMethod) {
        return callWithCallback(message, receiver, returnMethod, errorMethod, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #callWithCallback(io.qt.dbus.QDBusMessage, io.qt.core.QObject, java.lang.String, int)}
     *  with <code>timeout = -1</code>.</p>
     */
    @QtUninvokable
    public final boolean callWithCallback(io.qt.dbus.@NonNull QDBusMessage message, io.qt.core.@Nullable QObject receiver, java.lang.@Nullable String slot) {
        return callWithCallback(message, receiver, slot, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #registerObject(java.lang.String, io.qt.core.QObject, io.qt.dbus.QDBusConnection.RegisterOptions)}
     *  with <code>options = new io.qt.dbus.QDBusConnection.RegisterOptions(1)</code>.</p>
     */
    @QtUninvokable
    public final boolean registerObject(java.lang.@NonNull String path, io.qt.core.@Nullable QObject object) {
        return registerObject(path, object, new io.qt.dbus.QDBusConnection.RegisterOptions(1));
    }
    
    /**
     * <p>Overloaded function for {@link #registerObject(java.lang.String, io.qt.core.QObject, io.qt.dbus.QDBusConnection.RegisterOptions)}.</p>
     */
    @QtUninvokable
    public final boolean registerObject(java.lang.@NonNull String path, io.qt.core.@Nullable QObject object, io.qt.dbus.QDBusConnection.@NonNull RegisterOption @NonNull... options) {
        return registerObject(path, object, new io.qt.dbus.QDBusConnection.RegisterOptions(options));
    }
    
    /**
     * <p>Overloaded function for {@link #registerObject(java.lang.String, java.lang.String, io.qt.core.QObject, io.qt.dbus.QDBusConnection.RegisterOptions)}
     *  with <code>options = new io.qt.dbus.QDBusConnection.RegisterOptions(1)</code>.</p>
     */
    @QtUninvokable
    public final boolean registerObject(java.lang.@NonNull String path, java.lang.@NonNull String arg__interface, io.qt.core.@Nullable QObject object) {
        return registerObject(path, arg__interface, object, new io.qt.dbus.QDBusConnection.RegisterOptions(1));
    }
    
    /**
     * <p>Overloaded function for {@link #registerObject(java.lang.String, java.lang.String, io.qt.core.QObject, io.qt.dbus.QDBusConnection.RegisterOptions)}.</p>
     */
    @QtUninvokable
    public final boolean registerObject(java.lang.@NonNull String path, java.lang.@NonNull String arg__interface, io.qt.core.@Nullable QObject object, io.qt.dbus.QDBusConnection.@NonNull RegisterOption @NonNull... options) {
        return registerObject(path, arg__interface, object, new io.qt.dbus.QDBusConnection.RegisterOptions(options));
    }
    
    /**
     * <p>Overloaded function for {@link #unregisterObject(java.lang.String, io.qt.dbus.QDBusConnection.UnregisterMode)}
     *  with <code>mode = io.qt.dbus.QDBusConnection.UnregisterMode.UnregisterNode</code>.</p>
     */
    @QtUninvokable
    public final void unregisterObject(java.lang.@NonNull String path) {
        unregisterObject(path, io.qt.dbus.QDBusConnection.UnregisterMode.UnregisterNode);
    }
}
