package io.qt.dbus;

import io.qt.*;


/**
 * <p>Enables the programmer to identify the variant type provided by the D-Bus typesystem</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qdbusvariant.html">QDBusVariant</a></code></p>
 */
public class QDBusVariant extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusvariant.html#QDBusVariant">QDBusVariant::<wbr>QDBusVariant()</a></code></p>
     */
    public QDBusVariant(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QDBusVariant instance);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusvariant.html#QDBusVariant-1">QDBusVariant::<wbr>QDBusVariant(QVariant)</a></code></p>
     */
    public QDBusVariant(java.lang.Object variant){
        super((QPrivateConstructor)null);
        initialize_native(this, variant);
    }
    
    private native static void initialize_native(QDBusVariant instance, java.lang.Object variant);
    
    /**
     * <p>See <code>operator==(QDBusVariant,<wbr>QDBusVariant)</code></p>
     */
    @QtUninvokable
    private final boolean operator_equal(io.qt.dbus.@StrictNonNull QDBusVariant v2){
        java.util.Objects.requireNonNull(v2, "Argument 'v2': null not expected.");
        return operator_equal_native_cref_QDBusVariant(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(v2));
    }
    
    @QtUninvokable
    private native boolean operator_equal_native_cref_QDBusVariant(long __this__nativeId, long v2);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusvariant.html#setVariant">QDBusVariant::<wbr>setVariant(QVariant)</a></code></p>
     */
    @QtUninvokable
    public final void setVariant(java.lang.Object variant){
        setVariant_native_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), variant);
    }
    
    @QtUninvokable
    private native void setVariant_native_cref_QVariant(long __this__nativeId, java.lang.Object variant);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusvariant.html#swap">QDBusVariant::<wbr>swap(QDBusVariant&amp;)</a></code></p>
     */
    @QtUninvokable
    public final void swap(io.qt.dbus.@StrictNonNull QDBusVariant other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QDBusVariant(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void swap_native_ref_QDBusVariant(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusvariant.html#variant">QDBusVariant::<wbr>variant()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.Object variant(){
        return variant_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.Object variant_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QDBusVariant(QPrivateConstructor p) { super(p); } 
    

    /**
     * <p>See <code>operator==(QDBusVariant,<wbr>QDBusVariant)</code></p>
     */
    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.dbus.QDBusVariant) {
            return operator_equal((io.qt.dbus.QDBusVariant) other);
        }

        return false;
    }


    /**
     * Returns the objects's hash code computed by <code>qHash(QDBusVariant)</code>.
     */
    @QtUninvokable
    @Override
    public int hashCode() {
        return 0;
    }
    
    /**
     * <p>Creates and returns a copy of this object.</p>
     */
    @QtUninvokable
    @Override
    public QDBusVariant clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QDBusVariant clone_native(long __this_nativeId);
}
