package io.qt.dbus;

import io.qt.*;


/**
 * <p>Java wrapper for Qt class <code>QDBusPendingReplyBase</code></p>
 */
class QDBusPendingReplyBase extends QtObject
    implements io.qt.dbus.QDBusPendingCall
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <code>QDBusPendingReplyBase::<wbr>QDBusPendingReplyBase()</code></p>
     */
    protected QDBusPendingReplyBase(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QDBusPendingReplyBase instance);
    
    /**
     * <p>See <code>QDBusPendingReplyBase::<wbr>argumentAt(int)const</code></p>
     */
    @QtUninvokable
    protected final java.lang.Object argumentAt(int index){
        return argumentAt_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @QtUninvokable
    private native java.lang.Object argumentAt_native_int_constfct(long __this__nativeId, int index);
    
    /**
     * <p>See <code>QDBusPendingReplyBase::<wbr>assign(QDBusMessage)</code></p>
     */
    @QtUninvokable
    protected final void assign(io.qt.dbus.@NonNull QDBusMessage message){
        assign_native_cref_QDBusMessage(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(message));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QDBusMessage(long __this__nativeId, long message);
    
    /**
     * <p>See <code>QDBusPendingCall::<wbr>assign(QDBusPendingCall)</code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.dbus.@NonNull QDBusPendingCall call){
        assign_native_cref_QDBusPendingCall(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(call));
    }
    
    private native static void assign_native_cref_QDBusPendingCall(long __this__nativeId, long call);
    
    /**
     * <p>See <code>QDBusPendingCall::<wbr>error()const</code></p>
     */
    @QtUninvokable
    public final io.qt.dbus.@NonNull QDBusError error(){
        return error_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static io.qt.dbus.QDBusError error_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QDBusPendingCall::<wbr>isError()const</code></p>
     */
    @QtUninvokable
    public final boolean isError(){
        return isError_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static boolean isError_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QDBusPendingCall::<wbr>isFinished()const</code></p>
     */
    @QtUninvokable
    public final boolean isFinished(){
        return isFinished_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static boolean isFinished_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QDBusPendingCall::<wbr>isValid()const</code></p>
     */
    @QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QDBusPendingCall::<wbr>reply()const</code></p>
     */
    @QtUninvokable
    public final io.qt.dbus.@NonNull QDBusMessage reply(){
        return reply_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static io.qt.dbus.QDBusMessage reply_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QDBusPendingReplyBase::<wbr>setMetaTypes(int,<wbr>const QMetaType*)</code></p>
     */
    @QtUninvokable
    final void setMetaTypes(io.qt.core.@NonNull QMetaType @StrictNonNull[] metaTypes){
        java.util.Objects.requireNonNull(metaTypes, "Argument 'metaTypes': null not expected.");
        setMetaTypes_native_int_const_QMetaType_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), metaTypes);
    }
    
    @QtUninvokable
    private native void setMetaTypes_native_int_const_QMetaType_ptr(long __this__nativeId, io.qt.core.QMetaType[] metaTypes);
    
    /**
     * <p>See <code>QDBusPendingCall::<wbr>swap(QDBusPendingCall&amp;)</code></p>
     */
    @QtUninvokable
    public final void swap(io.qt.dbus.@StrictNonNull QDBusPendingCall other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QDBusPendingCall(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    private native static void swap_native_ref_QDBusPendingCall(long __this__nativeId, long other);
    
    /**
     * <p>See <code>QDBusPendingCall::<wbr>waitForFinished()</code></p>
     */
    @QtUninvokable
    public final void waitForFinished(){
        waitForFinished_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static void waitForFinished_native(long __this__nativeId);
    
    /**
     * <p>See <code>QDBusPendingCall::<wbr>fromCompletedCall(QDBusMessage)</code></p>
     */
    public static io.qt.dbus.@NonNull QDBusPendingCall fromCompletedCall(io.qt.dbus.@NonNull QDBusMessage message){
        return fromCompletedCall_native_cref_QDBusMessage(QtJambi_LibraryUtilities.internal.checkedNativeId(message));
    }
    
    private native static io.qt.dbus.QDBusPendingCall fromCompletedCall_native_cref_QDBusMessage(long message);
    
    /**
     * <p>See <code>QDBusPendingCall::<wbr>fromError(QDBusError)</code></p>
     */
    public static io.qt.dbus.@NonNull QDBusPendingCall fromError(io.qt.dbus.@NonNull QDBusError error){
        return fromError_native_cref_QDBusError(QtJambi_LibraryUtilities.internal.checkedNativeId(error));
    }
    
    private native static io.qt.dbus.QDBusPendingCall fromError_native_cref_QDBusError(long error);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QDBusPendingReplyBase(QPrivateConstructor p) { super(p); } 
    
}
