package io.qt.dbus;

import io.qt.*;


/**
 * <p>The base class of D-Bus adaptor classes</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qdbusabstractadaptor.html">QDBusAbstractAdaptor</a></code></p>
 */
public class QDBusAbstractAdaptor extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QDBusAbstractAdaptor.class);
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusabstractadaptor.html#QDBusAbstractAdaptor">QDBusAbstractAdaptor::<wbr>QDBusAbstractAdaptor(QObject*)</a></code></p>
     */
    protected QDBusAbstractAdaptor(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QDBusAbstractAdaptor instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusabstractadaptor.html#autoRelaySignals">QDBusAbstractAdaptor::<wbr>autoRelaySignals()const</a></code></p>
     */
    @QtUninvokable
    protected final boolean autoRelaySignals(){
        return autoRelaySignals_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean autoRelaySignals_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusabstractadaptor.html#setAutoRelaySignals">QDBusAbstractAdaptor::<wbr>setAutoRelaySignals(bool)</a></code></p>
     */
    @QtUninvokable
    protected final void setAutoRelaySignals(boolean enable){
        setAutoRelaySignals_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setAutoRelaySignals_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QDBusAbstractAdaptor(QPrivateConstructor p) { super(p); } 
    
}
