package io.qt.dbus;

import io.qt.*;


/**
 * <p>Peer-to-peer communication between processes on the same computer</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qdbusserver.html">QDBusServer</a></code></p>
 */
public class QDBusServer extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QDBusServer.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusserver.html#newConnection">QDBusServer::<wbr/>newConnection(QDBusConnection)</a></code></p>
     */
    public final @NonNull Signal1<io.qt.dbus.@NonNull QDBusConnection> newConnection = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusserver.html#QDBusServer-1">QDBusServer::<wbr/>QDBusServer(QObject*)</a></code></p>
     */
    public QDBusServer(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QDBusServer instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusserver.html#QDBusServer">QDBusServer::<wbr/>QDBusServer(QString,<wbr/>QObject*)</a></code></p>
     */
    public QDBusServer(java.lang.@NonNull String address, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, address, parent);
    }
    
    private native static void initialize_native(QDBusServer instance, java.lang.String address, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusserver.html#address">QDBusServer::<wbr/>address()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String address(){
        return address_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String address_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusserver.html#isAnonymousAuthenticationAllowed">QDBusServer::<wbr/>isAnonymousAuthenticationAllowed()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isAnonymousAuthenticationAllowed(){
        return isAnonymousAuthenticationAllowed_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isAnonymousAuthenticationAllowed_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusserver.html#isConnected">QDBusServer::<wbr/>isConnected()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isConnected(){
        return isConnected_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isConnected_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusserver.html#lastError">QDBusServer::<wbr/>lastError()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.dbus.@NonNull QDBusError lastError(){
        return lastError_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.dbus.QDBusError lastError_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusserver.html#setAnonymousAuthenticationAllowed">QDBusServer::<wbr/>setAnonymousAuthenticationAllowed(bool)</a></code></p>
     */
    @QtUninvokable
    public final void setAnonymousAuthenticationAllowed(boolean value){
        setAnonymousAuthenticationAllowed_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native void setAnonymousAuthenticationAllowed_native_bool(long __this__nativeId, boolean value);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QDBusServer(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QDBusServer(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QDBusServer instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QDBusServer(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QDBusServer() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QDBusServer(java.lang.String, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QDBusServer(java.lang.@NonNull String address) {
        this(address, (io.qt.core.QObject)null);
    }
}
