package io.qt.dbus;

import io.qt.*;


/**
 * <p>Enables the programmer to identify the OBJECT_PATH type provided by the D-Bus typesystem</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qdbusobjectpath.html">QDBusObjectPath</a></code></p>
 */
public class QDBusObjectPath extends QtObject
    implements java.lang.Comparable<io.qt.dbus.@StrictNonNull QDBusObjectPath>,
            java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusobjectpath.html#QDBusObjectPath">QDBusObjectPath::<wbr/>QDBusObjectPath()</a></code></p>
     */
    public QDBusObjectPath(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QDBusObjectPath instance);
    
    /**
     * <p>See <code>QDBusObjectPath::<wbr/>QDBusObjectPath(QDBusObjectPath)</code></p>
     */
    public QDBusObjectPath(io.qt.dbus.@NonNull QDBusObjectPath other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QDBusObjectPath instance, io.qt.dbus.QDBusObjectPath other);
    
    /**
     * <p>See <code>QDBusObjectPath::<wbr/>QDBusObjectPath(QString&amp;&amp;)</code></p>
     */
    public QDBusObjectPath(java.lang.@NonNull CharSequence p){
        super((QPrivateConstructor)null);
        initialize_native(this, p);
    }
    
    private native static void initialize_native(QDBusObjectPath instance, java.lang.CharSequence p);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusobjectpath.html#QDBusObjectPath-3">QDBusObjectPath::<wbr/>QDBusObjectPath(QString)</a></code></p>
     */
    public QDBusObjectPath(java.lang.@NonNull String path){
        super((QPrivateConstructor)null);
        initialize_native(this, path);
    }
    
    private native static void initialize_native(QDBusObjectPath instance, java.lang.String path);
    
    /**
     * <p>See <code>operator&lt;(QDBusObjectPath,<wbr/>QDBusObjectPath)</code></p>
     */
    @QtUninvokable
    private final boolean operator_less(io.qt.dbus.@NonNull QDBusObjectPath rhs){
        return operator_less_native_cref_QDBusObjectPath(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rhs));
    }
    
    @QtUninvokable
    private native boolean operator_less_native_cref_QDBusObjectPath(long __this__nativeId, long rhs);
    
    /**
     * <p>See <code>operator==(QDBusObjectPath,<wbr/>QDBusObjectPath)</code></p>
     */
    @QtUninvokable
    public final boolean equals(io.qt.dbus.@NonNull QDBusObjectPath rhs){
        return equals_native_cref_QDBusObjectPath(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rhs));
    }
    
    @QtUninvokable
    private native boolean equals_native_cref_QDBusObjectPath(long __this__nativeId, long rhs);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusobjectpath.html#path">QDBusObjectPath::<wbr/>path()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String path(){
        return path_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String path_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusobjectpath.html#setPath">QDBusObjectPath::<wbr/>setPath(QString)</a></code></p>
     */
    @QtUninvokable
    public final void setPath(java.lang.@NonNull String path){
        setPath_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), path);
    }
    
    @QtUninvokable
    private native void setPath_native_cref_QString(long __this__nativeId, java.lang.String path);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbusobjectpath.html#swap">QDBusObjectPath::<wbr/>swap(QDBusObjectPath&amp;)</a></code></p>
     */
    @QtUninvokable
    public final void swap(io.qt.dbus.@StrictNonNull QDBusObjectPath other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QDBusObjectPath(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void swap_native_ref_QDBusObjectPath(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QDBusObjectPath(QPrivateConstructor p) { super(p); } 
    

    /**
     * <p>See <code>operator==(QDBusObjectPath,<wbr/>QDBusObjectPath)</code></p>
     */
    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other==null || other instanceof io.qt.dbus.QDBusObjectPath) {
            return equals((io.qt.dbus.QDBusObjectPath) other);
        }

        return false;
    }

    /**
     * <p>See <code>operator&lt;(QDBusObjectPath,<wbr/>QDBusObjectPath)</code></p>
     */
    @QtUninvokable
    public int compareTo(io.qt.dbus.@StrictNonNull QDBusObjectPath other) {
        if (equals(other)) return 0;
        else if (operator_less(other)) return -1;
        else return 1;
    }


    /**
     * Returns the objects's hash code computed by <code>qHash(QDBusObjectPath)</code>.
     */
    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
    <p>See <code>QDBusObjectPath::<wbr/>QDBusObjectPath(QDBusObjectPath)</code></p>
     */
    @QtUninvokable
    @Override
    public QDBusObjectPath clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QDBusObjectPath clone_native(long __this_nativeId);
}
