package io.qt.dbus;

import io.qt.*;


/**
 * <p>Represents an error received from the D-Bus bus or from remote applications found in the bus</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qdbuserror.html">QDBusError</a></code></p>
 */
public class QDBusError extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QDBusError.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::ErrorType</a></code></p>
     */
    @QtRejectedEntries({"LastErrorType"})
    public enum ErrorType implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::<wbr/>NoError</a></code></p>
         */
        NoError(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::<wbr/>Other</a></code></p>
         */
        Other(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::<wbr/>Failed</a></code></p>
         */
        Failed(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::<wbr/>NoMemory</a></code></p>
         */
        NoMemory(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::<wbr/>ServiceUnknown</a></code></p>
         */
        ServiceUnknown(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::<wbr/>NoReply</a></code></p>
         */
        NoReply(5),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::<wbr/>BadAddress</a></code></p>
         */
        BadAddress(6),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::<wbr/>NotSupported</a></code></p>
         */
        NotSupported(7),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::<wbr/>LimitsExceeded</a></code></p>
         */
        LimitsExceeded(8),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::<wbr/>AccessDenied</a></code></p>
         */
        AccessDenied(9),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::<wbr/>NoServer</a></code></p>
         */
        NoServer(10),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::<wbr/>Timeout</a></code></p>
         */
        Timeout(11),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::<wbr/>NoNetwork</a></code></p>
         */
        NoNetwork(12),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::<wbr/>AddressInUse</a></code></p>
         */
        AddressInUse(13),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::<wbr/>Disconnected</a></code></p>
         */
        Disconnected(14),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::<wbr/>InvalidArgs</a></code></p>
         */
        InvalidArgs(15),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::<wbr/>UnknownMethod</a></code></p>
         */
        UnknownMethod(16),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::<wbr/>TimedOut</a></code></p>
         */
        TimedOut(17),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::<wbr/>InvalidSignature</a></code></p>
         */
        InvalidSignature(18),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::<wbr/>UnknownInterface</a></code></p>
         */
        UnknownInterface(19),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::<wbr/>UnknownObject</a></code></p>
         */
        UnknownObject(20),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::<wbr/>UnknownProperty</a></code></p>
         */
        UnknownProperty(21),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::<wbr/>PropertyReadOnly</a></code></p>
         */
        PropertyReadOnly(22),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::<wbr/>InternalError</a></code></p>
         */
        InternalError(23),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::<wbr/>InvalidService</a></code></p>
         */
        InvalidService(24),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::<wbr/>InvalidObjectPath</a></code></p>
         */
        InvalidObjectPath(25),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::<wbr/>InvalidInterface</a></code></p>
         */
        InvalidInterface(26),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::<wbr/>InvalidMember</a></code></p>
         */
        InvalidMember(27),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::<wbr/>LastErrorType</a></code></p>
         */
        LastErrorType(27);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ErrorType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ErrorType resolve(int value) {
            switch (value) {
            case 0: return NoError;
            case 1: return Other;
            case 2: return Failed;
            case 3: return NoMemory;
            case 4: return ServiceUnknown;
            case 5: return NoReply;
            case 6: return BadAddress;
            case 7: return NotSupported;
            case 8: return LimitsExceeded;
            case 9: return AccessDenied;
            case 10: return NoServer;
            case 11: return Timeout;
            case 12: return NoNetwork;
            case 13: return AddressInUse;
            case 14: return Disconnected;
            case 15: return InvalidArgs;
            case 16: return UnknownMethod;
            case 17: return TimedOut;
            case 18: return InvalidSignature;
            case 19: return UnknownInterface;
            case 20: return UnknownObject;
            case 21: return UnknownProperty;
            case 22: return PropertyReadOnly;
            case 23: return InternalError;
            case 24: return InvalidService;
            case 25: return InvalidObjectPath;
            case 26: return InvalidInterface;
            case 27: return InvalidMember;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code>QDBusError::<wbr/>QDBusError()</code></p>
     */
    public QDBusError(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QDBusError instance);
    
    /**
     * <p>See <code>QDBusError::<wbr/>QDBusError(QDBusError)</code></p>
     */
    public QDBusError(io.qt.dbus.@NonNull QDBusError other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QDBusError instance, io.qt.dbus.QDBusError other);
    
    /**
     * <p>See <code>QDBusError::<wbr/>QDBusError(QDBusError::ErrorType,<wbr/>QString)</code></p>
     */
    public QDBusError(io.qt.dbus.QDBusError.@NonNull ErrorType error, java.lang.@NonNull String message){
        super((QPrivateConstructor)null);
        initialize_native(this, error, message);
    }
    
    private native static void initialize_native(QDBusError instance, io.qt.dbus.QDBusError.ErrorType error, java.lang.String message);
    
    /**
     * <p>See <code>QDBusError::<wbr/>QDBusError(QDBusMessage)</code></p>
     */
    public QDBusError(io.qt.dbus.@NonNull QDBusMessage msg){
        super((QPrivateConstructor)null);
        initialize_native(this, msg);
    }
    
    private native static void initialize_native(QDBusError instance, io.qt.dbus.QDBusMessage msg);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbuserror.html#isValid">QDBusError::<wbr/>isValid()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbuserror.html#message">QDBusError::<wbr/>message()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String message(){
        return message_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String message_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbuserror.html#name">QDBusError::<wbr/>name()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String name(){
        return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String name_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QDBusError::<wbr/>operator=(QDBusError)</code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.dbus.@NonNull QDBusError other){
        assign_native_cref_QDBusError(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QDBusError(long __this__nativeId, long other);
    
    /**
     * <p>See <code>QDBusError::<wbr/>operator=(QDBusMessage)</code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.dbus.@NonNull QDBusMessage msg){
        assign_native_cref_QDBusMessage(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(msg));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QDBusMessage(long __this__nativeId, long msg);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbuserror.html#swap">QDBusError::<wbr/>swap(QDBusError&amp;)</a></code></p>
     */
    @QtUninvokable
    public final void swap(io.qt.dbus.@StrictNonNull QDBusError other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QDBusError(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void swap_native_ref_QDBusError(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbuserror.html#type">QDBusError::<wbr/>type()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.dbus.QDBusError.@NonNull ErrorType type(){
        return io.qt.dbus.QDBusError.ErrorType.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int type_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbuserror.html#errorString">QDBusError::<wbr/>errorString(QDBusError::ErrorType)</a></code></p>
     */
    public static java.lang.@NonNull String errorString(io.qt.dbus.QDBusError.@NonNull ErrorType error){
        return errorString_native_QDBusError_ErrorType(error.value());
    }
    
    private native static java.lang.String errorString_native_QDBusError_ErrorType(int error);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QDBusError(QPrivateConstructor p) { super(p); } 
    

    /**
     * <p>See <code>operator&lt;&lt;(QDebug,<wbr/>QDBusError)</code></p>
     */
    @QtUninvokable
    @Override
    public @NonNull String toString() {
        return toString_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private static native String toString_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
     */
    @QtUninvokable
    @Override
    public QDBusError clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QDBusError clone_native(long __this_nativeId);
}
