package io.qt.dbus;

import io.qt.*;


/**
 * <p>Allows slots to determine the D-Bus context of the calls</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qdbuscontext.html">QDBusContext</a></code></p>
 */
public interface QDBusContext extends QtObjectInterface
{
    /**
     * @hidden
     * <p>Implementor class for interface {@link io.qt.dbus.QDBusContext}</p>
     */
    public static class Impl extends QtObject
        implements io.qt.dbus.QDBusContext,
                java.lang.Cloneable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qdbuscontext.html#QDBusContext">QDBusContext::<wbr/>QDBusContext()</a></code></p>
         */
        public Impl(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(QDBusContext instance);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qdbuscontext.html#calledFromDBus">QDBusContext::<wbr/>calledFromDBus()const</a></code></p>
         */
        @QtUninvokable
        public final boolean calledFromDBus(){
            return calledFromDBus_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static boolean calledFromDBus_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qdbuscontext.html#connection">QDBusContext::<wbr/>connection()const</a></code></p>
         */
        @QtUninvokable
        public final io.qt.dbus.@NonNull QDBusConnection connection(){
            QDBusContext.Impl.checkCalledFromDBus(this);
            return connection_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static io.qt.dbus.QDBusConnection connection_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qdbuscontext.html#isDelayedReply">QDBusContext::<wbr/>isDelayedReply()const</a></code></p>
         */
        @QtUninvokable
        public final boolean isDelayedReply(){
            QDBusContext.Impl.checkCalledFromDBus(this);
            return isDelayedReply_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static boolean isDelayedReply_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qdbuscontext.html#message">QDBusContext::<wbr/>message()const</a></code></p>
         */
        @QtUninvokable
        public final io.qt.dbus.@NonNull QDBusMessage message(){
            QDBusContext.Impl.checkCalledFromDBus(this);
            return message_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static io.qt.dbus.QDBusMessage message_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qdbuscontext.html#sendErrorReply-1">QDBusContext::<wbr/>sendErrorReply(QDBusError::ErrorType,<wbr/>QString)const</a></code></p>
         */
        @QtUninvokable
        public final void sendErrorReply(io.qt.dbus.QDBusError.@NonNull ErrorType type, java.lang.@NonNull String msg){
            QDBusContext.Impl.checkCalledFromDBus(this);
            sendErrorReply_native_QDBusError_ErrorType_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), type.value(), msg);
        }
        
        private native static void sendErrorReply_native_QDBusError_ErrorType_cref_QString_constfct(long __this__nativeId, int type, java.lang.String msg);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qdbuscontext.html#sendErrorReply">QDBusContext::<wbr/>sendErrorReply(QString,<wbr/>QString)const</a></code></p>
         */
        @QtUninvokable
        public final void sendErrorReply(java.lang.@NonNull String name, java.lang.@NonNull String msg){
            QDBusContext.Impl.checkCalledFromDBus(this);
            sendErrorReply_native_cref_QString_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name, msg);
        }
        
        private native static void sendErrorReply_native_cref_QString_cref_QString_constfct(long __this__nativeId, java.lang.String name, java.lang.String msg);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qdbuscontext.html#setDelayedReply">QDBusContext::<wbr/>setDelayedReply(bool)const</a></code></p>
         */
        @QtUninvokable
        public final void setDelayedReply(boolean enable){
            QDBusContext.Impl.checkCalledFromDBus(this);
            setDelayedReply_native_bool_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
        }
        
        private native static void setDelayedReply_native_bool_constfct(long __this__nativeId, boolean enable);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         * @hidden
         */
        @NativeAccess
        protected Impl(QPrivateConstructor p) { super(p); } 
        
        private static void checkCalledFromDBus(QDBusContext instance){
            if(!instance.calledFromDBus())
                throw new IllegalStateException("QDBusContext has not ben called from DBus.");
        }
        
        /**
         * <p>Creates and returns a copy of this object.</p>
         */
        @QtUninvokable
        @Override
        public Impl clone() {
            return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private static native Impl clone_native(long __this_nativeId);
        
        /**
         * <p>Overloaded function for {@link #sendErrorReply(io.qt.dbus.QDBusError.ErrorType, java.lang.String)}
         *  with <code>msg = (String)null</code>.</p>
         */
        @QtUninvokable
        public final void sendErrorReply(io.qt.dbus.QDBusError.@NonNull ErrorType type) {
            sendErrorReply(type, (String)null);
        }
        
        /**
         * <p>Overloaded function for {@link #sendErrorReply(java.lang.String, java.lang.String)}
         *  with <code>msg = (String)null</code>.</p>
         */
        @QtUninvokable
        public final void sendErrorReply(java.lang.@NonNull String name) {
            sendErrorReply(name, (String)null);
        }
    }

    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbuscontext.html#calledFromDBus">QDBusContext::<wbr/>calledFromDBus()const</a></code></p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public default boolean calledFromDBus(){
        return Impl.calledFromDBus_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbuscontext.html#connection">QDBusContext::<wbr/>connection()const</a></code></p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public default io.qt.dbus.@NonNull QDBusConnection connection(){
        QDBusContext.Impl.checkCalledFromDBus(this);
        return Impl.connection_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbuscontext.html#isDelayedReply">QDBusContext::<wbr/>isDelayedReply()const</a></code></p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public default boolean isDelayedReply(){
        QDBusContext.Impl.checkCalledFromDBus(this);
        return Impl.isDelayedReply_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbuscontext.html#message">QDBusContext::<wbr/>message()const</a></code></p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public default io.qt.dbus.@NonNull QDBusMessage message(){
        QDBusContext.Impl.checkCalledFromDBus(this);
        return Impl.message_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbuscontext.html#sendErrorReply-1">QDBusContext::<wbr/>sendErrorReply(QDBusError::ErrorType,<wbr/>QString)const</a></code></p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public default void sendErrorReply(io.qt.dbus.QDBusError.@NonNull ErrorType type, java.lang.@NonNull String msg){
        QDBusContext.Impl.checkCalledFromDBus(this);
        Impl.sendErrorReply_native_QDBusError_ErrorType_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), type.value(), msg);
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbuscontext.html#sendErrorReply">QDBusContext::<wbr/>sendErrorReply(QString,<wbr/>QString)const</a></code></p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public default void sendErrorReply(java.lang.@NonNull String name, java.lang.@NonNull String msg){
        QDBusContext.Impl.checkCalledFromDBus(this);
        Impl.sendErrorReply_native_cref_QString_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name, msg);
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdbuscontext.html#setDelayedReply">QDBusContext::<wbr/>setDelayedReply(bool)const</a></code></p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public default void setDelayedReply(boolean enable){
        QDBusContext.Impl.checkCalledFromDBus(this);
        Impl.setDelayedReply_native_bool_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    
    /**
     * <p>Overloaded function for {@link #sendErrorReply(io.qt.dbus.QDBusError.ErrorType, java.lang.String)}
     *  with <code>msg = (String)null</code>.</p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public default void sendErrorReply(io.qt.dbus.QDBusError.@NonNull ErrorType type) {
        sendErrorReply(type, (String)null);
    }
    
    /**
     * <p>Overloaded function for {@link #sendErrorReply(java.lang.String, java.lang.String)}
     *  with <code>msg = (String)null</code>.</p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public default void sendErrorReply(java.lang.@NonNull String name) {
        sendErrorReply(name, (String)null);
    }
}
