package io.qt.dbus;

import io.qt.*;


/**
 * <p>Contains miscellaneous identifiers used throughout the Qt D-Bus module</p>
 * <p>Java wrapper for Qt header file <code><a href="https://doc.qt.io/qt/qdbus.html">QDBus</a></code></p>
 */
public final class QDBus
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    private QDBus() throws java.lang.InstantiationError { throw new java.lang.InstantiationError("Cannot instantiate namespace QDBus."); }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qdbus.html#CallMode-enum">QDBus::CallMode</a></code></p>
     */
    public enum CallMode implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbus.html#CallMode-enum">QDBus::<wbr/>NoBlock</a></code></p>
         */
        NoBlock(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbus.html#CallMode-enum">QDBus::<wbr/>Block</a></code></p>
         */
        Block(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbus.html#CallMode-enum">QDBus::<wbr/>BlockWithGui</a></code></p>
         */
        BlockWithGui(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdbus.html#CallMode-enum">QDBus::<wbr/>AutoDetect</a></code></p>
         */
        AutoDetect(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private CallMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull CallMode resolve(int value) {
            switch (value) {
            case 0: return NoBlock;
            case 1: return Block;
            case 2: return BlockWithGui;
            case 3: return AutoDetect;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
}
