package io.qt.dbus;

import io.qt.*;


/**
 * <p>Enables the programmer to identify the SIGNATURE type provided by the D-Bus typesystem</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qdbussignature.html">QDBusSignature</a></p>
 */
public class QDBusSignature extends QtObject
    implements java.lang.Comparable<io.qt.dbus.QDBusSignature>,
            java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbussignature.html#QDBusSignature">QDBusSignature::QDBusSignature()</a></p>
     */
    public QDBusSignature(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QDBusSignature instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbussignature.html#QDBusSignature-3">QDBusSignature::QDBusSignature(QString)</a></p>
     */
    public QDBusSignature(java.lang.@NonNull String signature){
        super((QPrivateConstructor)null);
        initialize_native(this, signature);
    }
    
    private native static void initialize_native(QDBusSignature instance, java.lang.String signature);
    
    @QtUninvokable
    private final boolean operator_less(io.qt.dbus.@NonNull QDBusSignature rhs){
        return operator_less_native_cref_QDBusSignature(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rhs));
    }
    
    @QtUninvokable
    private native boolean operator_less_native_cref_QDBusSignature(long __this__nativeId, long rhs);
    
    @QtUninvokable
    private final boolean operator_equal(io.qt.dbus.@NonNull QDBusSignature rhs){
        return operator_equal_native_cref_QDBusSignature(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rhs));
    }
    
    @QtUninvokable
    private native boolean operator_equal_native_cref_QDBusSignature(long __this__nativeId, long rhs);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbussignature.html#setSignature">QDBusSignature::setSignature(QString)</a></p>
     */
    @QtUninvokable
    public final void setSignature(java.lang.@NonNull String signature){
        setSignature_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), signature);
    }
    
    @QtUninvokable
    private native void setSignature_native_cref_QString(long __this__nativeId, java.lang.String signature);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbussignature.html#signature">QDBusSignature::signature()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String signature(){
        return signature_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String signature_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbussignature.html#swap">QDBusSignature::swap(QDBusSignature&amp;)</a></p>
     */
    @QtUninvokable
    public final void swap(io.qt.dbus.@StrictNonNull QDBusSignature other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QDBusSignature(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void swap_native_ref_QDBusSignature(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QDBusSignature(QPrivateConstructor p) { super(p); } 
    

    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.dbus.QDBusSignature) {
            return operator_equal((io.qt.dbus.QDBusSignature) other);
        }

        return false;
    }

    @QtUninvokable
    public int compareTo(io.qt.dbus.QDBusSignature other) {
        if (equals(other)) return 0;
        else if (operator_less(other)) return -1;
        else return 1;
    }


    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
     */
    @QtUninvokable
    @Override
    public QDBusSignature clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QDBusSignature clone_native(long __this_nativeId);
}
