package io.qt.dbus;

import io.qt.*;


/**
 * <p>Allows the user to watch for a bus service change</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qdbusservicewatcher.html">QDBusServiceWatcher</a></p>
 */
public class QDBusServiceWatcher extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QDBusServiceWatcher.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qdbusservicewatcher.html#WatchModeFlag-enum">QDBusServiceWatcher::WatchModeFlag</a></p>
     * 
     * @see WatchMode
     */
    public enum WatchModeFlag implements QtFlagEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbusservicewatcher.html#WatchModeFlag-enum">QDBusServiceWatcher::WatchForRegistration</a></p>
         */
        WatchForRegistration(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbusservicewatcher.html#WatchModeFlag-enum">QDBusServiceWatcher::WatchForUnregistration</a></p>
         */
        WatchForUnregistration(2),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbusservicewatcher.html#WatchModeFlag-enum">QDBusServiceWatcher::WatchForOwnerChange</a></p>
         */
        WatchForOwnerChange(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private WatchModeFlag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public @NonNull WatchMode asFlags() {
            return new WatchMode(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull WatchMode combined(@NonNull WatchModeFlag e) {
            return new WatchMode(this, e);
        }

        /**
         * Creates a new {@link WatchMode} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull WatchMode flags(@Nullable WatchModeFlag @NonNull... values) {
            return new WatchMode(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull WatchModeFlag resolve(int value) {
            switch (value) {
            case 1: return WatchForRegistration;
            case 2: return WatchForUnregistration;
            case 3: return WatchForOwnerChange;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link WatchModeFlag}
     */
    public static final class WatchMode extends QFlags<WatchModeFlag> implements Comparable<WatchMode> {
        private static final long serialVersionUID = 0x6219434d7a312e1dL;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new WatchMode where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public WatchMode(@Nullable WatchModeFlag @NonNull... args){
            super(args);
        }

        /**
         * Creates a new WatchMode with given <code>value</code>.
         * @param value
         */
        public WatchMode(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new WatchMode
         */
        @Override
        public final @NonNull WatchMode combined(@StrictNonNull WatchModeFlag e){
            return new WatchMode(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final @NonNull WatchMode setFlag(@Nullable WatchModeFlag e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final @NonNull WatchMode setFlag(@Nullable WatchModeFlag e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this WatchMode.
         * @return array of enum entries
         */
        @Override
        public final @NonNull WatchModeFlag @NonNull[] flags(){
            return super.flags(WatchModeFlag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull WatchMode clone(){
            return new WatchMode(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull WatchMode other){
            return Integer.compare(value(), other.value());
        }
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusservicewatcher.html#serviceOwnerChanged">QDBusServiceWatcher::serviceOwnerChanged(QString,QString,QString)</a></p>
     */
    public final @NonNull Signal3<java.lang.@NonNull String, java.lang.@NonNull String, java.lang.@NonNull String> serviceOwnerChanged = new Signal3<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusservicewatcher.html#serviceRegistered">QDBusServiceWatcher::serviceRegistered(QString)</a></p>
     */
    public final @NonNull Signal1<java.lang.@NonNull String> serviceRegistered = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusservicewatcher.html#serviceUnregistered">QDBusServiceWatcher::serviceUnregistered(QString)</a></p>
     */
    public final @NonNull Signal1<java.lang.@NonNull String> serviceUnregistered = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QDBusServiceWatcher(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QDBusServiceWatcher() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusservicewatcher.html#QDBusServiceWatcher">QDBusServiceWatcher::QDBusServiceWatcher(QObject*)</a></p>
     */
    public QDBusServiceWatcher(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QDBusServiceWatcher instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusservicewatcher.html#addWatchedService">QDBusServiceWatcher::addWatchedService(QString)</a></p>
     */
    @QtUninvokable
    public final void addWatchedService(java.lang.@NonNull String newService){
        addWatchedService_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), newService);
    }
    
    @QtUninvokable
    private native void addWatchedService_native_cref_QString(long __this__nativeId, java.lang.String newService);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusservicewatcher.html#watchMode-prop">QDBusServiceWatcher::bindableWatchMode()</a></p>
     */
    @QtPropertyBindable(name="watchMode")
    @QtUninvokable
    public final io.qt.core.@NonNull QBindable<io.qt.dbus.QDBusServiceWatcher.@NonNull WatchMode> bindableWatchMode(){
        return bindableWatchMode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QBindable<io.qt.dbus.QDBusServiceWatcher.WatchMode> bindableWatchMode_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusservicewatcher.html#watchedServices-prop">QDBusServiceWatcher::bindableWatchedServices()</a></p>
     */
    @QtPropertyBindable(name="watchedServices")
    @QtUninvokable
    public final io.qt.core.@NonNull QBindable<java.util.@NonNull List<java.lang.@NonNull String>> bindableWatchedServices(){
        return bindableWatchedServices_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QBindable<java.util.List<java.lang.String>> bindableWatchedServices_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusservicewatcher.html#removeWatchedService">QDBusServiceWatcher::removeWatchedService(QString)</a></p>
     */
    @QtUninvokable
    public final boolean removeWatchedService(java.lang.@NonNull String service){
        return removeWatchedService_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), service);
    }
    
    @QtUninvokable
    private native boolean removeWatchedService_native_cref_QString(long __this__nativeId, java.lang.String service);
    
    /**
     * <p>Overloaded function for {@link #setWatchMode(io.qt.dbus.QDBusServiceWatcher.WatchMode)}.</p>
     */
    @QtUninvokable
    public final void setWatchMode(io.qt.dbus.QDBusServiceWatcher.@NonNull WatchModeFlag @NonNull... mode){
        setWatchMode(new io.qt.dbus.QDBusServiceWatcher.WatchMode(mode));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusservicewatcher.html#watchMode-prop">QDBusServiceWatcher::setWatchMode(QDBusServiceWatcher::WatchMode)</a></p>
     */
    @QtPropertyWriter(name="watchMode")
    @QtUninvokable
    public final void setWatchMode(io.qt.dbus.QDBusServiceWatcher.@NonNull WatchMode mode){
        setWatchMode_native_QDBusServiceWatcher_WatchMode(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    @QtUninvokable
    private native void setWatchMode_native_QDBusServiceWatcher_WatchMode(long __this__nativeId, int mode);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusservicewatcher.html#setWatchedServices">QDBusServiceWatcher::setWatchedServices(QStringList)</a></p>
     */
    @QtPropertyWriter(name="watchedServices")
    @QtUninvokable
    public final void setWatchedServices(java.util.@NonNull Collection<java.lang.@NonNull String> services){
        setWatchedServices_native_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), services);
    }
    
    @QtUninvokable
    private native void setWatchedServices_native_cref_QStringList(long __this__nativeId, java.util.Collection<java.lang.String> services);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #watchMode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.dbus.QDBusServiceWatcher.@NonNull WatchMode getWatchMode() {
        return watchMode();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusservicewatcher.html#watchMode-prop">QDBusServiceWatcher::watchMode()const</a></p>
     */
    @QtPropertyReader(name="watchMode")
    @QtUninvokable
    public final io.qt.dbus.QDBusServiceWatcher.@NonNull WatchMode watchMode(){
        return new io.qt.dbus.QDBusServiceWatcher.WatchMode(watchMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int watchMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #watchedServices()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList getWatchedServices() {
        return watchedServices();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusservicewatcher.html#watchedServices">QDBusServiceWatcher::watchedServices()const</a></p>
     */
    @QtPropertyReader(name="watchedServices")
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList watchedServices(){
        return watchedServices_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList watchedServices_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QDBusServiceWatcher(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QDBusServiceWatcher(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QDBusServiceWatcher instance, QDeclarativeConstructor constructor);
    
}
