package io.qt.dbus;

import io.qt.*;


/**
 * <p>Represents one message sent or received over the D-Bus bus</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qdbusmessage.html">QDBusMessage</a></p>
 */
public class QDBusMessage extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qdbusmessage.html#MessageType-enum">QDBusMessage::MessageType</a></p>
     */
    public enum MessageType implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbusmessage.html#MessageType-enum">QDBusMessage::InvalidMessage</a></p>
         */
        InvalidMessage(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbusmessage.html#MessageType-enum">QDBusMessage::MethodCallMessage</a></p>
         */
        MethodCallMessage(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbusmessage.html#MessageType-enum">QDBusMessage::ReplyMessage</a></p>
         */
        ReplyMessage(2),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbusmessage.html#MessageType-enum">QDBusMessage::ErrorMessage</a></p>
         */
        ErrorMessage(3),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbusmessage.html#MessageType-enum">QDBusMessage::SignalMessage</a></p>
         */
        SignalMessage(4);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private MessageType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull MessageType resolve(int value) {
            switch (value) {
            case 0: return InvalidMessage;
            case 1: return MethodCallMessage;
            case 2: return ReplyMessage;
            case 3: return ErrorMessage;
            case 4: return SignalMessage;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusmessage.html#QDBusMessage">QDBusMessage::QDBusMessage()</a></p>
     */
    public QDBusMessage(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QDBusMessage instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusmessage.html#QDBusMessage-1">QDBusMessage::QDBusMessage(QDBusMessage)</a></p>
     */
    public QDBusMessage(io.qt.dbus.@NonNull QDBusMessage other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QDBusMessage instance, io.qt.dbus.QDBusMessage other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusmessage.html#arguments">QDBusMessage::arguments()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<java.lang.Object> arguments(){
        return arguments_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<java.lang.Object> arguments_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusmessage.html#autoStartService">QDBusMessage::autoStartService()const</a></p>
     */
    @QtUninvokable
    public final boolean autoStartService(){
        return autoStartService_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean autoStartService_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusmessage.html#createErrorReply-2">QDBusMessage::createErrorReply(QDBusError::ErrorType,QString)const</a></p>
     */
    @QtUninvokable
    public final io.qt.dbus.@NonNull QDBusMessage createErrorReply(io.qt.dbus.QDBusError.@NonNull ErrorType type, java.lang.@NonNull String msg){
        return createErrorReply_native_QDBusError_ErrorType_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), type.value(), msg);
    }
    
    @QtUninvokable
    private native io.qt.dbus.QDBusMessage createErrorReply_native_QDBusError_ErrorType_cref_QString_constfct(long __this__nativeId, int type, java.lang.String msg);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusmessage.html#createErrorReply-1">QDBusMessage::createErrorReply(QDBusError)const</a></p>
     */
    @QtUninvokable
    public final io.qt.dbus.@NonNull QDBusMessage createErrorReply(io.qt.dbus.@NonNull QDBusError err){
        return createErrorReply_native_cref_QDBusError_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(err));
    }
    
    @QtUninvokable
    private native io.qt.dbus.QDBusMessage createErrorReply_native_cref_QDBusError_constfct(long __this__nativeId, long err);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusmessage.html#createErrorReply">QDBusMessage::createErrorReply(QString,QString)const</a></p>
     */
    @QtUninvokable
    public final io.qt.dbus.@NonNull QDBusMessage createErrorReply(java.lang.@NonNull String name, java.lang.@NonNull String msg){
        return createErrorReply_native_cref_QString_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name, msg);
    }
    
    @QtUninvokable
    private native io.qt.dbus.QDBusMessage createErrorReply_native_cref_QString_cref_QString_constfct(long __this__nativeId, java.lang.String name, java.lang.String msg);
    
    /**
     * <p>Overloaded function for {@link #createReply(java.util.Collection)}
     *  with <code>arguments = java.util.Collections.emptyList()</code>.</p>
     */
    @QtUninvokable
    public final io.qt.dbus.@NonNull QDBusMessage createReply() {
        return createReply(java.util.Collections.emptyList());
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusmessage.html#createReply">QDBusMessage::createReply(QList&lt;QVariant&gt;)const</a></p>
     */
    @QtUninvokable
    public final io.qt.dbus.@NonNull QDBusMessage createReply(java.util.@NonNull Collection<? extends java.lang.Object> arguments){
        return createReply_native_cref_QList_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), arguments);
    }
    
    @QtUninvokable
    private native io.qt.dbus.QDBusMessage createReply_native_cref_QList_constfct(long __this__nativeId, java.util.Collection<? extends java.lang.Object> arguments);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusmessage.html#createReply-1">QDBusMessage::createReply(QVariant)const</a></p>
     */
    @QtUninvokable
    public final io.qt.dbus.@NonNull QDBusMessage createReply(java.lang.Object argument){
        return createReply_native_cref_QVariant_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), argument);
    }
    
    @QtUninvokable
    private native io.qt.dbus.QDBusMessage createReply_native_cref_QVariant_constfct(long __this__nativeId, java.lang.Object argument);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusmessage.html#errorMessage">QDBusMessage::errorMessage()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String errorMessage(){
        return errorMessage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String errorMessage_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusmessage.html#errorName">QDBusMessage::errorName()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String errorName(){
        return errorName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String errorName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusmessage.html#interface">QDBusMessage::interface()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String interfaceName(){
        return interfaceName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String interfaceName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusmessage.html#isDelayedReply">QDBusMessage::isDelayedReply()const</a></p>
     */
    @QtUninvokable
    public final boolean isDelayedReply(){
        return isDelayedReply_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isDelayedReply_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusmessage.html#isInteractiveAuthorizationAllowed">QDBusMessage::isInteractiveAuthorizationAllowed()const</a></p>
     */
    @QtUninvokable
    public final boolean isInteractiveAuthorizationAllowed(){
        return isInteractiveAuthorizationAllowed_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isInteractiveAuthorizationAllowed_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusmessage.html#isReplyRequired">QDBusMessage::isReplyRequired()const</a></p>
     */
    @QtUninvokable
    public final boolean isReplyRequired(){
        return isReplyRequired_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isReplyRequired_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusmessage.html#member">QDBusMessage::member()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String member(){
        return member_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String member_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusmessage.html#operator-lt-lt">QDBusMessage::operator&lt;&lt;(QVariant)</a></p>
     */
    @QtUninvokable
    public final @NonNull QDBusMessage append(java.lang.Object arg){
        return append_native_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), arg);
    }
    
    @QtUninvokable
    private native QDBusMessage append_native_cref_QVariant(long __this__nativeId, java.lang.Object arg);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusmessage.html#operator-eq-1">QDBusMessage::operator=(QDBusMessage)</a></p>
     */
    @QtUninvokable
    public final void assign(io.qt.dbus.@NonNull QDBusMessage other){
        assign_native_cref_QDBusMessage(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QDBusMessage(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusmessage.html#path">QDBusMessage::path()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String path(){
        return path_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String path_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusmessage.html#service">QDBusMessage::service()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String service(){
        return service_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String service_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusmessage.html#setArguments">QDBusMessage::setArguments(QList&lt;QVariant&gt;)</a></p>
     */
    @QtUninvokable
    public final void setArguments(java.util.@NonNull Collection<? extends java.lang.Object> arguments){
        setArguments_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), arguments);
    }
    
    @QtUninvokable
    private native void setArguments_native_cref_QList(long __this__nativeId, java.util.Collection<? extends java.lang.Object> arguments);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusmessage.html#setAutoStartService">QDBusMessage::setAutoStartService(bool)</a></p>
     */
    @QtUninvokable
    public final void setAutoStartService(boolean enable){
        setAutoStartService_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setAutoStartService_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusmessage.html#setDelayedReply">QDBusMessage::setDelayedReply(bool)const</a></p>
     */
    @QtUninvokable
    public final void setDelayedReply(boolean enable){
        setDelayedReply_native_bool_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setDelayedReply_native_bool_constfct(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusmessage.html#setInteractiveAuthorizationAllowed">QDBusMessage::setInteractiveAuthorizationAllowed(bool)</a></p>
     */
    @QtUninvokable
    public final void setInteractiveAuthorizationAllowed(boolean enable){
        setInteractiveAuthorizationAllowed_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setInteractiveAuthorizationAllowed_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusmessage.html#signature">QDBusMessage::signature()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String signature(){
        return signature_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String signature_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusmessage.html#swap">QDBusMessage::swap(QDBusMessage&amp;)</a></p>
     */
    @QtUninvokable
    public final void swap(io.qt.dbus.@StrictNonNull QDBusMessage other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QDBusMessage(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void swap_native_ref_QDBusMessage(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusmessage.html#type">QDBusMessage::type()const</a></p>
     */
    @QtUninvokable
    public final io.qt.dbus.QDBusMessage.@NonNull MessageType type(){
        return io.qt.dbus.QDBusMessage.MessageType.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int type_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusmessage.html#createError-2">QDBusMessage::createError(QDBusError::ErrorType,QString)</a></p>
     */
    public static io.qt.dbus.@NonNull QDBusMessage createError(io.qt.dbus.QDBusError.@NonNull ErrorType type, java.lang.@NonNull String msg){
        return createError_native_QDBusError_ErrorType_cref_QString(type.value(), msg);
    }
    
    private native static io.qt.dbus.QDBusMessage createError_native_QDBusError_ErrorType_cref_QString(int type, java.lang.String msg);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusmessage.html#createError-1">QDBusMessage::createError(QDBusError)</a></p>
     */
    public static io.qt.dbus.@NonNull QDBusMessage createError(io.qt.dbus.@NonNull QDBusError err){
        return createError_native_cref_QDBusError(QtJambi_LibraryUtilities.internal.checkedNativeId(err));
    }
    
    private native static io.qt.dbus.QDBusMessage createError_native_cref_QDBusError(long err);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusmessage.html#createError">QDBusMessage::createError(QString,QString)</a></p>
     */
    public native static io.qt.dbus.@NonNull QDBusMessage createError(java.lang.@NonNull String name, java.lang.@NonNull String msg);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusmessage.html#createMethodCall">QDBusMessage::createMethodCall(QString,QString,QString,QString)</a></p>
     */
    public native static io.qt.dbus.@NonNull QDBusMessage createMethodCall(java.lang.@NonNull String destination, java.lang.@NonNull String path, java.lang.@NonNull String arg__interface, java.lang.@NonNull String method);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusmessage.html#createSignal">QDBusMessage::createSignal(QString,QString,QString)</a></p>
     */
    public native static io.qt.dbus.@NonNull QDBusMessage createSignal(java.lang.@NonNull String path, java.lang.@NonNull String arg__interface, java.lang.@NonNull String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusmessage.html#createTargetedSignal">QDBusMessage::createTargetedSignal(QString,QString,QString,QString)</a></p>
     */
    public native static io.qt.dbus.@NonNull QDBusMessage createTargetedSignal(java.lang.@NonNull String service, java.lang.@NonNull String path, java.lang.@NonNull String arg__interface, java.lang.@NonNull String name);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QDBusMessage(QPrivateConstructor p) { super(p); } 
    

    @Override
    @QtUninvokable
    public @NonNull String toString() {
        return toString_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private static native String toString_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
     */
    @QtUninvokable
    @Override
    public QDBusMessage clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QDBusMessage clone_native(long __this_nativeId);
}
