package io.qt.dbus;

import io.qt.*;


/**
 * <p>Represents an error received from the D-Bus bus or from remote applications found in the bus</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qdbuserror.html">QDBusError</a></p>
 */
public class QDBusError extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QDBusError.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::ErrorType</a></p>
     */
    @QtRejectedEntries({"LastErrorType"})
    public enum ErrorType implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::NoError</a></p>
         */
        NoError(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::Other</a></p>
         */
        Other(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::Failed</a></p>
         */
        Failed(2),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::NoMemory</a></p>
         */
        NoMemory(3),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::ServiceUnknown</a></p>
         */
        ServiceUnknown(4),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::NoReply</a></p>
         */
        NoReply(5),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::BadAddress</a></p>
         */
        BadAddress(6),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::NotSupported</a></p>
         */
        NotSupported(7),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::LimitsExceeded</a></p>
         */
        LimitsExceeded(8),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::AccessDenied</a></p>
         */
        AccessDenied(9),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::NoServer</a></p>
         */
        NoServer(10),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::Timeout</a></p>
         */
        Timeout(11),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::NoNetwork</a></p>
         */
        NoNetwork(12),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::AddressInUse</a></p>
         */
        AddressInUse(13),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::Disconnected</a></p>
         */
        Disconnected(14),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::InvalidArgs</a></p>
         */
        InvalidArgs(15),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::UnknownMethod</a></p>
         */
        UnknownMethod(16),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::TimedOut</a></p>
         */
        TimedOut(17),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::InvalidSignature</a></p>
         */
        InvalidSignature(18),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::UnknownInterface</a></p>
         */
        UnknownInterface(19),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::UnknownObject</a></p>
         */
        UnknownObject(20),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::UnknownProperty</a></p>
         */
        UnknownProperty(21),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::PropertyReadOnly</a></p>
         */
        PropertyReadOnly(22),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::InternalError</a></p>
         */
        InternalError(23),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::InvalidService</a></p>
         */
        InvalidService(24),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::InvalidObjectPath</a></p>
         */
        InvalidObjectPath(25),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::InvalidInterface</a></p>
         */
        InvalidInterface(26),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::InvalidMember</a></p>
         */
        InvalidMember(27),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::LastErrorType</a></p>
         */
        LastErrorType(27);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ErrorType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ErrorType resolve(int value) {
            switch (value) {
            case 0: return NoError;
            case 1: return Other;
            case 2: return Failed;
            case 3: return NoMemory;
            case 4: return ServiceUnknown;
            case 5: return NoReply;
            case 6: return BadAddress;
            case 7: return NotSupported;
            case 8: return LimitsExceeded;
            case 9: return AccessDenied;
            case 10: return NoServer;
            case 11: return Timeout;
            case 12: return NoNetwork;
            case 13: return AddressInUse;
            case 14: return Disconnected;
            case 15: return InvalidArgs;
            case 16: return UnknownMethod;
            case 17: return TimedOut;
            case 18: return InvalidSignature;
            case 19: return UnknownInterface;
            case 20: return UnknownObject;
            case 21: return UnknownProperty;
            case 22: return PropertyReadOnly;
            case 23: return InternalError;
            case 24: return InvalidService;
            case 25: return InvalidObjectPath;
            case 26: return InvalidInterface;
            case 27: return InvalidMember;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    public QDBusError(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QDBusError instance);
    
    public QDBusError(io.qt.dbus.QDBusError.@NonNull ErrorType error, java.lang.@NonNull String message){
        super((QPrivateConstructor)null);
        initialize_native(this, error, message);
    }
    
    private native static void initialize_native(QDBusError instance, io.qt.dbus.QDBusError.ErrorType error, java.lang.String message);
    
    public QDBusError(io.qt.dbus.@NonNull QDBusError other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QDBusError instance, io.qt.dbus.QDBusError other);
    
    public QDBusError(io.qt.dbus.@NonNull QDBusMessage msg){
        super((QPrivateConstructor)null);
        initialize_native(this, msg);
    }
    
    private native static void initialize_native(QDBusError instance, io.qt.dbus.QDBusMessage msg);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbuserror.html#isValid">QDBusError::isValid()const</a></p>
     */
    @QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbuserror.html#message">QDBusError::message()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String message(){
        return message_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String message_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbuserror.html#name">QDBusError::name()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String name(){
        return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String name_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final void assign(io.qt.dbus.@NonNull QDBusError other){
        assign_native_cref_QDBusError(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QDBusError(long __this__nativeId, long other);
    
    @QtUninvokable
    public final void assign(io.qt.dbus.@NonNull QDBusMessage msg){
        assign_native_cref_QDBusMessage(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(msg));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QDBusMessage(long __this__nativeId, long msg);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbuserror.html#swap">QDBusError::swap(QDBusError&amp;)</a></p>
     */
    @QtUninvokable
    public final void swap(io.qt.dbus.@StrictNonNull QDBusError other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QDBusError(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void swap_native_ref_QDBusError(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbuserror.html#type">QDBusError::type()const</a></p>
     */
    @QtUninvokable
    public final io.qt.dbus.QDBusError.@NonNull ErrorType type(){
        return io.qt.dbus.QDBusError.ErrorType.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int type_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbuserror.html#errorString">QDBusError::errorString(QDBusError::ErrorType)</a></p>
     */
    public static java.lang.@NonNull String errorString(io.qt.dbus.QDBusError.@NonNull ErrorType error){
        return errorString_native_QDBusError_ErrorType(error.value());
    }
    
    private native static java.lang.String errorString_native_QDBusError_ErrorType(int error);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QDBusError(QPrivateConstructor p) { super(p); } 
    

    @Override
    @QtUninvokable
    public @NonNull String toString() {
        return toString_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private static native String toString_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
     */
    @QtUninvokable
    @Override
    public QDBusError clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QDBusError clone_native(long __this_nativeId);
}
