package io.qt.dbus;

import io.qt.*;


/**
 * <p>Used to marshall and demarshall D-Bus arguments</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qdbusargument.html">QDBusArgument</a></p>
 */
public class QDBusArgument extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qdbusargument.html#ElementType-enum">QDBusArgument::ElementType</a></p>
     */
    public enum ElementType implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbusargument.html#ElementType-enum">QDBusArgument::BasicType</a></p>
         */
        BasicType(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbusargument.html#ElementType-enum">QDBusArgument::VariantType</a></p>
         */
        VariantType(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbusargument.html#ElementType-enum">QDBusArgument::ArrayType</a></p>
         */
        ArrayType(2),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbusargument.html#ElementType-enum">QDBusArgument::StructureType</a></p>
         */
        StructureType(3),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbusargument.html#ElementType-enum">QDBusArgument::MapType</a></p>
         */
        MapType(4),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbusargument.html#ElementType-enum">QDBusArgument::MapEntryType</a></p>
         */
        MapEntryType(5),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbusargument.html#ElementType-enum">QDBusArgument::UnknownType</a></p>
         */
        UnknownType(-1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ElementType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ElementType resolve(int value) {
            switch (value) {
            case 0: return BasicType;
            case 1: return VariantType;
            case 2: return ArrayType;
            case 3: return StructureType;
            case 4: return MapType;
            case 5: return MapEntryType;
            case -1: return UnknownType;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#QDBusArgument">QDBusArgument::QDBusArgument()</a></p>
     */
    public QDBusArgument(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QDBusArgument instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#QDBusArgument-1">QDBusArgument::QDBusArgument(QDBusArgument)</a></p>
     */
    public QDBusArgument(io.qt.dbus.@NonNull QDBusArgument other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QDBusArgument instance, io.qt.dbus.QDBusArgument other);
    
    @QtUninvokable
    public final void appendVariant(java.lang.Object v){
        appendVariant_native_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void appendVariant_native_cref_QVariant(long __this__nativeId, java.lang.Object v);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#asVariant">QDBusArgument::asVariant()const</a></p>
     */
    @QtUninvokable
    public final java.lang.Object asVariant(){
        return asVariant_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.Object asVariant_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#atEnd">QDBusArgument::atEnd()const</a></p>
     */
    @QtUninvokable
    public final boolean atEnd(){
        return atEnd_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean atEnd_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#beginArray-2">QDBusArgument::beginArray()const</a></p>
     */
    @QtUninvokable
    public final void beginArray(){
        beginArray_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void beginArray_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#beginArray-1">QDBusArgument::beginArray(QMetaType)</a></p>
     */
    @QtUninvokable
    public final void beginArray(io.qt.core.@NonNull QMetaType elementMetaType){
        beginArray_native_QMetaType(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(elementMetaType));
    }
    
    @QtUninvokable
    private native void beginArray_native_QMetaType(long __this__nativeId, long elementMetaType);
    
    @QtUninvokable
    public final void beginArray(int elementMetaTypeId){
        beginArray_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), elementMetaTypeId);
    }
    
    @QtUninvokable
    private native void beginArray_native_int(long __this__nativeId, int elementMetaTypeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#beginMap-2">QDBusArgument::beginMap()const</a></p>
     */
    @QtUninvokable
    public final void beginMap(){
        beginMap_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void beginMap_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#beginMap-1">QDBusArgument::beginMap(QMetaType,QMetaType)</a></p>
     */
    @QtUninvokable
    public final void beginMap(io.qt.core.@NonNull QMetaType keyMetaType, io.qt.core.@NonNull QMetaType valueMetaType){
        beginMap_native_QMetaType_QMetaType(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(keyMetaType), QtJambi_LibraryUtilities.internal.checkedNativeId(valueMetaType));
    }
    
    @QtUninvokable
    private native void beginMap_native_QMetaType_QMetaType(long __this__nativeId, long keyMetaType, long valueMetaType);
    
    @QtUninvokable
    public final void beginMap(int keyMetaTypeId, int valueMetaTypeId){
        beginMap_native_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), keyMetaTypeId, valueMetaTypeId);
    }
    
    @QtUninvokable
    private native void beginMap_native_int_int(long __this__nativeId, int keyMetaTypeId, int valueMetaTypeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#beginMapEntry">QDBusArgument::beginMapEntry()</a></p>
     */
    @QtUninvokable
    public final void beginMapEntry(){
        beginMapEntry_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void beginMapEntry_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#beginStructure">QDBusArgument::beginStructure()</a></p>
     */
    @QtUninvokable
    public final void beginStructure(){
        beginStructure_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void beginStructure_native(long __this__nativeId);
    
    @QtUninvokable
    public final java.lang.@NonNull String currentSignature(){
        return currentSignature_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String currentSignature_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#currentType">QDBusArgument::currentType()const</a></p>
     */
    @QtUninvokable
    public final io.qt.dbus.QDBusArgument.@NonNull ElementType currentType(){
        return io.qt.dbus.QDBusArgument.ElementType.resolve(currentType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int currentType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#endArray">QDBusArgument::endArray()</a></p>
     */
    @QtUninvokable
    public final void endArray(){
        endArray_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void endArray_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#endMap">QDBusArgument::endMap()</a></p>
     */
    @QtUninvokable
    public final void endMap(){
        endMap_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void endMap_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#endMapEntry">QDBusArgument::endMapEntry()</a></p>
     */
    @QtUninvokable
    public final void endMapEntry(){
        endMapEntry_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void endMapEntry_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#endStructure">QDBusArgument::endStructure()</a></p>
     */
    @QtUninvokable
    public final void endStructure(){
        endStructure_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void endStructure_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#operator-lt-lt-1">QDBusArgument::operator&lt;&lt;(bool)</a></p>
     */
    @QtUninvokable
    public final @NonNull QDBusArgument append(boolean arg){
        return append_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), arg);
    }
    
    @QtUninvokable
    private native QDBusArgument append_native_bool(long __this__nativeId, boolean arg);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#operator-lt-lt-12">QDBusArgument::operator&lt;&lt;(QByteArray)</a></p>
     */
    @QtUninvokable
    public final @NonNull QDBusArgument append(io.qt.core.@NonNull QByteArray arg){
        return append_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg));
    }
    
    @QtUninvokable
    private native QDBusArgument append_native_cref_QByteArray(long __this__nativeId, long arg);
    
    @QtUninvokable
    public final @NonNull QDBusArgument append(io.qt.dbus.@NonNull QDBusObjectPath arg){
        return append_native_cref_QDBusObjectPath(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg));
    }
    
    @QtUninvokable
    private native QDBusArgument append_native_cref_QDBusObjectPath(long __this__nativeId, long arg);
    
    @QtUninvokable
    public final @NonNull QDBusArgument append(io.qt.dbus.@NonNull QDBusSignature arg){
        return append_native_cref_QDBusSignature(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg));
    }
    
    @QtUninvokable
    private native QDBusArgument append_native_cref_QDBusSignature(long __this__nativeId, long arg);
    
    @QtUninvokable
    public final @NonNull QDBusArgument append(io.qt.dbus.@NonNull QDBusUnixFileDescriptor arg){
        return append_native_cref_QDBusUnixFileDescriptor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg));
    }
    
    @QtUninvokable
    private native QDBusArgument append_native_cref_QDBusUnixFileDescriptor(long __this__nativeId, long arg);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#operator-lt-lt-10">QDBusArgument::operator&lt;&lt;(QDBusVariant)</a></p>
     */
    @QtUninvokable
    public final @NonNull QDBusArgument append(io.qt.dbus.@StrictNonNull QDBusVariant arg){
        java.util.Objects.requireNonNull(arg, "Argument 'arg': null not expected.");
        return append_native_cref_QDBusVariant(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg));
    }
    
    @QtUninvokable
    private native QDBusArgument append_native_cref_QDBusVariant(long __this__nativeId, long arg);
    
    @QtUninvokable
    public final @NonNull QDBusArgument append(io.qt.core.@NonNull QDate date){
        return append_native_cref_QDate(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(date));
    }
    
    @QtUninvokable
    private native QDBusArgument append_native_cref_QDate(long __this__nativeId, long date);
    
    @QtUninvokable
    public final @NonNull QDBusArgument append(io.qt.core.@NonNull QDateTime dt){
        return append_native_cref_QDateTime(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(dt));
    }
    
    @QtUninvokable
    private native QDBusArgument append_native_cref_QDateTime(long __this__nativeId, long dt);
    
    @QtUninvokable
    public final @NonNull QDBusArgument append(java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> map){
        return append_native_cref_QHash(QtJambi_LibraryUtilities.internal.nativeId(this), map);
    }
    
    @QtUninvokable
    private native QDBusArgument append_native_cref_QHash(long __this__nativeId, java.util.Map<java.lang.String, ? extends java.lang.Object> map);
    
    @QtUninvokable
    public final @NonNull QDBusArgument append(io.qt.core.@NonNull QLine line){
        return append_native_cref_QLine(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(line));
    }
    
    @QtUninvokable
    private native QDBusArgument append_native_cref_QLine(long __this__nativeId, long line);
    
    @QtUninvokable
    public final @NonNull QDBusArgument append(io.qt.core.@NonNull QLineF line){
        return append_native_cref_QLineF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(line));
    }
    
    @QtUninvokable
    private native QDBusArgument append_native_cref_QLineF(long __this__nativeId, long line);
    
    @QtUninvokable
    public final @NonNull QDBusArgument append(java.util.@NonNull Collection<? extends java.lang.Object> list){
        return append_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), list);
    }
    
    @QtUninvokable
    private native QDBusArgument append_native_cref_QList(long __this__nativeId, java.util.Collection<? extends java.lang.Object> list);
    
    @QtUninvokable
    public final @NonNull QDBusArgument append(java.util.@NonNull NavigableMap<java.lang.@NonNull String, ? extends java.lang.Object> map){
        return append_native_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), map);
    }
    
    @QtUninvokable
    private native QDBusArgument append_native_cref_QMap(long __this__nativeId, java.util.NavigableMap<java.lang.String, ? extends java.lang.Object> map);
    
    @QtUninvokable
    public final @NonNull QDBusArgument append(io.qt.core.@NonNull QPoint pt){
        return append_native_cref_QPoint(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pt));
    }
    
    @QtUninvokable
    private native QDBusArgument append_native_cref_QPoint(long __this__nativeId, long pt);
    
    @QtUninvokable
    public final @NonNull QDBusArgument append(io.qt.core.@NonNull QPointF pt){
        return append_native_cref_QPointF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pt));
    }
    
    @QtUninvokable
    private native QDBusArgument append_native_cref_QPointF(long __this__nativeId, long pt);
    
    @QtUninvokable
    public final @NonNull QDBusArgument append(io.qt.core.@NonNull QRect rect){
        return append_native_cref_QRect(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rect));
    }
    
    @QtUninvokable
    private native QDBusArgument append_native_cref_QRect(long __this__nativeId, long rect);
    
    @QtUninvokable
    public final @NonNull QDBusArgument append(io.qt.core.@NonNull QRectF rect){
        return append_native_cref_QRectF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rect));
    }
    
    @QtUninvokable
    private native QDBusArgument append_native_cref_QRectF(long __this__nativeId, long rect);
    
    @QtUninvokable
    public final @NonNull QDBusArgument append(io.qt.core.@NonNull QSize size){
        return append_native_cref_QSize(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(size));
    }
    
    @QtUninvokable
    private native QDBusArgument append_native_cref_QSize(long __this__nativeId, long size);
    
    @QtUninvokable
    public final @NonNull QDBusArgument append(io.qt.core.@NonNull QSizeF size){
        return append_native_cref_QSizeF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(size));
    }
    
    @QtUninvokable
    private native QDBusArgument append_native_cref_QSizeF(long __this__nativeId, long size);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#operator-lt-lt-9">QDBusArgument::operator&lt;&lt;(QString)</a></p>
     */
    @QtUninvokable
    public final @NonNull QDBusArgument append(java.lang.@Nullable CharSequence arg){
        return append_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), arg);
    }
    
    @QtUninvokable
    private native QDBusArgument append_native_cref_QString(long __this__nativeId, java.lang.CharSequence arg);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#operator-lt-lt-11">QDBusArgument::operator&lt;&lt;(QStringList)</a></p>
     */
    @QtUninvokable
    public final @NonNull QDBusArgument append(java.util.@NonNull List<java.lang.@NonNull String> arg){
        return append_native_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), arg);
    }
    
    @QtUninvokable
    private native QDBusArgument append_native_cref_QStringList(long __this__nativeId, java.util.List<java.lang.String> arg);
    
    @QtUninvokable
    public final @NonNull QDBusArgument append(io.qt.core.@NonNull QTime time){
        return append_native_cref_QTime(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(time));
    }
    
    @QtUninvokable
    private native QDBusArgument append_native_cref_QTime(long __this__nativeId, long time);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#operator-lt-lt-8">QDBusArgument::operator&lt;&lt;(double)</a></p>
     */
    @QtUninvokable
    public final @NonNull QDBusArgument append(double arg){
        return append_native_double(QtJambi_LibraryUtilities.internal.nativeId(this), arg);
    }
    
    @QtUninvokable
    private native QDBusArgument append_native_double(long __this__nativeId, double arg);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#operator-lt-lt-4">QDBusArgument::operator&lt;&lt;(int)</a></p>
     */
    @QtUninvokable
    public final @NonNull QDBusArgument append(int arg){
        return append_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), arg);
    }
    
    @QtUninvokable
    private native QDBusArgument append_native_int(long __this__nativeId, int arg);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#operator-lt-lt-6">QDBusArgument::operator&lt;&lt;(qlonglong)</a></p>
     */
    @QtUninvokable
    public final @NonNull QDBusArgument append(long arg){
        return append_native_qlonglong(QtJambi_LibraryUtilities.internal.nativeId(this), arg);
    }
    
    @QtUninvokable
    private native QDBusArgument append_native_qlonglong(long __this__nativeId, long arg);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#operator-lt-lt-2">QDBusArgument::operator&lt;&lt;(short)</a></p>
     */
    @QtUninvokable
    public final @NonNull QDBusArgument append(short arg){
        return append_native_short(QtJambi_LibraryUtilities.internal.nativeId(this), arg);
    }
    
    @QtUninvokable
    private native QDBusArgument append_native_short(long __this__nativeId, short arg);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#operator-lt-lt">QDBusArgument::operator&lt;&lt;(uchar)</a></p>
     */
    @QtUninvokable
    public final @NonNull QDBusArgument append(byte arg){
        return append_native_uchar(QtJambi_LibraryUtilities.internal.nativeId(this), arg);
    }
    
    @QtUninvokable
    private native QDBusArgument append_native_uchar(long __this__nativeId, byte arg);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#operator-eq-1">QDBusArgument::operator=(QDBusArgument)</a></p>
     */
    @QtUninvokable
    public final void assign(io.qt.dbus.@NonNull QDBusArgument other){
        assign_native_cref_QDBusArgument(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QDBusArgument(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#operator-gt-gt-12">QDBusArgument::operator&gt;&gt;(QByteArray&amp;)const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray extractBytes(){
        return extractBytes_native_ref_QByteArray_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.@NonNull QByteArray extractBytes_native_ref_QByteArray_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final io.qt.dbus.@NonNull QDBusObjectPath extractObjectPath(){
        return extractObjectPath_native_ref_QDBusObjectPath_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.dbus.@NonNull QDBusObjectPath extractObjectPath_native_ref_QDBusObjectPath_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final io.qt.dbus.@NonNull QDBusObjectPath extractSignature(){
        return extractSignature_native_ref_QDBusSignature_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.dbus.@NonNull QDBusObjectPath extractSignature_native_ref_QDBusSignature_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final io.qt.dbus.@NonNull QDBusUnixFileDescriptor extractUnixFileDescriptor(){
        return extractUnixFileDescriptor_native_ref_QDBusUnixFileDescriptor_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.dbus.@NonNull QDBusUnixFileDescriptor extractUnixFileDescriptor_native_ref_QDBusUnixFileDescriptor_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#operator-gt-gt-10">QDBusArgument::operator&gt;&gt;(QDBusVariant&amp;)const</a></p>
     */
    @QtUninvokable
    public final io.qt.dbus.@NonNull QDBusVariant extractVariant(){
        return extractVariant_native_ref_QDBusVariant_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.dbus.@NonNull QDBusVariant extractVariant_native_ref_QDBusVariant_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final io.qt.core.@NonNull QDate extractDate(io.qt.core.@StrictNonNull QDate date){
        java.util.Objects.requireNonNull(date, "Argument 'date': null not expected.");
        return extractDate_native_ref_QDate(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(date));
    }
    
    @QtUninvokable
    private native io.qt.core.@NonNull QDate extractDate_native_ref_QDate(long __this__nativeId, long date);
    
    @QtUninvokable
    public final io.qt.core.@NonNull QDateTime extractDateTime(io.qt.core.@StrictNonNull QDateTime dt){
        java.util.Objects.requireNonNull(dt, "Argument 'dt': null not expected.");
        return extractDateTime_native_ref_QDateTime(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(dt));
    }
    
    @QtUninvokable
    private native io.qt.core.@NonNull QDateTime extractDateTime_native_ref_QDateTime(long __this__nativeId, long dt);
    
    @QtUninvokable
    public final io.qt.core.@NonNull QLine extractLine(io.qt.core.@StrictNonNull QLine line){
        java.util.Objects.requireNonNull(line, "Argument 'line': null not expected.");
        return extractLine_native_ref_QLine(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(line));
    }
    
    @QtUninvokable
    private native io.qt.core.@NonNull QLine extractLine_native_ref_QLine(long __this__nativeId, long line);
    
    @QtUninvokable
    public final io.qt.core.@NonNull QLineF extractLineF(io.qt.core.@StrictNonNull QLineF line){
        java.util.Objects.requireNonNull(line, "Argument 'line': null not expected.");
        return extractLineF_native_ref_QLineF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(line));
    }
    
    @QtUninvokable
    private native io.qt.core.@NonNull QLineF extractLineF_native_ref_QLineF(long __this__nativeId, long line);
    
    @QtUninvokable
    public final io.qt.core.@NonNull QPoint extractPoint(io.qt.core.@StrictNonNull QPoint pt){
        java.util.Objects.requireNonNull(pt, "Argument 'pt': null not expected.");
        return extractPoint_native_ref_QPoint(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pt));
    }
    
    @QtUninvokable
    private native io.qt.core.@NonNull QPoint extractPoint_native_ref_QPoint(long __this__nativeId, long pt);
    
    @QtUninvokable
    public final io.qt.core.@NonNull QPointF extractPointF(io.qt.core.@StrictNonNull QPointF pt){
        java.util.Objects.requireNonNull(pt, "Argument 'pt': null not expected.");
        return extractPointF_native_ref_QPointF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pt));
    }
    
    @QtUninvokable
    private native io.qt.core.@NonNull QPointF extractPointF_native_ref_QPointF(long __this__nativeId, long pt);
    
    @QtUninvokable
    public final io.qt.core.@NonNull QRect extractRect(io.qt.core.@StrictNonNull QRect rect){
        java.util.Objects.requireNonNull(rect, "Argument 'rect': null not expected.");
        return extractRect_native_ref_QRect(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rect));
    }
    
    @QtUninvokable
    private native io.qt.core.@NonNull QRect extractRect_native_ref_QRect(long __this__nativeId, long rect);
    
    @QtUninvokable
    public final io.qt.core.@NonNull QRectF extractRectF(io.qt.core.@StrictNonNull QRectF rect){
        java.util.Objects.requireNonNull(rect, "Argument 'rect': null not expected.");
        return extractRectF_native_ref_QRectF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rect));
    }
    
    @QtUninvokable
    private native io.qt.core.@NonNull QRectF extractRectF_native_ref_QRectF(long __this__nativeId, long rect);
    
    @QtUninvokable
    public final io.qt.core.@NonNull QSize extractSize(io.qt.core.@StrictNonNull QSize size){
        java.util.Objects.requireNonNull(size, "Argument 'size': null not expected.");
        return extractSize_native_ref_QSize(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(size));
    }
    
    @QtUninvokable
    private native io.qt.core.@NonNull QSize extractSize_native_ref_QSize(long __this__nativeId, long size);
    
    @QtUninvokable
    public final io.qt.core.@NonNull QSizeF extractSizeF(io.qt.core.@StrictNonNull QSizeF size){
        java.util.Objects.requireNonNull(size, "Argument 'size': null not expected.");
        return extractSizeF_native_ref_QSizeF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(size));
    }
    
    @QtUninvokable
    private native io.qt.core.@NonNull QSizeF extractSizeF_native_ref_QSizeF(long __this__nativeId, long size);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#operator-gt-gt-9">QDBusArgument::operator&gt;&gt;(QString&amp;)const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.QString extractQString(){
        return extractQString_native_ref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QString extractQString_native_ref_QString_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#operator-gt-gt-11">QDBusArgument::operator&gt;&gt;(QStringList&amp;)const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList extractStrings(){
        return extractStrings_native_ref_QStringList_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.@NonNull QStringList extractStrings_native_ref_QStringList_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final io.qt.core.@NonNull QTime extractTime(io.qt.core.@StrictNonNull QTime time){
        java.util.Objects.requireNonNull(time, "Argument 'time': null not expected.");
        return extractTime_native_ref_QTime(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(time));
    }
    
    @QtUninvokable
    private native io.qt.core.@NonNull QTime extractTime_native_ref_QTime(long __this__nativeId, long time);
    
    @QtUninvokable
    public final io.qt.core.@NonNull QVariant extractObject(io.qt.core.@StrictNonNull QVariant v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        return extractObject_native_ref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native io.qt.core.@NonNull QVariant extractObject_native_ref_QVariant(long __this__nativeId, io.qt.core.QVariant v);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#operator-gt-gt-1">QDBusArgument::operator&gt;&gt;(bool&amp;)const</a></p>
     */
    @QtUninvokable
    public final boolean extractBoolean(){
        return extractBoolean_native_ref_bool_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean extractBoolean_native_ref_bool_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#operator-gt-gt-8">QDBusArgument::operator&gt;&gt;(double&amp;)const</a></p>
     */
    @QtUninvokable
    public final double extractDouble(){
        return extractDouble_native_ref_double_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double extractDouble_native_ref_double_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#operator-gt-gt-4">QDBusArgument::operator&gt;&gt;(int&amp;)const</a></p>
     */
    @QtUninvokable
    public final int extractInt(){
        return extractInt_native_ref_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int extractInt_native_ref_int_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#operator-gt-gt-6">QDBusArgument::operator&gt;&gt;(qlonglong&amp;)const</a></p>
     */
    @QtUninvokable
    public final long extractLong(){
        return extractLong_native_ref_qlonglong_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long extractLong_native_ref_qlonglong_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#operator-gt-gt-2">QDBusArgument::operator&gt;&gt;(short&amp;)const</a></p>
     */
    @QtUninvokable
    public final short extractShort(){
        return extractShort_native_ref_short_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native short extractShort_native_ref_short_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#operator-gt-gt">QDBusArgument::operator&gt;&gt;(uchar&amp;)const</a></p>
     */
    @QtUninvokable
    public final byte extractByte(){
        return extractByte_native_ref_uchar_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native byte extractByte_native_ref_uchar_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#swap">QDBusArgument::swap(QDBusArgument&amp;)</a></p>
     */
    @QtUninvokable
    public final void swap(io.qt.dbus.@StrictNonNull QDBusArgument other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QDBusArgument(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void swap_native_ref_QDBusArgument(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QDBusArgument(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Creates and returns a copy of this object.</p>
     */
    @QtUninvokable
    @Override
    public QDBusArgument clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QDBusArgument clone_native(long __this_nativeId);
}
