package io.qt.dbus;

import io.qt.*;


/**
 * <p>Contains miscellaneous identifiers used throughout the Qt D-Bus module</p>
 * <p>Java wrapper for Qt's namespace <a href="https://doc.qt.io/qt/qdbus.html">QDBus</a></p>
 */
public final class QDBus
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    private QDBus() throws java.lang.InstantiationError { throw new java.lang.InstantiationError("Cannot instantiate namespace QDBus."); }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qdbus.html#CallMode-enum">QDBus::CallMode</a></p>
     */
    public enum CallMode implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbus.html#CallMode-enum">QDBus::NoBlock</a></p>
         */
        NoBlock(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbus.html#CallMode-enum">QDBus::Block</a></p>
         */
        Block(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbus.html#CallMode-enum">QDBus::BlockWithGui</a></p>
         */
        BlockWithGui(2),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdbus.html#CallMode-enum">QDBus::AutoDetect</a></p>
         */
        AutoDetect(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private CallMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull CallMode resolve(int value) {
            switch (value) {
            case 0: return NoBlock;
            case 1: return Block;
            case 2: return BlockWithGui;
            case 3: return AutoDetect;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
}
