package io.qt.dbus;


/**
 * <p>Convenient way for waiting for asynchronous replies</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qdbuspendingcallwatcher.html">QDBusPendingCallWatcher</a></p>
 */
public class QDBusPendingCallWatcher extends io.qt.core.QObject
    implements io.qt.dbus.QDBusPendingCall
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QDBusPendingCallWatcher.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbuspendingcallwatcher.html#finished">QDBusPendingCallWatcher::finished(QDBusPendingCallWatcher*)</a></p>
     */
    public final Signal1Default1<io.qt.dbus.QDBusPendingCallWatcher> finished = new Signal1Default1<>(()->null);
    
    /**
     * <p>Overloaded constructor for {@link #QDBusPendingCallWatcher(io.qt.dbus.QDBusPendingCall, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QDBusPendingCallWatcher(io.qt.dbus.QDBusPendingCall call) {
        this(call, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbuspendingcallwatcher.html#QDBusPendingCallWatcher">QDBusPendingCallWatcher::QDBusPendingCallWatcher(QDBusPendingCall,QObject*)</a></p>
     */
    public QDBusPendingCallWatcher(io.qt.dbus.QDBusPendingCall call, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        java.util.Objects.requireNonNull(call, "Argument 'call': null not expected.");
        initialize_native(this, call, parent);
    }
    
    private native static void initialize_native(QDBusPendingCallWatcher instance, io.qt.dbus.QDBusPendingCall call, io.qt.core.QObject parent);
    
    @io.qt.QtUninvokable
    public final io.qt.dbus.QDBusError error(){
        return error_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static io.qt.dbus.QDBusError error_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final boolean isError(){
        return isError_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static boolean isError_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final boolean isFinished(){
        return isFinished_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static boolean isFinished_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static boolean isValid_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final io.qt.dbus.QDBusMessage reply(){
        return reply_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static io.qt.dbus.QDBusMessage reply_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbuspendingcall.html#swap">QDBusPendingCall::swap(QDBusPendingCall&amp;)</a></p>
     */
    @io.qt.QtUninvokable
    public final void swap(io.qt.dbus.QDBusPendingCall other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QDBusPendingCall(QtJambi_LibraryUtilities.internal.nativeId(this), other);
    }
    
    private native static void swap_native_ref_QDBusPendingCall(long __this__nativeId, io.qt.dbus.QDBusPendingCall other);
    
    @io.qt.QtUninvokable
    public final void waitForFinished(){
        waitForFinished_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static void waitForFinished_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QDBusPendingCallWatcher(QPrivateConstructor p) { super(p); } 
    
}
