package io.qt.dbus;


/**
 * <p>Represents an error received from the D-Bus bus or from remote applications found in the bus</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qdbuserror.html">QDBusError</a></p>
 */
public class QDBusError extends io.qt.QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QDBusError.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qdbuserror.html#ErrorType-enum">QDBusError::ErrorType</a></p>
     */
    @io.qt.QtRejectedEntries({"LastErrorType"})
    public enum ErrorType implements io.qt.QtEnumerator {
        NoError(0),
        Other(1),
        Failed(2),
        NoMemory(3),
        ServiceUnknown(4),
        NoReply(5),
        BadAddress(6),
        NotSupported(7),
        LimitsExceeded(8),
        AccessDenied(9),
        NoServer(10),
        Timeout(11),
        NoNetwork(12),
        AddressInUse(13),
        Disconnected(14),
        InvalidArgs(15),
        UnknownMethod(16),
        TimedOut(17),
        InvalidSignature(18),
        UnknownInterface(19),
        UnknownObject(20),
        UnknownProperty(21),
        PropertyReadOnly(22),
        InternalError(23),
        InvalidService(24),
        InvalidObjectPath(25),
        InvalidInterface(26),
        InvalidMember(27),
        LastErrorType(27);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ErrorType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ErrorType resolve(int value) {
            switch (value) {
            case 0: return NoError;
            case 1: return Other;
            case 2: return Failed;
            case 3: return NoMemory;
            case 4: return ServiceUnknown;
            case 5: return NoReply;
            case 6: return BadAddress;
            case 7: return NotSupported;
            case 8: return LimitsExceeded;
            case 9: return AccessDenied;
            case 10: return NoServer;
            case 11: return Timeout;
            case 12: return NoNetwork;
            case 13: return AddressInUse;
            case 14: return Disconnected;
            case 15: return InvalidArgs;
            case 16: return UnknownMethod;
            case 17: return TimedOut;
            case 18: return InvalidSignature;
            case 19: return UnknownInterface;
            case 20: return UnknownObject;
            case 21: return UnknownProperty;
            case 22: return PropertyReadOnly;
            case 23: return InternalError;
            case 24: return InvalidService;
            case 25: return InvalidObjectPath;
            case 26: return InvalidInterface;
            case 27: return InvalidMember;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    public QDBusError(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QDBusError instance);
    
    public QDBusError(io.qt.dbus.QDBusError.ErrorType error, java.lang.String message){
        super((QPrivateConstructor)null);
        initialize_native(this, error, message);
    }
    
    private native static void initialize_native(QDBusError instance, io.qt.dbus.QDBusError.ErrorType error, java.lang.String message);
    
    public QDBusError(io.qt.dbus.QDBusError other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QDBusError instance, io.qt.dbus.QDBusError other);
    
    public QDBusError(io.qt.dbus.QDBusMessage msg){
        super((QPrivateConstructor)null);
        initialize_native(this, msg);
    }
    
    private native static void initialize_native(QDBusError instance, io.qt.dbus.QDBusMessage msg);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbuserror.html#isValid">QDBusError::isValid()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbuserror.html#message">QDBusError::message()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String message(){
        return message_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String message_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbuserror.html#name">QDBusError::name()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String name(){
        return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String name_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbuserror.html#swap">QDBusError::swap(QDBusError&amp;)</a></p>
     */
    @io.qt.QtUninvokable
    public final void swap(io.qt.dbus.QDBusError other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QDBusError(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native void swap_native_ref_QDBusError(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbuserror.html#type">QDBusError::type()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.dbus.QDBusError.ErrorType type(){
        return io.qt.dbus.QDBusError.ErrorType.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int type_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbuserror.html#errorString">QDBusError::errorString(QDBusError::ErrorType)</a></p>
     */
    public static java.lang.String errorString(io.qt.dbus.QDBusError.ErrorType error){
        return errorString_native_QDBusError_ErrorType(error.value());
    }
    
    private native static java.lang.String errorString_native_QDBusError_ErrorType(int error);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QDBusError(QPrivateConstructor p) { super(p); } 
    

    @Override
    @io.qt.QtUninvokable
    public String toString() {
        return toString_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @io.qt.QtUninvokable
    private static native String toString_native(long __this_nativeId);
    
    @Override
    public QDBusError clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private native QDBusError clone_native(long __this_nativeId);
}
