package io.qt.dbus;


/**
 * <p>Used to marshall and demarshall D-Bus arguments</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qdbusargument.html">QDBusArgument</a></p>
 */
public class QDBusArgument extends io.qt.QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qdbusargument.html#ElementType-enum">QDBusArgument::ElementType</a></p>
     */
    public enum ElementType implements io.qt.QtEnumerator {
        BasicType(0),
        VariantType(1),
        ArrayType(2),
        StructureType(3),
        MapType(4),
        MapEntryType(5),
        UnknownType(-1);

        private ElementType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ElementType resolve(int value) {
            switch (value) {
            case 0: return BasicType;
            case 1: return VariantType;
            case 2: return ArrayType;
            case 3: return StructureType;
            case 4: return MapType;
            case 5: return MapEntryType;
            case -1: return UnknownType;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#QDBusArgument">QDBusArgument::QDBusArgument()</a></p>
     */
    public QDBusArgument(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QDBusArgument instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#QDBusArgument-1">QDBusArgument::QDBusArgument(QDBusArgument)</a></p>
     */
    public QDBusArgument(io.qt.dbus.QDBusArgument other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QDBusArgument instance, io.qt.dbus.QDBusArgument other);
    
    @io.qt.QtUninvokable
    public final void appendVariant(java.lang.Object v){
        appendVariant_native_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void appendVariant_native_cref_QVariant(long __this__nativeId, java.lang.Object v);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#asVariant">QDBusArgument::asVariant()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object asVariant(){
        return asVariant_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.Object asVariant_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#atEnd">QDBusArgument::atEnd()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean atEnd(){
        return atEnd_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean atEnd_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#beginArray-2">QDBusArgument::beginArray()const</a></p>
     */
    @io.qt.QtUninvokable
    public final void beginArray(){
        beginArray_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void beginArray_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#beginArray-1">QDBusArgument::beginArray(QMetaType)</a></p>
     */
    @io.qt.QtUninvokable
    public final void beginArray(io.qt.core.QMetaType elementMetaType){
        beginArray_native_QMetaType(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(elementMetaType));
    }
    
    @io.qt.QtUninvokable
    private native void beginArray_native_QMetaType(long __this__nativeId, long elementMetaType);
    
    @io.qt.QtUninvokable
    public final void beginArray(int elementMetaTypeId){
        beginArray_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), elementMetaTypeId);
    }
    
    @io.qt.QtUninvokable
    private native void beginArray_native_int(long __this__nativeId, int elementMetaTypeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#beginMap-2">QDBusArgument::beginMap()const</a></p>
     */
    @io.qt.QtUninvokable
    public final void beginMap(){
        beginMap_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void beginMap_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#beginMap-1">QDBusArgument::beginMap(QMetaType,QMetaType)</a></p>
     */
    @io.qt.QtUninvokable
    public final void beginMap(io.qt.core.QMetaType keyMetaType, io.qt.core.QMetaType valueMetaType){
        beginMap_native_QMetaType_QMetaType(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(keyMetaType), QtJambi_LibraryUtilities.internal.checkedNativeId(valueMetaType));
    }
    
    @io.qt.QtUninvokable
    private native void beginMap_native_QMetaType_QMetaType(long __this__nativeId, long keyMetaType, long valueMetaType);
    
    @io.qt.QtUninvokable
    public final void beginMap(int keyMetaTypeId, int valueMetaTypeId){
        beginMap_native_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), keyMetaTypeId, valueMetaTypeId);
    }
    
    @io.qt.QtUninvokable
    private native void beginMap_native_int_int(long __this__nativeId, int keyMetaTypeId, int valueMetaTypeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#beginMapEntry">QDBusArgument::beginMapEntry()</a></p>
     */
    @io.qt.QtUninvokable
    public final void beginMapEntry(){
        beginMapEntry_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void beginMapEntry_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#beginStructure">QDBusArgument::beginStructure()</a></p>
     */
    @io.qt.QtUninvokable
    public final void beginStructure(){
        beginStructure_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void beginStructure_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final java.lang.String currentSignature(){
        return currentSignature_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String currentSignature_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#currentType">QDBusArgument::currentType()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.dbus.QDBusArgument.ElementType currentType(){
        return io.qt.dbus.QDBusArgument.ElementType.resolve(currentType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int currentType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#endArray">QDBusArgument::endArray()</a></p>
     */
    @io.qt.QtUninvokable
    public final void endArray(){
        endArray_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void endArray_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#endMap">QDBusArgument::endMap()</a></p>
     */
    @io.qt.QtUninvokable
    public final void endMap(){
        endMap_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void endMap_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#endMapEntry">QDBusArgument::endMapEntry()</a></p>
     */
    @io.qt.QtUninvokable
    public final void endMapEntry(){
        endMapEntry_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void endMapEntry_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#endStructure">QDBusArgument::endStructure()</a></p>
     */
    @io.qt.QtUninvokable
    public final void endStructure(){
        endStructure_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void endStructure_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#operator-lt-lt-1">QDBusArgument::operator&lt;&lt;(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final QDBusArgument append(boolean arg){
        append_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), arg);
        return this;
    }
    
    @io.qt.QtUninvokable
    private native QDBusArgument append_native_bool(long __this__nativeId, boolean arg);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#operator-lt-lt-11">QDBusArgument::operator&lt;&lt;(QByteArray)</a></p>
     */
    @io.qt.QtUninvokable
    public final QDBusArgument append(io.qt.core.QByteArray arg){
        append_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg));
        return this;
    }
    
    @io.qt.QtUninvokable
    private native QDBusArgument append_native_cref_QByteArray(long __this__nativeId, long arg);
    
    @io.qt.QtUninvokable
    public final QDBusArgument append(io.qt.dbus.QDBusObjectPath arg){
        append_native_cref_QDBusObjectPath(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg));
        return this;
    }
    
    @io.qt.QtUninvokable
    private native QDBusArgument append_native_cref_QDBusObjectPath(long __this__nativeId, long arg);
    
    @io.qt.QtUninvokable
    public final QDBusArgument append(io.qt.dbus.QDBusSignature arg){
        append_native_cref_QDBusSignature(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg));
        return this;
    }
    
    @io.qt.QtUninvokable
    private native QDBusArgument append_native_cref_QDBusSignature(long __this__nativeId, long arg);
    
    @io.qt.QtUninvokable
    public final QDBusArgument append(io.qt.dbus.QDBusUnixFileDescriptor arg){
        append_native_cref_QDBusUnixFileDescriptor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg));
        return this;
    }
    
    @io.qt.QtUninvokable
    private native QDBusArgument append_native_cref_QDBusUnixFileDescriptor(long __this__nativeId, long arg);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#operator-lt-lt-10">QDBusArgument::operator&lt;&lt;(QDBusVariant)</a></p>
     */
    @io.qt.QtUninvokable
    public final QDBusArgument append(io.qt.dbus.QDBusVariant arg){
        java.util.Objects.requireNonNull(arg, "Argument 'arg': null not expected.");
        append_native_cref_QDBusVariant(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg));
        return this;
    }
    
    @io.qt.QtUninvokable
    private native QDBusArgument append_native_cref_QDBusVariant(long __this__nativeId, long arg);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#operator-lt-lt-9">QDBusArgument::operator&lt;&lt;(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final QDBusArgument append(java.lang.String arg){
        append_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), arg);
        return this;
    }
    
    @io.qt.QtUninvokable
    private native QDBusArgument append_native_cref_QString(long __this__nativeId, java.lang.String arg);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#operator-lt-lt">QDBusArgument::operator&lt;&lt;(QStringList)</a></p>
     */
    @io.qt.QtUninvokable
    public final QDBusArgument append(java.util.Collection<java.lang.String> arg){
        append_native_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), arg);
        return this;
    }
    
    @io.qt.QtUninvokable
    private native QDBusArgument append_native_cref_QStringList(long __this__nativeId, java.util.Collection<java.lang.String> arg);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#operator-lt-lt-8">QDBusArgument::operator&lt;&lt;(double)</a></p>
     */
    @io.qt.QtUninvokable
    public final QDBusArgument append(double arg){
        append_native_double(QtJambi_LibraryUtilities.internal.nativeId(this), arg);
        return this;
    }
    
    @io.qt.QtUninvokable
    private native QDBusArgument append_native_double(long __this__nativeId, double arg);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#operator-lt-lt-4">QDBusArgument::operator&lt;&lt;(int)</a></p>
     */
    @io.qt.QtUninvokable
    public final QDBusArgument append(int arg){
        append_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), arg);
        return this;
    }
    
    @io.qt.QtUninvokable
    private native QDBusArgument append_native_int(long __this__nativeId, int arg);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#operator-lt-lt-6">QDBusArgument::operator&lt;&lt;(qlonglong)</a></p>
     */
    @io.qt.QtUninvokable
    public final QDBusArgument append(long arg){
        append_native_long_long(QtJambi_LibraryUtilities.internal.nativeId(this), arg);
        return this;
    }
    
    @io.qt.QtUninvokable
    private native QDBusArgument append_native_long_long(long __this__nativeId, long arg);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#operator-lt-lt-2">QDBusArgument::operator&lt;&lt;(short)</a></p>
     */
    @io.qt.QtUninvokable
    public final QDBusArgument append(short arg){
        append_native_short(QtJambi_LibraryUtilities.internal.nativeId(this), arg);
        return this;
    }
    
    @io.qt.QtUninvokable
    private native QDBusArgument append_native_short(long __this__nativeId, short arg);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#operator-lt-lt">QDBusArgument::operator&lt;&lt;(uchar)</a></p>
     */
    @io.qt.QtUninvokable
    public final QDBusArgument append(byte arg){
        append_native_unsigned_char(QtJambi_LibraryUtilities.internal.nativeId(this), arg);
        return this;
    }
    
    @io.qt.QtUninvokable
    private native QDBusArgument append_native_unsigned_char(long __this__nativeId, byte arg);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#operator-gt-gt-11">QDBusArgument::operator&gt;&gt;(QByteArray&amp;)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QByteArray extractBytes(){
        return extractBytes_native_ref_QByteArray_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QByteArray extractBytes_native_ref_QByteArray_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final io.qt.dbus.QDBusObjectPath extractObjectPath(){
        return extractObjectPath_native_ref_QDBusObjectPath_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.dbus.QDBusObjectPath extractObjectPath_native_ref_QDBusObjectPath_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final io.qt.dbus.QDBusObjectPath extractSignature(){
        return extractSignature_native_ref_QDBusSignature_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.dbus.QDBusObjectPath extractSignature_native_ref_QDBusSignature_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final io.qt.dbus.QDBusUnixFileDescriptor extractUnixFileDescriptor(){
        return extractUnixFileDescriptor_native_ref_QDBusUnixFileDescriptor_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.dbus.QDBusUnixFileDescriptor extractUnixFileDescriptor_native_ref_QDBusUnixFileDescriptor_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#operator-gt-gt-10">QDBusArgument::operator&gt;&gt;(QDBusVariant&amp;)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.dbus.QDBusVariant extractVariant(){
        return extractVariant_native_ref_QDBusVariant_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.dbus.QDBusVariant extractVariant_native_ref_QDBusVariant_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#operator-gt-gt-9">QDBusArgument::operator&gt;&gt;(QString&amp;)const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String extractString(){
        return extractString_native_ref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String extractString_native_ref_QString_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#operator-gt-gt">QDBusArgument::operator&gt;&gt;(QStringList&amp;)const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.util.List<java.lang.String> extractStrings(){
        return extractStrings_native_ref_QStringList_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.util.List<java.lang.String> extractStrings_native_ref_QStringList_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#operator-gt-gt-1">QDBusArgument::operator&gt;&gt;(bool&amp;)const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean extractBoolean(){
        return extractBoolean_native_ref_bool_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean extractBoolean_native_ref_bool_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#operator-gt-gt-8">QDBusArgument::operator&gt;&gt;(double&amp;)const</a></p>
     */
    @io.qt.QtUninvokable
    public final double extractDouble(){
        return extractDouble_native_ref_double_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double extractDouble_native_ref_double_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#operator-gt-gt-4">QDBusArgument::operator&gt;&gt;(int&amp;)const</a></p>
     */
    @io.qt.QtUninvokable
    public final int extractInt(){
        return extractInt_native_ref_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int extractInt_native_ref_int_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#operator-gt-gt-6">QDBusArgument::operator&gt;&gt;(qlonglong&amp;)const</a></p>
     */
    @io.qt.QtUninvokable
    public final long extractLong(){
        return extractLong_native_ref_long_long_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native long extractLong_native_ref_long_long_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#operator-gt-gt-2">QDBusArgument::operator&gt;&gt;(short&amp;)const</a></p>
     */
    @io.qt.QtUninvokable
    public final short extractShort(){
        return extractShort_native_ref_short_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native short extractShort_native_ref_short_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#operator-gt-gt">QDBusArgument::operator&gt;&gt;(uchar&amp;)const</a></p>
     */
    @io.qt.QtUninvokable
    public final byte extractByte(){
        return extractByte_native_ref_unsigned_char_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native byte extractByte_native_ref_unsigned_char_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusargument.html#swap">QDBusArgument::swap(QDBusArgument&amp;)</a></p>
     */
    @io.qt.QtUninvokable
    public final void swap(io.qt.dbus.QDBusArgument other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QDBusArgument(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native void swap_native_ref_QDBusArgument(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QDBusArgument(QPrivateConstructor p) { super(p); } 
    
    
    @Override
    public QDBusArgument clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private native QDBusArgument clone_native(long __this_nativeId);
}
