package io.qt.dbus;


/**
 * <p>Refers to one pending asynchronous call</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qdbuspendingcall.html">QDBusPendingCall</a></p>
 */
public interface QDBusPendingCall extends io.qt.QtObjectInterface
{
    /**
     * <p>Implementor class for interface {@link io.qt.dbus.QDBusPendingCall}</p>
     */
    public static class Impl extends io.qt.QtObject
        implements io.qt.dbus.QDBusPendingCall,
                java.lang.Cloneable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qdbuspendingcall.html#QDBusPendingCall">QDBusPendingCall::QDBusPendingCall(QDBusPendingCall)</a></p>
         */
        public Impl(io.qt.dbus.QDBusPendingCall other){
            super((QPrivateConstructor)null);
            java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
            initialize_native(this, other);
        }
        
        private native static void initialize_native(QDBusPendingCall instance, io.qt.dbus.QDBusPendingCall other);
        
        @io.qt.QtUninvokable
        public final io.qt.dbus.QDBusError error(){
            return error_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static io.qt.dbus.QDBusError error_native_constfct(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final boolean isError(){
            return isError_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static boolean isError_native_constfct(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final boolean isFinished(){
            return isFinished_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static boolean isFinished_native_constfct(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final boolean isValid(){
            return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static boolean isValid_native_constfct(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final io.qt.dbus.QDBusMessage reply(){
            return reply_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static io.qt.dbus.QDBusMessage reply_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qdbuspendingcall.html#swap">QDBusPendingCall::swap(QDBusPendingCall&amp;)</a></p>
         */
        @io.qt.QtUninvokable
        public final void swap(io.qt.dbus.QDBusPendingCall other){
            java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
            swap_native_ref_QDBusPendingCall(QtJambi_LibraryUtilities.internal.nativeId(this), other);
        }
        
        private native static void swap_native_ref_QDBusPendingCall(long __this__nativeId, io.qt.dbus.QDBusPendingCall other);
        
        @io.qt.QtUninvokable
        public final void waitForFinished(){
            waitForFinished_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static void waitForFinished_native(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qdbuspendingcall.html#fromCompletedCall">QDBusPendingCall::fromCompletedCall(QDBusMessage)</a></p>
         */
        private static io.qt.dbus.QDBusPendingCall fromCompletedCall(io.qt.dbus.QDBusMessage message){
            return fromCompletedCall_native_cref_QDBusMessage(QtJambi_LibraryUtilities.internal.checkedNativeId(message));
        }
        
        private native static io.qt.dbus.QDBusPendingCall fromCompletedCall_native_cref_QDBusMessage(long message);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qdbuspendingcall.html#fromError">QDBusPendingCall::fromError(QDBusError)</a></p>
         */
        private static io.qt.dbus.QDBusPendingCall fromError(io.qt.dbus.QDBusError error){
            return fromError_native_cref_QDBusError(QtJambi_LibraryUtilities.internal.checkedNativeId(error));
        }
        
        private native static io.qt.dbus.QDBusPendingCall fromError_native_cref_QDBusError(long error);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected Impl(QPrivateConstructor p) { super(p); } 
        
        
        @Override
        public Impl clone() {
            return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private native Impl clone_native(long __this_nativeId);
    }

    
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default io.qt.dbus.QDBusError error(){
        return Impl.error_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default boolean isError(){
        return Impl.isError_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default boolean isFinished(){
        return Impl.isFinished_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default boolean isValid(){
        return Impl.isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default io.qt.dbus.QDBusMessage reply(){
        return Impl.reply_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbuspendingcall.html#swap">QDBusPendingCall::swap(QDBusPendingCall&amp;)</a></p>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default void swap(io.qt.dbus.QDBusPendingCall other){
        Impl.swap_native_ref_QDBusPendingCall(QtJambi_LibraryUtilities.internal.nativeId(this), other);
    }
    
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default void waitForFinished(){
        Impl.waitForFinished_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbuspendingcall.html#fromCompletedCall">QDBusPendingCall::fromCompletedCall(QDBusMessage)</a></p>
     */
    public static io.qt.dbus.QDBusPendingCall fromCompletedCall(io.qt.dbus.QDBusMessage message){
        return Impl.fromCompletedCall(message);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbuspendingcall.html#fromError">QDBusPendingCall::fromError(QDBusError)</a></p>
     */
    public static io.qt.dbus.QDBusPendingCall fromError(io.qt.dbus.QDBusError error){
        return Impl.fromError(error);
    }
    
}
