package io.qt.dbus;


/**
 * <p>Holds one Unix file descriptor</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qdbusunixfiledescriptor.html">QDBusUnixFileDescriptor</a></p>
 */
public class QDBusUnixFileDescriptor extends io.qt.QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusunixfiledescriptor.html#QDBusUnixFileDescriptor">QDBusUnixFileDescriptor::QDBusUnixFileDescriptor()</a></p>
     */
    public QDBusUnixFileDescriptor(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QDBusUnixFileDescriptor instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusunixfiledescriptor.html#QDBusUnixFileDescriptor-2">QDBusUnixFileDescriptor::QDBusUnixFileDescriptor(QDBusUnixFileDescriptor)</a></p>
     */
    public QDBusUnixFileDescriptor(io.qt.dbus.QDBusUnixFileDescriptor other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QDBusUnixFileDescriptor instance, io.qt.dbus.QDBusUnixFileDescriptor other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusunixfiledescriptor.html#QDBusUnixFileDescriptor-1">QDBusUnixFileDescriptor::QDBusUnixFileDescriptor(int)</a></p>
     */
    public QDBusUnixFileDescriptor(int fileDescriptor){
        super((QPrivateConstructor)null);
        initialize_native(this, fileDescriptor);
    }
    
    private native static void initialize_native(QDBusUnixFileDescriptor instance, int fileDescriptor);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusunixfiledescriptor.html#fileDescriptor">QDBusUnixFileDescriptor::fileDescriptor()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int fileDescriptor(){
        return fileDescriptor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int fileDescriptor_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void giveFileDescriptor(int fileDescriptor){
        giveFileDescriptor_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), fileDescriptor);
    }
    
    @io.qt.QtUninvokable
    private native void giveFileDescriptor_native_int(long __this__nativeId, int fileDescriptor);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusunixfiledescriptor.html#isValid">QDBusUnixFileDescriptor::isValid()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusunixfiledescriptor.html#setFileDescriptor">QDBusUnixFileDescriptor::setFileDescriptor(int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setFileDescriptor(int fileDescriptor){
        setFileDescriptor_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), fileDescriptor);
    }
    
    @io.qt.QtUninvokable
    private native void setFileDescriptor_native_int(long __this__nativeId, int fileDescriptor);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusunixfiledescriptor.html#swap">QDBusUnixFileDescriptor::swap(QDBusUnixFileDescriptor&amp;)</a></p>
     */
    @io.qt.QtUninvokable
    public final void swap(io.qt.dbus.QDBusUnixFileDescriptor other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QDBusUnixFileDescriptor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native void swap_native_ref_QDBusUnixFileDescriptor(long __this__nativeId, long other);
    
    @io.qt.QtUninvokable
    public final int takeFileDescriptor(){
        return takeFileDescriptor_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int takeFileDescriptor_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdbusunixfiledescriptor.html#isSupported">QDBusUnixFileDescriptor::isSupported()</a></p>
     */
    public native static boolean isSupported();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QDBusUnixFileDescriptor(QPrivateConstructor p) { super(p); } 
    
    
    @Override
    public QDBusUnixFileDescriptor clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private native QDBusUnixFileDescriptor clone_native(long __this_nativeId);
}
