/*
 * Decompiled with CFR 0.152.
 */
package io.qt.dbus;

import io.qt.QtUninvokable;
import io.qt.core.QMetaType;
import io.qt.dbus.QDBusArgument;
import io.qt.dbus.QDBusError;
import io.qt.dbus.QDBusMessage;
import io.qt.dbus.QDBusMetaType;
import io.qt.dbus.QDBusPendingCall;
import io.qt.dbus.QDBusPendingReplyBase;
import io.qt.dbus.QtJambi_LibraryUtilities;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;

public class QDBusPendingReply<A>
extends QDBusPendingReplyBase
implements Cloneable {
    private final QMetaType typeA;
    private boolean hasCalculatedMetaTypes = false;

    public static QDBusPendingReply<Object> newInstance(QDBusMessage message) {
        return new QDBusPendingReply<Object>(message, QMetaType.Type.QVariant);
    }

    public static QDBusPendingReply<Object> newInstance(QDBusPendingCall call) {
        return new QDBusPendingReply<Object>(call, QMetaType.Type.QVariant);
    }

    public static QDBusPendingReply<List<?>> newListInstance(QDBusMessage message) {
        return new QDBusPendingReply(message, QMetaType.Type.QVariantList);
    }

    public static QDBusPendingReply<List<?>> newListInstance(QDBusPendingCall call) {
        return new QDBusPendingReply(call, QMetaType.Type.QVariantList);
    }

    public static QDBusPendingReply<List<String>> newStringListInstance(QDBusMessage message) {
        return new QDBusPendingReply<List<String>>(message, QMetaType.Type.QStringList);
    }

    public static QDBusPendingReply<List<String>> newStringListInstance(QDBusPendingCall call) {
        return new QDBusPendingReply<List<String>>(call, QMetaType.Type.QStringList);
    }

    public static QDBusPendingReply<NavigableMap<String, ?>> newMapInstance(QDBusMessage message) {
        return new QDBusPendingReply(message, QMetaType.Type.QVariantMap);
    }

    public static QDBusPendingReply<NavigableMap<String, ?>> newMapInstance(QDBusPendingCall call) {
        return new QDBusPendingReply(call, QMetaType.Type.QVariantMap);
    }

    public static QDBusPendingReply<Map<String, ?>> newHashInstance(QDBusMessage message) {
        return new QDBusPendingReply(message, QMetaType.Type.QVariantHash);
    }

    public static QDBusPendingReply<Map<String, ?>> newHashInstance(QDBusPendingCall call) {
        return new QDBusPendingReply(call, QMetaType.Type.QVariantHash);
    }

    public QDBusPendingReply() {
        this.typeA = new QMetaType();
        this.assign(QDBusPendingCall.fromError(new QDBusError()));
    }

    private QDBusPendingReply(QDBusMessage message, QMetaType.Type variantTypeA) {
        this.typeA = new QMetaType(variantTypeA);
        this.assign(QDBusPendingCall.fromCompletedCall(message));
    }

    private QDBusPendingReply(QDBusPendingCall call, QMetaType.Type variantTypeA) {
        this.typeA = new QMetaType(variantTypeA);
        this.assign(call);
    }

    public QDBusPendingReply(QDBusMessage message, Class<A> typeA, QMetaType ... instantiations) {
        this.typeA = QMetaType.fromType(typeA, (QMetaType[])instantiations);
        this.assign(QDBusPendingCall.fromCompletedCall(message));
    }

    public QDBusPendingReply(QDBusPendingCall call, Class<A> typeA, QMetaType ... instantiations) {
        this.typeA = QMetaType.fromType(typeA, (QMetaType[])instantiations);
        this.assign(call);
    }

    public QDBusPendingReply(QDBusPendingReply<A> other) {
        this.typeA = other.typeA;
        this.assign(other);
    }

    private void calculateMetaTypes() {
        if (!this.hasCalculatedMetaTypes) {
            this.hasCalculatedMetaTypes = true;
            QMetaType[] metaTypes = new QMetaType[this.numberOfArguments()];
            this.fillMetaTypes(metaTypes);
            for (int i = 0; i < metaTypes.length; ++i) {
                if (metaTypes[i] == null) {
                    throw new NullPointerException("QDBusPendingReply: meta type is null.");
                }
                if (!metaTypes[i].isValid()) {
                    throw new RuntimeException("QDBusPendingReply: meta type is unknown.");
                }
                String signature = QDBusMetaType.typeToSignature(metaTypes[i]);
                if (signature != null && !signature.isEmpty()) continue;
                throw new RuntimeException("QDBusPendingReply: type " + metaTypes[i].name() + " is not registered with QtDBus");
            }
            this.setMetaTypes(metaTypes);
        }
    }

    void fillMetaTypes(QMetaType[] metaTypes) {
        metaTypes[0] = this.typeA;
    }

    public QDBusPendingReply<A> clone() {
        return new QDBusPendingReply<A>(this);
    }

    @QtUninvokable
    public final int count() {
        return this.isInvalid() ? 0 : this.numberOfArguments();
    }

    boolean isInvalid() {
        return this.typeA == null || !this.typeA.isValid();
    }

    int numberOfArguments() {
        return 1;
    }

    @QtUninvokable
    final <R> R argumentAt(QMetaType type, int index) {
        if (index < 0 || index >= this.numberOfArguments()) {
            throw new IndexOutOfBoundsException("Index out of range: " + index);
        }
        if (this.isInvalid()) {
            throw new RuntimeException("Invalid QDBusPendingReply");
        }
        this.calculateMetaTypes();
        Object result = this.argumentAt(index);
        if (result instanceof QDBusArgument) {
            QDBusArgument argument = (QDBusArgument)result;
            result = QDBusMetaType.demarshall(argument, type);
        }
        return (R)result;
    }

    @QtUninvokable
    public final A argumentAt0() {
        return (A)this.argumentAt(this.typeA, 0);
    }

    @QtUninvokable
    public final A value() {
        return this.argumentAt0();
    }

    static {
        QtJambi_LibraryUtilities.initialize();
    }
}

