package io.qt.dbus;


/**
 * <p>Peer-to-peer communication between processes on the same computer</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qdbusserver.html">QDBusServer</a></p>
 */
public class QDBusServer extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QDBusServer.class);
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusserver.html#newConnection">QDBusServer::newConnection(QDBusConnection)</a></p>
     */
    public final Signal1<io.qt.dbus.QDBusConnection> newConnection = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QDBusServer(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QDBusServer() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusserver.html#QDBusServer-1">QDBusServer::QDBusServer(QObject*)</a></p>
     */
    public QDBusServer(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QDBusServer instance, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QDBusServer(java.lang.String, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QDBusServer(java.lang.String address) {
        this(address, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusserver.html#QDBusServer">QDBusServer::QDBusServer(QString,QObject*)</a></p>
     */
    public QDBusServer(java.lang.String address, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, address, parent);
    }
    
    private native static void initialize_native(QDBusServer instance, java.lang.String address, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusserver.html#address">QDBusServer::address()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String address(){
        return address_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String address_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusserver.html#isAnonymousAuthenticationAllowed">QDBusServer::isAnonymousAuthenticationAllowed()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isAnonymousAuthenticationAllowed(){
        return isAnonymousAuthenticationAllowed_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isAnonymousAuthenticationAllowed_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusserver.html#isConnected">QDBusServer::isConnected()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isConnected(){
        return isConnected_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isConnected_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusserver.html#lastError">QDBusServer::lastError()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.dbus.QDBusError lastError(){
        return lastError_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.dbus.QDBusError lastError_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusserver.html#setAnonymousAuthenticationAllowed">QDBusServer::setAnonymousAuthenticationAllowed(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setAnonymousAuthenticationAllowed(boolean value){
        setAnonymousAuthenticationAllowed_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @io.qt.QtUninvokable
    private native void setAnonymousAuthenticationAllowed_native_bool(long __this__nativeId, boolean value);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QDBusServer(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QDBusServer(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QDBusServer instance, QDeclarativeConstructor constructor);
    
}
