package io.qt.dbus;


/**
 * <p>Access to the D-Bus bus daemon service</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qdbusconnectioninterface.html">QDBusConnectionInterface</a></p>
 */
public final class QDBusConnectionInterface extends io.qt.dbus.QDBusAbstractInterface
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QDBusConnectionInterface.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qdbusconnectioninterface.html#RegisterServiceReply-enum">QDBusConnectionInterface::RegisterServiceReply</a></p>
     */
    public enum RegisterServiceReply implements io.qt.QtEnumerator {
        ServiceNotRegistered(0),
        ServiceRegistered(1),
        ServiceQueued(2);

        private RegisterServiceReply(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static RegisterServiceReply resolve(int value) {
            switch (value) {
            case 0: return ServiceNotRegistered;
            case 1: return ServiceRegistered;
            case 2: return ServiceQueued;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qdbusconnectioninterface.html#ServiceQueueOptions-enum">QDBusConnectionInterface::ServiceQueueOptions</a></p>
     */
    public enum ServiceQueueOptions implements io.qt.QtEnumerator {
        DontQueueService(0),
        QueueService(1),
        ReplaceExistingService(2);

        private ServiceQueueOptions(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ServiceQueueOptions resolve(int value) {
            switch (value) {
            case 0: return DontQueueService;
            case 1: return QueueService;
            case 2: return ReplaceExistingService;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qdbusconnectioninterface.html#ServiceReplacementOptions-enum">QDBusConnectionInterface::ServiceReplacementOptions</a></p>
     */
    public enum ServiceReplacementOptions implements io.qt.QtEnumerator {
        DontAllowReplacement(0),
        AllowReplacement(1);

        private ServiceReplacementOptions(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ServiceReplacementOptions resolve(int value) {
            switch (value) {
            case 0: return DontAllowReplacement;
            case 1: return AllowReplacement;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    public final Signal1<java.lang.String> NameAcquired = new Signal1<>();

    public final Signal1<java.lang.String> NameLost = new Signal1<>();

    public final Signal3<java.lang.String, java.lang.String, java.lang.String> NameOwnerChanged = new Signal3<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnectioninterface.html#callWithCallbackFailed">QDBusConnectionInterface::callWithCallbackFailed(QDBusError,QDBusMessage)</a></p>
     */
    public final Signal2<io.qt.dbus.QDBusError, io.qt.dbus.QDBusMessage> callWithCallbackFailed = new Signal2<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnectioninterface-obsolete.html#serviceOwnerChanged">QDBusConnectionInterface::serviceOwnerChanged(QString,QString,QString)</a></p>
     */
    public final Signal3<java.lang.String, java.lang.String, java.lang.String> serviceOwnerChanged = new Signal3<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnectioninterface.html#serviceRegistered">QDBusConnectionInterface::serviceRegistered(QString)</a></p>
     */
    public final Signal1<java.lang.String> serviceRegistered = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnectioninterface.html#serviceUnregistered">QDBusConnectionInterface::serviceUnregistered(QString)</a></p>
     */
    public final Signal1<java.lang.String> serviceUnregistered = new Signal1<>();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnectioninterface.html#activatableServiceNames-prop">QDBusConnectionInterface::activatableServiceNames()const</a></p>
     */
    @io.qt.QtPropertyReader(name="activatableServiceNames")
    public final io.qt.dbus.QDBusReply<java.util.List<java.lang.String>> activatableServiceNames(){
        return activatableServiceNames_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native io.qt.dbus.QDBusReply<java.util.List<java.lang.String>> activatableServiceNames_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnectioninterface.html#isServiceRegistered">QDBusConnectionInterface::isServiceRegistered(QString)const</a></p>
     */
    public final io.qt.dbus.QDBusReply<java.lang.Boolean> isServiceRegistered(java.lang.String serviceName){
        return isServiceRegistered_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), serviceName);
    }
    
    private native io.qt.dbus.QDBusReply<java.lang.Boolean> isServiceRegistered_native_cref_QString_constfct(long __this__nativeId, java.lang.String serviceName);
    
    /**
     * <p>Overloaded function for {@link #registerService(java.lang.String, io.qt.dbus.QDBusConnectionInterface.ServiceQueueOptions, io.qt.dbus.QDBusConnectionInterface.ServiceReplacementOptions)}
     *  with <code>roption = io.qt.dbus.QDBusConnectionInterface.ServiceReplacementOptions.DontAllowReplacement</code>.</p>
     */
    public final io.qt.dbus.QDBusReply<io.qt.dbus.QDBusConnectionInterface.RegisterServiceReply> registerService(java.lang.String serviceName, io.qt.dbus.QDBusConnectionInterface.ServiceQueueOptions qoption) {
        return registerService(serviceName, qoption, io.qt.dbus.QDBusConnectionInterface.ServiceReplacementOptions.DontAllowReplacement);
    }
    
    /**
     * <p>Overloaded function for {@link #registerService(java.lang.String, io.qt.dbus.QDBusConnectionInterface.ServiceQueueOptions, io.qt.dbus.QDBusConnectionInterface.ServiceReplacementOptions)}</p>
     * <p>with: </p><ul>
     * <li><code>qoption = io.qt.dbus.QDBusConnectionInterface.ServiceQueueOptions.DontQueueService</code></li>
     * <li><code>roption = io.qt.dbus.QDBusConnectionInterface.ServiceReplacementOptions.DontAllowReplacement</code></li>
     * </ul>
     */
    public final io.qt.dbus.QDBusReply<io.qt.dbus.QDBusConnectionInterface.RegisterServiceReply> registerService(java.lang.String serviceName) {
        return registerService(serviceName, io.qt.dbus.QDBusConnectionInterface.ServiceQueueOptions.DontQueueService, io.qt.dbus.QDBusConnectionInterface.ServiceReplacementOptions.DontAllowReplacement);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnectioninterface.html#registerService">QDBusConnectionInterface::registerService(QString,QDBusConnectionInterface::ServiceQueueOptions,QDBusConnectionInterface::ServiceReplacementOptions)</a></p>
     */
    public final io.qt.dbus.QDBusReply<io.qt.dbus.QDBusConnectionInterface.RegisterServiceReply> registerService(java.lang.String serviceName, io.qt.dbus.QDBusConnectionInterface.ServiceQueueOptions qoption, io.qt.dbus.QDBusConnectionInterface.ServiceReplacementOptions roption){
        return registerService_native_cref_QString_QDBusConnectionInterface_ServiceQueueOptions_QDBusConnectionInterface_ServiceReplacementOptions(QtJambi_LibraryUtilities.internal.nativeId(this), serviceName, qoption.value(), roption.value());
    }
    
    private native io.qt.dbus.QDBusReply<io.qt.dbus.QDBusConnectionInterface.RegisterServiceReply> registerService_native_cref_QString_QDBusConnectionInterface_ServiceQueueOptions_QDBusConnectionInterface_ServiceReplacementOptions(long __this__nativeId, java.lang.String serviceName, int qoption, int roption);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnectioninterface.html#registeredServiceNames-prop">QDBusConnectionInterface::registeredServiceNames()const</a></p>
     */
    @io.qt.QtPropertyReader(name="registeredServiceNames")
    public final io.qt.dbus.QDBusReply<java.util.List<java.lang.String>> registeredServiceNames(){
        return registeredServiceNames_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native io.qt.dbus.QDBusReply<java.util.List<java.lang.String>> registeredServiceNames_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnectioninterface.html#serviceOwner">QDBusConnectionInterface::serviceOwner(QString)const</a></p>
     */
    public final io.qt.dbus.QDBusReply<java.lang.String> serviceOwner(java.lang.String name){
        return serviceOwner_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    private native io.qt.dbus.QDBusReply<java.lang.String> serviceOwner_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnectioninterface.html#servicePid">QDBusConnectionInterface::servicePid(QString)const</a></p>
     */
    public final io.qt.dbus.QDBusReply<java.lang.Integer> servicePid(java.lang.String serviceName){
        return servicePid_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), serviceName);
    }
    
    private native io.qt.dbus.QDBusReply<java.lang.Integer> servicePid_native_cref_QString_constfct(long __this__nativeId, java.lang.String serviceName);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnectioninterface.html#serviceUid">QDBusConnectionInterface::serviceUid(QString)const</a></p>
     */
    public final io.qt.dbus.QDBusReply<java.lang.Integer> serviceUid(java.lang.String serviceName){
        return serviceUid_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), serviceName);
    }
    
    private native io.qt.dbus.QDBusReply<java.lang.Integer> serviceUid_native_cref_QString_constfct(long __this__nativeId, java.lang.String serviceName);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnectioninterface.html#startService">QDBusConnectionInterface::startService(QString)</a></p>
     */
    public final io.qt.dbus.QDBusReply<java.lang.Void> startService(java.lang.String name){
        return startService_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    private native io.qt.dbus.QDBusReply<java.lang.Void> startService_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnectioninterface.html#unregisterService">QDBusConnectionInterface::unregisterService(QString)</a></p>
     */
    public final io.qt.dbus.QDBusReply<java.lang.Boolean> unregisterService(java.lang.String serviceName){
        return unregisterService_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), serviceName);
    }
    
    private native io.qt.dbus.QDBusReply<java.lang.Boolean> unregisterService_native_cref_QString(long __this__nativeId, java.lang.String serviceName);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QDBusConnectionInterface(QPrivateConstructor p) { super(p); } 
    
}
