package io.qt.dbus;


/**
 * <p>Represents a connection to the D-Bus bus daemon</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qdbusconnection.html">QDBusConnection</a></p>
 */
public class QDBusConnection extends io.qt.QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QDBusConnection.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qdbusconnection.html#BusType-enum">QDBusConnection::BusType</a></p>
     */
    public enum BusType implements io.qt.QtEnumerator {
        SessionBus(0),
        SystemBus(1),
        ActivationBus(2);

        private BusType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static BusType resolve(int value) {
            switch (value) {
            case 0: return SessionBus;
            case 1: return SystemBus;
            case 2: return ActivationBus;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qdbusconnection.html#ConnectionCapability-enum">QDBusConnection::ConnectionCapability</a></p>
     * 
     * @see ConnectionCapabilities
     */
    public enum ConnectionCapability implements io.qt.QtFlagEnumerator {
        UnixFileDescriptorPassing(1);

        private ConnectionCapability(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public ConnectionCapabilities asFlags() {
            return new ConnectionCapabilities(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public ConnectionCapabilities combined(ConnectionCapability e) {
            return new ConnectionCapabilities(this, e);
        }

        /**
         * Creates a new {@link ConnectionCapabilities} from the entries.
         * @param values entries
         * @return new flag
         */
        public static ConnectionCapabilities flags(ConnectionCapability ... values) {
            return new ConnectionCapabilities(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ConnectionCapability resolve(int value) {
            switch (value) {
            case 1: return UnixFileDescriptorPassing;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link ConnectionCapability}
     */
    public static final class ConnectionCapabilities extends io.qt.QFlags<ConnectionCapability> implements Comparable<ConnectionCapabilities> {
        private static final long serialVersionUID = 0x1c0381e5cdcd7f5L;

        /**
         * Creates a new ConnectionCapabilities where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public ConnectionCapabilities(ConnectionCapability ... args){
            super(args);
        }

        /**
         * Creates a new ConnectionCapabilities with given <code>value</code>.
         * @param value
         */
        public ConnectionCapabilities(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new ConnectionCapabilities
         */
        @Override
        public final ConnectionCapabilities combined(ConnectionCapability e){
            return new ConnectionCapabilities(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final ConnectionCapabilities setFlag(ConnectionCapability e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final ConnectionCapabilities setFlag(ConnectionCapability e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this ConnectionCapabilities.
         * @return array of enum entries
         */
        @Override
        public final ConnectionCapability[] flags(){
            return super.flags(ConnectionCapability.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final ConnectionCapabilities clone(){
            return new ConnectionCapabilities(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(ConnectionCapabilities other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qdbusconnection.html#RegisterOption-enum">QDBusConnection::RegisterOption</a></p>
     * 
     * @see RegisterOptions
     */
    @io.qt.QtRejectedEntries({"ExportAllSignal"})
    public enum RegisterOption implements io.qt.QtFlagEnumerator {
        ExportAdaptors(1),
        ExportScriptableSlots(16),
        ExportScriptableSignals(32),
        ExportScriptableProperties(64),
        ExportScriptableInvokables(128),
        ExportScriptableContents(240),
        ExportNonScriptableSlots(256),
        ExportNonScriptableSignals(512),
        ExportNonScriptableProperties(1024),
        ExportNonScriptableInvokables(2048),
        ExportNonScriptableContents(3840),
        ExportAllSlots(272),
        ExportAllSignals(544),
        ExportAllProperties(1088),
        ExportAllInvokables(2176),
        ExportAllContents(4080),
        ExportAllSignal(544),
        ExportChildObjects(4096);

        private RegisterOption(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public RegisterOptions asFlags() {
            return new RegisterOptions(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public RegisterOptions combined(RegisterOption e) {
            return new RegisterOptions(this, e);
        }

        /**
         * Creates a new {@link RegisterOptions} from the entries.
         * @param values entries
         * @return new flag
         */
        public static RegisterOptions flags(RegisterOption ... values) {
            return new RegisterOptions(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static RegisterOption resolve(int value) {
            switch (value) {
            case 1: return ExportAdaptors;
            case 16: return ExportScriptableSlots;
            case 32: return ExportScriptableSignals;
            case 64: return ExportScriptableProperties;
            case 128: return ExportScriptableInvokables;
            case 240: return ExportScriptableContents;
            case 256: return ExportNonScriptableSlots;
            case 512: return ExportNonScriptableSignals;
            case 1024: return ExportNonScriptableProperties;
            case 2048: return ExportNonScriptableInvokables;
            case 3840: return ExportNonScriptableContents;
            case 272: return ExportAllSlots;
            case 544: return ExportAllSignals;
            case 1088: return ExportAllProperties;
            case 2176: return ExportAllInvokables;
            case 4080: return ExportAllContents;
            case 4096: return ExportChildObjects;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link RegisterOption}
     */
    public static final class RegisterOptions extends io.qt.QFlags<RegisterOption> implements Comparable<RegisterOptions> {
        private static final long serialVersionUID = 0xcf9fb21866980eebL;

        /**
         * Creates a new RegisterOptions where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public RegisterOptions(RegisterOption ... args){
            super(args);
        }

        /**
         * Creates a new RegisterOptions with given <code>value</code>.
         * @param value
         */
        public RegisterOptions(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new RegisterOptions
         */
        @Override
        public final RegisterOptions combined(RegisterOption e){
            return new RegisterOptions(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final RegisterOptions setFlag(RegisterOption e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final RegisterOptions setFlag(RegisterOption e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this RegisterOptions.
         * @return array of enum entries
         */
        @Override
        public final RegisterOption[] flags(){
            return super.flags(RegisterOption.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final RegisterOptions clone(){
            return new RegisterOptions(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(RegisterOptions other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qdbusconnection.html#UnregisterMode-enum">QDBusConnection::UnregisterMode</a></p>
     */
    public enum UnregisterMode implements io.qt.QtEnumerator {
        UnregisterNode(0),
        UnregisterTree(1);

        private UnregisterMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static UnregisterMode resolve(int value) {
            switch (value) {
            case 0: return UnregisterNode;
            case 1: return UnregisterTree;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum QDBusConnection::VirtualObjectRegisterOption</p>
     */
    public enum VirtualObjectRegisterOption implements io.qt.QtEnumerator {
        SingleNode(0),
        SubPath(1);

        private VirtualObjectRegisterOption(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static VirtualObjectRegisterOption resolve(int value) {
            switch (value) {
            case 0: return SingleNode;
            case 1: return SubPath;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnection.html#QDBusConnection-1">QDBusConnection::QDBusConnection(QDBusConnection)</a></p>
     */
    public QDBusConnection(io.qt.dbus.QDBusConnection other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QDBusConnection instance, io.qt.dbus.QDBusConnection other);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnection.html#QDBusConnection">QDBusConnection::QDBusConnection(QString)</a></p>
     */
    public QDBusConnection(java.lang.String name){
        super((QPrivateConstructor)null);
        initialize_native(this, name);
    }
    
    private native static void initialize_native(QDBusConnection instance, java.lang.String name);
    
    /**
     * <p>Overloaded function for {@link #asyncCall(io.qt.dbus.QDBusMessage, int)}
     *  with <code>timeout = -1</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.dbus.QDBusPendingCall asyncCall(io.qt.dbus.QDBusMessage message) {
        return asyncCall(message, (int)-1);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnection.html#asyncCall">QDBusConnection::asyncCall(QDBusMessage,int)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.dbus.QDBusPendingCall asyncCall(io.qt.dbus.QDBusMessage message, int timeout){
        return asyncCall_native_cref_QDBusMessage_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(message), timeout);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.dbus.QDBusPendingCall asyncCall_native_cref_QDBusMessage_int_constfct(long __this__nativeId, long message, int timeout);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnection.html#baseService">QDBusConnection::baseService()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String baseService(){
        return baseService_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String baseService_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #call(io.qt.dbus.QDBusMessage, io.qt.dbus.QDBus.CallMode, int)}
     *  with <code>timeout = -1</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.dbus.QDBusMessage call(io.qt.dbus.QDBusMessage message, io.qt.dbus.QDBus.CallMode mode) {
        return call(message, mode, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #call(io.qt.dbus.QDBusMessage, io.qt.dbus.QDBus.CallMode, int)}</p>
     * <p>with: </p><ul>
     * <li><code>mode = io.qt.dbus.QDBus.CallMode.Block</code></li>
     * <li><code>timeout = -1</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final io.qt.dbus.QDBusMessage call(io.qt.dbus.QDBusMessage message) {
        return call(message, io.qt.dbus.QDBus.CallMode.Block, (int)-1);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnection.html#call">QDBusConnection::call(QDBusMessage,QDBus::CallMode,int)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.dbus.QDBusMessage call(io.qt.dbus.QDBusMessage message, io.qt.dbus.QDBus.CallMode mode, int timeout){
        return call_native_cref_QDBusMessage_QDBus_CallMode_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(message), mode.value(), timeout);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.dbus.QDBusMessage call_native_cref_QDBusMessage_QDBus_CallMode_int_constfct(long __this__nativeId, long message, int mode, int timeout);
    
    /**
     * <p>Overloaded function for {@link #callWithCallback(io.qt.dbus.QDBusMessage, io.qt.core.QObject, java.lang.String, java.lang.String, int)}
     *  with <code>timeout = -1</code>.</p>
     */
    @io.qt.QtUninvokable
    public final boolean callWithCallback(io.qt.dbus.QDBusMessage message, io.qt.core.QObject receiver, java.lang.String returnMethod, java.lang.String errorMethod) {
        return callWithCallback(message, receiver, returnMethod, errorMethod, (int)-1);
    }
    
    @io.qt.QtUninvokable
    public final boolean callWithCallback(io.qt.dbus.QDBusMessage message, io.qt.core.QObject receiver, java.lang.String returnMethod, java.lang.String errorMethod, int timeout){
        if(returnMethod!=null && !returnMethod.startsWith("1") && !returnMethod.startsWith("2")) {
                            io.qt.core.QMetaMethod method = receiver.metaObject().method(returnMethod);
                            if(method!=null && method.isValid()) {
                                if(method.methodType()==io.qt.core.QMetaMethod.MethodType.Signal)
                                    returnMethod = "2" + method.cppMethodSignature();
                                else
                                    returnMethod = "1" + method.cppMethodSignature();
                            }
                        }
                        if(errorMethod!=null && !errorMethod.startsWith("1") && !errorMethod.startsWith("2")) {
                            io.qt.core.QMetaMethod method = receiver.metaObject().method(errorMethod);
                            if(method!=null && method.isValid()) {
                                if(method.methodType()==io.qt.core.QMetaMethod.MethodType.Signal)
                                    errorMethod = "2" + method.cppMethodSignature();
                                else
                                    errorMethod = "1" + method.cppMethodSignature();
                            }
                        }
        return callWithCallback_native_cref_QDBusMessage_QObject_ptr_const_char_ptr_const_char_ptr_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(message), QtJambi_LibraryUtilities.internal.checkedNativeId(receiver), returnMethod, errorMethod, timeout);
    }
    
    @io.qt.QtUninvokable
    private native boolean callWithCallback_native_cref_QDBusMessage_QObject_ptr_const_char_ptr_const_char_ptr_int_constfct(long __this__nativeId, long message, long receiver, java.lang.String returnMethod, java.lang.String errorMethod, int timeout);
    
    /**
     * <p>Overloaded function for {@link #callWithCallback(io.qt.dbus.QDBusMessage, io.qt.core.QObject, java.lang.String, int)}
     *  with <code>timeout = -1</code>.</p>
     */
    @io.qt.QtUninvokable
    public final boolean callWithCallback(io.qt.dbus.QDBusMessage message, io.qt.core.QObject receiver, java.lang.String slot) {
        return callWithCallback(message, receiver, slot, (int)-1);
    }
    
    @io.qt.QtUninvokable
    public final boolean callWithCallback(io.qt.dbus.QDBusMessage message, io.qt.core.QObject receiver, java.lang.String slot, int timeout){
        if(slot!=null && !slot.startsWith("1") && !slot.startsWith("2")) {
                            io.qt.core.QMetaMethod method = receiver.metaObject().method(slot);
                            if(method!=null && method.isValid()) {
                                if(method.methodType()==io.qt.core.QMetaMethod.MethodType.Signal)
                                    slot = "2" + method.cppMethodSignature();
                                else
                                    slot = "1" + method.cppMethodSignature();
                            }
                        }
        return callWithCallback_native_cref_QDBusMessage_QObject_ptr_const_char_ptr_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(message), QtJambi_LibraryUtilities.internal.checkedNativeId(receiver), slot, timeout);
    }
    
    @io.qt.QtUninvokable
    private native boolean callWithCallback_native_cref_QDBusMessage_QObject_ptr_const_char_ptr_int_constfct(long __this__nativeId, long message, long receiver, java.lang.String slot, int timeout);
    
    @io.qt.QtUninvokable
    public final boolean connect(java.lang.String service, java.lang.String path, java.lang.String arg__interface, java.lang.String name, io.qt.core.QObject receiver, java.lang.String slot){
        if(slot!=null && !slot.startsWith("1") && !slot.startsWith("2")) {
                            io.qt.core.QMetaMethod method = receiver.metaObject().method(slot);
                            if(method!=null && method.isValid()) {
                                if(method.methodType()==io.qt.core.QMetaMethod.MethodType.Signal)
                                    slot = "2" + method.cppMethodSignature();
                                else
                                    slot = "1" + method.cppMethodSignature();
                            }
                        }
        return connect_native_cref_QString_cref_QString_cref_QString_cref_QString_QObject_ptr_const_char_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), service, path, arg__interface, name, QtJambi_LibraryUtilities.internal.checkedNativeId(receiver), slot);
    }
    
    @io.qt.QtUninvokable
    private native boolean connect_native_cref_QString_cref_QString_cref_QString_cref_QString_QObject_ptr_const_char_ptr(long __this__nativeId, java.lang.String service, java.lang.String path, java.lang.String arg__interface, java.lang.String name, long receiver, java.lang.String slot);
    
    @io.qt.QtUninvokable
    public final boolean connect(java.lang.String service, java.lang.String path, java.lang.String arg__interface, java.lang.String name, java.lang.String signature, io.qt.core.QObject receiver, java.lang.String slot){
        if(slot!=null && !slot.startsWith("1") && !slot.startsWith("2")) {
                            io.qt.core.QMetaMethod method = receiver.metaObject().method(slot);
                            if(method!=null && method.isValid()) {
                                if(method.methodType()==io.qt.core.QMetaMethod.MethodType.Signal)
                                    slot = "2" + method.cppMethodSignature();
                                else
                                    slot = "1" + method.cppMethodSignature();
                            }
                        }
        return connect_native_cref_QString_cref_QString_cref_QString_cref_QString_cref_QString_QObject_ptr_const_char_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), service, path, arg__interface, name, signature, QtJambi_LibraryUtilities.internal.checkedNativeId(receiver), slot);
    }
    
    @io.qt.QtUninvokable
    private native boolean connect_native_cref_QString_cref_QString_cref_QString_cref_QString_cref_QString_QObject_ptr_const_char_ptr(long __this__nativeId, java.lang.String service, java.lang.String path, java.lang.String arg__interface, java.lang.String name, java.lang.String signature, long receiver, java.lang.String slot);
    
    @io.qt.QtUninvokable
    public final boolean connect(java.lang.String service, java.lang.String path, java.lang.String arg__interface, java.lang.String name, java.util.Collection<java.lang.String> argumentMatch, java.lang.String signature, io.qt.core.QObject receiver, java.lang.String slot){
        if(slot!=null && !slot.startsWith("1") && !slot.startsWith("2")) {
                            io.qt.core.QMetaMethod method = receiver.metaObject().method(slot);
                            if(method!=null && method.isValid()) {
                                if(method.methodType()==io.qt.core.QMetaMethod.MethodType.Signal)
                                    slot = "2" + method.cppMethodSignature();
                                else
                                    slot = "1" + method.cppMethodSignature();
                            }
                        }
        return connect_native_cref_QString_cref_QString_cref_QString_cref_QString_cref_QStringList_cref_QString_QObject_ptr_const_char_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), service, path, arg__interface, name, argumentMatch, signature, QtJambi_LibraryUtilities.internal.checkedNativeId(receiver), slot);
    }
    
    @io.qt.QtUninvokable
    private native boolean connect_native_cref_QString_cref_QString_cref_QString_cref_QString_cref_QStringList_cref_QString_QObject_ptr_const_char_ptr(long __this__nativeId, java.lang.String service, java.lang.String path, java.lang.String arg__interface, java.lang.String name, java.util.Collection<java.lang.String> argumentMatch, java.lang.String signature, long receiver, java.lang.String slot);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnection.html#connectionCapabilities">QDBusConnection::connectionCapabilities()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.dbus.QDBusConnection.ConnectionCapabilities connectionCapabilities(){
        return new io.qt.dbus.QDBusConnection.ConnectionCapabilities(connectionCapabilities_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int connectionCapabilities_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final boolean disconnect(java.lang.String service, java.lang.String path, java.lang.String arg__interface, java.lang.String name, io.qt.core.QObject receiver, java.lang.String slot){
        if(slot!=null && !slot.startsWith("1") && !slot.startsWith("2")) {
                            io.qt.core.QMetaMethod method = receiver.metaObject().method(slot);
                            if(method!=null && method.isValid()) {
                                if(method.methodType()==io.qt.core.QMetaMethod.MethodType.Signal)
                                    slot = "2" + method.cppMethodSignature();
                                else
                                    slot = "1" + method.cppMethodSignature();
                            }
                        }
        return disconnect_native_cref_QString_cref_QString_cref_QString_cref_QString_QObject_ptr_const_char_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), service, path, arg__interface, name, QtJambi_LibraryUtilities.internal.checkedNativeId(receiver), slot);
    }
    
    @io.qt.QtUninvokable
    private native boolean disconnect_native_cref_QString_cref_QString_cref_QString_cref_QString_QObject_ptr_const_char_ptr(long __this__nativeId, java.lang.String service, java.lang.String path, java.lang.String arg__interface, java.lang.String name, long receiver, java.lang.String slot);
    
    @io.qt.QtUninvokable
    public final boolean disconnect(java.lang.String service, java.lang.String path, java.lang.String arg__interface, java.lang.String name, java.lang.String signature, io.qt.core.QObject receiver, java.lang.String slot){
        if(slot!=null && !slot.startsWith("1") && !slot.startsWith("2")) {
                            io.qt.core.QMetaMethod method = receiver.metaObject().method(slot);
                            if(method!=null && method.isValid()) {
                                if(method.methodType()==io.qt.core.QMetaMethod.MethodType.Signal)
                                    slot = "2" + method.cppMethodSignature();
                                else
                                    slot = "1" + method.cppMethodSignature();
                            }
                        }
        return disconnect_native_cref_QString_cref_QString_cref_QString_cref_QString_cref_QString_QObject_ptr_const_char_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), service, path, arg__interface, name, signature, QtJambi_LibraryUtilities.internal.checkedNativeId(receiver), slot);
    }
    
    @io.qt.QtUninvokable
    private native boolean disconnect_native_cref_QString_cref_QString_cref_QString_cref_QString_cref_QString_QObject_ptr_const_char_ptr(long __this__nativeId, java.lang.String service, java.lang.String path, java.lang.String arg__interface, java.lang.String name, java.lang.String signature, long receiver, java.lang.String slot);
    
    @io.qt.QtUninvokable
    public final boolean disconnect(java.lang.String service, java.lang.String path, java.lang.String arg__interface, java.lang.String name, java.util.Collection<java.lang.String> argumentMatch, java.lang.String signature, io.qt.core.QObject receiver, java.lang.String slot){
        if(slot!=null && !slot.startsWith("1") && !slot.startsWith("2")) {
                            io.qt.core.QMetaMethod method = receiver.metaObject().method(slot);
                            if(method!=null && method.isValid()) {
                                if(method.methodType()==io.qt.core.QMetaMethod.MethodType.Signal)
                                    slot = "2" + method.cppMethodSignature();
                                else
                                    slot = "1" + method.cppMethodSignature();
                            }
                        }
        return disconnect_native_cref_QString_cref_QString_cref_QString_cref_QString_cref_QStringList_cref_QString_QObject_ptr_const_char_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), service, path, arg__interface, name, argumentMatch, signature, QtJambi_LibraryUtilities.internal.checkedNativeId(receiver), slot);
    }
    
    @io.qt.QtUninvokable
    private native boolean disconnect_native_cref_QString_cref_QString_cref_QString_cref_QString_cref_QStringList_cref_QString_QObject_ptr_const_char_ptr(long __this__nativeId, java.lang.String service, java.lang.String path, java.lang.String arg__interface, java.lang.String name, java.util.Collection<java.lang.String> argumentMatch, java.lang.String signature, long receiver, java.lang.String slot);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnection.html#interface">QDBusConnection::interface()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.dbus.QDBusConnectionInterface connectionInterface(){
        return connectionInterface_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.dbus.QDBusConnectionInterface connectionInterface_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnection.html#isConnected">QDBusConnection::isConnected()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isConnected(){
        return isConnected_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isConnected_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnection.html#lastError">QDBusConnection::lastError()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.dbus.QDBusError lastError(){
        return lastError_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.dbus.QDBusError lastError_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnection.html#name">QDBusConnection::name()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String name(){
        return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String name_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnection.html#objectRegisteredAt">QDBusConnection::objectRegisteredAt(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QObject objectRegisteredAt(java.lang.String path){
        return objectRegisteredAt_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), path);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QObject objectRegisteredAt_native_cref_QString_constfct(long __this__nativeId, java.lang.String path);
    
    /**
     * <p>Overloaded function for {@link #registerObject(java.lang.String, io.qt.core.QObject, io.qt.dbus.QDBusConnection.RegisterOptions)}.</p>
     */
    @io.qt.QtUninvokable
    public final boolean registerObject(java.lang.String path, io.qt.core.QObject object, io.qt.dbus.QDBusConnection.RegisterOption ... options){
        return registerObject(path, object, new io.qt.dbus.QDBusConnection.RegisterOptions(options));
    }
    
    /**
     * <p>Overloaded function for {@link #registerObject(java.lang.String, io.qt.core.QObject, io.qt.dbus.QDBusConnection.RegisterOptions)}
     *  with <code>options = new io.qt.dbus.QDBusConnection.RegisterOptions(1)</code>.</p>
     */
    @io.qt.QtUninvokable
    public final boolean registerObject(java.lang.String path, io.qt.core.QObject object) {
        return registerObject(path, object, new io.qt.dbus.QDBusConnection.RegisterOptions(1));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnection.html#registerObject">QDBusConnection::registerObject(QString,QObject*,RegisterOptions)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean registerObject(java.lang.String path, io.qt.core.QObject object, io.qt.dbus.QDBusConnection.RegisterOptions options){
        return registerObject_native_cref_QString_QObject_ptr_QFlags_QDBusConnection_RegisterOption_(QtJambi_LibraryUtilities.internal.nativeId(this), path, QtJambi_LibraryUtilities.internal.checkedNativeId(object), options.value());
    }
    
    @io.qt.QtUninvokable
    private native boolean registerObject_native_cref_QString_QObject_ptr_QFlags_QDBusConnection_RegisterOption_(long __this__nativeId, java.lang.String path, long object, int options);
    
    /**
     * <p>Overloaded function for {@link #registerObject(java.lang.String, java.lang.String, io.qt.core.QObject, io.qt.dbus.QDBusConnection.RegisterOptions)}.</p>
     */
    @io.qt.QtUninvokable
    public final boolean registerObject(java.lang.String path, java.lang.String arg__interface, io.qt.core.QObject object, io.qt.dbus.QDBusConnection.RegisterOption ... options){
        return registerObject(path, arg__interface, object, new io.qt.dbus.QDBusConnection.RegisterOptions(options));
    }
    
    /**
     * <p>Overloaded function for {@link #registerObject(java.lang.String, java.lang.String, io.qt.core.QObject, io.qt.dbus.QDBusConnection.RegisterOptions)}
     *  with <code>options = new io.qt.dbus.QDBusConnection.RegisterOptions(1)</code>.</p>
     */
    @io.qt.QtUninvokable
    public final boolean registerObject(java.lang.String path, java.lang.String arg__interface, io.qt.core.QObject object) {
        return registerObject(path, arg__interface, object, new io.qt.dbus.QDBusConnection.RegisterOptions(1));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnection.html#registerObject-1">QDBusConnection::registerObject(QString,QString,QObject*,RegisterOptions)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean registerObject(java.lang.String path, java.lang.String arg__interface, io.qt.core.QObject object, io.qt.dbus.QDBusConnection.RegisterOptions options){
        return registerObject_native_cref_QString_cref_QString_QObject_ptr_QFlags_QDBusConnection_RegisterOption_(QtJambi_LibraryUtilities.internal.nativeId(this), path, arg__interface, QtJambi_LibraryUtilities.internal.checkedNativeId(object), options.value());
    }
    
    @io.qt.QtUninvokable
    private native boolean registerObject_native_cref_QString_cref_QString_QObject_ptr_QFlags_QDBusConnection_RegisterOption_(long __this__nativeId, java.lang.String path, java.lang.String arg__interface, long object, int options);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnection.html#registerService">QDBusConnection::registerService(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean registerService(java.lang.String serviceName){
        return registerService_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), serviceName);
    }
    
    @io.qt.QtUninvokable
    private native boolean registerService_native_cref_QString(long __this__nativeId, java.lang.String serviceName);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnection.html#send">QDBusConnection::send(QDBusMessage)const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean send(io.qt.dbus.QDBusMessage message){
        return send_native_cref_QDBusMessage_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(message));
    }
    
    @io.qt.QtUninvokable
    private native boolean send_native_cref_QDBusMessage_constfct(long __this__nativeId, long message);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnection.html#swap">QDBusConnection::swap(QDBusConnection&amp;)</a></p>
     */
    @io.qt.QtUninvokable
    public final void swap(io.qt.dbus.QDBusConnection other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QDBusConnection(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native void swap_native_ref_QDBusConnection(long __this__nativeId, long other);
    
    /**
     * <p>Overloaded function for {@link #unregisterObject(java.lang.String, io.qt.dbus.QDBusConnection.UnregisterMode)}
     *  with <code>mode = io.qt.dbus.QDBusConnection.UnregisterMode.UnregisterNode</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void unregisterObject(java.lang.String path) {
        unregisterObject(path, io.qt.dbus.QDBusConnection.UnregisterMode.UnregisterNode);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnection.html#unregisterObject">QDBusConnection::unregisterObject(QString,QDBusConnection::UnregisterMode)</a></p>
     */
    @io.qt.QtUninvokable
    public final void unregisterObject(java.lang.String path, io.qt.dbus.QDBusConnection.UnregisterMode mode){
        unregisterObject_native_cref_QString_QDBusConnection_UnregisterMode(QtJambi_LibraryUtilities.internal.nativeId(this), path, mode.value());
    }
    
    @io.qt.QtUninvokable
    private native void unregisterObject_native_cref_QString_QDBusConnection_UnregisterMode(long __this__nativeId, java.lang.String path, int mode);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnection.html#unregisterService">QDBusConnection::unregisterService(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean unregisterService(java.lang.String serviceName){
        return unregisterService_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), serviceName);
    }
    
    @io.qt.QtUninvokable
    private native boolean unregisterService_native_cref_QString(long __this__nativeId, java.lang.String serviceName);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnection.html#connectToBus">QDBusConnection::connectToBus(QDBusConnection::BusType,QString)</a></p>
     */
    public static io.qt.dbus.QDBusConnection connectToBus(io.qt.dbus.QDBusConnection.BusType type, java.lang.String name){
        return connectToBus_native_QDBusConnection_BusType_cref_QString(type.value(), name);
    }
    
    private native static io.qt.dbus.QDBusConnection connectToBus_native_QDBusConnection_BusType_cref_QString(int type, java.lang.String name);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnection.html#connectToBus-1">QDBusConnection::connectToBus(QString,QString)</a></p>
     */
    public native static io.qt.dbus.QDBusConnection connectToBus(java.lang.String address, java.lang.String name);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnection.html#connectToPeer">QDBusConnection::connectToPeer(QString,QString)</a></p>
     */
    public native static io.qt.dbus.QDBusConnection connectToPeer(java.lang.String address, java.lang.String name);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnection.html#disconnectFromBus">QDBusConnection::disconnectFromBus(QString)</a></p>
     */
    public native static void disconnectFromBus(java.lang.String name);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnection.html#disconnectFromPeer">QDBusConnection::disconnectFromPeer(QString)</a></p>
     */
    public native static void disconnectFromPeer(java.lang.String name);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnection.html#localMachineId">QDBusConnection::localMachineId()</a></p>
     */
    public native static io.qt.core.QByteArray localMachineId();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnection-obsolete.html#sender">QDBusConnection::sender()</a></p>
     * 
     * @deprecated This function no longer works, use QDBusContext instead
     */
    @Deprecated
    public native static io.qt.dbus.QDBusConnection sender();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnection.html#sessionBus">QDBusConnection::sessionBus()</a></p>
     */
    public native static io.qt.dbus.QDBusConnection sessionBus();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnection.html#systemBus">QDBusConnection::systemBus()</a></p>
     */
    public native static io.qt.dbus.QDBusConnection systemBus();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QDBusConnection(QPrivateConstructor p) { super(p); } 
    
    
    @Override
    public QDBusConnection clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private native QDBusConnection clone_native(long __this_nativeId);
}
