/*
 * Decompiled with CFR 0.152.
 */
package io.qt.dbus;

import io.qt.core.QMetaType;
import io.qt.dbus.QDBusArgument;
import io.qt.dbus.QtJambi_LibraryUtilities;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

public final class QDBusMetaType {
    public static QMetaType registerDBusMetaType(Class<?> clazz, QMetaType ... instantiations) {
        QMetaType metaType = QMetaType.fromType(clazz, (QMetaType[])instantiations);
        if (metaType == null || !metaType.isValid()) {
            throw new RuntimeException("Unable to find meta type for class " + clazz.getName());
        }
        QDBusMetaType.registerDBusMetaType(metaType.id(), null, null, null);
        return metaType;
    }

    public static QMetaType registerDBusMetaType(QMetaType metaType) {
        if (metaType != null && metaType.isValid()) {
            QDBusMetaType.registerDBusMetaType(metaType.id(), null, null, null);
        }
        return metaType;
    }

    public static <T> QMetaType registerDBusMetaType(MarshallFunction<T> marshallFunction, DemarshallFunction<T> demarshallFunction) {
        int[] marshallFunctionTypes = QtJambi_LibraryUtilities.internal.lambdaMetaTypes(MarshallFunction.class, Objects.requireNonNull(marshallFunction));
        int[] demarshallFunctionTypes = QtJambi_LibraryUtilities.internal.lambdaMetaTypes(DemarshallFunction.class, Objects.requireNonNull(demarshallFunction));
        Class[] marshallFunctionClassTypes = QtJambi_LibraryUtilities.internal.lambdaClassTypes(MarshallFunction.class, Objects.requireNonNull(marshallFunction));
        Class[] demarshallFunctionClassTypes = QtJambi_LibraryUtilities.internal.lambdaClassTypes(DemarshallFunction.class, Objects.requireNonNull(demarshallFunction));
        if (marshallFunctionTypes == null || demarshallFunctionTypes == null || marshallFunctionTypes.length != 3 || demarshallFunctionTypes.length != 2) {
            throw new IllegalArgumentException("Marshall and/or demarshall function not a lambda expression.");
        }
        if (demarshallFunctionTypes[0] == 0 || marshallFunctionTypes[2] == 0) {
            throw new IllegalArgumentException("Unable to recognize meta type.");
        }
        if (demarshallFunctionTypes[0] != marshallFunctionTypes[2] || demarshallFunctionClassTypes[0] != marshallFunctionClassTypes[2]) {
            throw new IllegalArgumentException(String.format("Marshalled type %1$s (%2$s) is different from demarshalled type %3$s (%4$s).", marshallFunctionClassTypes[2].getTypeName(), new QMetaType(marshallFunctionTypes[2]).name(), demarshallFunctionClassTypes[0].getTypeName(), new QMetaType(demarshallFunctionTypes[0]).name()));
        }
        QDBusMetaType.registerDBusMetaType(demarshallFunctionTypes[0], demarshallFunctionClassTypes[0], marshallFunction, demarshallFunction);
        return new QMetaType(demarshallFunctionTypes[0]);
    }

    private static native <T> void registerDBusMetaType(int var0, Class<?> var1, MarshallFunction<T> var2, DemarshallFunction<T> var3);

    public static native Object demarshall(QDBusArgument var0, QMetaType var1) throws UnsupportedOperationException;

    public static void marshall(QDBusArgument arg, Object value) throws UnsupportedOperationException {
        QDBusMetaType.marshall(arg, null, value);
    }

    public static native void marshall(QDBusArgument var0, QMetaType var1, Object var2) throws UnsupportedOperationException;

    public static native String typeToSignature(QMetaType var0);

    public static native QMetaType signatureToMetaType(String var0);

    static {
        QtJambi_LibraryUtilities.initialize();
    }

    public static interface DemarshallFunction<U>
    extends Function<QDBusArgument, U>,
    Serializable {
    }

    public static interface MarshallFunction<U>
    extends BiConsumer<QDBusArgument, U>,
    Serializable {
    }
}

