/*
 * Decompiled with CFR 0.152.
 */
package io.qt.dbus;

import io.qt.NonNull;
import io.qt.QNoSuchEnumValueException;
import io.qt.QtEnumerator;
import io.qt.QtObject;
import io.qt.QtUninvokable;
import io.qt.StrictNonNull;
import io.qt.core.QList;
import io.qt.dbus.QDBusError;
import io.qt.dbus.QtJambi_LibraryUtilities;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public class QDBusMessage
extends QtObject
implements Cloneable {
    public QDBusMessage() {
        super((QtObject.QPrivateConstructor)null);
        QDBusMessage.initialize_native(this);
    }

    private static native void initialize_native(QDBusMessage var0);

    public QDBusMessage(@NonNull QDBusMessage other) {
        super((QtObject.QPrivateConstructor)null);
        QDBusMessage.initialize_native(this, other);
    }

    private static native void initialize_native(QDBusMessage var0, QDBusMessage var1);

    @QtUninvokable
    public final @NonNull QList<Object> arguments() {
        return this.arguments_native_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
    }

    @QtUninvokable
    private native QList<Object> arguments_native_constfct(long var1);

    @QtUninvokable
    public final boolean autoStartService() {
        return this.autoStartService_native_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
    }

    @QtUninvokable
    private native boolean autoStartService_native_constfct(long var1);

    @QtUninvokable
    public final @NonNull QDBusMessage createErrorReply(@NonNull QDBusError.ErrorType type, @NonNull String msg) {
        return this.createErrorReply_native_QDBusError_ErrorType_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this), type.value(), msg);
    }

    @QtUninvokable
    private native QDBusMessage createErrorReply_native_QDBusError_ErrorType_cref_QString_constfct(long var1, int var3, String var4);

    @QtUninvokable
    public final @NonNull QDBusMessage createErrorReply(@NonNull QDBusError err) {
        return this.createErrorReply_native_cref_QDBusError_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this), QtJambi_LibraryUtilities.internal.checkedNativeId((QtObject)err));
    }

    @QtUninvokable
    private native QDBusMessage createErrorReply_native_cref_QDBusError_constfct(long var1, long var3);

    @QtUninvokable
    public final @NonNull QDBusMessage createErrorReply(@NonNull String name, @NonNull String msg) {
        return this.createErrorReply_native_const_QString_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this), name, msg);
    }

    @QtUninvokable
    private native QDBusMessage createErrorReply_native_const_QString_cref_QString_constfct(long var1, String var3, String var4);

    @QtUninvokable
    public final @NonNull QDBusMessage createReply() {
        return this.createReply(Collections.emptyList());
    }

    @QtUninvokable
    public final @NonNull QDBusMessage createReply(@NonNull Collection<? extends Object> arguments) {
        return this.createReply_native_cref_QList_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this), arguments);
    }

    @QtUninvokable
    private native QDBusMessage createReply_native_cref_QList_constfct(long var1, Collection<? extends Object> var3);

    @QtUninvokable
    public final @NonNull QDBusMessage createReply(Object argument) {
        return this.createReply_native_cref_QVariant_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this), argument);
    }

    @QtUninvokable
    private native QDBusMessage createReply_native_cref_QVariant_constfct(long var1, Object var3);

    @QtUninvokable
    public final @NonNull String errorMessage() {
        return this.errorMessage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
    }

    @QtUninvokable
    private native String errorMessage_native_constfct(long var1);

    @QtUninvokable
    public final @NonNull String errorName() {
        return this.errorName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
    }

    @QtUninvokable
    private native String errorName_native_constfct(long var1);

    @QtUninvokable
    public final @NonNull String interfaceName() {
        return this.interfaceName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
    }

    @QtUninvokable
    private native String interfaceName_native_constfct(long var1);

    @QtUninvokable
    public final boolean isDelayedReply() {
        return this.isDelayedReply_native_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
    }

    @QtUninvokable
    private native boolean isDelayedReply_native_constfct(long var1);

    @QtUninvokable
    public final boolean isInteractiveAuthorizationAllowed() {
        return this.isInteractiveAuthorizationAllowed_native_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
    }

    @QtUninvokable
    private native boolean isInteractiveAuthorizationAllowed_native_constfct(long var1);

    @QtUninvokable
    public final boolean isReplyRequired() {
        return this.isReplyRequired_native_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
    }

    @QtUninvokable
    private native boolean isReplyRequired_native_constfct(long var1);

    @QtUninvokable
    public final @NonNull String member() {
        return this.member_native_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
    }

    @QtUninvokable
    private native String member_native_constfct(long var1);

    @QtUninvokable
    public final @NonNull QDBusMessage append(Object arg) {
        return this.append_native_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this), arg);
    }

    @QtUninvokable
    private native QDBusMessage append_native_cref_QVariant(long var1, Object var3);

    @QtUninvokable
    public final void assign(@NonNull QDBusMessage other) {
        this.assign_native_cref_QDBusMessage(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this), QtJambi_LibraryUtilities.internal.checkedNativeId((QtObject)other));
    }

    @QtUninvokable
    private native void assign_native_cref_QDBusMessage(long var1, long var3);

    @QtUninvokable
    public final @NonNull String path() {
        return this.path_native_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
    }

    @QtUninvokable
    private native String path_native_constfct(long var1);

    @QtUninvokable
    public final @NonNull String service() {
        return this.service_native_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
    }

    @QtUninvokable
    private native String service_native_constfct(long var1);

    @QtUninvokable
    public final void setArguments(@NonNull Collection<? extends Object> arguments) {
        this.setArguments_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this), arguments);
    }

    @QtUninvokable
    private native void setArguments_native_cref_QList(long var1, Collection<? extends Object> var3);

    @QtUninvokable
    public final void setAutoStartService(boolean enable) {
        this.setAutoStartService_native_bool(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this), enable);
    }

    @QtUninvokable
    private native void setAutoStartService_native_bool(long var1, boolean var3);

    @QtUninvokable
    public final void setDelayedReply(boolean enable) {
        this.setDelayedReply_native_bool_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this), enable);
    }

    @QtUninvokable
    private native void setDelayedReply_native_bool_constfct(long var1, boolean var3);

    @QtUninvokable
    public final void setInteractiveAuthorizationAllowed(boolean enable) {
        this.setInteractiveAuthorizationAllowed_native_bool(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this), enable);
    }

    @QtUninvokable
    private native void setInteractiveAuthorizationAllowed_native_bool(long var1, boolean var3);

    @QtUninvokable
    public final @NonNull String signature() {
        return this.signature_native_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
    }

    @QtUninvokable
    private native String signature_native_constfct(long var1);

    @QtUninvokable
    public final void swap(@StrictNonNull QDBusMessage other) {
        Objects.requireNonNull(other, "Argument 'other': null not expected.");
        this.swap_native_ref_QDBusMessage(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this), QtJambi_LibraryUtilities.internal.checkedNativeId((QtObject)other));
    }

    @QtUninvokable
    private native void swap_native_ref_QDBusMessage(long var1, long var3);

    @QtUninvokable
    public final @NonNull MessageType type() {
        return MessageType.resolve(this.type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this)));
    }

    @QtUninvokable
    private native int type_native_constfct(long var1);

    public static @NonNull QDBusMessage createError(@NonNull QDBusError.ErrorType type, @NonNull String msg) {
        return QDBusMessage.createError_native_QDBusError_ErrorType_cref_QString(type.value(), msg);
    }

    private static native QDBusMessage createError_native_QDBusError_ErrorType_cref_QString(int var0, String var1);

    public static @NonNull QDBusMessage createError(@NonNull QDBusError err) {
        return QDBusMessage.createError_native_cref_QDBusError(QtJambi_LibraryUtilities.internal.checkedNativeId((QtObject)err));
    }

    private static native QDBusMessage createError_native_cref_QDBusError(long var0);

    public static native @NonNull QDBusMessage createError(@NonNull String var0, @NonNull String var1);

    public static native @NonNull QDBusMessage createMethodCall(@NonNull String var0, @NonNull String var1, @NonNull String var2, @NonNull String var3);

    public static native @NonNull QDBusMessage createSignal(@NonNull String var0, @NonNull String var1, @NonNull String var2);

    public static native @NonNull QDBusMessage createTargetedSignal(@NonNull String var0, @NonNull String var1, @NonNull String var2, @NonNull String var3);

    protected QDBusMessage(QtObject.QPrivateConstructor p) {
        super(p);
    }

    @QtUninvokable
    public @NonNull String toString() {
        return QDBusMessage.toString_native(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
    }

    @QtUninvokable
    private static native String toString_native(long var0);

    @QtUninvokable
    public QDBusMessage clone() {
        return QDBusMessage.clone_native(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
    }

    private static native QDBusMessage clone_native(long var0);

    static {
        QtJambi_LibraryUtilities.initialize();
    }

    public static enum MessageType implements QtEnumerator
    {
        InvalidMessage(0),
        MethodCallMessage(1),
        ReplyMessage(2),
        ErrorMessage(3),
        SignalMessage(4);

        private final int value;

        private MessageType(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public static @NonNull MessageType resolve(int value) {
            switch (value) {
                case 0: {
                    return InvalidMessage;
                }
                case 1: {
                    return MethodCallMessage;
                }
                case 2: {
                    return ReplyMessage;
                }
                case 3: {
                    return ErrorMessage;
                }
                case 4: {
                    return SignalMessage;
                }
            }
            throw new QNoSuchEnumValueException(value);
        }

        static {
            QtJambi_LibraryUtilities.initialize();
        }
    }
}

