package io.qt.dbus;

import io.qt.*;


/**
 * <p>Used to handle several DBus paths with one class</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qdbusvirtualobject.html">QDBusVirtualObject</a></p>
 */
public abstract class QDBusVirtualObject extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QDBusVirtualObject.class);
    
    @NativeAccess
    private static final class ConcreteWrapper extends QDBusVirtualObject {
        
        @NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @QtUninvokable
        public boolean handleMessage(io.qt.dbus.@NonNull QDBusMessage message, io.qt.dbus.@NonNull QDBusConnection connection){
            return handleMessage_native_cref_QDBusMessage_cref_QDBusConnection(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(message), QtJambi_LibraryUtilities.internal.checkedNativeId(connection));
        }
        @QtUninvokable
        private native boolean handleMessage_native_cref_QDBusMessage_cref_QDBusConnection(long __this__nativeId, long message, long connection);
        
        
        @Override
        @QtUninvokable
        public java.lang.@NonNull String introspect(java.lang.@NonNull String path){
            return introspect_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), path);
        }
        @QtUninvokable
        private native java.lang.String introspect_native_cref_QString_constfct(long __this__nativeId, java.lang.String path);
        
    }
    
    
    /**
     * <p>Overloaded constructor for {@link #QDBusVirtualObject(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QDBusVirtualObject() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusvirtualobject.html#QDBusVirtualObject">QDBusVirtualObject::QDBusVirtualObject(QObject*)</a></p>
     */
    public QDBusVirtualObject(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QDBusVirtualObject instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusvirtualobject.html#handleMessage">QDBusVirtualObject::handleMessage(QDBusMessage,QDBusConnection)</a></p>
     */
    @QtUninvokable
    public abstract boolean handleMessage(io.qt.dbus.@NonNull QDBusMessage message, io.qt.dbus.@NonNull QDBusConnection connection);
    
    @QtUninvokable
    private native boolean handleMessage_native_cref_QDBusMessage_cref_QDBusConnection(long __this__nativeId, long message, long connection);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusvirtualobject.html#introspect">QDBusVirtualObject::introspect(QString)const</a></p>
     */
    @QtUninvokable
    public abstract java.lang.@NonNull String introspect(java.lang.@NonNull String path);
    
    @QtUninvokable
    private native java.lang.String introspect_native_cref_QString_constfct(long __this__nativeId, java.lang.String path);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QDBusVirtualObject(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QDBusVirtualObject(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QDBusVirtualObject instance, QDeclarativeConstructor constructor);
    
}
