package io.qt.dbus;

import io.qt.*;


/**
 * <p>Enables the programmer to identify the OBJECT_PATH type provided by the D-Bus typesystem</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qdbusobjectpath.html">QDBusObjectPath</a></p>
 */
public class QDBusObjectPath extends QtObject
    implements java.lang.Comparable<io.qt.dbus.QDBusObjectPath>,
            java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusobjectpath.html#QDBusObjectPath">QDBusObjectPath::QDBusObjectPath()</a></p>
     */
    public QDBusObjectPath(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QDBusObjectPath instance);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusobjectpath.html#QDBusObjectPath-3">QDBusObjectPath::QDBusObjectPath(QString)</a></p>
     */
    public QDBusObjectPath(java.lang.@NonNull String path){
        super((QPrivateConstructor)null);
        initialize_native(this, path);
    }
    
    private native static void initialize_native(QDBusObjectPath instance, java.lang.String path);
    
    @QtUninvokable
    private final boolean operator_less(io.qt.dbus.@NonNull QDBusObjectPath rhs){
        return operator_less_native_cref_QDBusObjectPath(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rhs));
    }
    
    @QtUninvokable
    private native boolean operator_less_native_cref_QDBusObjectPath(long __this__nativeId, long rhs);
    
    @QtUninvokable
    private final boolean operator_equal(io.qt.dbus.@NonNull QDBusObjectPath rhs){
        return operator_equal_native_cref_QDBusObjectPath(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rhs));
    }
    
    @QtUninvokable
    private native boolean operator_equal_native_cref_QDBusObjectPath(long __this__nativeId, long rhs);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusobjectpath.html#path">QDBusObjectPath::path()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String path(){
        return path_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String path_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusobjectpath.html#setPath">QDBusObjectPath::setPath(QString)</a></p>
     */
    @QtUninvokable
    public final void setPath(java.lang.@NonNull String path){
        setPath_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), path);
    }
    
    @QtUninvokable
    private native void setPath_native_cref_QString(long __this__nativeId, java.lang.String path);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusobjectpath.html#swap">QDBusObjectPath::swap(QDBusObjectPath&amp;)</a></p>
     */
    @QtUninvokable
    public final void swap(io.qt.dbus.@StrictNonNull QDBusObjectPath other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QDBusObjectPath(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void swap_native_ref_QDBusObjectPath(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QDBusObjectPath(QPrivateConstructor p) { super(p); } 
    

    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.dbus.QDBusObjectPath) {
            return operator_equal((io.qt.dbus.QDBusObjectPath) other);
        }

        return false;
    }

    @QtUninvokable
    public int compareTo(io.qt.dbus.QDBusObjectPath other) {
        if (equals(other)) return 0;
        else if (operator_less(other)) return -1;
        else return 1;
    }


    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
     */
    @QtUninvokable
    @Override
    public QDBusObjectPath clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QDBusObjectPath clone_native(long __this_nativeId);
}
