package io.qt.dbus;

import io.qt.*;


/**
 * <p>Proxy for interfaces on remote objects</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qdbusinterface.html">QDBusInterface</a></p>
 */
public class QDBusInterface extends io.qt.dbus.QDBusAbstractInterface
{
    
    /**
     * <p>Overloaded constructor for {@link #(java.lang.String, java.lang.String, java.lang.String, io.qt.dbus.QDBusConnection, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QDBusInterface(java.lang.@NonNull String service, java.lang.@NonNull String path, java.lang.@NonNull String arg__interface, io.qt.dbus.@NonNull QDBusConnection connection) {
        this(service, path, arg__interface, connection, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #(java.lang.String, java.lang.String, java.lang.String, io.qt.dbus.QDBusConnection, io.qt.core.QObject)}</p>
     * <p>with: </p><ul>
     * <li><code>connection = io.qt.dbus.QDBusConnection.sessionBus()</code></li>
     * <li><code>parent = null</code></li>
     * </ul>
     */
    public QDBusInterface(java.lang.@NonNull String service, java.lang.@NonNull String path, java.lang.@NonNull String arg__interface) {
        this(service, path, arg__interface, io.qt.dbus.QDBusConnection.sessionBus(), (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #(java.lang.String, java.lang.String, java.lang.String, io.qt.dbus.QDBusConnection, io.qt.core.QObject)}</p>
     * <p>with: </p><ul>
     * <li><code>arg__interface = (String)null</code></li>
     * <li><code>connection = io.qt.dbus.QDBusConnection.sessionBus()</code></li>
     * <li><code>parent = null</code></li>
     * </ul>
     */
    public QDBusInterface(java.lang.@NonNull String service, java.lang.@NonNull String path) {
        this(service, path, (String)null, io.qt.dbus.QDBusConnection.sessionBus(), (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusinterface.html#QDBusInterface-1">QDBusInterface::QDBusInterface(QString,QString,QString,QDBusConnection,QObject*)</a></p>
     */
    public QDBusInterface(java.lang.@NonNull String service, java.lang.@NonNull String path, java.lang.@NonNull String arg__interface, io.qt.dbus.@NonNull QDBusConnection connection, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, service, path, arg__interface, connection, parent);
    }
    
    private native static void initialize_native(QDBusInterface instance, java.lang.String service, java.lang.String path, java.lang.String arg__interface, io.qt.dbus.QDBusConnection connection, io.qt.core.QObject parent);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QDBusInterface(QPrivateConstructor p) { super(p); } 
    
}
