package io.qt.dbus;

import io.qt.*;


/**
 * <p>Allows slots to determine the D-Bus context of the calls</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qdbuscontext.html">QDBusContext</a></p>
 */
public interface QDBusContext extends QtObjectInterface
{
    /**
     * <p>Implementor class for interface {@link io.qt.dbus.QDBusContext}</p>
     */
    public static class Impl extends QtObject
        implements io.qt.dbus.QDBusContext
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdbuscontext.html#QDBusContext">QDBusContext::QDBusContext()</a></p>
         */
        public Impl(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(QDBusContext instance);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdbuscontext.html#calledFromDBus">QDBusContext::calledFromDBus()const</a></p>
         */
        @QtUninvokable
        public final boolean calledFromDBus(){
            return calledFromDBus_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static boolean calledFromDBus_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdbuscontext.html#connection">QDBusContext::connection()const</a></p>
         */
        @QtUninvokable
        public final io.qt.dbus.@NonNull QDBusConnection connection(){
            QDBusContext.Impl.checkCalledFromDBus(this);
            return connection_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static io.qt.dbus.QDBusConnection connection_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdbuscontext.html#isDelayedReply">QDBusContext::isDelayedReply()const</a></p>
         */
        @QtUninvokable
        public final boolean isDelayedReply(){
            QDBusContext.Impl.checkCalledFromDBus(this);
            return isDelayedReply_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static boolean isDelayedReply_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdbuscontext.html#message">QDBusContext::message()const</a></p>
         */
        @QtUninvokable
        public final io.qt.dbus.@NonNull QDBusMessage message(){
            QDBusContext.Impl.checkCalledFromDBus(this);
            return message_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static io.qt.dbus.QDBusMessage message_native_constfct(long __this__nativeId);
        
        /**
         * <p>Overloaded function for {@link #sendErrorReply(io.qt.dbus.QDBusError.ErrorType, java.lang.String)}
         *  with <code>msg = (String)null</code>.</p>
         */
        @QtUninvokable
        public final void sendErrorReply(io.qt.dbus.QDBusError.@NonNull ErrorType type) {
            sendErrorReply(type, (String)null);
        }
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdbuscontext.html#sendErrorReply-1">QDBusContext::sendErrorReply(QDBusError::ErrorType,QString)const</a></p>
         */
        @QtUninvokable
        public final void sendErrorReply(io.qt.dbus.QDBusError.@NonNull ErrorType type, java.lang.@NonNull String msg){
            QDBusContext.Impl.checkCalledFromDBus(this);
            sendErrorReply_native_QDBusError_ErrorType_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), type.value(), msg);
        }
        
        private native static void sendErrorReply_native_QDBusError_ErrorType_cref_QString_constfct(long __this__nativeId, int type, java.lang.String msg);
        
        /**
         * <p>Overloaded function for {@link #sendErrorReply(java.lang.String, java.lang.String)}
         *  with <code>msg = (String)null</code>.</p>
         */
        @QtUninvokable
        public final void sendErrorReply(java.lang.@NonNull String name) {
            sendErrorReply(name, (String)null);
        }
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdbuscontext.html#sendErrorReply">QDBusContext::sendErrorReply(QString,QString)const</a></p>
         */
        @QtUninvokable
        public final void sendErrorReply(java.lang.@NonNull String name, java.lang.@NonNull String msg){
            QDBusContext.Impl.checkCalledFromDBus(this);
            sendErrorReply_native_cref_QString_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name, msg);
        }
        
        private native static void sendErrorReply_native_cref_QString_cref_QString_constfct(long __this__nativeId, java.lang.String name, java.lang.String msg);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdbuscontext.html#setDelayedReply">QDBusContext::setDelayedReply(bool)const</a></p>
         */
        @QtUninvokable
        public final void setDelayedReply(boolean enable){
            QDBusContext.Impl.checkCalledFromDBus(this);
            setDelayedReply_native_bool_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
        }
        
        private native static void setDelayedReply_native_bool_constfct(long __this__nativeId, boolean enable);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @NativeAccess
        protected Impl(QPrivateConstructor p) { super(p); } 
        
        private static void checkCalledFromDBus(QDBusContext instance){
            if(!instance.calledFromDBus())
                throw new IllegalStateException("QDBusContext has not ben called from DBus.");
        }
    }

    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbuscontext.html#calledFromDBus">QDBusContext::calledFromDBus()const</a></p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public default boolean calledFromDBus(){
        return Impl.calledFromDBus_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbuscontext.html#connection">QDBusContext::connection()const</a></p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public default io.qt.dbus.@NonNull QDBusConnection connection(){
        QDBusContext.Impl.checkCalledFromDBus(this);
        return Impl.connection_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbuscontext.html#isDelayedReply">QDBusContext::isDelayedReply()const</a></p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public default boolean isDelayedReply(){
        QDBusContext.Impl.checkCalledFromDBus(this);
        return Impl.isDelayedReply_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbuscontext.html#message">QDBusContext::message()const</a></p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public default io.qt.dbus.@NonNull QDBusMessage message(){
        QDBusContext.Impl.checkCalledFromDBus(this);
        return Impl.message_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    /**
     * <p>Overloaded function for {@link #sendErrorReply(io.qt.dbus.QDBusError.ErrorType, java.lang.String)}
     *  with <code>msg = (String)null</code>.</p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public default void sendErrorReply(io.qt.dbus.QDBusError.@NonNull ErrorType type) {
        sendErrorReply(type, (String)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbuscontext.html#sendErrorReply-1">QDBusContext::sendErrorReply(QDBusError::ErrorType,QString)const</a></p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public default void sendErrorReply(io.qt.dbus.QDBusError.@NonNull ErrorType type, java.lang.@NonNull String msg){
        QDBusContext.Impl.checkCalledFromDBus(this);
        Impl.sendErrorReply_native_QDBusError_ErrorType_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), type.value(), msg);
    }
    
    /**
     * <p>Overloaded function for {@link #sendErrorReply(java.lang.String, java.lang.String)}
     *  with <code>msg = (String)null</code>.</p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public default void sendErrorReply(java.lang.@NonNull String name) {
        sendErrorReply(name, (String)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbuscontext.html#sendErrorReply">QDBusContext::sendErrorReply(QString,QString)const</a></p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public default void sendErrorReply(java.lang.@NonNull String name, java.lang.@NonNull String msg){
        QDBusContext.Impl.checkCalledFromDBus(this);
        Impl.sendErrorReply_native_cref_QString_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name, msg);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbuscontext.html#setDelayedReply">QDBusContext::setDelayedReply(bool)const</a></p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public default void setDelayedReply(boolean enable){
        QDBusContext.Impl.checkCalledFromDBus(this);
        Impl.setDelayedReply_native_bool_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
}
