package io.qt.dbus;

import io.qt.*;


/**
 * <p>Access to the D-Bus bus daemon service</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qdbusconnectioninterface.html">QDBusConnectionInterface</a></p>
 */
public final class QDBusConnectionInterface extends io.qt.dbus.QDBusAbstractInterface
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QDBusConnectionInterface.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qdbusconnectioninterface.html#RegisterServiceReply-enum">QDBusConnectionInterface::RegisterServiceReply</a></p>
     */
    public enum RegisterServiceReply implements QtEnumerator {
        ServiceNotRegistered(0),
        ServiceRegistered(1),
        ServiceQueued(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private RegisterServiceReply(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static RegisterServiceReply resolve(int value) {
            switch (value) {
            case 0: return ServiceNotRegistered;
            case 1: return ServiceRegistered;
            case 2: return ServiceQueued;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qdbusconnectioninterface.html#ServiceQueueOptions-enum">QDBusConnectionInterface::ServiceQueueOptions</a></p>
     */
    public enum ServiceQueueOptions implements QtEnumerator {
        DontQueueService(0),
        QueueService(1),
        ReplaceExistingService(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ServiceQueueOptions(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ServiceQueueOptions resolve(int value) {
            switch (value) {
            case 0: return DontQueueService;
            case 1: return QueueService;
            case 2: return ReplaceExistingService;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qdbusconnectioninterface.html#ServiceReplacementOptions-enum">QDBusConnectionInterface::ServiceReplacementOptions</a></p>
     */
    public enum ServiceReplacementOptions implements QtEnumerator {
        DontAllowReplacement(0),
        AllowReplacement(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ServiceReplacementOptions(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ServiceReplacementOptions resolve(int value) {
            switch (value) {
            case 0: return DontAllowReplacement;
            case 1: return AllowReplacement;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    public final @NonNull Signal1<java.lang.@NonNull String> NameAcquired = new Signal1<>();

    public final @NonNull Signal1<java.lang.@NonNull String> NameLost = new Signal1<>();

    public final @NonNull Signal3<java.lang.@NonNull String, java.lang.@NonNull String, java.lang.@NonNull String> NameOwnerChanged = new Signal3<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnectioninterface.html#callWithCallbackFailed">QDBusConnectionInterface::callWithCallbackFailed(QDBusError,QDBusMessage)</a></p>
     */
    public final @NonNull Signal2<io.qt.dbus.@NonNull QDBusError, io.qt.dbus.@NonNull QDBusMessage> callWithCallbackFailed = new Signal2<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnectioninterface-obsolete.html#serviceOwnerChanged">QDBusConnectionInterface::serviceOwnerChanged(QString,QString,QString)</a></p>
     */
    public final @NonNull Signal3<java.lang.@NonNull String, java.lang.@NonNull String, java.lang.@NonNull String> serviceOwnerChanged = new Signal3<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnectioninterface.html#serviceRegistered">QDBusConnectionInterface::serviceRegistered(QString)</a></p>
     */
    public final @NonNull Signal1<java.lang.@NonNull String> serviceRegistered = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnectioninterface.html#serviceUnregistered">QDBusConnectionInterface::serviceUnregistered(QString)</a></p>
     */
    public final @NonNull Signal1<java.lang.@NonNull String> serviceUnregistered = new Signal1<>();
    
    /**
     * <p>Kotlin property getter. In Java use {@link #activatableServiceNames()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    public final io.qt.dbus.@NonNull QDBusReply<java.util.@NonNull List<java.lang.@NonNull String>> getActivatableServiceNames() {
        return activatableServiceNames();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnectioninterface.html#activatableServiceNames-prop">QDBusConnectionInterface::activatableServiceNames()const</a></p>
     */
    @QtPropertyReader(name="activatableServiceNames")
    public final io.qt.dbus.@NonNull QDBusReply<java.util.@NonNull List<java.lang.@NonNull String>> activatableServiceNames(){
        return activatableServiceNames_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native io.qt.dbus.QDBusReply<java.util.List<java.lang.String>> activatableServiceNames_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnectioninterface.html#isServiceRegistered">QDBusConnectionInterface::isServiceRegistered(QString)const</a></p>
     */
    public final io.qt.dbus.@NonNull QDBusReply<java.lang.@QtPrimitiveType@NonNull Boolean> isServiceRegistered(java.lang.@NonNull String serviceName){
        return isServiceRegistered_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), serviceName);
    }
    
    private native io.qt.dbus.QDBusReply<java.lang.@QtPrimitiveType Boolean> isServiceRegistered_native_cref_QString_constfct(long __this__nativeId, java.lang.String serviceName);
    
    /**
     * <p>Overloaded function for {@link #registerService(java.lang.String, io.qt.dbus.QDBusConnectionInterface.ServiceQueueOptions, io.qt.dbus.QDBusConnectionInterface.ServiceReplacementOptions)}
     *  with <code>roption = io.qt.dbus.QDBusConnectionInterface.ServiceReplacementOptions.DontAllowReplacement</code>.</p>
     */
    public final io.qt.dbus.@NonNull QDBusReply<io.qt.dbus.QDBusConnectionInterface.@NonNull RegisterServiceReply> registerService(java.lang.@NonNull String serviceName, io.qt.dbus.QDBusConnectionInterface.@NonNull ServiceQueueOptions qoption) {
        return registerService(serviceName, qoption, io.qt.dbus.QDBusConnectionInterface.ServiceReplacementOptions.DontAllowReplacement);
    }
    
    /**
     * <p>Overloaded function for {@link #registerService(java.lang.String, io.qt.dbus.QDBusConnectionInterface.ServiceQueueOptions, io.qt.dbus.QDBusConnectionInterface.ServiceReplacementOptions)}</p>
     * <p>with: </p><ul>
     * <li><code>qoption = io.qt.dbus.QDBusConnectionInterface.ServiceQueueOptions.DontQueueService</code></li>
     * <li><code>roption = io.qt.dbus.QDBusConnectionInterface.ServiceReplacementOptions.DontAllowReplacement</code></li>
     * </ul>
     */
    public final io.qt.dbus.@NonNull QDBusReply<io.qt.dbus.QDBusConnectionInterface.@NonNull RegisterServiceReply> registerService(java.lang.@NonNull String serviceName) {
        return registerService(serviceName, io.qt.dbus.QDBusConnectionInterface.ServiceQueueOptions.DontQueueService, io.qt.dbus.QDBusConnectionInterface.ServiceReplacementOptions.DontAllowReplacement);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnectioninterface.html#registerService">QDBusConnectionInterface::registerService(QString,QDBusConnectionInterface::ServiceQueueOptions,QDBusConnectionInterface::ServiceReplacementOptions)</a></p>
     */
    public final io.qt.dbus.@NonNull QDBusReply<io.qt.dbus.QDBusConnectionInterface.@NonNull RegisterServiceReply> registerService(java.lang.@NonNull String serviceName, io.qt.dbus.QDBusConnectionInterface.@NonNull ServiceQueueOptions qoption, io.qt.dbus.QDBusConnectionInterface.@NonNull ServiceReplacementOptions roption){
        return registerService_native_cref_QString_QDBusConnectionInterface_ServiceQueueOptions_QDBusConnectionInterface_ServiceReplacementOptions(QtJambi_LibraryUtilities.internal.nativeId(this), serviceName, qoption.value(), roption.value());
    }
    
    private native io.qt.dbus.QDBusReply<io.qt.dbus.QDBusConnectionInterface.RegisterServiceReply> registerService_native_cref_QString_QDBusConnectionInterface_ServiceQueueOptions_QDBusConnectionInterface_ServiceReplacementOptions(long __this__nativeId, java.lang.String serviceName, int qoption, int roption);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #registeredServiceNames()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    public final io.qt.dbus.@NonNull QDBusReply<java.util.@NonNull List<java.lang.@NonNull String>> getRegisteredServiceNames() {
        return registeredServiceNames();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnectioninterface.html#registeredServiceNames-prop">QDBusConnectionInterface::registeredServiceNames()const</a></p>
     */
    @QtPropertyReader(name="registeredServiceNames")
    public final io.qt.dbus.@NonNull QDBusReply<java.util.@NonNull List<java.lang.@NonNull String>> registeredServiceNames(){
        return registeredServiceNames_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native io.qt.dbus.QDBusReply<java.util.List<java.lang.String>> registeredServiceNames_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnectioninterface.html#serviceOwner">QDBusConnectionInterface::serviceOwner(QString)const</a></p>
     */
    public final io.qt.dbus.@NonNull QDBusReply<java.lang.@NonNull String> serviceOwner(java.lang.@NonNull String name){
        return serviceOwner_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    private native io.qt.dbus.QDBusReply<java.lang.String> serviceOwner_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnectioninterface.html#servicePid">QDBusConnectionInterface::servicePid(QString)const</a></p>
     */
    public final io.qt.dbus.@NonNull QDBusReply<java.lang.@QtPrimitiveType@NonNull Integer> servicePid(java.lang.@NonNull String serviceName){
        return servicePid_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), serviceName);
    }
    
    private native io.qt.dbus.QDBusReply<java.lang.@QtPrimitiveType Integer> servicePid_native_cref_QString_constfct(long __this__nativeId, java.lang.String serviceName);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnectioninterface.html#serviceUid">QDBusConnectionInterface::serviceUid(QString)const</a></p>
     */
    public final io.qt.dbus.@NonNull QDBusReply<java.lang.@QtPrimitiveType@NonNull Integer> serviceUid(java.lang.@NonNull String serviceName){
        return serviceUid_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), serviceName);
    }
    
    private native io.qt.dbus.QDBusReply<java.lang.@QtPrimitiveType Integer> serviceUid_native_cref_QString_constfct(long __this__nativeId, java.lang.String serviceName);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnectioninterface.html#startService">QDBusConnectionInterface::startService(QString)</a></p>
     */
    public final io.qt.dbus.@NonNull QDBusReply<java.lang.@NonNull Void> startService(java.lang.@NonNull String name){
        return startService_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    private native io.qt.dbus.QDBusReply<java.lang.@QtPrimitiveType Void> startService_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusconnectioninterface.html#unregisterService">QDBusConnectionInterface::unregisterService(QString)</a></p>
     */
    public final io.qt.dbus.@NonNull QDBusReply<java.lang.@QtPrimitiveType@NonNull Boolean> unregisterService(java.lang.@NonNull String serviceName){
        return unregisterService_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), serviceName);
    }
    
    private native io.qt.dbus.QDBusReply<java.lang.@QtPrimitiveType Boolean> unregisterService_native_cref_QString(long __this__nativeId, java.lang.String serviceName);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QDBusConnectionInterface(QPrivateConstructor p) { super(p); } 
    
}
