package io.qt.dbus;

import io.qt.*;


/**
 * <p>The base class for all D-Bus interfaces in the Qt D-Bus binding, allowing access to remote interfaces</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qdbusabstractinterface.html">QDBusAbstractInterface</a></p>
 */
public class QDBusAbstractInterface extends io.qt.dbus.QDBusAbstractInterfaceBase
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QDBusAbstractInterface.class);
    
    
    protected QDBusAbstractInterface(java.lang.@NonNull String service, java.lang.@NonNull String path, java.lang.@Nullable String arg__interface, io.qt.dbus.@NonNull QDBusConnection connection, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, service, path, arg__interface, connection, parent);
    }
    
    private native static void initialize_native(QDBusAbstractInterface instance, java.lang.String service, java.lang.String path, java.lang.String arg__interface, io.qt.dbus.QDBusConnection connection, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusabstractinterface.html#asyncCall-1">QDBusAbstractInterface::asyncCall(QString)</a></p>
     */
    @QtUninvokable
    public final io.qt.dbus.@NonNull QDBusPendingCall asyncCall(java.lang.@NonNull String method){
        return asyncCall_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), method);
    }
    
    @QtUninvokable
    private native io.qt.dbus.QDBusPendingCall asyncCall_native_cref_QString(long __this__nativeId, java.lang.String method);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusabstractinterface.html#asyncCallWithArgumentList">QDBusAbstractInterface::asyncCallWithArgumentList(QString,QList&lt;QVariant&gt;)</a></p>
     */
    @QtUninvokable
    public final io.qt.dbus.@NonNull QDBusPendingCall asyncCallWithArgumentList(java.lang.@NonNull String method, java.util.@NonNull Collection<? extends java.lang.Object> args){
        return asyncCallWithArgumentList_native_cref_QString_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), method, args);
    }
    
    @QtUninvokable
    private native io.qt.dbus.QDBusPendingCall asyncCallWithArgumentList_native_cref_QString_cref_QList(long __this__nativeId, java.lang.String method, java.util.Collection<? extends java.lang.Object> args);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusabstractinterface.html#callWithArgumentList">QDBusAbstractInterface::callWithArgumentList(QDBus::CallMode,QString,QList&lt;QVariant&gt;)</a></p>
     */
    @QtUninvokable
    public final io.qt.dbus.@NonNull QDBusMessage callWithArgumentList(io.qt.dbus.QDBus.@NonNull CallMode mode, java.lang.@NonNull String method, java.util.@NonNull Collection<? extends java.lang.Object> args){
        return callWithArgumentList_native_QDBus_CallMode_cref_QString_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value(), method, args);
    }
    
    @QtUninvokable
    private native io.qt.dbus.QDBusMessage callWithArgumentList_native_QDBus_CallMode_cref_QString_cref_QList(long __this__nativeId, int mode, java.lang.String method, java.util.Collection<? extends java.lang.Object> args);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusabstractinterface.html#callWithCallback-1">QDBusAbstractInterface::callWithCallback(QString,QList&lt;QVariant&gt;,QObject*,const char*)</a></p>
     */
    @QtUninvokable
    public final boolean callWithCallback(java.lang.@NonNull String method, java.util.@NonNull Collection<? extends java.lang.Object> args, io.qt.core.@Nullable QObject receiver, java.lang.@Nullable String member){
        if(member!=null && !member.startsWith("1") && !member.startsWith("2")) {
            io.qt.core.QMetaMethod _method = receiver.metaObject().method(member);
            if(_method!=null && _method.isValid()) {
                if(_method.methodType()==io.qt.core.QMetaMethod.MethodType.Signal)
                    member = "2" + _method.cppMethodSignature();
                else
                    member = "1" + _method.cppMethodSignature();
            }
        }
        return callWithCallback_native_cref_QString_cref_QList_QObject_ptr_const_char_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), method, args, QtJambi_LibraryUtilities.internal.checkedNativeId(receiver), member);
    }
    
    @QtUninvokable
    private native boolean callWithCallback_native_cref_QString_cref_QList_QObject_ptr_const_char_ptr(long __this__nativeId, java.lang.String method, java.util.Collection<? extends java.lang.Object> args, long receiver, java.lang.String member);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusabstractinterface.html#callWithCallback">QDBusAbstractInterface::callWithCallback(QString,QList&lt;QVariant&gt;,QObject*,const char*,const char*)</a></p>
     */
    @QtUninvokable
    public final boolean callWithCallback(java.lang.@NonNull String method, java.util.@NonNull Collection<? extends java.lang.Object> args, io.qt.core.@Nullable QObject receiver, java.lang.@Nullable String member, java.lang.@Nullable String errorSlot){
        if(member!=null && !member.startsWith("1") && !member.startsWith("2")) {
            io.qt.core.QMetaMethod _method = receiver.metaObject().method(member);
            if(_method!=null && _method.isValid()) {
                if(_method.methodType()==io.qt.core.QMetaMethod.MethodType.Signal)
                    member = "2" + _method.cppMethodSignature();
                else
                    member = "1" + _method.cppMethodSignature();
            }
        }
        if(errorSlot!=null && !errorSlot.startsWith("1") && !errorSlot.startsWith("2")) {
            io.qt.core.QMetaMethod _method = receiver.metaObject().method(errorSlot);
            if(_method!=null && _method.isValid()) {
                if(_method.methodType()==io.qt.core.QMetaMethod.MethodType.Signal)
                    errorSlot = "2" + _method.cppMethodSignature();
                else
                    errorSlot = "1" + _method.cppMethodSignature();
            }
        }
        return callWithCallback_native_cref_QString_cref_QList_QObject_ptr_const_char_ptr_const_char_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), method, args, QtJambi_LibraryUtilities.internal.checkedNativeId(receiver), member, errorSlot);
    }
    
    @QtUninvokable
    private native boolean callWithCallback_native_cref_QString_cref_QList_QObject_ptr_const_char_ptr_const_char_ptr(long __this__nativeId, java.lang.String method, java.util.Collection<? extends java.lang.Object> args, long receiver, java.lang.String member, java.lang.String errorSlot);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusabstractinterface.html#connection">QDBusAbstractInterface::connection()const</a></p>
     */
    @QtUninvokable
    public final io.qt.dbus.@NonNull QDBusConnection connection(){
        return connection_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.dbus.QDBusConnection connection_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusabstractinterface.html#interface">QDBusAbstractInterface::interface()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String interfaceName(){
        return interfaceName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String interfaceName_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #internalConstCall(io.qt.dbus.QDBus.CallMode, java.lang.String, java.util.Collection)}
     *  with <code>args = java.util.Collections.emptyList()</code>.</p>
     */
    @QtUninvokable
    protected final io.qt.dbus.@NonNull QDBusMessage internalConstCall(io.qt.dbus.QDBus.@NonNull CallMode mode, java.lang.@NonNull String method) {
        return internalConstCall(mode, method, java.util.Collections.emptyList());
    }
    
    @QtUninvokable
    protected final io.qt.dbus.@NonNull QDBusMessage internalConstCall(io.qt.dbus.QDBus.@NonNull CallMode mode, java.lang.@NonNull String method, java.util.@NonNull Collection<? extends java.lang.Object> args){
        return internalConstCall_native_QDBus_CallMode_cref_QString_cref_QList_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value(), method, args);
    }
    
    @QtUninvokable
    private native io.qt.dbus.QDBusMessage internalConstCall_native_QDBus_CallMode_cref_QString_cref_QList_constfct(long __this__nativeId, int mode, java.lang.String method, java.util.Collection<? extends java.lang.Object> args);
    
    @QtUninvokable
    protected final java.lang.Object internalPropGet(java.lang.@Nullable String propname){
        return internalPropGet_native_const_char_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), propname);
    }
    
    @QtUninvokable
    private native java.lang.Object internalPropGet_native_const_char_ptr_constfct(long __this__nativeId, java.lang.String propname);
    
    @QtUninvokable
    protected final void internalPropSet(java.lang.@Nullable String propname, java.lang.Object value){
        internalPropSet_native_const_char_ptr_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), propname, value);
    }
    
    @QtUninvokable
    private native void internalPropSet_native_const_char_ptr_cref_QVariant(long __this__nativeId, java.lang.String propname, java.lang.Object value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusabstractinterface.html#isValid">QDBusAbstractInterface::isValid()const</a></p>
     */
    @QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusabstractinterface.html#lastError">QDBusAbstractInterface::lastError()const</a></p>
     */
    @QtUninvokable
    public final io.qt.dbus.@NonNull QDBusError lastError(){
        return lastError_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.dbus.QDBusError lastError_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusabstractinterface.html#path">QDBusAbstractInterface::path()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String path(){
        return path_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String path_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusabstractinterface.html#service">QDBusAbstractInterface::service()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String service(){
        return service_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String service_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusabstractinterface.html#setTimeout">QDBusAbstractInterface::setTimeout(int)</a></p>
     */
    @QtUninvokable
    public final void setTimeout(int timeout){
        setTimeout_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), timeout);
    }
    
    @QtUninvokable
    private native void setTimeout_native_int(long __this__nativeId, int timeout);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusabstractinterface.html#timeout">QDBusAbstractInterface::timeout()const</a></p>
     */
    @QtUninvokable
    public final int timeout(){
        return timeout_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int timeout_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qobject.html#connectNotify">QObject::connectNotify(QMetaMethod)</a></p>
     */
    @QtUninvokable
    protected void connectNotify(io.qt.core.@NonNull QMetaMethod signal){
        connectNotify_native_cref_QMetaMethod(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(signal));
    }
    
    @QtUninvokable
    private native void connectNotify_native_cref_QMetaMethod(long __this__nativeId, long signal);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qobject.html#disconnectNotify">QObject::disconnectNotify(QMetaMethod)</a></p>
     */
    @QtUninvokable
    protected void disconnectNotify(io.qt.core.@NonNull QMetaMethod signal){
        disconnectNotify_native_cref_QMetaMethod(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(signal));
    }
    
    @QtUninvokable
    private native void disconnectNotify_native_cref_QMetaMethod(long __this__nativeId, long signal);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QDBusAbstractInterface(QPrivateConstructor p) { super(p); } 
    
    @QtUninvokable
    public final io.qt.dbus.QDBusPendingCall asyncCall(java.lang.String method, java.lang.Object... args){
        return asyncCallWithArgumentList(method, java.util.Arrays.asList(args));
    }
    
    @QtUninvokable
    public final io.qt.dbus.QDBusMessage call(io.qt.dbus.QDBus.CallMode mode, java.lang.String method, java.lang.Object... args){
        return callWithArgumentList(mode, method, java.util.Arrays.asList(args));
    }
    
    @QtUninvokable
    public final io.qt.dbus.QDBusMessage call(java.lang.String method, java.lang.Object... args){
        return callWithArgumentList(io.qt.dbus.QDBus.CallMode.AutoDetect, method, java.util.Arrays.asList(args));
    }
}
