package io.qt.dbus;

import io.qt.*;


/**
 * <p>The base class of D-Bus adaptor classes</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qdbusabstractadaptor.html">QDBusAbstractAdaptor</a></p>
 */
public class QDBusAbstractAdaptor extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QDBusAbstractAdaptor.class);
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusabstractadaptor.html#QDBusAbstractAdaptor">QDBusAbstractAdaptor::QDBusAbstractAdaptor(QObject*)</a></p>
     */
    protected QDBusAbstractAdaptor(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QDBusAbstractAdaptor instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusabstractadaptor.html#autoRelaySignals">QDBusAbstractAdaptor::autoRelaySignals()const</a></p>
     */
    @QtUninvokable
    protected final boolean autoRelaySignals(){
        return autoRelaySignals_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean autoRelaySignals_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusabstractadaptor.html#setAutoRelaySignals">QDBusAbstractAdaptor::setAutoRelaySignals(bool)</a></p>
     */
    @QtUninvokable
    protected final void setAutoRelaySignals(boolean enable){
        setAutoRelaySignals_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setAutoRelaySignals_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QDBusAbstractAdaptor(QPrivateConstructor p) { super(p); } 
    
}
