package io.qt.dbus;

import io.qt.*;


/**
 * <p>Contains miscellaneous identifiers used throughout the Qt D-Bus module</p>
 * <p>Java wrapper for Qt's namespace <a href="http://doc.qt.io/qt-5/qdbus.html">QDBus</a></p>
 */
public final class QDBus
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    private QDBus() throws java.lang.InstantiationError { throw new java.lang.InstantiationError("Cannot instantiate namespace QDBus."); }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qdbus.html#CallMode-enum">QDBus::CallMode</a></p>
     */
    public enum CallMode implements QtEnumerator {
        NoBlock(0),
        Block(1),
        BlockWithGui(2),
        AutoDetect(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private CallMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static CallMode resolve(int value) {
            switch (value) {
            case 0: return NoBlock;
            case 1: return Block;
            case 2: return BlockWithGui;
            case 3: return AutoDetect;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
}
