package io.qt.dbus;


/**
 * <p>Enables the programmer to identify the variant type provided by the D-Bus typesystem</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qdbusvariant.html">QDBusVariant</a></p>
 */
public class QDBusVariant extends io.qt.QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusvariant.html#QDBusVariant">QDBusVariant::QDBusVariant()</a></p>
     */
    public QDBusVariant(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QDBusVariant instance);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusvariant.html#QDBusVariant-1">QDBusVariant::QDBusVariant(QVariant)</a></p>
     */
    public QDBusVariant(java.lang.Object variant){
        super((QPrivateConstructor)null);
        initialize_native(this, variant);
    }
    
    private native static void initialize_native(QDBusVariant instance, java.lang.Object variant);
    
    @io.qt.QtUninvokable
    private final boolean operator_equal(io.qt.dbus.QDBusVariant v2){
        java.util.Objects.requireNonNull(v2, "Argument 'v2': null not expected.");
        return operator_equal_native_cref_QDBusVariant(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(v2));
    }
    
    @io.qt.QtUninvokable
    private native boolean operator_equal_native_cref_QDBusVariant(long __this__nativeId, long v2);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusvariant.html#setVariant">QDBusVariant::setVariant(QVariant)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setVariant(java.lang.Object variant){
        setVariant_native_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), variant);
    }
    
    @io.qt.QtUninvokable
    private native void setVariant_native_cref_QVariant(long __this__nativeId, java.lang.Object variant);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusvariant.html#swap">QDBusVariant::swap(QDBusVariant&amp;)</a></p>
     */
    @io.qt.QtUninvokable
    public final void swap(io.qt.dbus.QDBusVariant other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QDBusVariant(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native void swap_native_ref_QDBusVariant(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusvariant.html#variant">QDBusVariant::variant()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object variant(){
        return variant_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.Object variant_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QDBusVariant(QPrivateConstructor p) { super(p); } 
    

    @Override
    @io.qt.QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.dbus.QDBusVariant) {
            return operator_equal((io.qt.dbus.QDBusVariant) other);
        }

        return false;
    }

}
