package io.qt.dbus;


/**
 * <p>Enables the programmer to identify the SIGNATURE type provided by the D-Bus typesystem</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qdbussignature.html">QDBusSignature</a></p>
 */
public class QDBusSignature extends io.qt.QtObject
    implements java.lang.Comparable<io.qt.dbus.QDBusSignature>,
            java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbussignature.html#QDBusSignature">QDBusSignature::QDBusSignature()</a></p>
     */
    public QDBusSignature(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QDBusSignature instance);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbussignature.html#QDBusSignature-3">QDBusSignature::QDBusSignature(QString)</a></p>
     */
    public QDBusSignature(java.lang.String signature){
        super((QPrivateConstructor)null);
        initialize_native(this, signature);
    }
    
    private native static void initialize_native(QDBusSignature instance, java.lang.String signature);
    
    @io.qt.QtUninvokable
    private final boolean operator_less(io.qt.dbus.QDBusSignature rhs){
        return operator_less_native_cref_QDBusSignature(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rhs));
    }
    
    @io.qt.QtUninvokable
    private native boolean operator_less_native_cref_QDBusSignature(long __this__nativeId, long rhs);
    
    @io.qt.QtUninvokable
    private final boolean operator_equal(io.qt.dbus.QDBusSignature rhs){
        return operator_equal_native_cref_QDBusSignature(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rhs));
    }
    
    @io.qt.QtUninvokable
    private native boolean operator_equal_native_cref_QDBusSignature(long __this__nativeId, long rhs);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbussignature.html#setSignature">QDBusSignature::setSignature(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setSignature(java.lang.String signature){
        setSignature_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), signature);
    }
    
    @io.qt.QtUninvokable
    private native void setSignature_native_cref_QString(long __this__nativeId, java.lang.String signature);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbussignature.html#signature">QDBusSignature::signature()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String signature(){
        return signature_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String signature_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbussignature.html#swap">QDBusSignature::swap(QDBusSignature&amp;)</a></p>
     */
    @io.qt.QtUninvokable
    public final void swap(io.qt.dbus.QDBusSignature other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QDBusSignature(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native void swap_native_ref_QDBusSignature(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QDBusSignature(QPrivateConstructor p) { super(p); } 
    

    @Override
    @io.qt.QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.dbus.QDBusSignature) {
            return operator_equal((io.qt.dbus.QDBusSignature) other);
        }

        return false;
    }

    @io.qt.QtUninvokable
    public int compareTo(io.qt.dbus.QDBusSignature other) {
        if (equals(other)) return 0;
        else if (operator_less(other)) return -1;
        else return 1;
    }


    @io.qt.QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @io.qt.QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    @Override
    public QDBusSignature clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private native QDBusSignature clone_native(long __this_nativeId);
}
