package io.qt.dbus;


/**
 * <p>Allows the user to watch for a bus service change</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qdbusservicewatcher.html">QDBusServiceWatcher</a></p>
 */
public class QDBusServiceWatcher extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QDBusServiceWatcher.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qdbusservicewatcher.html#WatchModeFlag-enum">QDBusServiceWatcher::WatchModeFlag</a></p>
     * 
     * @see WatchMode
     */
    public enum WatchModeFlag implements io.qt.QtFlagEnumerator {
        WatchForRegistration(1),
        WatchForUnregistration(2),
        WatchForOwnerChange(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private WatchModeFlag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public WatchMode asFlags() {
            return new WatchMode(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public WatchMode combined(WatchModeFlag e) {
            return new WatchMode(this, e);
        }

        /**
         * Creates a new {@link WatchMode} from the entries.
         * @param values entries
         * @return new flag
         */
        public static WatchMode flags(WatchModeFlag ... values) {
            return new WatchMode(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static WatchModeFlag resolve(int value) {
            switch (value) {
            case 1: return WatchForRegistration;
            case 2: return WatchForUnregistration;
            case 3: return WatchForOwnerChange;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link WatchModeFlag}
     */
    public static final class WatchMode extends io.qt.QFlags<WatchModeFlag> implements Comparable<WatchMode> {
        private static final long serialVersionUID = 0x6219434d7a312e1dL;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new WatchMode where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public WatchMode(WatchModeFlag ... args){
            super(args);
        }

        /**
         * Creates a new WatchMode with given <code>value</code>.
         * @param value
         */
        public WatchMode(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new WatchMode
         */
        @Override
        public final WatchMode combined(WatchModeFlag e){
            return new WatchMode(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final WatchMode setFlag(WatchModeFlag e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final WatchMode setFlag(WatchModeFlag e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this WatchMode.
         * @return array of enum entries
         */
        @Override
        public final WatchModeFlag[] flags(){
            return super.flags(WatchModeFlag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final WatchMode clone(){
            return new WatchMode(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(WatchMode other){
            return Integer.compare(value(), other.value());
        }
    }
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusservicewatcher.html#serviceOwnerChanged">QDBusServiceWatcher::serviceOwnerChanged(QString,QString,QString)</a></p>
     */
    public final Signal3<java.lang.String, java.lang.String, java.lang.String> serviceOwnerChanged = new Signal3<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusservicewatcher.html#serviceRegistered">QDBusServiceWatcher::serviceRegistered(QString)</a></p>
     */
    public final Signal1<java.lang.String> serviceRegistered = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusservicewatcher.html#serviceUnregistered">QDBusServiceWatcher::serviceUnregistered(QString)</a></p>
     */
    public final Signal1<java.lang.String> serviceUnregistered = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QDBusServiceWatcher(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QDBusServiceWatcher() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusservicewatcher.html#QDBusServiceWatcher">QDBusServiceWatcher::QDBusServiceWatcher(QObject*)</a></p>
     */
    public QDBusServiceWatcher(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QDBusServiceWatcher instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusservicewatcher.html#addWatchedService">QDBusServiceWatcher::addWatchedService(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addWatchedService(java.lang.String newService){
        addWatchedService_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), newService);
    }
    
    @io.qt.QtUninvokable
    private native void addWatchedService_native_cref_QString(long __this__nativeId, java.lang.String newService);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusservicewatcher.html#removeWatchedService">QDBusServiceWatcher::removeWatchedService(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean removeWatchedService(java.lang.String service){
        return removeWatchedService_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), service);
    }
    
    @io.qt.QtUninvokable
    private native boolean removeWatchedService_native_cref_QString(long __this__nativeId, java.lang.String service);
    
    /**
     * <p>Overloaded function for {@link #setWatchMode(io.qt.dbus.QDBusServiceWatcher.WatchMode)}.</p>
     */
    @io.qt.QtUninvokable
    public final void setWatchMode(io.qt.dbus.QDBusServiceWatcher.WatchModeFlag ... mode){
        setWatchMode(new io.qt.dbus.QDBusServiceWatcher.WatchMode(mode));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusservicewatcher.html#watchMode-prop">QDBusServiceWatcher::setWatchMode(QDBusServiceWatcher::WatchMode)</a></p>
     */
    @io.qt.QtPropertyWriter(name="watchMode")
    @io.qt.QtUninvokable
    public final void setWatchMode(io.qt.dbus.QDBusServiceWatcher.WatchMode mode){
        setWatchMode_native_QFlags_QDBusServiceWatcher_WatchModeFlag_(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    @io.qt.QtUninvokable
    private native void setWatchMode_native_QFlags_QDBusServiceWatcher_WatchModeFlag_(long __this__nativeId, int mode);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusservicewatcher.html#setWatchedServices">QDBusServiceWatcher::setWatchedServices(QStringList)</a></p>
     */
    @io.qt.QtPropertyWriter(name="watchedServices")
    @io.qt.QtUninvokable
    public final void setWatchedServices(java.util.Collection<java.lang.String> services){
        setWatchedServices_native_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), services);
    }
    
    @io.qt.QtUninvokable
    private native void setWatchedServices_native_cref_QStringList(long __this__nativeId, java.util.Collection<java.lang.String> services);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusservicewatcher.html#watchMode-prop">QDBusServiceWatcher::watchMode()const</a></p>
     */
    @io.qt.QtPropertyReader(name="watchMode")
    @io.qt.QtUninvokable
    public final io.qt.dbus.QDBusServiceWatcher.WatchMode watchMode(){
        return new io.qt.dbus.QDBusServiceWatcher.WatchMode(watchMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int watchMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusservicewatcher.html#watchedServices">QDBusServiceWatcher::watchedServices()const</a></p>
     */
    @io.qt.QtPropertyReader(name="watchedServices")
    @io.qt.QtUninvokable
    public final io.qt.core.QStringList watchedServices(){
        return watchedServices_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QStringList watchedServices_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QDBusServiceWatcher(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QDBusServiceWatcher(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QDBusServiceWatcher instance, QDeclarativeConstructor constructor);
    
}
