package io.qt.dbus;


/**
 * <p>Represents one message sent or received over the D-Bus bus</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qdbusmessage.html">QDBusMessage</a></p>
 */
public class QDBusMessage extends io.qt.QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qdbusmessage.html#MessageType-enum">QDBusMessage::MessageType</a></p>
     */
    public enum MessageType implements io.qt.QtEnumerator {
        InvalidMessage(0),
        MethodCallMessage(1),
        ReplyMessage(2),
        ErrorMessage(3),
        SignalMessage(4);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private MessageType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static MessageType resolve(int value) {
            switch (value) {
            case 0: return InvalidMessage;
            case 1: return MethodCallMessage;
            case 2: return ReplyMessage;
            case 3: return ErrorMessage;
            case 4: return SignalMessage;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusmessage.html#QDBusMessage">QDBusMessage::QDBusMessage()</a></p>
     */
    public QDBusMessage(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QDBusMessage instance);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusmessage.html#QDBusMessage-1">QDBusMessage::QDBusMessage(QDBusMessage)</a></p>
     */
    public QDBusMessage(io.qt.dbus.QDBusMessage other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QDBusMessage instance, io.qt.dbus.QDBusMessage other);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusmessage.html#arguments">QDBusMessage::arguments()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<java.lang.Object> arguments(){
        return arguments_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<java.lang.Object> arguments_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusmessage.html#autoStartService">QDBusMessage::autoStartService()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean autoStartService(){
        return autoStartService_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean autoStartService_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusmessage.html#createErrorReply-2">QDBusMessage::createErrorReply(QDBusError::ErrorType,QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.dbus.QDBusMessage createErrorReply(io.qt.dbus.QDBusError.ErrorType type, java.lang.String msg){
        return createErrorReply_native_QDBusError_ErrorType_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), type.value(), msg);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.dbus.QDBusMessage createErrorReply_native_QDBusError_ErrorType_cref_QString_constfct(long __this__nativeId, int type, java.lang.String msg);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusmessage.html#createErrorReply-1">QDBusMessage::createErrorReply(QDBusError)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.dbus.QDBusMessage createErrorReply(io.qt.dbus.QDBusError err){
        return createErrorReply_native_cref_QDBusError_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(err));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.dbus.QDBusMessage createErrorReply_native_cref_QDBusError_constfct(long __this__nativeId, long err);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusmessage.html#createErrorReply">QDBusMessage::createErrorReply(QString,QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.dbus.QDBusMessage createErrorReply(java.lang.String name, java.lang.String msg){
        return createErrorReply_native_const_QString_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name, msg);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.dbus.QDBusMessage createErrorReply_native_const_QString_cref_QString_constfct(long __this__nativeId, java.lang.String name, java.lang.String msg);
    
    /**
     * <p>Overloaded function for {@link #createReply(java.util.Collection)}
     *  with <code>arguments = java.util.Collections.emptyList()</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.dbus.QDBusMessage createReply() {
        return createReply(java.util.Collections.emptyList());
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusmessage.html#createReply">QDBusMessage::createReply(QList&lt;QVariant&gt;)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.dbus.QDBusMessage createReply(java.util.Collection<? extends java.lang.Object> arguments){
        return createReply_native_cref_QList_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), arguments);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.dbus.QDBusMessage createReply_native_cref_QList_constfct(long __this__nativeId, java.util.Collection<? extends java.lang.Object> arguments);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusmessage.html#createReply-1">QDBusMessage::createReply(QVariant)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.dbus.QDBusMessage createReply(java.lang.Object argument){
        return createReply_native_cref_QVariant_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), argument);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.dbus.QDBusMessage createReply_native_cref_QVariant_constfct(long __this__nativeId, java.lang.Object argument);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusmessage.html#errorMessage">QDBusMessage::errorMessage()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String errorMessage(){
        return errorMessage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String errorMessage_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusmessage.html#errorName">QDBusMessage::errorName()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String errorName(){
        return errorName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String errorName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusmessage.html#interface">QDBusMessage::interface()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String interfaceName(){
        return interfaceName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String interfaceName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusmessage.html#isDelayedReply">QDBusMessage::isDelayedReply()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isDelayedReply(){
        return isDelayedReply_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isDelayedReply_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusmessage.html#isInteractiveAuthorizationAllowed">QDBusMessage::isInteractiveAuthorizationAllowed()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isInteractiveAuthorizationAllowed(){
        return isInteractiveAuthorizationAllowed_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isInteractiveAuthorizationAllowed_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusmessage.html#isReplyRequired">QDBusMessage::isReplyRequired()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isReplyRequired(){
        return isReplyRequired_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isReplyRequired_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusmessage.html#member">QDBusMessage::member()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String member(){
        return member_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String member_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusmessage.html#path">QDBusMessage::path()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String path(){
        return path_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String path_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusmessage.html#service">QDBusMessage::service()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String service(){
        return service_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String service_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusmessage.html#setArguments">QDBusMessage::setArguments(QList&lt;QVariant&gt;)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setArguments(java.util.Collection<? extends java.lang.Object> arguments){
        setArguments_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), arguments);
    }
    
    @io.qt.QtUninvokable
    private native void setArguments_native_cref_QList(long __this__nativeId, java.util.Collection<? extends java.lang.Object> arguments);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusmessage.html#setAutoStartService">QDBusMessage::setAutoStartService(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setAutoStartService(boolean enable){
        setAutoStartService_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @io.qt.QtUninvokable
    private native void setAutoStartService_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusmessage.html#setDelayedReply">QDBusMessage::setDelayedReply(bool)const</a></p>
     */
    @io.qt.QtUninvokable
    public final void setDelayedReply(boolean enable){
        setDelayedReply_native_bool_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @io.qt.QtUninvokable
    private native void setDelayedReply_native_bool_constfct(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusmessage.html#setInteractiveAuthorizationAllowed">QDBusMessage::setInteractiveAuthorizationAllowed(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setInteractiveAuthorizationAllowed(boolean enable){
        setInteractiveAuthorizationAllowed_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @io.qt.QtUninvokable
    private native void setInteractiveAuthorizationAllowed_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusmessage.html#signature">QDBusMessage::signature()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String signature(){
        return signature_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String signature_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusmessage.html#swap">QDBusMessage::swap(QDBusMessage&amp;)</a></p>
     */
    @io.qt.QtUninvokable
    public final void swap(io.qt.dbus.QDBusMessage other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QDBusMessage(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native void swap_native_ref_QDBusMessage(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusmessage.html#type">QDBusMessage::type()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.dbus.QDBusMessage.MessageType type(){
        return io.qt.dbus.QDBusMessage.MessageType.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int type_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusmessage.html#createError-2">QDBusMessage::createError(QDBusError::ErrorType,QString)</a></p>
     */
    public static io.qt.dbus.QDBusMessage createError(io.qt.dbus.QDBusError.ErrorType type, java.lang.String msg){
        return createError_native_QDBusError_ErrorType_cref_QString(type.value(), msg);
    }
    
    private native static io.qt.dbus.QDBusMessage createError_native_QDBusError_ErrorType_cref_QString(int type, java.lang.String msg);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusmessage.html#createError-1">QDBusMessage::createError(QDBusError)</a></p>
     */
    public static io.qt.dbus.QDBusMessage createError(io.qt.dbus.QDBusError err){
        return createError_native_cref_QDBusError(QtJambi_LibraryUtilities.internal.checkedNativeId(err));
    }
    
    private native static io.qt.dbus.QDBusMessage createError_native_cref_QDBusError(long err);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusmessage.html#createError">QDBusMessage::createError(QString,QString)</a></p>
     */
    public native static io.qt.dbus.QDBusMessage createError(java.lang.String name, java.lang.String msg);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusmessage.html#createMethodCall">QDBusMessage::createMethodCall(QString,QString,QString,QString)</a></p>
     */
    public native static io.qt.dbus.QDBusMessage createMethodCall(java.lang.String destination, java.lang.String path, java.lang.String arg__interface, java.lang.String method);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusmessage.html#createSignal">QDBusMessage::createSignal(QString,QString,QString)</a></p>
     */
    public native static io.qt.dbus.QDBusMessage createSignal(java.lang.String path, java.lang.String arg__interface, java.lang.String name);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdbusmessage.html#createTargetedSignal">QDBusMessage::createTargetedSignal(QString,QString,QString,QString)</a></p>
     */
    public native static io.qt.dbus.QDBusMessage createTargetedSignal(java.lang.String service, java.lang.String path, java.lang.String arg__interface, java.lang.String name);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QDBusMessage(QPrivateConstructor p) { super(p); } 
    

    @Override
    @io.qt.QtUninvokable
    public String toString() {
        return toString_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @io.qt.QtUninvokable
    private static native String toString_native(long __this_nativeId);
    
    @Override
    public QDBusMessage clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private native QDBusMessage clone_native(long __this_nativeId);
}
