#include <QtCore/QtGlobal>
#include <QtDBus/qdbusconnection.h>
#include <QtCore/QVariant>
#include <QDBusConnection>
#include <QtDBus/qdbuserror.h>
#include <QtDBus/qdbusmessage.h>
#include <QtCore/qobject.h>
#include <QtDBus/qdbuspendingcall.h>
#include <QtCore/QStringList>
#include <QtDBus/qdbusconnectioninterface.h>
#include <QtCore/qbytearray.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QDBusConnection(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QDBusConnection")
    QDBusConnection *_ptr = reinterpret_cast<QDBusConnection *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QDBusConnection(QDBusConnection)
void __qt_construct_QDBusConnection_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QDBusConnection(QDBusConnection)")
    jobject other0 = __java_arguments[0].l;
    const QDBusConnection& __qt_other0 = qtjambi_cast<const QDBusConnection& >(__jni_env, other0);
    QDBusConnection *__qt_this = new(__qtjambi_ptr) QDBusConnection(__qt_other0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QDBusConnection(QString)
void __qt_construct_QDBusConnection_1(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QDBusConnection(QString)")
    jstring name0 = static_cast<jstring>(__java_arguments[0].l);
    QString  __qt_name0 = qtjambi_cast<QString >(__jni_env, name0);
    QDBusConnection *__qt_this = new(__qtjambi_ptr) QDBusConnection(__qt_name0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// destruct QDBusConnection
void __qt_destruct_QDBusConnection(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QDBusConnection")
    reinterpret_cast<QDBusConnection*>(ptr)->~QDBusConnection();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QDBusConnection::QDBusConnection(QDBusConnection)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusConnection_initialize_1native__Lio_qt_dbus_QDBusConnection_2Lio_qt_dbus_QDBusConnection_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDBusConnection::QDBusConnection(QDBusConnection)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QDBusConnection_0, sizeof(QDBusConnection), typeid(QDBusConnection), false, &deleter_QDBusConnection, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDBusConnection::QDBusConnection(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusConnection_initialize_1native__Lio_qt_dbus_QDBusConnection_2Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jstring name0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDBusConnection::QDBusConnection(QString)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = name0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QDBusConnection_1, sizeof(QDBusConnection), typeid(QDBusConnection), false, &deleter_QDBusConnection, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDBusConnection::asyncCall(QDBusMessage,int)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusConnection_asyncCall_1native_1cref_1QDBusMessage_1int_1constfct__JJI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID message0,
 jint timeout1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusConnection *__qt_this = QtJambiAPI::objectFromNativeId<QDBusConnection>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusConnection::asyncCall(QDBusMessage,int)const", __qt_this)
        const QDBusMessage& __qt_message0 = QtJambiAPI::valueReferenceFromNativeId<QDBusMessage>(message0);
        QDBusPendingCall __qt_return_value = __qt_this->asyncCall(__qt_message0, static_cast<int>(timeout1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusConnection::baseService()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusConnection_baseService_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusConnection *__qt_this = QtJambiAPI::objectFromNativeId<QDBusConnection>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusConnection::baseService()const", __qt_this)
        QString __qt_return_value = __qt_this->baseService();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusConnection::call(QDBusMessage,QDBus::CallMode,int)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusConnection_call_1native_1cref_1QDBusMessage_1QDBus_1CallMode_1int_1constfct__JJII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID message0,
 jint mode1,
 jint timeout2)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusConnection *__qt_this = QtJambiAPI::objectFromNativeId<QDBusConnection>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusConnection::call(QDBusMessage,QDBus::CallMode,int)const", __qt_this)
        const QDBusMessage& __qt_message0 = QtJambiAPI::valueReferenceFromNativeId<QDBusMessage>(message0);
        QDBus::CallMode __qt_mode1 = qtjambi_cast<QDBus::CallMode>(__jni_env, mode1);
        QDBusMessage __qt_return_value = __qt_this->call(__qt_message0, QDBus::CallMode(__qt_mode1), static_cast<int>(timeout2));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusConnection::callWithCallback(QDBusMessage,QObject*,const char*,const char*,int)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusConnection_callWithCallback_1native_1cref_1QDBusMessage_1QObject_1ptr_1const_1char_1ptr_1const_1char_1ptr_1int_1constfct__JJJLjava_lang_String_2Ljava_lang_String_2I)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID message0,
 QtJambiNativeID receiver1,
 jstring returnMethod2,
 jstring errorMethod3,
 jint timeout4)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusConnection *__qt_this = QtJambiAPI::objectFromNativeId<QDBusConnection>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusConnection::callWithCallback(QDBusMessage,QObject*,const char*,const char*,int)const", __qt_this)
        const QDBusMessage& __qt_message0 = QtJambiAPI::valueReferenceFromNativeId<QDBusMessage>(message0);
        QObject* __qt_receiver1 = QtJambiAPI::objectFromNativeId<QObject>(receiver1);
        const char*  __qt_returnMethod2 = qtjambi_cast<const char* >(__jni_env, __qtjambi_scope, returnMethod2);
        const char*  __qt_errorMethod3 = qtjambi_cast<const char* >(__jni_env, __qtjambi_scope, errorMethod3);
        __java_return_value = __qt_this->callWithCallback(__qt_message0, __qt_receiver1, __qt_returnMethod2, __qt_errorMethod3, static_cast<int>(timeout4));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusConnection::callWithCallback(QDBusMessage,QObject*,const char*,int)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusConnection_callWithCallback_1native_1cref_1QDBusMessage_1QObject_1ptr_1const_1char_1ptr_1int_1constfct__JJJLjava_lang_String_2I)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID message0,
 QtJambiNativeID receiver1,
 jstring slot2,
 jint timeout3)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusConnection *__qt_this = QtJambiAPI::objectFromNativeId<QDBusConnection>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusConnection::callWithCallback(QDBusMessage,QObject*,const char*,int)const", __qt_this)
        const QDBusMessage& __qt_message0 = QtJambiAPI::valueReferenceFromNativeId<QDBusMessage>(message0);
        QObject* __qt_receiver1 = QtJambiAPI::objectFromNativeId<QObject>(receiver1);
        const char*  __qt_slot2 = qtjambi_cast<const char* >(__jni_env, __qtjambi_scope, slot2);
        __java_return_value = __qt_this->callWithCallback(__qt_message0, __qt_receiver1, __qt_slot2, static_cast<int>(timeout3));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusConnection::connect(QString,QString,QString,QString,QObject*,const char*)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusConnection_connect_1native_1cref_1QString_1cref_1QString_1cref_1QString_1cref_1QString_1QObject_1ptr_1const_1char_1ptr__JLjava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring service0,
 jstring path1,
 jstring interface2,
 jstring name3,
 QtJambiNativeID receiver4,
 jstring slot5)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QDBusConnection *__qt_this = QtJambiAPI::objectFromNativeId<QDBusConnection>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusConnection::connect(QString,QString,QString,QString,QObject*,const char*)", __qt_this)
        QString  __qt_service0 = qtjambi_cast<QString >(__jni_env, service0);
        QString  __qt_path1 = qtjambi_cast<QString >(__jni_env, path1);
        QString  __qt_interface2 = qtjambi_cast<QString >(__jni_env, interface2);
        QString  __qt_name3 = qtjambi_cast<QString >(__jni_env, name3);
        QObject* __qt_receiver4 = QtJambiAPI::objectFromNativeId<QObject>(receiver4);
        const char*  __qt_slot5 = qtjambi_cast<const char* >(__jni_env, __qtjambi_scope, slot5);
        __java_return_value = __qt_this->connect(__qt_service0, __qt_path1, __qt_interface2, __qt_name3, __qt_receiver4, __qt_slot5);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusConnection::connect(QString,QString,QString,QString,QString,QObject*,const char*)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusConnection_connect_1native_1cref_1QString_1cref_1QString_1cref_1QString_1cref_1QString_1cref_1QString_1QObject_1ptr_1const_1char_1ptr__JLjava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring service0,
 jstring path1,
 jstring interface2,
 jstring name3,
 jstring signature4,
 QtJambiNativeID receiver5,
 jstring slot6)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QDBusConnection *__qt_this = QtJambiAPI::objectFromNativeId<QDBusConnection>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusConnection::connect(QString,QString,QString,QString,QString,QObject*,const char*)", __qt_this)
        QString  __qt_service0 = qtjambi_cast<QString >(__jni_env, service0);
        QString  __qt_path1 = qtjambi_cast<QString >(__jni_env, path1);
        QString  __qt_interface2 = qtjambi_cast<QString >(__jni_env, interface2);
        QString  __qt_name3 = qtjambi_cast<QString >(__jni_env, name3);
        QString  __qt_signature4 = qtjambi_cast<QString >(__jni_env, signature4);
        QObject* __qt_receiver5 = QtJambiAPI::objectFromNativeId<QObject>(receiver5);
        const char*  __qt_slot6 = qtjambi_cast<const char* >(__jni_env, __qtjambi_scope, slot6);
        __java_return_value = __qt_this->connect(__qt_service0, __qt_path1, __qt_interface2, __qt_name3, __qt_signature4, __qt_receiver5, __qt_slot6);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusConnection::connect(QString,QString,QString,QString,QStringList,QString,QObject*,const char*)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusConnection_connect_1native_1cref_1QString_1cref_1QString_1cref_1QString_1cref_1QString_1cref_1QStringList_1cref_1QString_1QObject_1ptr_1const_1char_1ptr__JLjava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2Ljava_util_Collection_2Ljava_lang_String_2JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring service0,
 jstring path1,
 jstring interface2,
 jstring name3,
 jobject argumentMatch4,
 jstring signature5,
 QtJambiNativeID receiver6,
 jstring slot7)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QDBusConnection *__qt_this = QtJambiAPI::objectFromNativeId<QDBusConnection>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusConnection::connect(QString,QString,QString,QString,QStringList,QString,QObject*,const char*)", __qt_this)
        QString  __qt_service0 = qtjambi_cast<QString >(__jni_env, service0);
        QString  __qt_path1 = qtjambi_cast<QString >(__jni_env, path1);
        QString  __qt_interface2 = qtjambi_cast<QString >(__jni_env, interface2);
        QString  __qt_name3 = qtjambi_cast<QString >(__jni_env, name3);
        const QStringList&  __qt_argumentMatch4 = qtjambi_cast<const QStringList& >(__jni_env, __qtjambi_scope, argumentMatch4);
        QString  __qt_signature5 = qtjambi_cast<QString >(__jni_env, signature5);
        QObject* __qt_receiver6 = QtJambiAPI::objectFromNativeId<QObject>(receiver6);
        const char*  __qt_slot7 = qtjambi_cast<const char* >(__jni_env, __qtjambi_scope, slot7);
        __java_return_value = __qt_this->connect(__qt_service0, __qt_path1, __qt_interface2, __qt_name3, __qt_argumentMatch4, __qt_signature5, __qt_receiver6, __qt_slot7);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusConnection::connectionCapabilities()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusConnection_connectionCapabilities_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusConnection *__qt_this = QtJambiAPI::objectFromNativeId<QDBusConnection>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusConnection::connectionCapabilities()const", __qt_this)
        QDBusConnection::ConnectionCapabilities __qt_return_value = __qt_this->connectionCapabilities();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusConnection::disconnect(QString,QString,QString,QString,QObject*,const char*)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusConnection_disconnect_1native_1cref_1QString_1cref_1QString_1cref_1QString_1cref_1QString_1QObject_1ptr_1const_1char_1ptr__JLjava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring service0,
 jstring path1,
 jstring interface2,
 jstring name3,
 QtJambiNativeID receiver4,
 jstring slot5)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QDBusConnection *__qt_this = QtJambiAPI::objectFromNativeId<QDBusConnection>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusConnection::disconnect(QString,QString,QString,QString,QObject*,const char*)", __qt_this)
        QString  __qt_service0 = qtjambi_cast<QString >(__jni_env, service0);
        QString  __qt_path1 = qtjambi_cast<QString >(__jni_env, path1);
        QString  __qt_interface2 = qtjambi_cast<QString >(__jni_env, interface2);
        QString  __qt_name3 = qtjambi_cast<QString >(__jni_env, name3);
        QObject* __qt_receiver4 = QtJambiAPI::objectFromNativeId<QObject>(receiver4);
        const char*  __qt_slot5 = qtjambi_cast<const char* >(__jni_env, __qtjambi_scope, slot5);
        __java_return_value = __qt_this->disconnect(__qt_service0, __qt_path1, __qt_interface2, __qt_name3, __qt_receiver4, __qt_slot5);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusConnection::disconnect(QString,QString,QString,QString,QString,QObject*,const char*)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusConnection_disconnect_1native_1cref_1QString_1cref_1QString_1cref_1QString_1cref_1QString_1cref_1QString_1QObject_1ptr_1const_1char_1ptr__JLjava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring service0,
 jstring path1,
 jstring interface2,
 jstring name3,
 jstring signature4,
 QtJambiNativeID receiver5,
 jstring slot6)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QDBusConnection *__qt_this = QtJambiAPI::objectFromNativeId<QDBusConnection>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusConnection::disconnect(QString,QString,QString,QString,QString,QObject*,const char*)", __qt_this)
        QString  __qt_service0 = qtjambi_cast<QString >(__jni_env, service0);
        QString  __qt_path1 = qtjambi_cast<QString >(__jni_env, path1);
        QString  __qt_interface2 = qtjambi_cast<QString >(__jni_env, interface2);
        QString  __qt_name3 = qtjambi_cast<QString >(__jni_env, name3);
        QString  __qt_signature4 = qtjambi_cast<QString >(__jni_env, signature4);
        QObject* __qt_receiver5 = QtJambiAPI::objectFromNativeId<QObject>(receiver5);
        const char*  __qt_slot6 = qtjambi_cast<const char* >(__jni_env, __qtjambi_scope, slot6);
        __java_return_value = __qt_this->disconnect(__qt_service0, __qt_path1, __qt_interface2, __qt_name3, __qt_signature4, __qt_receiver5, __qt_slot6);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusConnection::disconnect(QString,QString,QString,QString,QStringList,QString,QObject*,const char*)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusConnection_disconnect_1native_1cref_1QString_1cref_1QString_1cref_1QString_1cref_1QString_1cref_1QStringList_1cref_1QString_1QObject_1ptr_1const_1char_1ptr__JLjava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2Ljava_util_Collection_2Ljava_lang_String_2JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring service0,
 jstring path1,
 jstring interface2,
 jstring name3,
 jobject argumentMatch4,
 jstring signature5,
 QtJambiNativeID receiver6,
 jstring slot7)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QDBusConnection *__qt_this = QtJambiAPI::objectFromNativeId<QDBusConnection>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusConnection::disconnect(QString,QString,QString,QString,QStringList,QString,QObject*,const char*)", __qt_this)
        QString  __qt_service0 = qtjambi_cast<QString >(__jni_env, service0);
        QString  __qt_path1 = qtjambi_cast<QString >(__jni_env, path1);
        QString  __qt_interface2 = qtjambi_cast<QString >(__jni_env, interface2);
        QString  __qt_name3 = qtjambi_cast<QString >(__jni_env, name3);
        const QStringList&  __qt_argumentMatch4 = qtjambi_cast<const QStringList& >(__jni_env, __qtjambi_scope, argumentMatch4);
        QString  __qt_signature5 = qtjambi_cast<QString >(__jni_env, signature5);
        QObject* __qt_receiver6 = QtJambiAPI::objectFromNativeId<QObject>(receiver6);
        const char*  __qt_slot7 = qtjambi_cast<const char* >(__jni_env, __qtjambi_scope, slot7);
        __java_return_value = __qt_this->disconnect(__qt_service0, __qt_path1, __qt_interface2, __qt_name3, __qt_argumentMatch4, __qt_signature5, __qt_receiver6, __qt_slot7);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusConnection::interface()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusConnection_connectionInterface_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusConnection *__qt_this = QtJambiAPI::objectFromNativeId<QDBusConnection>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusConnection::interface()const", __qt_this)
        QDBusConnectionInterface* __qt_return_value = __qt_this->interface();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusConnection::isConnected()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusConnection_isConnected_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusConnection *__qt_this = QtJambiAPI::objectFromNativeId<QDBusConnection>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusConnection::isConnected()const", __qt_this)
        __java_return_value = __qt_this->isConnected();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusConnection::lastError()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusConnection_lastError_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusConnection *__qt_this = QtJambiAPI::objectFromNativeId<QDBusConnection>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusConnection::lastError()const", __qt_this)
        QDBusError __qt_return_value = __qt_this->lastError();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusConnection::name()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusConnection_name_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusConnection *__qt_this = QtJambiAPI::objectFromNativeId<QDBusConnection>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusConnection::name()const", __qt_this)
        QString __qt_return_value = __qt_this->name();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusConnection::objectRegisteredAt(QString)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusConnection_objectRegisteredAt_1native_1cref_1QString_1constfct__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring path0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusConnection *__qt_this = QtJambiAPI::objectFromNativeId<QDBusConnection>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusConnection::objectRegisteredAt(QString)const", __qt_this)
        QString  __qt_path0 = qtjambi_cast<QString >(__jni_env, path0);
        QObject* __qt_return_value = __qt_this->objectRegisteredAt(__qt_path0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusConnection::operator=(QDBusConnection)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusConnection_assign_1native_1cref_1QDBusConnection__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDBusConnection *__qt_this = QtJambiAPI::objectFromNativeId<QDBusConnection>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusConnection::operator=(QDBusConnection)", __qt_this)
        const QDBusConnection& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QDBusConnection>(__jni_env, other0);
        (*__qt_this) = __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDBusConnection::registerObject(QString,QObject*,QDBusConnection::RegisterOptions)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusConnection_registerObject_1native_1cref_1QString_1QObject_1ptr_1QDBusConnection_1RegisterOptions__JLjava_lang_String_2JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring path0,
 QtJambiNativeID object1,
 jint options2)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QDBusConnection *__qt_this = QtJambiAPI::objectFromNativeId<QDBusConnection>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusConnection::registerObject(QString,QObject*,QDBusConnection::RegisterOptions)", __qt_this)
        QString  __qt_path0 = qtjambi_cast<QString >(__jni_env, path0);
        QObject* __qt_object1 = QtJambiAPI::objectFromNativeId<QObject>(object1);
        QDBusConnection::RegisterOptions __qt_options2 = qtjambi_cast<QDBusConnection::RegisterOptions>(__jni_env, options2);
        __java_return_value = __qt_this->registerObject(__qt_path0, __qt_object1, QDBusConnection::RegisterOptions(__qt_options2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusConnection::registerObject(QString,QString,QObject*,QDBusConnection::RegisterOptions)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusConnection_registerObject_1native_1cref_1QString_1cref_1QString_1QObject_1ptr_1QDBusConnection_1RegisterOptions__JLjava_lang_String_2Ljava_lang_String_2JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring path0,
 jstring interface1,
 QtJambiNativeID object2,
 jint options3)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QDBusConnection *__qt_this = QtJambiAPI::objectFromNativeId<QDBusConnection>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusConnection::registerObject(QString,QString,QObject*,QDBusConnection::RegisterOptions)", __qt_this)
        QString  __qt_path0 = qtjambi_cast<QString >(__jni_env, path0);
        QString  __qt_interface1 = qtjambi_cast<QString >(__jni_env, interface1);
        QObject* __qt_object2 = QtJambiAPI::objectFromNativeId<QObject>(object2);
        QDBusConnection::RegisterOptions __qt_options3 = qtjambi_cast<QDBusConnection::RegisterOptions>(__jni_env, options3);
        __java_return_value = __qt_this->registerObject(__qt_path0, __qt_interface1, __qt_object2, QDBusConnection::RegisterOptions(__qt_options3));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusConnection::registerService(QString)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusConnection_registerService_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring serviceName0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QDBusConnection *__qt_this = QtJambiAPI::objectFromNativeId<QDBusConnection>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusConnection::registerService(QString)", __qt_this)
        QString  __qt_serviceName0 = qtjambi_cast<QString >(__jni_env, serviceName0);
        __java_return_value = __qt_this->registerService(__qt_serviceName0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusConnection::send(QDBusMessage)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusConnection_send_1native_1cref_1QDBusMessage_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID message0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusConnection *__qt_this = QtJambiAPI::objectFromNativeId<QDBusConnection>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusConnection::send(QDBusMessage)const", __qt_this)
        const QDBusMessage& __qt_message0 = QtJambiAPI::valueReferenceFromNativeId<QDBusMessage>(message0);
        __java_return_value = __qt_this->send(__qt_message0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusConnection::swap(QDBusConnection&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusConnection_swap_1native_1ref_1QDBusConnection__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDBusConnection *__qt_this = QtJambiAPI::objectFromNativeId<QDBusConnection>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusConnection::swap(QDBusConnection&)", __qt_this)
        QDBusConnection& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QDBusConnection>(__jni_env, other0);
        __qt_this->swap(__qt_other0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDBusConnection::unregisterObject(QString,QDBusConnection::UnregisterMode)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusConnection_unregisterObject_1native_1cref_1QString_1QDBusConnection_1UnregisterMode__JLjava_lang_String_2I)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring path0,
 jint mode1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDBusConnection *__qt_this = QtJambiAPI::objectFromNativeId<QDBusConnection>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusConnection::unregisterObject(QString,QDBusConnection::UnregisterMode)", __qt_this)
        QString  __qt_path0 = qtjambi_cast<QString >(__jni_env, path0);
        QDBusConnection::UnregisterMode __qt_mode1 = qtjambi_cast<QDBusConnection::UnregisterMode>(__jni_env, mode1);
        __qt_this->unregisterObject(__qt_path0, QDBusConnection::UnregisterMode(__qt_mode1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDBusConnection::unregisterService(QString)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusConnection_unregisterService_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring serviceName0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QDBusConnection *__qt_this = QtJambiAPI::objectFromNativeId<QDBusConnection>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusConnection::unregisterService(QString)", __qt_this)
        QString  __qt_serviceName0 = qtjambi_cast<QString >(__jni_env, serviceName0);
        __java_return_value = __qt_this->unregisterService(__qt_serviceName0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusConnection::connectToBus(QDBusConnection::BusType,QString)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusConnection_connectToBus_1native_1QDBusConnection_1BusType_1cref_1QString__ILjava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 jint type0,
 jstring name1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDBusConnection::connectToBus(QDBusConnection::BusType,QString)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDBusConnection::BusType __qt_type0 = qtjambi_cast<QDBusConnection::BusType>(__jni_env, type0);
        QString  __qt_name1 = qtjambi_cast<QString >(__jni_env, name1);
        QDBusConnection __qt_return_value = QDBusConnection::connectToBus(QDBusConnection::BusType(__qt_type0), __qt_name1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusConnection::connectToBus(QString,QString)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusConnection_connectToBus__Ljava_lang_String_2Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 jstring address0,
 jstring name1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDBusConnection::connectToBus(QString,QString)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QString  __qt_address0 = qtjambi_cast<QString >(__jni_env, address0);
        QString  __qt_name1 = qtjambi_cast<QString >(__jni_env, name1);
        QDBusConnection __qt_return_value = QDBusConnection::connectToBus(__qt_address0, __qt_name1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusConnection::connectToPeer(QString,QString)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusConnection_connectToPeer__Ljava_lang_String_2Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 jstring address0,
 jstring name1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDBusConnection::connectToPeer(QString,QString)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QString  __qt_address0 = qtjambi_cast<QString >(__jni_env, address0);
        QString  __qt_name1 = qtjambi_cast<QString >(__jni_env, name1);
        QDBusConnection __qt_return_value = QDBusConnection::connectToPeer(__qt_address0, __qt_name1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusConnection::disconnectFromBus(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusConnection_disconnectFromBus__Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 jstring name0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDBusConnection::disconnectFromBus(QString)")
    QTJAMBI_TRY {
        QString  __qt_name0 = qtjambi_cast<QString >(__jni_env, name0);
        QDBusConnection::disconnectFromBus(__qt_name0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDBusConnection::disconnectFromPeer(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusConnection_disconnectFromPeer__Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 jstring name0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDBusConnection::disconnectFromPeer(QString)")
    QTJAMBI_TRY {
        QString  __qt_name0 = qtjambi_cast<QString >(__jni_env, name0);
        QDBusConnection::disconnectFromPeer(__qt_name0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDBusConnection::localMachineId()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusConnection_localMachineId__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDBusConnection::localMachineId()")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QByteArray __qt_return_value = QDBusConnection::localMachineId();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusConnection::sessionBus()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusConnection_sessionBus__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDBusConnection::sessionBus()")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDBusConnection __qt_return_value = QDBusConnection::sessionBus();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusConnection::systemBus()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusConnection_systemBus__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDBusConnection::systemBus()")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDBusConnection __qt_return_value = QDBusConnection::systemBus();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeCustomStructors)
void custom_default_constructor_QDBusConnection(const QtPrivate::QMetaTypeInterface *metaTypeInterface, void* placement)
{
    Q_UNUSED(metaTypeInterface)
    Q_UNUSED(placement)
    new(placement) QDBusConnection("");
}

// emitting (writeJavaLangObjectOverrideFunctions)
// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusConnection_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QDBusConnection *__qt_this = QtJambiAPI::objectFromNativeId<QDBusConnection>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QDBusConnection(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QDBusConnection>("QDBusConnection", "io/qt/dbus/QDBusConnection");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QDBusConnection, {
        ConstructorInfo(&__qt_construct_QDBusConnection_0, "Lio/qt/dbus/QDBusConnection;")
       ,ConstructorInfo(&__qt_construct_QDBusConnection_1, "Ljava/lang/String;")
    });
// END: function table

    registerMetaObject(typeId, QDBusConnection::staticMetaObject, false);
// END: signal table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QDBusConnection);
    registerMetaType<QDBusConnection>("QDBusConnection", &custom_default_constructor_QDBusConnection, QtJambiPrivate::QMetaTypeInterfaceFunctions<QDBusConnection>::copyCtr, QtJambiPrivate::QMetaTypeInterfaceFunctions<QDBusConnection>::moveCtr);
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QDBusConnection::BusType>("QDBusConnection::BusType", "io/qt/dbus/QDBusConnection$BusType");
    registerEnumTypeInfo<QDBusConnection::ConnectionCapability>("QDBusConnection::ConnectionCapability", "io/qt/dbus/QDBusConnection$ConnectionCapability", "QDBusConnection::ConnectionCapabilities", "QFlags<QDBusConnection::ConnectionCapability>", "io/qt/dbus/QDBusConnection$ConnectionCapabilities");
    registerEnumTypeInfo<QDBusConnection::RegisterOption>("QDBusConnection::RegisterOption", "io/qt/dbus/QDBusConnection$RegisterOption", "QDBusConnection::RegisterOptions", "QFlags<QDBusConnection::RegisterOption>", "io/qt/dbus/QDBusConnection$RegisterOptions");
    registerEnumTypeInfo<QDBusConnection::UnregisterMode>("QDBusConnection::UnregisterMode", "io/qt/dbus/QDBusConnection$UnregisterMode");
    registerEnumTypeInfo<QDBusConnection::VirtualObjectRegisterOption>("QDBusConnection::VirtualObjectRegisterOption", "io/qt/dbus/QDBusConnection$VirtualObjectRegisterOption", "QDBusConnection::VirtualObjectRegisterOptions", "QFlags<QDBusConnection::VirtualObjectRegisterOption>", "io/qt/dbus/QDBusConnection$VirtualObjectRegisterOptions");
// END: enums and flags
}
