#include <QtCore/QtGlobal>
#include <QtDBus/qdbusargument.h>
#include <QtCore/QVariant>
#include <QtDBus/qdbusextratypes.h>
#include <QtDBus/qdbusunixfiledescriptor.h>
#include <QtCore/QStringList>
#include <QtCore/qbytearray.h>
#include <QtCore/qstring.h>
#include <QtCore/qvariant.h>
#include <QtCore/qdatetime.h>
#include <QtCore/qrect.h>
#include <QtCore/qsize.h>
#include <QtCore/qpoint.h>
#include <QtCore/qline.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

// emitting (writeClassCodeInjections)
void qtjambi_dbus_check_write_argument(JNIEnv *,const QDBusArgument *);
void qtjambi_dbus_check_read_argument(JNIEnv *,const QDBusArgument *);
bool qtjambi_dbus_is_read_argument(const QDBusArgument *);

void deleter_QDBusArgument(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QDBusArgument")
    QDBusArgument *_ptr = reinterpret_cast<QDBusArgument *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QDBusArgument()
void __qt_construct_QDBusArgument_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QDBusArgument()")
    Q_UNUSED(__java_arguments)
    QDBusArgument *__qt_this = new(__qtjambi_ptr) QDBusArgument();
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// new QDBusArgument(QDBusArgument)
void __qt_construct_QDBusArgument_1(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QDBusArgument(QDBusArgument)")
    jobject other0 = __java_arguments[0].l;
    const QDBusArgument& __qt_other0 = qtjambi_cast<const QDBusArgument& >(__jni_env, other0);
    QDBusArgument *__qt_this = new(__qtjambi_ptr) QDBusArgument(__qt_other0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// destruct QDBusArgument
void __qt_destruct_QDBusArgument(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QDBusArgument")
    reinterpret_cast<QDBusArgument*>(ptr)->~QDBusArgument();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QDBusArgument::QDBusArgument()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_initialize_1native__Lio_qt_dbus_QDBusArgument_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDBusArgument::QDBusArgument()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QDBusArgument_0, sizeof(QDBusArgument), typeid(QDBusArgument), false, &deleter_QDBusArgument, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDBusArgument::QDBusArgument(QDBusArgument)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_initialize_1native__Lio_qt_dbus_QDBusArgument_2Lio_qt_dbus_QDBusArgument_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDBusArgument::QDBusArgument(QDBusArgument)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QDBusArgument_1, sizeof(QDBusArgument), typeid(QDBusArgument), false, &deleter_QDBusArgument, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDBusArgument::appendVariant(QVariant)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_appendVariant_1native_1cref_1QVariant__JLjava_lang_Object_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject v0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::appendVariant(QVariant)", __qt_this)
        QVariant  __qt_v0 = qtjambi_cast<QVariant >(__jni_env, v0);

        qtjambi_dbus_check_write_argument(__jni_env, __qt_this);

        __qt_this->appendVariant(__qt_v0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDBusArgument::asVariant()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_asVariant_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::asVariant()const", __qt_this)

        qtjambi_dbus_check_read_argument(__jni_env, __qt_this);

        QVariant __qt_return_value = __qt_this->asVariant();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::atEnd()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_atEnd_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::atEnd()const", __qt_this)

        qtjambi_dbus_check_read_argument(__jni_env, __qt_this);

        __java_return_value = __qt_this->atEnd();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::beginArray()const
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_beginArray_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        const QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::beginArray()const", __qt_this)
        __qt_this->beginArray();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDBusArgument::beginArray(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_beginArray_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint elementMetaTypeId0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::beginArray(int)", __qt_this)

        qtjambi_dbus_check_write_argument(__jni_env, __qt_this);

        __qt_this->beginArray(static_cast<int>(elementMetaTypeId0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDBusArgument::beginMap()const
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_beginMap_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        const QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::beginMap()const", __qt_this)
        __qt_this->beginMap();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDBusArgument::beginMap(int,int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_beginMap_1native_1int_1int__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint keyMetaTypeId0,
 jint valueMetaTypeId1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::beginMap(int,int)", __qt_this)

        qtjambi_dbus_check_write_argument(__jni_env, __qt_this);

        __qt_this->beginMap(static_cast<int>(keyMetaTypeId0), static_cast<int>(valueMetaTypeId1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDBusArgument::beginMapEntry()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_beginMapEntry_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::beginMapEntry()", __qt_this)

        if(qtjambi_dbus_is_read_argument(__qt_this)){
            const_cast<const QDBusArgument *>(__qt_this)->beginMapEntry();
            return;
        }

        __qt_this->beginMapEntry();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDBusArgument::beginStructure()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_beginStructure_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::beginStructure()", __qt_this)

        if(qtjambi_dbus_is_read_argument(__qt_this)){
            const_cast<const QDBusArgument *>(__qt_this)->beginStructure();
            return;
        }

        __qt_this->beginStructure();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDBusArgument::currentSignature()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_currentSignature_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::currentSignature()const", __qt_this)
        QString __qt_return_value = __qt_this->currentSignature();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::currentType()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_currentType_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::currentType()const", __qt_this)
        QDBusArgument::ElementType __qt_return_value = __qt_this->currentType();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::endArray()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_endArray_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::endArray()", __qt_this)

        if(qtjambi_dbus_is_read_argument(__qt_this)){
            const_cast<const QDBusArgument *>(__qt_this)->endArray();
            return;
        }

        __qt_this->endArray();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDBusArgument::endMap()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_endMap_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::endMap()", __qt_this)

        if(qtjambi_dbus_is_read_argument(__qt_this)){
            const_cast<const QDBusArgument *>(__qt_this)->endMap();
            return;
        }

        __qt_this->endMap();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDBusArgument::endMapEntry()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_endMapEntry_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::endMapEntry()", __qt_this)

        if(qtjambi_dbus_is_read_argument(__qt_this)){
            const_cast<const QDBusArgument *>(__qt_this)->endMapEntry();
            return;
        }

        __qt_this->endMapEntry();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDBusArgument::endStructure()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_endStructure_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::endStructure()", __qt_this)

        if(qtjambi_dbus_is_read_argument(__qt_this)){
            const_cast<const QDBusArgument *>(__qt_this)->endStructure();
            return;
        }

        __qt_this->endStructure();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDBusArgument::operator<<(bool)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_append_1native_1bool__JZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jboolean arg0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator<<(bool)", __qt_this)

        qtjambi_dbus_check_write_argument(__jni_env, __qt_this);

        (*__qt_this) << static_cast<bool>(arg0);
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator<<(QByteArray)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_append_1native_1cref_1QByteArray__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator<<(QByteArray)", __qt_this)
        const QByteArray& __qt_arg0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(arg0);

        qtjambi_dbus_check_write_argument(__jni_env, __qt_this);

        (*__qt_this) << __qt_arg0;
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator<<(QDBusObjectPath)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_append_1native_1cref_1QDBusObjectPath__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator<<(QDBusObjectPath)", __qt_this)
        const QDBusObjectPath& __qt_arg0 = QtJambiAPI::valueReferenceFromNativeId<QDBusObjectPath>(arg0);

        qtjambi_dbus_check_write_argument(__jni_env, __qt_this);

        (*__qt_this) << __qt_arg0;
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator<<(QDBusSignature)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_append_1native_1cref_1QDBusSignature__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator<<(QDBusSignature)", __qt_this)
        const QDBusSignature& __qt_arg0 = QtJambiAPI::valueReferenceFromNativeId<QDBusSignature>(arg0);

        qtjambi_dbus_check_write_argument(__jni_env, __qt_this);

        (*__qt_this) << __qt_arg0;
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator<<(QDBusUnixFileDescriptor)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_append_1native_1cref_1QDBusUnixFileDescriptor__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator<<(QDBusUnixFileDescriptor)", __qt_this)
        const QDBusUnixFileDescriptor& __qt_arg0 = QtJambiAPI::valueReferenceFromNativeId<QDBusUnixFileDescriptor>(arg0);

        qtjambi_dbus_check_write_argument(__jni_env, __qt_this);

        (*__qt_this) << __qt_arg0;
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator<<(QDBusVariant)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_append_1native_1cref_1QDBusVariant__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator<<(QDBusVariant)", __qt_this)
        const QDBusVariant& __qt_arg0 = QtJambiAPI::objectReferenceFromNativeId<QDBusVariant>(__jni_env, arg0);

        qtjambi_dbus_check_write_argument(__jni_env, __qt_this);

        (*__qt_this) << __qt_arg0;
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator<<(QDBusArgument&,QDate)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_append_1native_1cref_1QDate__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID date1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator<<(QDBusArgument&,QDate)", __qt_this)
        const QDate& __qt_date1 = QtJambiAPI::valueReferenceFromNativeId<QDate>(date1);
        (*__qt_this) << __qt_date1;
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator<<(QDBusArgument&,QDateTime)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_append_1native_1cref_1QDateTime__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID dt1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator<<(QDBusArgument&,QDateTime)", __qt_this)
        const QDateTime& __qt_dt1 = QtJambiAPI::valueReferenceFromNativeId<QDateTime>(dt1);
        (*__qt_this) << __qt_dt1;
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator<<(QDBusArgument&,QLine)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_append_1native_1cref_1QLine__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID line1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator<<(QDBusArgument&,QLine)", __qt_this)
        const QLine& __qt_line1 = QtJambiAPI::valueReferenceFromNativeId<QLine>(line1);
        (*__qt_this) << __qt_line1;
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator<<(QDBusArgument&,QLineF)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_append_1native_1cref_1QLineF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID line1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator<<(QDBusArgument&,QLineF)", __qt_this)
        const QLineF& __qt_line1 = QtJambiAPI::valueReferenceFromNativeId<QLineF>(line1);
        (*__qt_this) << __qt_line1;
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator<<(QDBusArgument&,QPoint)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_append_1native_1cref_1QPoint__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID pt1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator<<(QDBusArgument&,QPoint)", __qt_this)
        const QPoint& __qt_pt1 = QtJambiAPI::valueReferenceFromNativeId<QPoint>(pt1);
        (*__qt_this) << __qt_pt1;
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator<<(QDBusArgument&,QPointF)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_append_1native_1cref_1QPointF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID pt1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator<<(QDBusArgument&,QPointF)", __qt_this)
        const QPointF& __qt_pt1 = QtJambiAPI::valueReferenceFromNativeId<QPointF>(pt1);
        (*__qt_this) << __qt_pt1;
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator<<(QDBusArgument&,QRect)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_append_1native_1cref_1QRect__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID rect1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator<<(QDBusArgument&,QRect)", __qt_this)
        const QRect& __qt_rect1 = QtJambiAPI::valueReferenceFromNativeId<QRect>(rect1);
        (*__qt_this) << __qt_rect1;
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator<<(QDBusArgument&,QRectF)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_append_1native_1cref_1QRectF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID rect1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator<<(QDBusArgument&,QRectF)", __qt_this)
        const QRectF& __qt_rect1 = QtJambiAPI::valueReferenceFromNativeId<QRectF>(rect1);
        (*__qt_this) << __qt_rect1;
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator<<(QDBusArgument&,QSize)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_append_1native_1cref_1QSize__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID size1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator<<(QDBusArgument&,QSize)", __qt_this)
        const QSize& __qt_size1 = QtJambiAPI::valueReferenceFromNativeId<QSize>(size1);
        (*__qt_this) << __qt_size1;
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator<<(QDBusArgument&,QSizeF)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_append_1native_1cref_1QSizeF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID size1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator<<(QDBusArgument&,QSizeF)", __qt_this)
        const QSizeF& __qt_size1 = QtJambiAPI::valueReferenceFromNativeId<QSizeF>(size1);
        (*__qt_this) << __qt_size1;
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator<<(QString)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_append_1native_1cref_1QString__JLjava_lang_CharSequence_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject arg0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator<<(QString)", __qt_this)
        QString  __qt_arg0 = qtjambi_cast<QString >(__jni_env, arg0);

        qtjambi_dbus_check_write_argument(__jni_env, __qt_this);

        (*__qt_this) << __qt_arg0;
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator<<(QStringList)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_append_1native_1cref_1QStringList__JLjava_util_List_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject arg0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator<<(QStringList)", __qt_this)
        const QStringList&  __qt_arg0 = qtjambi_cast<const QStringList& >(__jni_env, __qtjambi_scope, arg0);

        qtjambi_dbus_check_write_argument(__jni_env, __qt_this);

        (*__qt_this) << __qt_arg0;
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator<<(QDBusArgument&,QTime)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_append_1native_1cref_1QTime__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID time1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator<<(QDBusArgument&,QTime)", __qt_this)
        const QTime& __qt_time1 = QtJambiAPI::valueReferenceFromNativeId<QTime>(time1);
        (*__qt_this) << __qt_time1;
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator<<(double)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_append_1native_1double__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble arg0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator<<(double)", __qt_this)

        qtjambi_dbus_check_write_argument(__jni_env, __qt_this);

        (*__qt_this) << static_cast<double>(arg0);
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator<<(int)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_append_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint arg0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator<<(int)", __qt_this)

        qtjambi_dbus_check_write_argument(__jni_env, __qt_this);

        (*__qt_this) << static_cast<int>(arg0);
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator<<(qlonglong)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_append_1native_1qlonglong__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong arg0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator<<(qlonglong)", __qt_this)

        qtjambi_dbus_check_write_argument(__jni_env, __qt_this);

        (*__qt_this) << static_cast<qlonglong>(arg0);
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator<<(short)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_append_1native_1short__JS)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jshort arg0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator<<(short)", __qt_this)

        qtjambi_dbus_check_write_argument(__jni_env, __qt_this);

        (*__qt_this) << static_cast<short>(arg0);
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator<<(uchar)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_append_1native_1uchar__JB)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jbyte arg0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator<<(uchar)", __qt_this)

        qtjambi_dbus_check_write_argument(__jni_env, __qt_this);

        (*__qt_this) << static_cast<uchar>(arg0);
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator=(QDBusArgument)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_assign_1native_1cref_1QDBusArgument__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator=(QDBusArgument)", __qt_this)
        const QDBusArgument& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QDBusArgument>(other0);
        (*__qt_this) = __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDBusArgument::operator>>(QByteArray&)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_extractBytes_1native_1ref_1QByteArray_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator>>(QByteArray&)const", __qt_this)
        QByteArray __qt_arg0;

        qtjambi_dbus_check_read_argument(__jni_env, __qt_this);

        const QDBusArgument& __qt_return_value = (*__qt_this) >> __qt_arg0;
        Q_UNUSED(__qt_return_value)
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_arg0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator>>(QDBusObjectPath&)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_extractObjectPath_1native_1ref_1QDBusObjectPath_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator>>(QDBusObjectPath&)const", __qt_this)
        QDBusObjectPath __qt_arg0;

        qtjambi_dbus_check_read_argument(__jni_env, __qt_this);

        const QDBusArgument& __qt_return_value = (*__qt_this) >> __qt_arg0;
        Q_UNUSED(__qt_return_value)
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_arg0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator>>(QDBusSignature&)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_extractSignature_1native_1ref_1QDBusSignature_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator>>(QDBusSignature&)const", __qt_this)
        QDBusObjectPath __qt_arg0;

        qtjambi_dbus_check_read_argument(__jni_env, __qt_this);

        const QDBusArgument& __qt_return_value = (*__qt_this) >> __qt_arg0;
        Q_UNUSED(__qt_return_value)
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_arg0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator>>(QDBusUnixFileDescriptor&)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_extractUnixFileDescriptor_1native_1ref_1QDBusUnixFileDescriptor_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator>>(QDBusUnixFileDescriptor&)const", __qt_this)
        QDBusUnixFileDescriptor __qt_arg0;

        qtjambi_dbus_check_read_argument(__jni_env, __qt_this);

        const QDBusArgument& __qt_return_value = (*__qt_this) >> __qt_arg0;
        Q_UNUSED(__qt_return_value)
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_arg0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator>>(QDBusVariant&)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_extractVariant_1native_1ref_1QDBusVariant_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator>>(QDBusVariant&)const", __qt_this)
        QDBusVariant __qt_arg0;

        qtjambi_dbus_check_read_argument(__jni_env, __qt_this);

        const QDBusArgument& __qt_return_value = (*__qt_this) >> __qt_arg0;
        Q_UNUSED(__qt_return_value)
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_arg0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator>>(QDBusArgument,QDate&)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_extractDate_1native_1ref_1QDate__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID date1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator>>(QDBusArgument,QDate&)", __qt_this)
        QDate& __qt_date1 = QtJambiAPI::objectReferenceFromNativeId<QDate>(__jni_env, date1);

        qtjambi_dbus_check_read_argument(__jni_env, __qt_this);

        const QDBusArgument& __qt_return_value = (*__qt_this) >> __qt_date1;
        Q_UNUSED(__qt_return_value)
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_date1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator>>(QDBusArgument,QDateTime&)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_extractDateTime_1native_1ref_1QDateTime__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID dt1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator>>(QDBusArgument,QDateTime&)", __qt_this)
        QDateTime& __qt_dt1 = QtJambiAPI::objectReferenceFromNativeId<QDateTime>(__jni_env, dt1);

        qtjambi_dbus_check_read_argument(__jni_env, __qt_this);

        const QDBusArgument& __qt_return_value = (*__qt_this) >> __qt_dt1;
        Q_UNUSED(__qt_return_value)
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_dt1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator>>(QDBusArgument,QLine&)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_extractLine_1native_1ref_1QLine__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID line1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator>>(QDBusArgument,QLine&)", __qt_this)
        QLine& __qt_line1 = QtJambiAPI::objectReferenceFromNativeId<QLine>(__jni_env, line1);

        qtjambi_dbus_check_read_argument(__jni_env, __qt_this);

        const QDBusArgument& __qt_return_value = (*__qt_this) >> __qt_line1;
        Q_UNUSED(__qt_return_value)
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_line1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator>>(QDBusArgument,QLineF&)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_extractLineF_1native_1ref_1QLineF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID line1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator>>(QDBusArgument,QLineF&)", __qt_this)
        QLineF& __qt_line1 = QtJambiAPI::objectReferenceFromNativeId<QLineF>(__jni_env, line1);

        qtjambi_dbus_check_read_argument(__jni_env, __qt_this);

        const QDBusArgument& __qt_return_value = (*__qt_this) >> __qt_line1;
        Q_UNUSED(__qt_return_value)
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_line1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator>>(QDBusArgument,QPoint&)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_extractPoint_1native_1ref_1QPoint__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID pt1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator>>(QDBusArgument,QPoint&)", __qt_this)
        QPoint& __qt_pt1 = QtJambiAPI::objectReferenceFromNativeId<QPoint>(__jni_env, pt1);

        qtjambi_dbus_check_read_argument(__jni_env, __qt_this);

        const QDBusArgument& __qt_return_value = (*__qt_this) >> __qt_pt1;
        Q_UNUSED(__qt_return_value)
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_pt1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator>>(QDBusArgument,QPointF&)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_extractPointF_1native_1ref_1QPointF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID pt1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator>>(QDBusArgument,QPointF&)", __qt_this)
        QPointF& __qt_pt1 = QtJambiAPI::objectReferenceFromNativeId<QPointF>(__jni_env, pt1);

        qtjambi_dbus_check_read_argument(__jni_env, __qt_this);

        const QDBusArgument& __qt_return_value = (*__qt_this) >> __qt_pt1;
        Q_UNUSED(__qt_return_value)
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_pt1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator>>(QDBusArgument,QRect&)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_extractRect_1native_1ref_1QRect__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID rect1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator>>(QDBusArgument,QRect&)", __qt_this)
        QRect& __qt_rect1 = QtJambiAPI::objectReferenceFromNativeId<QRect>(__jni_env, rect1);

        qtjambi_dbus_check_read_argument(__jni_env, __qt_this);

        const QDBusArgument& __qt_return_value = (*__qt_this) >> __qt_rect1;
        Q_UNUSED(__qt_return_value)
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_rect1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator>>(QDBusArgument,QRectF&)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_extractRectF_1native_1ref_1QRectF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID rect1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator>>(QDBusArgument,QRectF&)", __qt_this)
        QRectF& __qt_rect1 = QtJambiAPI::objectReferenceFromNativeId<QRectF>(__jni_env, rect1);

        qtjambi_dbus_check_read_argument(__jni_env, __qt_this);

        const QDBusArgument& __qt_return_value = (*__qt_this) >> __qt_rect1;
        Q_UNUSED(__qt_return_value)
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_rect1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator>>(QDBusArgument,QSize&)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_extractSize_1native_1ref_1QSize__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID size1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator>>(QDBusArgument,QSize&)", __qt_this)
        QSize& __qt_size1 = QtJambiAPI::objectReferenceFromNativeId<QSize>(__jni_env, size1);

        qtjambi_dbus_check_read_argument(__jni_env, __qt_this);

        const QDBusArgument& __qt_return_value = (*__qt_this) >> __qt_size1;
        Q_UNUSED(__qt_return_value)
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_size1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator>>(QDBusArgument,QSizeF&)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_extractSizeF_1native_1ref_1QSizeF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID size1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator>>(QDBusArgument,QSizeF&)", __qt_this)
        QSizeF& __qt_size1 = QtJambiAPI::objectReferenceFromNativeId<QSizeF>(__jni_env, size1);

        qtjambi_dbus_check_read_argument(__jni_env, __qt_this);

        const QDBusArgument& __qt_return_value = (*__qt_this) >> __qt_size1;
        Q_UNUSED(__qt_return_value)
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_size1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator>>(QString&)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_extractQString_1native_1ref_1QString_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator>>(QString&)const", __qt_this)
        QString __qt_arg0;

        qtjambi_dbus_check_read_argument(__jni_env, __qt_this);

        const QDBusArgument& __qt_return_value = (*__qt_this) >> __qt_arg0;
        Q_UNUSED(__qt_return_value)
        __java_return_value = QtJambiAPI::convertQStringToJavaObject(__jni_env, __qt_arg0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator>>(QStringList&)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_extractStrings_1native_1ref_1QStringList_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator>>(QStringList&)const", __qt_this)
        QStringList __qt_arg0;

        qtjambi_dbus_check_read_argument(__jni_env, __qt_this);

        const QDBusArgument& __qt_return_value = (*__qt_this) >> __qt_arg0;
        Q_UNUSED(__qt_return_value)
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_arg0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator>>(QDBusArgument,QTime&)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_extractTime_1native_1ref_1QTime__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID time1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator>>(QDBusArgument,QTime&)", __qt_this)
        QTime& __qt_time1 = QtJambiAPI::objectReferenceFromNativeId<QTime>(__jni_env, time1);

        qtjambi_dbus_check_read_argument(__jni_env, __qt_this);

        const QDBusArgument& __qt_return_value = (*__qt_this) >> __qt_time1;
        Q_UNUSED(__qt_return_value)
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_time1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator>>(QDBusArgument,QVariant&)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_extractObject_1native_1ref_1QVariant__JLio_qt_core_QVariant_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject v1)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator>>(QDBusArgument,QVariant&)", __qt_this)
        QVariant&  __qt_v1 = qtjambi_cast<QVariant& >(__jni_env, __qtjambi_scope, v1);

        qtjambi_dbus_check_read_argument(__jni_env, __qt_this);

        const QDBusArgument& __qt_return_value = (*__qt_this) >> __qt_v1;
        Q_UNUSED(__qt_return_value)
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_v1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator>>(bool&)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_extractBoolean_1native_1ref_1bool_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator>>(bool&)const", __qt_this)
        bool __java_return_value;
        bool& __qt_arg0 = __java_return_value;

        qtjambi_dbus_check_read_argument(__jni_env, __qt_this);

        const QDBusArgument& __qt_return_value = (*__qt_this) >> __qt_arg0;
        Q_UNUSED(__qt_return_value)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator>>(double&)const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_extractDouble_1native_1ref_1double_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator>>(double&)const", __qt_this)
        jdouble __java_return_value;
        double& __qt_arg0 = __java_return_value;

        qtjambi_dbus_check_read_argument(__jni_env, __qt_this);

        const QDBusArgument& __qt_return_value = (*__qt_this) >> __qt_arg0;
        Q_UNUSED(__qt_return_value)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator>>(int&)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_extractInt_1native_1ref_1int_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator>>(int&)const", __qt_this)
        int __java_return_value;
        int& __qt_arg0 = __java_return_value;

        qtjambi_dbus_check_read_argument(__jni_env, __qt_this);

        const QDBusArgument& __qt_return_value = (*__qt_this) >> __qt_arg0;
        Q_UNUSED(__qt_return_value)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator>>(qlonglong&)const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_extractLong_1native_1ref_1qlonglong_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator>>(qlonglong&)const", __qt_this)
        jlong __java_return_value;
        long long& __qt_arg0 = *reinterpret_cast<long long*>(&__java_return_value);

        qtjambi_dbus_check_read_argument(__jni_env, __qt_this);

        const QDBusArgument& __qt_return_value = (*__qt_this) >> __qt_arg0;
        Q_UNUSED(__qt_return_value)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator>>(short&)const
extern "C" Q_DECL_EXPORT jshort JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_extractShort_1native_1ref_1short_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jshort __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator>>(short&)const", __qt_this)
        jshort __java_return_value;
        short& __qt_arg0 = *reinterpret_cast<short*>(&__java_return_value);

        qtjambi_dbus_check_read_argument(__jni_env, __qt_this);

        const QDBusArgument& __qt_return_value = (*__qt_this) >> __qt_arg0;
        Q_UNUSED(__qt_return_value)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::operator>>(uchar&)const
extern "C" Q_DECL_EXPORT jbyte JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_extractByte_1native_1ref_1uchar_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jbyte __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::operator>>(uchar&)const", __qt_this)
        jbyte __java_return_value;
        uchar& __qt_arg0 = *reinterpret_cast<uchar*>(&__java_return_value);

        qtjambi_dbus_check_read_argument(__jni_env, __qt_this);

        const QDBusArgument& __qt_return_value = (*__qt_this) >> __qt_arg0;
        Q_UNUSED(__qt_return_value)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusArgument::swap(QDBusArgument&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_swap_1native_1ref_1QDBusArgument__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusArgument::swap(QDBusArgument&)", __qt_this)
        QDBusArgument& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QDBusArgument>(__jni_env, other0);
        __qt_this->swap(__qt_other0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// emitting (writeJavaLangObjectOverrideFunctions)
// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusArgument_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QDBusArgument *__qt_this = QtJambiAPI::objectFromNativeId<QDBusArgument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QDBusArgument(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QDBusArgument>("QDBusArgument", "io/qt/dbus/QDBusArgument");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QDBusArgument, {
        ConstructorInfo(&__qt_construct_QDBusArgument_0, nullptr)
       ,ConstructorInfo(&__qt_construct_QDBusArgument_1, "Lio/qt/dbus/QDBusArgument;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QDBusArgument);
    registerMetaType<QDBusArgument>("QDBusArgument");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QDBusArgument::ElementType>("QDBusArgument::ElementType", "io/qt/dbus/QDBusArgument$ElementType");
// END: enums and flags
}
