#include <QtCore/QtGlobal>
#include <QtDBus/qdbusmessage.h>
#include <QtCore/QList>
#include <QtCore/QVariant>
#include <QtDBus/qdbuserror.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QDBusMessage(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QDBusMessage")
    QDBusMessage *_ptr = reinterpret_cast<QDBusMessage *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QDBusMessage()
void __qt_construct_QDBusMessage(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QDBusMessage()")
    Q_UNUSED(__java_arguments)
    QDBusMessage *__qt_this = new(__qtjambi_ptr) QDBusMessage();
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// QDBusMessage::QDBusMessage()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusMessage_initialize_1native__Lio_qt_dbus_QDBusMessage_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDBusMessage::QDBusMessage()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QDBusMessage, sizeof(QDBusMessage), typeid(QDBusMessage), false, &deleter_QDBusMessage, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QDBusMessage(QDBusMessage)
void __qt_construct_QDBusMessage_cref_QDBusMessage(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QDBusMessage(QDBusMessage)")
    jobject other0 = __java_arguments[0].l;
    const QDBusMessage& __qt_other0 = qtjambi_cast<const QDBusMessage& >(__jni_env, other0);
    QDBusMessage *__qt_this = new(__qtjambi_ptr) QDBusMessage(__qt_other0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QDBusMessage::QDBusMessage(QDBusMessage)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusMessage_initialize_1native__Lio_qt_dbus_QDBusMessage_2Lio_qt_dbus_QDBusMessage_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDBusMessage::QDBusMessage(QDBusMessage)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QDBusMessage_cref_QDBusMessage, sizeof(QDBusMessage), typeid(QDBusMessage), false, &deleter_QDBusMessage, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QDBusMessage
void __qt_destruct_QDBusMessage(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QDBusMessage")
    reinterpret_cast<QDBusMessage*>(ptr)->~QDBusMessage();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QDBusMessage::arguments()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusMessage_arguments_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusMessage *__qt_this = QtJambiAPI::objectFromNativeId<QDBusMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusMessage::arguments()const", __qt_this)
        QList<QVariant> __qt_return_value = __qt_this->arguments();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusMessage::autoStartService()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusMessage_autoStartService_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusMessage *__qt_this = QtJambiAPI::objectFromNativeId<QDBusMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusMessage::autoStartService()const", __qt_this)
        __java_return_value = __qt_this->autoStartService();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusMessage::createErrorReply(QDBusError)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusMessage_createErrorReply_1native_1cref_1QDBusError_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID err0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusMessage *__qt_this = QtJambiAPI::objectFromNativeId<QDBusMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusMessage::createErrorReply(QDBusError)const", __qt_this)
        const QDBusError& __qt_err0 = QtJambiAPI::valueReferenceFromNativeId<QDBusError>(err0);
        QDBusMessage __qt_return_value = __qt_this->createErrorReply(__qt_err0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusMessage::createErrorReply(QDBusError::ErrorType,QString)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusMessage_createErrorReply_1native_1QDBusError_1ErrorType_1cref_1QString_1constfct__JILjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint type0,
 jstring msg1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusMessage *__qt_this = QtJambiAPI::objectFromNativeId<QDBusMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusMessage::createErrorReply(QDBusError::ErrorType,QString)const", __qt_this)
        QDBusError::ErrorType __qt_type0 = qtjambi_cast<QDBusError::ErrorType>(__jni_env, type0);
        QString  __qt_msg1 = qtjambi_cast<QString>(__jni_env, msg1);
        QDBusMessage __qt_return_value = __qt_this->createErrorReply(QDBusError::ErrorType(__qt_type0), __qt_msg1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusMessage::createErrorReply(QString,QString)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusMessage_createErrorReply_1native_1cref_1QString_1cref_1QString_1constfct__JLjava_lang_String_2Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring name0,
 jstring msg1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusMessage *__qt_this = QtJambiAPI::objectFromNativeId<QDBusMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusMessage::createErrorReply(QString,QString)const", __qt_this)
        QString  __qt_name0 = qtjambi_cast<QString>(__jni_env, name0);
        QString  __qt_msg1 = qtjambi_cast<QString>(__jni_env, msg1);
        QDBusMessage __qt_return_value = __qt_this->createErrorReply(__qt_name0, __qt_msg1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusMessage::createReply(QList<QVariant>)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusMessage_createReply_1native_1cref_1QList_1constfct__JLjava_util_Collection_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject arguments0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusMessage *__qt_this = QtJambiAPI::objectFromNativeId<QDBusMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusMessage::createReply(QList<QVariant>)const", __qt_this)
        const QList<QVariant>&  __qt_arguments0 = qtjambi_cast<const QList<QVariant>& >(__jni_env, __qtjambi_scope, arguments0);
        QDBusMessage __qt_return_value = __qt_this->createReply(__qt_arguments0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusMessage::createReply(QVariant)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusMessage_createReply_1native_1cref_1QVariant_1constfct__JLjava_lang_Object_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject argument0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusMessage *__qt_this = QtJambiAPI::objectFromNativeId<QDBusMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusMessage::createReply(QVariant)const", __qt_this)
        QVariant  __qt_argument0 = qtjambi_cast<QVariant >(__jni_env, argument0);
        QDBusMessage __qt_return_value = __qt_this->createReply(__qt_argument0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusMessage::errorMessage()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusMessage_errorMessage_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusMessage *__qt_this = QtJambiAPI::objectFromNativeId<QDBusMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusMessage::errorMessage()const", __qt_this)
        QString __qt_return_value = __qt_this->errorMessage();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusMessage::errorName()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusMessage_errorName_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusMessage *__qt_this = QtJambiAPI::objectFromNativeId<QDBusMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusMessage::errorName()const", __qt_this)
        QString __qt_return_value = __qt_this->errorName();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusMessage::interface()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusMessage_interfaceName_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusMessage *__qt_this = QtJambiAPI::objectFromNativeId<QDBusMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusMessage::interface()const", __qt_this)
        QString __qt_return_value = __qt_this->interface();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusMessage::isDelayedReply()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusMessage_isDelayedReply_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusMessage *__qt_this = QtJambiAPI::objectFromNativeId<QDBusMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusMessage::isDelayedReply()const", __qt_this)
        __java_return_value = __qt_this->isDelayedReply();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusMessage::isInteractiveAuthorizationAllowed()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusMessage_isInteractiveAuthorizationAllowed_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusMessage *__qt_this = QtJambiAPI::objectFromNativeId<QDBusMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusMessage::isInteractiveAuthorizationAllowed()const", __qt_this)
        __java_return_value = __qt_this->isInteractiveAuthorizationAllowed();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusMessage::isReplyRequired()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusMessage_isReplyRequired_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusMessage *__qt_this = QtJambiAPI::objectFromNativeId<QDBusMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusMessage::isReplyRequired()const", __qt_this)
        __java_return_value = __qt_this->isReplyRequired();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusMessage::member()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusMessage_member_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusMessage *__qt_this = QtJambiAPI::objectFromNativeId<QDBusMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusMessage::member()const", __qt_this)
        QString __qt_return_value = __qt_this->member();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusMessage::operator<<(QVariant)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusMessage_append_1native_1cref_1QVariant__JLjava_lang_Object_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject arg0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDBusMessage *__qt_this = QtJambiAPI::objectFromNativeId<QDBusMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusMessage::operator<<(QVariant)", __qt_this)
        QVariant  __qt_arg0 = qtjambi_cast<QVariant >(__jni_env, arg0);
        (*__qt_this) << __qt_arg0;
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusMessage::operator=(QDBusMessage)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusMessage_assign_1native_1cref_1QDBusMessage__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDBusMessage *__qt_this = QtJambiAPI::objectFromNativeId<QDBusMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusMessage::operator=(QDBusMessage)", __qt_this)
        const QDBusMessage& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QDBusMessage>(other0);
        (*__qt_this) = __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDBusMessage::path()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusMessage_path_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusMessage *__qt_this = QtJambiAPI::objectFromNativeId<QDBusMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusMessage::path()const", __qt_this)
        QString __qt_return_value = __qt_this->path();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusMessage::service()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusMessage_service_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusMessage *__qt_this = QtJambiAPI::objectFromNativeId<QDBusMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusMessage::service()const", __qt_this)
        QString __qt_return_value = __qt_this->service();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusMessage::setArguments(QList<QVariant>)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusMessage_setArguments_1native_1cref_1QList__JLjava_util_Collection_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject arguments0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDBusMessage *__qt_this = QtJambiAPI::objectFromNativeId<QDBusMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusMessage::setArguments(QList<QVariant>)", __qt_this)
        const QList<QVariant>&  __qt_arguments0 = qtjambi_cast<const QList<QVariant>& >(__jni_env, __qtjambi_scope, arguments0);
        __qt_this->setArguments(__qt_arguments0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDBusMessage::setAutoStartService(bool)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusMessage_setAutoStartService_1native_1bool__JZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jboolean enable0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDBusMessage *__qt_this = QtJambiAPI::objectFromNativeId<QDBusMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusMessage::setAutoStartService(bool)", __qt_this)
        __qt_this->setAutoStartService(static_cast<bool>(enable0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDBusMessage::setDelayedReply(bool)const
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusMessage_setDelayedReply_1native_1bool_1constfct__JZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jboolean enable0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        const QDBusMessage *__qt_this = QtJambiAPI::objectFromNativeId<QDBusMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusMessage::setDelayedReply(bool)const", __qt_this)
        __qt_this->setDelayedReply(static_cast<bool>(enable0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDBusMessage::setInteractiveAuthorizationAllowed(bool)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusMessage_setInteractiveAuthorizationAllowed_1native_1bool__JZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jboolean enable0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDBusMessage *__qt_this = QtJambiAPI::objectFromNativeId<QDBusMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusMessage::setInteractiveAuthorizationAllowed(bool)", __qt_this)
        __qt_this->setInteractiveAuthorizationAllowed(static_cast<bool>(enable0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDBusMessage::signature()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusMessage_signature_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusMessage *__qt_this = QtJambiAPI::objectFromNativeId<QDBusMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusMessage::signature()const", __qt_this)
        QString __qt_return_value = __qt_this->signature();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusMessage::swap(QDBusMessage&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusMessage_swap_1native_1ref_1QDBusMessage__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDBusMessage *__qt_this = QtJambiAPI::objectFromNativeId<QDBusMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusMessage::swap(QDBusMessage&)", __qt_this)
        QDBusMessage& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QDBusMessage>(__jni_env, other0);
        __qt_this->swap(__qt_other0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDBusMessage::type()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusMessage_type_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusMessage *__qt_this = QtJambiAPI::objectFromNativeId<QDBusMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDBusMessage::type()const", __qt_this)
        QDBusMessage::MessageType __qt_return_value = __qt_this->type();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusMessage::createError(QDBusError)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusMessage_createError_1native_1cref_1QDBusError__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID err0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDBusMessage::createError(QDBusError)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDBusError& __qt_err0 = QtJambiAPI::valueReferenceFromNativeId<QDBusError>(err0);
        QDBusMessage __qt_return_value = QDBusMessage::createError(__qt_err0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusMessage::createError(QDBusError::ErrorType,QString)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusMessage_createError_1native_1QDBusError_1ErrorType_1cref_1QString__ILjava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 jint type0,
 jstring msg1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDBusMessage::createError(QDBusError::ErrorType,QString)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDBusError::ErrorType __qt_type0 = qtjambi_cast<QDBusError::ErrorType>(__jni_env, type0);
        QString  __qt_msg1 = qtjambi_cast<QString>(__jni_env, msg1);
        QDBusMessage __qt_return_value = QDBusMessage::createError(QDBusError::ErrorType(__qt_type0), __qt_msg1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusMessage::createError(QString,QString)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusMessage_createError__Ljava_lang_String_2Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 jstring name0,
 jstring msg1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDBusMessage::createError(QString,QString)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QString  __qt_name0 = qtjambi_cast<QString>(__jni_env, name0);
        QString  __qt_msg1 = qtjambi_cast<QString>(__jni_env, msg1);
        QDBusMessage __qt_return_value = QDBusMessage::createError(__qt_name0, __qt_msg1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusMessage::createMethodCall(QString,QString,QString,QString)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusMessage_createMethodCall__Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 jstring destination0,
 jstring path1,
 jstring interface2,
 jstring method3)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDBusMessage::createMethodCall(QString,QString,QString,QString)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QString  __qt_destination0 = qtjambi_cast<QString>(__jni_env, destination0);
        QString  __qt_path1 = qtjambi_cast<QString>(__jni_env, path1);
        QString  __qt_interface2 = qtjambi_cast<QString>(__jni_env, interface2);
        QString  __qt_method3 = qtjambi_cast<QString>(__jni_env, method3);
        QDBusMessage __qt_return_value = QDBusMessage::createMethodCall(__qt_destination0, __qt_path1, __qt_interface2, __qt_method3);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusMessage::createSignal(QString,QString,QString)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusMessage_createSignal__Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 jstring path0,
 jstring interface1,
 jstring name2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDBusMessage::createSignal(QString,QString,QString)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QString  __qt_path0 = qtjambi_cast<QString>(__jni_env, path0);
        QString  __qt_interface1 = qtjambi_cast<QString>(__jni_env, interface1);
        QString  __qt_name2 = qtjambi_cast<QString>(__jni_env, name2);
        QDBusMessage __qt_return_value = QDBusMessage::createSignal(__qt_path0, __qt_interface1, __qt_name2);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDBusMessage::createTargetedSignal(QString,QString,QString,QString)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusMessage_createTargetedSignal__Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 jstring service0,
 jstring path1,
 jstring interface2,
 jstring name3)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDBusMessage::createTargetedSignal(QString,QString,QString,QString)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QString  __qt_service0 = qtjambi_cast<QString>(__jni_env, service0);
        QString  __qt_path1 = qtjambi_cast<QString>(__jni_env, path1);
        QString  __qt_interface2 = qtjambi_cast<QString>(__jni_env, interface2);
        QString  __qt_name3 = qtjambi_cast<QString>(__jni_env, name3);
        QDBusMessage __qt_return_value = QDBusMessage::createTargetedSignal(__qt_service0, __qt_path1, __qt_interface2, __qt_name3);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

#include <QtCore/QDebug>
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusMessage_toString_1native)(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jstring __java_return_value = nullptr;
    QTJAMBI_TRY {
        QDBusMessage *__qt_this = QtJambiAPI::objectFromNativeId<QDBusMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QString res;
        QDebug(&res).noquote() << *__qt_this;
        if(!res.isEmpty() && res.back().isSpace())
            res = res.trimmed();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, res);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_dbus_QDBusMessage_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QDBusMessage *__qt_this = QtJambiAPI::objectFromNativeId<QDBusMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QDBusMessage(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QDBusMessage>("QDBusMessage", "io/qt/dbus/QDBusMessage");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QDBusMessage, {
        ConstructorInfo(&__qt_construct_QDBusMessage, nullptr)
       ,ConstructorInfo(&__qt_construct_QDBusMessage_cref_QDBusMessage, "Lio/qt/dbus/QDBusMessage;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QDBusMessage);
    registerMetaType<QDBusMessage>("QDBusMessage");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QDBusMessage::MessageType>("QDBusMessage::MessageType", "io/qt/dbus/QDBusMessage$MessageType");
// END: enums and flags
}
